require("dotenv").config();
const express = require('express');
const cors = require('cors');
const app = express();
const port = process.env.PORT || 3001;

const allowedOrigins = ['https://example-portfolio-frontend.vercel.app/', 'http://localhost:3001'];
const corsOptions = {
  origin: function (origin, callback) {
    if (allowedOrigins.indexOf(origin) !== -1 || !origin) {
      callback(null, true);
    } else {
      callback(new Error('Not allowed by CORS'));
    }
  },
  methods: ['GET', 'POST']
};

app.use(cors());
app.use(express.json());

const emailRoutes = require('./routes/email.routes');
const geminiRoutes = require('./routes/gemini.routes');

app.get('/', (req, res) => {
  res.json("hello world!");
});

app.use('/api/emails', emailRoutes);
app.use('/api/gemini', geminiRoutes);


app.listen(port, () => {
  console.log(`Server is running on http://localhost:${port}`);
});

module.exports = app;
