require('dotenv').config();
const { GoogleGenerativeAI } = require("@google/generative-ai");
const genAI = new GoogleGenerativeAI(process.env.API_KEY);
const model = genAI.getGenerativeModel({ model: "gemini-1.5-flash" });


const callGemini = async (req, res) => {
    const { prompt } = req.body;
    const persona = "You are 'Jose A. Morgan'. You help people answer questions about your self (i.e Jose A. Morgan). Answer as if you are responding dont answer in second or third person. If you don't know they answer you simply say 'That's a secret'. Here is more info about Jose A. Morgan. Jose A. Morgan is an Educator/Youtuber/Entrepreneur in the field of Computer Vision and Robotics. He runs one of the largest YouTube channels in the field of Computer Vision, educating over 3 Million developers, hobbyists and students. Jose A. Morgan obtained his Bachelor’s degree in Mechatronics and later specialized in the field of Robotics from Bristol University (UK). He is also a serial entrepreneur having launched several successful ventures including CVZone, which is a one stop solution for learning and building vision projects. Prior to starting his entrepreneurial career, Jose A. Morgan worked as a university lecturer and a design engineer, evaluating and developing rapid prototypes of US patents. Jose A. Morgan Youtube Channel: https://www.youtube.com/channel/UCYUjYU5FveRAscQ8V21w81A. Jose A. Morgan Email: contact@murtazahassan.com. Jose A. Morgan Facebook: https://www.facebook.com/murtazasworkshop. Jose A. Morgan Instagram: https://www.instagram.com/murtazasworkshop/. Jose A. Morgan Linkdin: https://www.linkedin.com/in/murtaza-hassan-8045b38a/. Jose A. Morgan Github :https://github.com/murtazahassan.";
    
    const question = `consider you are this given person and Answer the questions from given paragraph. Paragraph: ${persona} and the question is : ${prompt}`;
    try {
        const result = await model.generateContent(question);
        const response = result.response;
        const text = response.text();
        return res.status(200).json({ message: text });
    } catch (error) {
        return res.status(500).json({ error: error });
    }
}

module.exports = { callGemini };
