require("dotenv").config();
const nodemailer = require('nodemailer');

const sendEmail = async (req, res) => {
  const { name, email, message } = req.body;

  if (!name || !email || !message) {
    return res.status(400).json({ error: 'All fields are required.' });
  }

  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  if (!emailRegex.test(email)) {
    return res.status(400).json({ error: 'Invalid email format.' });
  }

  const emailContent = `
    Name: ${name}
    Email: ${email}
    Message: ${message}
  `;

  // Nodemailer configuration
  const transporter = nodemailer.createTransport({
    service: "gmail",
    auth: {
      user: process.env.My_Email,
      pass: process.env.My_Pass,
    },
  });

  try {
    await transporter.sendMail({
      from: process.env.My_Email,
      to: '201306@pakaims.edu.pk',
      subject: 'New Message from Contact Form',
      text: emailContent
    });

    return res.status(200).json({ message: 'Email sent successfully.' });
  } catch (error) {
    console.error('Error sending email:', error);
    return res.status(500).json({ error: 'Failed to send email.' });
  }
};

module.exports = { sendEmail };
