export type IconFamily = "classic" | "duotone" | "sharp" | "sharp-duotone";
export type IconPrefix = "fas" | "fass" | "far" | "fasr" | "fal" | "fasl" | "fat" | "fast" | "fad" | "fasds" | "fab" | "fak" | "fakd";
export type CssStyleClass = "fa-solid" | "fa-regular" | "fa-light" | "fa-thin" | "fa-duotone" | "fa-brands";
export type IconStyle = "solid" | "regular" | "light" | "thin" | "duotone" | "brands";
export type IconPathData = string | string[]

export interface IconLookup {
  prefix: IconPrefix;
  // IconName is defined in the code that will be generated at build time and bundled with this file.
  iconName: IconName;
}

export interface IconDefinition extends IconLookup {
  icon: [
    number, // width
    number, // height
    string[], // ligatures
    string, // unicode
    IconPathData // svgPathData
  ];
}

export interface IconPack {
  [key: string]: IconDefinition;
}

export type IconName = '0' | 
  '00' | 
  '1' | 
  '100' | 
  '2' | 
  '3' | 
  '360-degrees' | 
  '4' | 
  '42-group' | 
  '5' | 
  '500px' | 
  '6' | 
  '7' | 
  '8' | 
  '9' | 
  'a' | 
  'abacus' | 
  'accent-grave' | 
  'accessible-icon' | 
  'accusoft' | 
  'acorn' | 
  'ad' | 
  'add' | 
  'address-book' | 
  'address-card' | 
  'adjust' | 
  'adn' | 
  'adversal' | 
  'affiliatetheme' | 
  'air-conditioner' | 
  'air-freshener' | 
  'airbnb' | 
  'airplay' | 
  'alarm-clock' | 
  'alarm-exclamation' | 
  'alarm-plus' | 
  'alarm-snooze' | 
  'album' | 
  'album-circle-plus' | 
  'album-circle-user' | 
  'album-collection' | 
  'album-collection-circle-plus' | 
  'album-collection-circle-user' | 
  'algolia' | 
  'alicorn' | 
  'alien' | 
  'alien-8bit' | 
  'alien-monster' | 
  'align-center' | 
  'align-justify' | 
  'align-left' | 
  'align-right' | 
  'align-slash' | 
  'alipay' | 
  'allergies' | 
  'alt' | 
  'amazon' | 
  'amazon-pay' | 
  'ambulance' | 
  'american-sign-language-interpreting' | 
  'amilia' | 
  'amp-guitar' | 
  'ampersand' | 
  'analytics' | 
  'anchor' | 
  'anchor-circle-check' | 
  'anchor-circle-exclamation' | 
  'anchor-circle-xmark' | 
  'anchor-lock' | 
  'android' | 
  'angel' | 
  'angellist' | 
  'angle' | 
  'angle-90' | 
  'angle-double-down' | 
  'angle-double-left' | 
  'angle-double-right' | 
  'angle-double-up' | 
  'angle-down' | 
  'angle-left' | 
  'angle-right' | 
  'angle-up' | 
  'angles-down' | 
  'angles-left' | 
  'angles-right' | 
  'angles-up' | 
  'angles-up-down' | 
  'angry' | 
  'angrycreative' | 
  'angular' | 
  'ankh' | 
  'ant' | 
  'apartment' | 
  'aperture' | 
  'apostrophe' | 
  'app-store' | 
  'app-store-ios' | 
  'apper' | 
  'apple' | 
  'apple-alt' | 
  'apple-core' | 
  'apple-crate' | 
  'apple-pay' | 
  'apple-whole' | 
  'archive' | 
  'archway' | 
  'area-chart' | 
  'arrow-alt-circle-down' | 
  'arrow-alt-circle-left' | 
  'arrow-alt-circle-right' | 
  'arrow-alt-circle-up' | 
  'arrow-alt-down' | 
  'arrow-alt-from-bottom' | 
  'arrow-alt-from-left' | 
  'arrow-alt-from-right' | 
  'arrow-alt-from-top' | 
  'arrow-alt-left' | 
  'arrow-alt-right' | 
  'arrow-alt-square-down' | 
  'arrow-alt-square-left' | 
  'arrow-alt-square-right' | 
  'arrow-alt-square-up' | 
  'arrow-alt-to-bottom' | 
  'arrow-alt-to-left' | 
  'arrow-alt-to-right' | 
  'arrow-alt-to-top' | 
  'arrow-alt-up' | 
  'arrow-circle-down' | 
  'arrow-circle-left' | 
  'arrow-circle-right' | 
  'arrow-circle-up' | 
  'arrow-down' | 
  'arrow-down-1-9' | 
  'arrow-down-9-1' | 
  'arrow-down-a-z' | 
  'arrow-down-arrow-up' | 
  'arrow-down-big-small' | 
  'arrow-down-from-arc' | 
  'arrow-down-from-bracket' | 
  'arrow-down-from-dotted-line' | 
  'arrow-down-from-line' | 
  'arrow-down-left' | 
  'arrow-down-left-and-arrow-up-right-to-center' | 
  'arrow-down-long' | 
  'arrow-down-right' | 
  'arrow-down-short-wide' | 
  'arrow-down-small-big' | 
  'arrow-down-square-triangle' | 
  'arrow-down-to-arc' | 
  'arrow-down-to-bracket' | 
  'arrow-down-to-dotted-line' | 
  'arrow-down-to-line' | 
  'arrow-down-to-square' | 
  'arrow-down-triangle-square' | 
  'arrow-down-up-across-line' | 
  'arrow-down-up-lock' | 
  'arrow-down-wide-short' | 
  'arrow-down-z-a' | 
  'arrow-from-bottom' | 
  'arrow-from-left' | 
  'arrow-from-right' | 
  'arrow-from-top' | 
  'arrow-left' | 
  'arrow-left-from-arc' | 
  'arrow-left-from-bracket' | 
  'arrow-left-from-line' | 
  'arrow-left-long' | 
  'arrow-left-long-to-line' | 
  'arrow-left-rotate' | 
  'arrow-left-to-arc' | 
  'arrow-left-to-bracket' | 
  'arrow-left-to-line' | 
  'arrow-pointer' | 
  'arrow-progress' | 
  'arrow-right' | 
  'arrow-right-arrow-left' | 
  'arrow-right-from-arc' | 
  'arrow-right-from-bracket' | 
  'arrow-right-from-file' | 
  'arrow-right-from-line' | 
  'arrow-right-long' | 
  'arrow-right-long-to-line' | 
  'arrow-right-rotate' | 
  'arrow-right-to-arc' | 
  'arrow-right-to-bracket' | 
  'arrow-right-to-city' | 
  'arrow-right-to-file' | 
  'arrow-right-to-line' | 
  'arrow-rotate-back' | 
  'arrow-rotate-backward' | 
  'arrow-rotate-forward' | 
  'arrow-rotate-left' | 
  'arrow-rotate-right' | 
  'arrow-square-down' | 
  'arrow-square-left' | 
  'arrow-square-right' | 
  'arrow-square-up' | 
  'arrow-to-bottom' | 
  'arrow-to-left' | 
  'arrow-to-right' | 
  'arrow-to-top' | 
  'arrow-trend-down' | 
  'arrow-trend-up' | 
  'arrow-turn-down' | 
  'arrow-turn-down-left' | 
  'arrow-turn-down-right' | 
  'arrow-turn-left' | 
  'arrow-turn-left-down' | 
  'arrow-turn-left-up' | 
  'arrow-turn-right' | 
  'arrow-turn-up' | 
  'arrow-up' | 
  'arrow-up-1-9' | 
  'arrow-up-9-1' | 
  'arrow-up-a-z' | 
  'arrow-up-arrow-down' | 
  'arrow-up-big-small' | 
  'arrow-up-from-arc' | 
  'arrow-up-from-bracket' | 
  'arrow-up-from-dotted-line' | 
  'arrow-up-from-ground-water' | 
  'arrow-up-from-line' | 
  'arrow-up-from-square' | 
  'arrow-up-from-water-pump' | 
  'arrow-up-left' | 
  'arrow-up-left-from-circle' | 
  'arrow-up-long' | 
  'arrow-up-right' | 
  'arrow-up-right-and-arrow-down-left-from-center' | 
  'arrow-up-right-dots' | 
  'arrow-up-right-from-square' | 
  'arrow-up-short-wide' | 
  'arrow-up-small-big' | 
  'arrow-up-square-triangle' | 
  'arrow-up-to-arc' | 
  'arrow-up-to-bracket' | 
  'arrow-up-to-dotted-line' | 
  'arrow-up-to-line' | 
  'arrow-up-triangle-square' | 
  'arrow-up-wide-short' | 
  'arrow-up-z-a' | 
  'arrows' | 
  'arrows-alt' | 
  'arrows-alt-h' | 
  'arrows-alt-v' | 
  'arrows-cross' | 
  'arrows-down-to-line' | 
  'arrows-down-to-people' | 
  'arrows-from-dotted-line' | 
  'arrows-from-line' | 
  'arrows-h' | 
  'arrows-left-right' | 
  'arrows-left-right-to-line' | 
  'arrows-maximize' | 
  'arrows-minimize' | 
  'arrows-repeat' | 
  'arrows-repeat-1' | 
  'arrows-retweet' | 
  'arrows-rotate' | 
  'arrows-rotate-reverse' | 
  'arrows-spin' | 
  'arrows-split-up-and-left' | 
  'arrows-to-circle' | 
  'arrows-to-dot' | 
  'arrows-to-dotted-line' | 
  'arrows-to-eye' | 
  'arrows-to-line' | 
  'arrows-turn-right' | 
  'arrows-turn-to-dots' | 
  'arrows-up-down' | 
  'arrows-up-down-left-right' | 
  'arrows-up-to-line' | 
  'arrows-v' | 
  'artstation' | 
  'asl-interpreting' | 
  'assistive-listening-systems' | 
  'asterisk' | 
  'asymmetrik' | 
  'at' | 
  'atlas' | 
  'atlassian' | 
  'atom' | 
  'atom-alt' | 
  'atom-simple' | 
  'audible' | 
  'audio-description' | 
  'audio-description-slash' | 
  'austral-sign' | 
  'automobile' | 
  'autoprefixer' | 
  'avianex' | 
  'aviato' | 
  'avocado' | 
  'award' | 
  'award-simple' | 
  'aws' | 
  'axe' | 
  'axe-battle' | 
  'b' | 
  'baby' | 
  'baby-carriage' | 
  'backpack' | 
  'backspace' | 
  'backward' | 
  'backward-fast' | 
  'backward-step' | 
  'bacon' | 
  'bacteria' | 
  'bacterium' | 
  'badge' | 
  'badge-check' | 
  'badge-dollar' | 
  'badge-percent' | 
  'badge-sheriff' | 
  'badger-honey' | 
  'badminton' | 
  'bag-seedling' | 
  'bag-shopping' | 
  'bag-shopping-minus' | 
  'bag-shopping-plus' | 
  'bagel' | 
  'bags-shopping' | 
  'baguette' | 
  'bahai' | 
  'baht-sign' | 
  'balance-scale' | 
  'balance-scale-left' | 
  'balance-scale-right' | 
  'ball-pile' | 
  'balloon' | 
  'balloons' | 
  'ballot' | 
  'ballot-check' | 
  'ban' | 
  'ban-bug' | 
  'ban-parking' | 
  'ban-smoking' | 
  'banana' | 
  'band-aid' | 
  'bandage' | 
  'bandcamp' | 
  'bangladeshi-taka-sign' | 
  'banjo' | 
  'bank' | 
  'bar-chart' | 
  'barcode' | 
  'barcode-alt' | 
  'barcode-read' | 
  'barcode-scan' | 
  'barn-silo' | 
  'bars' | 
  'bars-filter' | 
  'bars-progress' | 
  'bars-sort' | 
  'bars-staggered' | 
  'baseball' | 
  'baseball-ball' | 
  'baseball-bat-ball' | 
  'basket-shopping' | 
  'basket-shopping-minus' | 
  'basket-shopping-plus' | 
  'basket-shopping-simple' | 
  'basketball' | 
  'basketball-ball' | 
  'basketball-hoop' | 
  'bat' | 
  'bath' | 
  'bathtub' | 
  'battery' | 
  'battery-bolt' | 
  'battery-car' | 
  'battery-empty' | 
  'battery-exclamation' | 
  'battery-full' | 
  'battery-half' | 
  'battery-low' | 
  'battery-quarter' | 
  'battery-slash' | 
  'battery-three-quarters' | 
  'battery0' | 
  'battery1' | 
  'battery2' | 
  'battery3' | 
  'battery4' | 
  'battery5' | 
  'battle-net' | 
  'bed' | 
  'bed-alt' | 
  'bed-bunk' | 
  'bed-empty' | 
  'bed-front' | 
  'bed-pulse' | 
  'bee' | 
  'beer' | 
  'beer-foam' | 
  'beer-mug' | 
  'beer-mug-empty' | 
  'behance' | 
  'behance-square' | 
  'bell' | 
  'bell-concierge' | 
  'bell-exclamation' | 
  'bell-on' | 
  'bell-plus' | 
  'bell-ring' | 
  'bell-school' | 
  'bell-school-slash' | 
  'bell-slash' | 
  'bells' | 
  'bench-tree' | 
  'betamax' | 
  'bezier-curve' | 
  'bible' | 
  'bicycle' | 
  'biking' | 
  'biking-mountain' | 
  'bilibili' | 
  'billboard' | 
  'bimobject' | 
  'bin-bottles' | 
  'bin-bottles-recycle' | 
  'bin-recycle' | 
  'binary' | 
  'binary-circle-check' | 
  'binary-lock' | 
  'binary-slash' | 
  'binoculars' | 
  'biohazard' | 
  'bird' | 
  'birthday-cake' | 
  'bitbucket' | 
  'bitcoin' | 
  'bitcoin-sign' | 
  'bity' | 
  'black-tie' | 
  'blackberry' | 
  'blackboard' | 
  'blanket' | 
  'blanket-fire' | 
  'blender' | 
  'blender-phone' | 
  'blind' | 
  'blinds' | 
  'blinds-open' | 
  'blinds-raised' | 
  'block' | 
  'block-brick' | 
  'block-brick-fire' | 
  'block-question' | 
  'block-quote' | 
  'blog' | 
  'blogger' | 
  'blogger-b' | 
  'blueberries' | 
  'bluesky' | 
  'bluetooth' | 
  'bluetooth-b' | 
  'bold' | 
  'bolt' | 
  'bolt-auto' | 
  'bolt-lightning' | 
  'bolt-slash' | 
  'bomb' | 
  'bone' | 
  'bone-break' | 
  'bong' | 
  'book' | 
  'book-alt' | 
  'book-arrow-right' | 
  'book-arrow-up' | 
  'book-atlas' | 
  'book-bible' | 
  'book-blank' | 
  'book-bookmark' | 
  'book-circle' | 
  'book-circle-arrow-right' | 
  'book-circle-arrow-up' | 
  'book-copy' | 
  'book-dead' | 
  'book-font' | 
  'book-heart' | 
  'book-journal-whills' | 
  'book-law' | 
  'book-medical' | 
  'book-open' | 
  'book-open-alt' | 
  'book-open-cover' | 
  'book-open-reader' | 
  'book-quran' | 
  'book-reader' | 
  'book-section' | 
  'book-skull' | 
  'book-sparkles' | 
  'book-spells' | 
  'book-tanakh' | 
  'book-user' | 
  'bookmark' | 
  'bookmark-circle' | 
  'bookmark-slash' | 
  'books' | 
  'books-medical' | 
  'boombox' | 
  'boot' | 
  'boot-heeled' | 
  'booth-curtain' | 
  'bootstrap' | 
  'border-all' | 
  'border-bottom' | 
  'border-bottom-right' | 
  'border-center-h' | 
  'border-center-v' | 
  'border-inner' | 
  'border-left' | 
  'border-none' | 
  'border-outer' | 
  'border-right' | 
  'border-style' | 
  'border-style-alt' | 
  'border-top' | 
  'border-top-left' | 
  'bore-hole' | 
  'bots' | 
  'bottle-baby' | 
  'bottle-droplet' | 
  'bottle-water' | 
  'bow-arrow' | 
  'bowl-chopsticks' | 
  'bowl-chopsticks-noodles' | 
  'bowl-food' | 
  'bowl-hot' | 
  'bowl-rice' | 
  'bowl-salad' | 
  'bowl-scoop' | 
  'bowl-scoops' | 
  'bowl-shaved-ice' | 
  'bowl-soft-serve' | 
  'bowl-spoon' | 
  'bowling-ball' | 
  'bowling-ball-pin' | 
  'bowling-pins' | 
  'box' | 
  'box-alt' | 
  'box-archive' | 
  'box-ballot' | 
  'box-check' | 
  'box-circle-check' | 
  'box-dollar' | 
  'box-fragile' | 
  'box-full' | 
  'box-heart' | 
  'box-open' | 
  'box-open-full' | 
  'box-taped' | 
  'box-tissue' | 
  'box-up' | 
  'box-usd' | 
  'boxes' | 
  'boxes-alt' | 
  'boxes-packing' | 
  'boxes-stacked' | 
  'boxing-glove' | 
  'bracket' | 
  'bracket-curly' | 
  'bracket-curly-left' | 
  'bracket-curly-right' | 
  'bracket-left' | 
  'bracket-round' | 
  'bracket-round-right' | 
  'bracket-square' | 
  'bracket-square-right' | 
  'brackets' | 
  'brackets-curly' | 
  'brackets-round' | 
  'brackets-square' | 
  'braille' | 
  'brain' | 
  'brain-arrow-curved-right' | 
  'brain-circuit' | 
  'brake-warning' | 
  'brave' | 
  'brave-reverse' | 
  'brazilian-real-sign' | 
  'bread-loaf' | 
  'bread-slice' | 
  'bread-slice-butter' | 
  'bridge' | 
  'bridge-circle-check' | 
  'bridge-circle-exclamation' | 
  'bridge-circle-xmark' | 
  'bridge-lock' | 
  'bridge-suspension' | 
  'bridge-water' | 
  'briefcase' | 
  'briefcase-arrow-right' | 
  'briefcase-blank' | 
  'briefcase-clock' | 
  'briefcase-medical' | 
  'brightness' | 
  'brightness-low' | 
  'bring-forward' | 
  'bring-front' | 
  'broadcast-tower' | 
  'broccoli' | 
  'broom' | 
  'broom-ball' | 
  'broom-wide' | 
  'browser' | 
  'browsers' | 
  'brush' | 
  'btc' | 
  'bucket' | 
  'buffer' | 
  'bug' | 
  'bug-slash' | 
  'bugs' | 
  'building' | 
  'building-circle-arrow-right' | 
  'building-circle-check' | 
  'building-circle-exclamation' | 
  'building-circle-xmark' | 
  'building-columns' | 
  'building-flag' | 
  'building-lock' | 
  'building-magnifying-glass' | 
  'building-memo' | 
  'building-ngo' | 
  'building-shield' | 
  'building-un' | 
  'building-user' | 
  'building-wheat' | 
  'buildings' | 
  'bulldozer' | 
  'bullhorn' | 
  'bullseye' | 
  'bullseye-arrow' | 
  'bullseye-pointer' | 
  'buoy' | 
  'buoy-mooring' | 
  'burger' | 
  'burger-cheese' | 
  'burger-fries' | 
  'burger-glass' | 
  'burger-lettuce' | 
  'burger-soda' | 
  'burn' | 
  'buromobelexperte' | 
  'burrito' | 
  'burst' | 
  'bus' | 
  'bus-alt' | 
  'bus-school' | 
  'bus-simple' | 
  'business-front' | 
  'business-time' | 
  'butter' | 
  'buy-n-large' | 
  'buysellads' | 
  'c' | 
  'cab' | 
  'cabin' | 
  'cabinet-filing' | 
  'cable-car' | 
  'cactus' | 
  'caduceus' | 
  'cake' | 
  'cake-candles' | 
  'cake-slice' | 
  'calculator' | 
  'calculator-alt' | 
  'calculator-simple' | 
  'calendar' | 
  'calendar-alt' | 
  'calendar-arrow-down' | 
  'calendar-arrow-up' | 
  'calendar-check' | 
  'calendar-circle' | 
  'calendar-circle-exclamation' | 
  'calendar-circle-minus' | 
  'calendar-circle-plus' | 
  'calendar-circle-user' | 
  'calendar-clock' | 
  'calendar-day' | 
  'calendar-days' | 
  'calendar-download' | 
  'calendar-edit' | 
  'calendar-exclamation' | 
  'calendar-heart' | 
  'calendar-image' | 
  'calendar-lines' | 
  'calendar-lines-pen' | 
  'calendar-minus' | 
  'calendar-note' | 
  'calendar-pen' | 
  'calendar-plus' | 
  'calendar-range' | 
  'calendar-star' | 
  'calendar-time' | 
  'calendar-times' | 
  'calendar-upload' | 
  'calendar-users' | 
  'calendar-week' | 
  'calendar-xmark' | 
  'calendars' | 
  'camcorder' | 
  'camera' | 
  'camera-alt' | 
  'camera-cctv' | 
  'camera-circle' | 
  'camera-home' | 
  'camera-movie' | 
  'camera-polaroid' | 
  'camera-retro' | 
  'camera-rotate' | 
  'camera-security' | 
  'camera-slash' | 
  'camera-viewfinder' | 
  'camera-web' | 
  'camera-web-slash' | 
  'campfire' | 
  'campground' | 
  'can-food' | 
  'canadian-maple-leaf' | 
  'cancel' | 
  'candle-holder' | 
  'candy' | 
  'candy-bar' | 
  'candy-cane' | 
  'candy-corn' | 
  'cannabis' | 
  'cannon' | 
  'capsules' | 
  'car' | 
  'car-alt' | 
  'car-battery' | 
  'car-bolt' | 
  'car-building' | 
  'car-bump' | 
  'car-burst' | 
  'car-bus' | 
  'car-circle-bolt' | 
  'car-crash' | 
  'car-garage' | 
  'car-mechanic' | 
  'car-mirrors' | 
  'car-on' | 
  'car-rear' | 
  'car-side' | 
  'car-side-bolt' | 
  'car-tilt' | 
  'car-tunnel' | 
  'car-wash' | 
  'car-wrench' | 
  'caravan' | 
  'caravan-alt' | 
  'caravan-simple' | 
  'card-club' | 
  'card-diamond' | 
  'card-heart' | 
  'card-spade' | 
  'cards' | 
  'cards-blank' | 
  'caret-circle-down' | 
  'caret-circle-left' | 
  'caret-circle-right' | 
  'caret-circle-up' | 
  'caret-down' | 
  'caret-left' | 
  'caret-right' | 
  'caret-square-down' | 
  'caret-square-left' | 
  'caret-square-right' | 
  'caret-square-up' | 
  'caret-up' | 
  'carriage-baby' | 
  'carrot' | 
  'cars' | 
  'cart-arrow-down' | 
  'cart-arrow-up' | 
  'cart-circle-arrow-down' | 
  'cart-circle-arrow-up' | 
  'cart-circle-check' | 
  'cart-circle-exclamation' | 
  'cart-circle-plus' | 
  'cart-circle-xmark' | 
  'cart-flatbed' | 
  'cart-flatbed-boxes' | 
  'cart-flatbed-empty' | 
  'cart-flatbed-suitcase' | 
  'cart-minus' | 
  'cart-plus' | 
  'cart-shopping' | 
  'cart-shopping-fast' | 
  'cart-xmark' | 
  'cash-register' | 
  'cassette-betamax' | 
  'cassette-tape' | 
  'cassette-vhs' | 
  'castle' | 
  'cat' | 
  'cat-space' | 
  'cauldron' | 
  'cc-amazon-pay' | 
  'cc-amex' | 
  'cc-apple-pay' | 
  'cc-diners-club' | 
  'cc-discover' | 
  'cc-jcb' | 
  'cc-mastercard' | 
  'cc-paypal' | 
  'cc-stripe' | 
  'cc-visa' | 
  'cctv' | 
  'cedi-sign' | 
  'cent-sign' | 
  'centercode' | 
  'centos' | 
  'certificate' | 
  'chain' | 
  'chain-broken' | 
  'chain-horizontal' | 
  'chain-horizontal-slash' | 
  'chain-slash' | 
  'chair' | 
  'chair-office' | 
  'chalkboard' | 
  'chalkboard-teacher' | 
  'chalkboard-user' | 
  'champagne-glass' | 
  'champagne-glasses' | 
  'charging-station' | 
  'chart-area' | 
  'chart-bar' | 
  'chart-bullet' | 
  'chart-candlestick' | 
  'chart-column' | 
  'chart-gantt' | 
  'chart-kanban' | 
  'chart-line' | 
  'chart-line-down' | 
  'chart-line-up' | 
  'chart-line-up-down' | 
  'chart-mixed' | 
  'chart-mixed-up-circle-currency' | 
  'chart-mixed-up-circle-dollar' | 
  'chart-network' | 
  'chart-pie' | 
  'chart-pie-alt' | 
  'chart-pie-simple' | 
  'chart-pie-simple-circle-currency' | 
  'chart-pie-simple-circle-dollar' | 
  'chart-pyramid' | 
  'chart-radar' | 
  'chart-scatter' | 
  'chart-scatter-3d' | 
  'chart-scatter-bubble' | 
  'chart-simple' | 
  'chart-simple-horizontal' | 
  'chart-tree-map' | 
  'chart-user' | 
  'chart-waterfall' | 
  'check' | 
  'check-circle' | 
  'check-double' | 
  'check-square' | 
  'check-to-slot' | 
  'cheese' | 
  'cheese-swiss' | 
  'cheeseburger' | 
  'cherries' | 
  'chess' | 
  'chess-bishop' | 
  'chess-bishop-alt' | 
  'chess-bishop-piece' | 
  'chess-board' | 
  'chess-clock' | 
  'chess-clock-alt' | 
  'chess-clock-flip' | 
  'chess-king' | 
  'chess-king-alt' | 
  'chess-king-piece' | 
  'chess-knight' | 
  'chess-knight-alt' | 
  'chess-knight-piece' | 
  'chess-pawn' | 
  'chess-pawn-alt' | 
  'chess-pawn-piece' | 
  'chess-queen' | 
  'chess-queen-alt' | 
  'chess-queen-piece' | 
  'chess-rook' | 
  'chess-rook-alt' | 
  'chess-rook-piece' | 
  'chestnut' | 
  'chevron-circle-down' | 
  'chevron-circle-left' | 
  'chevron-circle-right' | 
  'chevron-circle-up' | 
  'chevron-double-down' | 
  'chevron-double-left' | 
  'chevron-double-right' | 
  'chevron-double-up' | 
  'chevron-down' | 
  'chevron-left' | 
  'chevron-right' | 
  'chevron-square-down' | 
  'chevron-square-left' | 
  'chevron-square-right' | 
  'chevron-square-up' | 
  'chevron-up' | 
  'chevrons-down' | 
  'chevrons-left' | 
  'chevrons-right' | 
  'chevrons-up' | 
  'chf-sign' | 
  'child' | 
  'child-combatant' | 
  'child-dress' | 
  'child-reaching' | 
  'child-rifle' | 
  'children' | 
  'chimney' | 
  'chocolate-bar' | 
  'chopsticks' | 
  'chrome' | 
  'chromecast' | 
  'church' | 
  'circle' | 
  'circle-0' | 
  'circle-1' | 
  'circle-2' | 
  'circle-3' | 
  'circle-4' | 
  'circle-5' | 
  'circle-6' | 
  'circle-7' | 
  'circle-8' | 
  'circle-9' | 
  'circle-a' | 
  'circle-ampersand' | 
  'circle-arrow-down' | 
  'circle-arrow-down-left' | 
  'circle-arrow-down-right' | 
  'circle-arrow-left' | 
  'circle-arrow-right' | 
  'circle-arrow-up' | 
  'circle-arrow-up-left' | 
  'circle-arrow-up-right' | 
  'circle-b' | 
  'circle-bolt' | 
  'circle-book-open' | 
  'circle-bookmark' | 
  'circle-c' | 
  'circle-calendar' | 
  'circle-camera' | 
  'circle-caret-down' | 
  'circle-caret-left' | 
  'circle-caret-right' | 
  'circle-caret-up' | 
  'circle-check' | 
  'circle-chevron-down' | 
  'circle-chevron-left' | 
  'circle-chevron-right' | 
  'circle-chevron-up' | 
  'circle-d' | 
  'circle-dashed' | 
  'circle-divide' | 
  'circle-dollar' | 
  'circle-dollar-to-slot' | 
  'circle-dot' | 
  'circle-down' | 
  'circle-down-left' | 
  'circle-down-right' | 
  'circle-e' | 
  'circle-ellipsis' | 
  'circle-ellipsis-vertical' | 
  'circle-envelope' | 
  'circle-euro' | 
  'circle-exclamation' | 
  'circle-exclamation-check' | 
  'circle-f' | 
  'circle-g' | 
  'circle-gf' | 
  'circle-h' | 
  'circle-half' | 
  'circle-half-stroke' | 
  'circle-heart' | 
  'circle-i' | 
  'circle-info' | 
  'circle-j' | 
  'circle-k' | 
  'circle-l' | 
  'circle-left' | 
  'circle-location-arrow' | 
  'circle-m' | 
  'circle-microphone' | 
  'circle-microphone-lines' | 
  'circle-minus' | 
  'circle-n' | 
  'circle-nodes' | 
  'circle-notch' | 
  'circle-o' | 
  'circle-p' | 
  'circle-parking' | 
  'circle-pause' | 
  'circle-phone' | 
  'circle-phone-flip' | 
  'circle-phone-hangup' | 
  'circle-play' | 
  'circle-plus' | 
  'circle-q' | 
  'circle-quarter' | 
  'circle-quarter-stroke' | 
  'circle-quarters' | 
  'circle-question' | 
  'circle-r' | 
  'circle-radiation' | 
  'circle-right' | 
  'circle-s' | 
  'circle-small' | 
  'circle-sort' | 
  'circle-sort-down' | 
  'circle-sort-up' | 
  'circle-star' | 
  'circle-sterling' | 
  'circle-stop' | 
  'circle-t' | 
  'circle-three-quarters' | 
  'circle-three-quarters-stroke' | 
  'circle-trash' | 
  'circle-u' | 
  'circle-up' | 
  'circle-up-left' | 
  'circle-up-right' | 
  'circle-user' | 
  'circle-v' | 
  'circle-video' | 
  'circle-w' | 
  'circle-waveform-lines' | 
  'circle-wifi' | 
  'circle-wifi-circle-wifi' | 
  'circle-wifi-group' | 
  'circle-x' | 
  'circle-xmark' | 
  'circle-y' | 
  'circle-yen' | 
  'circle-z' | 
  'circles-overlap' | 
  'citrus' | 
  'citrus-slice' | 
  'city' | 
  'clapperboard' | 
  'clapperboard-play' | 
  'clarinet' | 
  'claw-marks' | 
  'clinic-medical' | 
  'clipboard' | 
  'clipboard-check' | 
  'clipboard-list' | 
  'clipboard-list-check' | 
  'clipboard-medical' | 
  'clipboard-prescription' | 
  'clipboard-question' | 
  'clipboard-user' | 
  'clock' | 
  'clock-desk' | 
  'clock-eight' | 
  'clock-eight-thirty' | 
  'clock-eleven' | 
  'clock-eleven-thirty' | 
  'clock-five' | 
  'clock-five-thirty' | 
  'clock-four' | 
  'clock-four-thirty' | 
  'clock-nine' | 
  'clock-nine-thirty' | 
  'clock-one' | 
  'clock-one-thirty' | 
  'clock-rotate-left' | 
  'clock-seven' | 
  'clock-seven-thirty' | 
  'clock-six' | 
  'clock-six-thirty' | 
  'clock-ten' | 
  'clock-ten-thirty' | 
  'clock-three' | 
  'clock-three-thirty' | 
  'clock-twelve' | 
  'clock-twelve-thirty' | 
  'clock-two' | 
  'clock-two-thirty' | 
  'clone' | 
  'close' | 
  'closed-captioning' | 
  'closed-captioning-slash' | 
  'clothes-hanger' | 
  'cloud' | 
  'cloud-arrow-down' | 
  'cloud-arrow-up' | 
  'cloud-binary' | 
  'cloud-bolt' | 
  'cloud-bolt-moon' | 
  'cloud-bolt-sun' | 
  'cloud-check' | 
  'cloud-download' | 
  'cloud-download-alt' | 
  'cloud-drizzle' | 
  'cloud-exclamation' | 
  'cloud-fog' | 
  'cloud-hail' | 
  'cloud-hail-mixed' | 
  'cloud-meatball' | 
  'cloud-minus' | 
  'cloud-moon' | 
  'cloud-moon-rain' | 
  'cloud-music' | 
  'cloud-plus' | 
  'cloud-question' | 
  'cloud-rain' | 
  'cloud-rainbow' | 
  'cloud-showers' | 
  'cloud-showers-heavy' | 
  'cloud-showers-water' | 
  'cloud-slash' | 
  'cloud-sleet' | 
  'cloud-snow' | 
  'cloud-sun' | 
  'cloud-sun-rain' | 
  'cloud-upload' | 
  'cloud-upload-alt' | 
  'cloud-word' | 
  'cloud-xmark' | 
  'cloudflare' | 
  'clouds' | 
  'clouds-moon' | 
  'clouds-sun' | 
  'cloudscale' | 
  'cloudsmith' | 
  'cloudversify' | 
  'clover' | 
  'club' | 
  'cmplid' | 
  'cny' | 
  'cocktail' | 
  'coconut' | 
  'code' | 
  'code-branch' | 
  'code-commit' | 
  'code-compare' | 
  'code-fork' | 
  'code-merge' | 
  'code-pull-request' | 
  'code-pull-request-closed' | 
  'code-pull-request-draft' | 
  'code-simple' | 
  'codepen' | 
  'codiepie' | 
  'coffee' | 
  'coffee-bean' | 
  'coffee-beans' | 
  'coffee-pot' | 
  'coffee-togo' | 
  'coffin' | 
  'coffin-cross' | 
  'cog' | 
  'cogs' | 
  'coin' | 
  'coin-blank' | 
  'coin-front' | 
  'coin-vertical' | 
  'coins' | 
  'colon' | 
  'colon-sign' | 
  'columns' | 
  'columns-3' | 
  'comet' | 
  'comma' | 
  'command' | 
  'comment' | 
  'comment-alt' | 
  'comment-alt-arrow-down' | 
  'comment-alt-arrow-up' | 
  'comment-alt-captions' | 
  'comment-alt-check' | 
  'comment-alt-dollar' | 
  'comment-alt-dots' | 
  'comment-alt-edit' | 
  'comment-alt-exclamation' | 
  'comment-alt-image' | 
  'comment-alt-lines' | 
  'comment-alt-medical' | 
  'comment-alt-minus' | 
  'comment-alt-music' | 
  'comment-alt-plus' | 
  'comment-alt-quote' | 
  'comment-alt-slash' | 
  'comment-alt-smile' | 
  'comment-alt-text' | 
  'comment-alt-times' | 
  'comment-arrow-down' | 
  'comment-arrow-up' | 
  'comment-arrow-up-right' | 
  'comment-captions' | 
  'comment-check' | 
  'comment-code' | 
  'comment-dollar' | 
  'comment-dots' | 
  'comment-edit' | 
  'comment-exclamation' | 
  'comment-heart' | 
  'comment-image' | 
  'comment-lines' | 
  'comment-medical' | 
  'comment-middle' | 
  'comment-middle-alt' | 
  'comment-middle-top' | 
  'comment-middle-top-alt' | 
  'comment-minus' | 
  'comment-music' | 
  'comment-pen' | 
  'comment-plus' | 
  'comment-question' | 
  'comment-quote' | 
  'comment-slash' | 
  'comment-smile' | 
  'comment-sms' | 
  'comment-text' | 
  'comment-times' | 
  'comment-xmark' | 
  'commenting' | 
  'comments' | 
  'comments-alt' | 
  'comments-alt-dollar' | 
  'comments-dollar' | 
  'comments-question' | 
  'comments-question-check' | 
  'compact-disc' | 
  'compass' | 
  'compass-drafting' | 
  'compass-slash' | 
  'compress' | 
  'compress-alt' | 
  'compress-arrows' | 
  'compress-arrows-alt' | 
  'compress-wide' | 
  'computer' | 
  'computer-classic' | 
  'computer-mouse' | 
  'computer-mouse-scrollwheel' | 
  'computer-speaker' | 
  'concierge-bell' | 
  'confluence' | 
  'connectdevelop' | 
  'construction' | 
  'contact-book' | 
  'contact-card' | 
  'container-storage' | 
  'contao' | 
  'conveyor-belt' | 
  'conveyor-belt-alt' | 
  'conveyor-belt-arm' | 
  'conveyor-belt-boxes' | 
  'conveyor-belt-empty' | 
  'cookie' | 
  'cookie-bite' | 
  'copy' | 
  'copyright' | 
  'corn' | 
  'corner' | 
  'cotton-bureau' | 
  'couch' | 
  'couch-small' | 
  'court-sport' | 
  'cow' | 
  'cowbell' | 
  'cowbell-circle-plus' | 
  'cowbell-more' | 
  'cpanel' | 
  'crab' | 
  'crate-apple' | 
  'crate-empty' | 
  'creative-commons' | 
  'creative-commons-by' | 
  'creative-commons-nc' | 
  'creative-commons-nc-eu' | 
  'creative-commons-nc-jp' | 
  'creative-commons-nd' | 
  'creative-commons-pd' | 
  'creative-commons-pd-alt' | 
  'creative-commons-remix' | 
  'creative-commons-sa' | 
  'creative-commons-sampling' | 
  'creative-commons-sampling-plus' | 
  'creative-commons-share' | 
  'creative-commons-zero' | 
  'credit-card' | 
  'credit-card-alt' | 
  'credit-card-blank' | 
  'credit-card-front' | 
  'creemee' | 
  'cricket' | 
  'cricket-bat-ball' | 
  'critical-role' | 
  'croissant' | 
  'crop' | 
  'crop-alt' | 
  'crop-simple' | 
  'cross' | 
  'crosshairs' | 
  'crosshairs-simple' | 
  'crow' | 
  'crown' | 
  'crutch' | 
  'crutches' | 
  'cruzeiro-sign' | 
  'crystal-ball' | 
  'css3' | 
  'css3-alt' | 
  'cube' | 
  'cubes' | 
  'cubes-stacked' | 
  'cucumber' | 
  'cup-straw' | 
  'cup-straw-swoosh' | 
  'cup-togo' | 
  'cupcake' | 
  'curling' | 
  'curling-stone' | 
  'custard' | 
  'cut' | 
  'cutlery' | 
  'cuttlefish' | 
  'd' | 
  'd-and-d' | 
  'd-and-d-beyond' | 
  'dagger' | 
  'dailymotion' | 
  'dart-lang' | 
  'dash' | 
  'dashboard' | 
  'dashcube' | 
  'database' | 
  'deaf' | 
  'deafness' | 
  'debian' | 
  'debug' | 
  'dedent' | 
  'deer' | 
  'deer-rudolph' | 
  'deezer' | 
  'delete-left' | 
  'delete-right' | 
  'delicious' | 
  'democrat' | 
  'deploydog' | 
  'deskpro' | 
  'desktop' | 
  'desktop-alt' | 
  'desktop-arrow-down' | 
  'desktop-code' | 
  'desktop-medical' | 
  'desktop-slash' | 
  'dev' | 
  'deviantart' | 
  'dewpoint' | 
  'dharmachakra' | 
  'dhl' | 
  'diagnoses' | 
  'diagram-cells' | 
  'diagram-lean-canvas' | 
  'diagram-nested' | 
  'diagram-next' | 
  'diagram-predecessor' | 
  'diagram-previous' | 
  'diagram-project' | 
  'diagram-sankey' | 
  'diagram-subtask' | 
  'diagram-successor' | 
  'diagram-venn' | 
  'dial' | 
  'dial-high' | 
  'dial-low' | 
  'dial-max' | 
  'dial-med' | 
  'dial-med-high' | 
  'dial-med-low' | 
  'dial-min' | 
  'dial-off' | 
  'diamond' | 
  'diamond-exclamation' | 
  'diamond-half' | 
  'diamond-half-stroke' | 
  'diamond-turn-right' | 
  'diamonds-4' | 
  'diaspora' | 
  'dice' | 
  'dice-d10' | 
  'dice-d12' | 
  'dice-d20' | 
  'dice-d4' | 
  'dice-d6' | 
  'dice-d8' | 
  'dice-five' | 
  'dice-four' | 
  'dice-one' | 
  'dice-six' | 
  'dice-three' | 
  'dice-two' | 
  'digg' | 
  'digging' | 
  'digital-ocean' | 
  'digital-tachograph' | 
  'dinosaur' | 
  'diploma' | 
  'directions' | 
  'disc-drive' | 
  'discord' | 
  'discourse' | 
  'disease' | 
  'display' | 
  'display-arrow-down' | 
  'display-chart-up' | 
  'display-chart-up-circle-currency' | 
  'display-chart-up-circle-dollar' | 
  'display-code' | 
  'display-medical' | 
  'display-slash' | 
  'distribute-spacing-horizontal' | 
  'distribute-spacing-vertical' | 
  'ditto' | 
  'divide' | 
  'dizzy' | 
  'dna' | 
  'do-not-enter' | 
  'dochub' | 
  'docker' | 
  'dog' | 
  'dog-leashed' | 
  'dollar' | 
  'dollar-circle' | 
  'dollar-sign' | 
  'dollar-square' | 
  'dolly' | 
  'dolly-box' | 
  'dolly-empty' | 
  'dolly-flatbed' | 
  'dolly-flatbed-alt' | 
  'dolly-flatbed-empty' | 
  'dolphin' | 
  'donate' | 
  'dong-sign' | 
  'donut' | 
  'door-closed' | 
  'door-open' | 
  'dot-circle' | 
  'doughnut' | 
  'dove' | 
  'down' | 
  'down-from-bracket' | 
  'down-from-dotted-line' | 
  'down-from-line' | 
  'down-left' | 
  'down-left-and-up-right-to-center' | 
  'down-long' | 
  'down-right' | 
  'down-to-bracket' | 
  'down-to-dotted-line' | 
  'down-to-line' | 
  'download' | 
  'draft2digital' | 
  'drafting-compass' | 
  'dragon' | 
  'draw-circle' | 
  'draw-polygon' | 
  'draw-square' | 
  'dreidel' | 
  'dribbble' | 
  'dribbble-square' | 
  'drivers-license' | 
  'drone' | 
  'drone-alt' | 
  'drone-front' | 
  'dropbox' | 
  'droplet' | 
  'droplet-degree' | 
  'droplet-percent' | 
  'droplet-slash' | 
  'drum' | 
  'drum-steelpan' | 
  'drumstick' | 
  'drumstick-bite' | 
  'drupal' | 
  'dryer' | 
  'dryer-alt' | 
  'dryer-heat' | 
  'duck' | 
  'dumbbell' | 
  'dumpster' | 
  'dumpster-fire' | 
  'dungeon' | 
  'dyalog' | 
  'e' | 
  'ear' | 
  'ear-deaf' | 
  'ear-listen' | 
  'ear-muffs' | 
  'earlybirds' | 
  'earth' | 
  'earth-africa' | 
  'earth-america' | 
  'earth-americas' | 
  'earth-asia' | 
  'earth-europe' | 
  'earth-oceania' | 
  'ebay' | 
  'eclipse' | 
  'eclipse-alt' | 
  'edge' | 
  'edge-legacy' | 
  'edit' | 
  'egg' | 
  'egg-fried' | 
  'eggplant' | 
  'eject' | 
  'elementor' | 
  'elephant' | 
  'elevator' | 
  'ellipsis' | 
  'ellipsis-h' | 
  'ellipsis-h-alt' | 
  'ellipsis-stroke' | 
  'ellipsis-stroke-vertical' | 
  'ellipsis-v' | 
  'ellipsis-v-alt' | 
  'ellipsis-vertical' | 
  'ello' | 
  'ember' | 
  'empire' | 
  'empty-set' | 
  'engine' | 
  'engine-exclamation' | 
  'engine-warning' | 
  'envelope' | 
  'envelope-badge' | 
  'envelope-circle' | 
  'envelope-circle-check' | 
  'envelope-dot' | 
  'envelope-open' | 
  'envelope-open-dollar' | 
  'envelope-open-text' | 
  'envelope-square' | 
  'envelopes' | 
  'envelopes-bulk' | 
  'envira' | 
  'equals' | 
  'eraser' | 
  'erlang' | 
  'escalator' | 
  'ethereum' | 
  'ethernet' | 
  'etsy' | 
  'eur' | 
  'euro' | 
  'euro-sign' | 
  'evernote' | 
  'excavator' | 
  'exchange' | 
  'exchange-alt' | 
  'exclamation' | 
  'exclamation-circle' | 
  'exclamation-square' | 
  'exclamation-triangle' | 
  'expand' | 
  'expand-alt' | 
  'expand-arrows' | 
  'expand-arrows-alt' | 
  'expand-wide' | 
  'expeditedssl' | 
  'exploding-head' | 
  'explosion' | 
  'external-link' | 
  'external-link-alt' | 
  'external-link-square' | 
  'external-link-square-alt' | 
  'eye' | 
  'eye-dropper' | 
  'eye-dropper-empty' | 
  'eye-dropper-full' | 
  'eye-dropper-half' | 
  'eye-evil' | 
  'eye-low-vision' | 
  'eye-slash' | 
  'eyedropper' | 
  'eyes' | 
  'f' | 
  'face-angry' | 
  'face-angry-horns' | 
  'face-anguished' | 
  'face-anxious-sweat' | 
  'face-astonished' | 
  'face-awesome' | 
  'face-beam-hand-over-mouth' | 
  'face-clouds' | 
  'face-confounded' | 
  'face-confused' | 
  'face-cowboy-hat' | 
  'face-diagonal-mouth' | 
  'face-disappointed' | 
  'face-disguise' | 
  'face-dizzy' | 
  'face-dotted' | 
  'face-downcast-sweat' | 
  'face-drooling' | 
  'face-exhaling' | 
  'face-explode' | 
  'face-expressionless' | 
  'face-eyes-xmarks' | 
  'face-fearful' | 
  'face-flushed' | 
  'face-frown' | 
  'face-frown-open' | 
  'face-frown-slight' | 
  'face-glasses' | 
  'face-grimace' | 
  'face-grin' | 
  'face-grin-beam' | 
  'face-grin-beam-sweat' | 
  'face-grin-hearts' | 
  'face-grin-squint' | 
  'face-grin-squint-tears' | 
  'face-grin-stars' | 
  'face-grin-tears' | 
  'face-grin-tongue' | 
  'face-grin-tongue-squint' | 
  'face-grin-tongue-wink' | 
  'face-grin-wide' | 
  'face-grin-wink' | 
  'face-hand-over-mouth' | 
  'face-hand-peeking' | 
  'face-hand-yawn' | 
  'face-head-bandage' | 
  'face-holding-back-tears' | 
  'face-hushed' | 
  'face-icicles' | 
  'face-kiss' | 
  'face-kiss-beam' | 
  'face-kiss-closed-eyes' | 
  'face-kiss-wink-heart' | 
  'face-laugh' | 
  'face-laugh-beam' | 
  'face-laugh-squint' | 
  'face-laugh-wink' | 
  'face-lying' | 
  'face-mask' | 
  'face-meh' | 
  'face-meh-blank' | 
  'face-melting' | 
  'face-monocle' | 
  'face-nauseated' | 
  'face-nose-steam' | 
  'face-party' | 
  'face-pensive' | 
  'face-persevering' | 
  'face-pleading' | 
  'face-pouting' | 
  'face-raised-eyebrow' | 
  'face-relieved' | 
  'face-rolling-eyes' | 
  'face-sad-cry' | 
  'face-sad-sweat' | 
  'face-sad-tear' | 
  'face-saluting' | 
  'face-scream' | 
  'face-shush' | 
  'face-sleeping' | 
  'face-sleepy' | 
  'face-smile' | 
  'face-smile-beam' | 
  'face-smile-halo' | 
  'face-smile-hearts' | 
  'face-smile-horns' | 
  'face-smile-plus' | 
  'face-smile-relaxed' | 
  'face-smile-tear' | 
  'face-smile-tongue' | 
  'face-smile-upside-down' | 
  'face-smile-wink' | 
  'face-smiling-hands' | 
  'face-smirking' | 
  'face-spiral-eyes' | 
  'face-sunglasses' | 
  'face-surprise' | 
  'face-swear' | 
  'face-thermometer' | 
  'face-thinking' | 
  'face-tired' | 
  'face-tissue' | 
  'face-tongue-money' | 
  'face-tongue-sweat' | 
  'face-unamused' | 
  'face-viewfinder' | 
  'face-vomit' | 
  'face-weary' | 
  'face-woozy' | 
  'face-worried' | 
  'face-zany' | 
  'face-zipper' | 
  'facebook' | 
  'facebook-f' | 
  'facebook-messenger' | 
  'facebook-square' | 
  'falafel' | 
  'family' | 
  'family-dress' | 
  'family-pants' | 
  'fan' | 
  'fan-table' | 
  'fantasy-flight-games' | 
  'farm' | 
  'fast-backward' | 
  'fast-forward' | 
  'faucet' | 
  'faucet-drip' | 
  'fax' | 
  'feather' | 
  'feather-alt' | 
  'feather-pointed' | 
  'fedex' | 
  'fedora' | 
  'feed' | 
  'female' | 
  'fence' | 
  'ferris-wheel' | 
  'ferry' | 
  'field-hockey' | 
  'field-hockey-stick-ball' | 
  'fighter-jet' | 
  'figma' | 
  'file' | 
  'file-alt' | 
  'file-archive' | 
  'file-arrow-down' | 
  'file-arrow-up' | 
  'file-audio' | 
  'file-award' | 
  'file-binary' | 
  'file-cad' | 
  'file-caret-down' | 
  'file-caret-up' | 
  'file-certificate' | 
  'file-chart-column' | 
  'file-chart-line' | 
  'file-chart-pie' | 
  'file-check' | 
  'file-circle-check' | 
  'file-circle-exclamation' | 
  'file-circle-info' | 
  'file-circle-minus' | 
  'file-circle-plus' | 
  'file-circle-question' | 
  'file-circle-xmark' | 
  'file-clipboard' | 
  'file-code' | 
  'file-contract' | 
  'file-csv' | 
  'file-dashed-line' | 
  'file-doc' | 
  'file-download' | 
  'file-edit' | 
  'file-eps' | 
  'file-excel' | 
  'file-exclamation' | 
  'file-export' | 
  'file-gif' | 
  'file-heart' | 
  'file-image' | 
  'file-import' | 
  'file-invoice' | 
  'file-invoice-dollar' | 
  'file-jpg' | 
  'file-lines' | 
  'file-lock' | 
  'file-magnifying-glass' | 
  'file-medical' | 
  'file-medical-alt' | 
  'file-minus' | 
  'file-mov' | 
  'file-mp3' | 
  'file-mp4' | 
  'file-music' | 
  'file-pdf' | 
  'file-pen' | 
  'file-plus' | 
  'file-plus-minus' | 
  'file-png' | 
  'file-powerpoint' | 
  'file-ppt' | 
  'file-prescription' | 
  'file-search' | 
  'file-shield' | 
  'file-signature' | 
  'file-slash' | 
  'file-spreadsheet' | 
  'file-svg' | 
  'file-text' | 
  'file-times' | 
  'file-upload' | 
  'file-user' | 
  'file-vector' | 
  'file-video' | 
  'file-waveform' | 
  'file-word' | 
  'file-xls' | 
  'file-xmark' | 
  'file-xml' | 
  'file-zip' | 
  'file-zipper' | 
  'files' | 
  'files-medical' | 
  'fill' | 
  'fill-drip' | 
  'film' | 
  'film-alt' | 
  'film-canister' | 
  'film-cannister' | 
  'film-simple' | 
  'film-slash' | 
  'films' | 
  'filter' | 
  'filter-circle-dollar' | 
  'filter-circle-xmark' | 
  'filter-list' | 
  'filter-slash' | 
  'filters' | 
  'fingerprint' | 
  'fire' | 
  'fire-alt' | 
  'fire-burner' | 
  'fire-extinguisher' | 
  'fire-flame' | 
  'fire-flame-curved' | 
  'fire-flame-simple' | 
  'fire-hydrant' | 
  'fire-smoke' | 
  'firefox' | 
  'firefox-browser' | 
  'fireplace' | 
  'firewall' | 
  'first-aid' | 
  'first-order' | 
  'first-order-alt' | 
  'firstdraft' | 
  'fish' | 
  'fish-bones' | 
  'fish-cooked' | 
  'fish-fins' | 
  'fishing-rod' | 
  'fist-raised' | 
  'flag' | 
  'flag-alt' | 
  'flag-checkered' | 
  'flag-pennant' | 
  'flag-swallowtail' | 
  'flag-usa' | 
  'flame' | 
  'flashlight' | 
  'flask' | 
  'flask-gear' | 
  'flask-poison' | 
  'flask-potion' | 
  'flask-round-poison' | 
  'flask-round-potion' | 
  'flask-vial' | 
  'flatbread' | 
  'flatbread-stuffed' | 
  'flickr' | 
  'flipboard' | 
  'floppy-disk' | 
  'floppy-disk-circle-arrow-right' | 
  'floppy-disk-circle-xmark' | 
  'floppy-disk-pen' | 
  'floppy-disk-times' | 
  'floppy-disks' | 
  'florin-sign' | 
  'flower' | 
  'flower-daffodil' | 
  'flower-tulip' | 
  'flushed' | 
  'flute' | 
  'flutter' | 
  'flux-capacitor' | 
  'fly' | 
  'flying-disc' | 
  'fog' | 
  'folder' | 
  'folder-arrow-down' | 
  'folder-arrow-up' | 
  'folder-blank' | 
  'folder-bookmark' | 
  'folder-check' | 
  'folder-closed' | 
  'folder-cog' | 
  'folder-download' | 
  'folder-gear' | 
  'folder-grid' | 
  'folder-heart' | 
  'folder-image' | 
  'folder-magnifying-glass' | 
  'folder-medical' | 
  'folder-minus' | 
  'folder-music' | 
  'folder-open' | 
  'folder-plus' | 
  'folder-search' | 
  'folder-times' | 
  'folder-tree' | 
  'folder-upload' | 
  'folder-user' | 
  'folder-xmark' | 
  'folders' | 
  'fondue-pot' | 
  'font' | 
  'font-awesome' | 
  'font-awesome-alt' | 
  'font-awesome-flag' | 
  'font-awesome-logo-full' | 
  'font-case' | 
  'fonticons' | 
  'fonticons-fi' | 
  'football' | 
  'football-ball' | 
  'football-helmet' | 
  'fork' | 
  'fork-knife' | 
  'forklift' | 
  'fort' | 
  'fort-awesome' | 
  'fort-awesome-alt' | 
  'forumbee' | 
  'forward' | 
  'forward-fast' | 
  'forward-step' | 
  'foursquare' | 
  'fragile' | 
  'frame' | 
  'franc-sign' | 
  'free-code-camp' | 
  'freebsd' | 
  'french-fries' | 
  'frog' | 
  'frosty-head' | 
  'frown' | 
  'frown-open' | 
  'fulcrum' | 
  'function' | 
  'funnel-dollar' | 
  'futbol' | 
  'futbol-ball' | 
  'g' | 
  'galactic-republic' | 
  'galactic-senate' | 
  'galaxy' | 
  'gallery-thumbnails' | 
  'game-board' | 
  'game-board-alt' | 
  'game-board-simple' | 
  'game-console-handheld' | 
  'game-console-handheld-crank' | 
  'gamepad' | 
  'gamepad-alt' | 
  'gamepad-modern' | 
  'garage' | 
  'garage-car' | 
  'garage-open' | 
  'garlic' | 
  'gas-pump' | 
  'gas-pump-slash' | 
  'gauge' | 
  'gauge-circle-bolt' | 
  'gauge-circle-minus' | 
  'gauge-circle-plus' | 
  'gauge-high' | 
  'gauge-low' | 
  'gauge-max' | 
  'gauge-med' | 
  'gauge-min' | 
  'gauge-simple' | 
  'gauge-simple-high' | 
  'gauge-simple-low' | 
  'gauge-simple-max' | 
  'gauge-simple-med' | 
  'gauge-simple-min' | 
  'gave-dandy' | 
  'gavel' | 
  'gbp' | 
  'gear' | 
  'gear-code' | 
  'gear-complex' | 
  'gear-complex-code' | 
  'gears' | 
  'gem' | 
  'genderless' | 
  'get-pocket' | 
  'gg' | 
  'gg-circle' | 
  'ghost' | 
  'gif' | 
  'gift' | 
  'gift-card' | 
  'gifts' | 
  'gingerbread-man' | 
  'git' | 
  'git-alt' | 
  'git-square' | 
  'github' | 
  'github-alt' | 
  'github-square' | 
  'gitkraken' | 
  'gitlab' | 
  'gitlab-square' | 
  'gitter' | 
  'glass' | 
  'glass-champagne' | 
  'glass-cheers' | 
  'glass-citrus' | 
  'glass-empty' | 
  'glass-half' | 
  'glass-half-empty' | 
  'glass-half-full' | 
  'glass-martini' | 
  'glass-martini-alt' | 
  'glass-water' | 
  'glass-water-droplet' | 
  'glass-whiskey' | 
  'glass-whiskey-rocks' | 
  'glasses' | 
  'glasses-alt' | 
  'glasses-round' | 
  'glide' | 
  'glide-g' | 
  'globe' | 
  'globe-africa' | 
  'globe-americas' | 
  'globe-asia' | 
  'globe-europe' | 
  'globe-oceania' | 
  'globe-pointer' | 
  'globe-snow' | 
  'globe-stand' | 
  'globe-wifi' | 
  'glove-boxing' | 
  'goal-net' | 
  'gofore' | 
  'golang' | 
  'golf-ball' | 
  'golf-ball-tee' | 
  'golf-club' | 
  'golf-flag-hole' | 
  'goodreads' | 
  'goodreads-g' | 
  'google' | 
  'google-drive' | 
  'google-pay' | 
  'google-play' | 
  'google-plus' | 
  'google-plus-g' | 
  'google-plus-square' | 
  'google-scholar' | 
  'google-wallet' | 
  'gopuram' | 
  'graduation-cap' | 
  'gramophone' | 
  'grapes' | 
  'grate' | 
  'grate-droplet' | 
  'gratipay' | 
  'grav' | 
  'greater-than' | 
  'greater-than-equal' | 
  'grid' | 
  'grid-2' | 
  'grid-2-plus' | 
  'grid-4' | 
  'grid-5' | 
  'grid-dividers' | 
  'grid-horizontal' | 
  'grid-round' | 
  'grid-round-2' | 
  'grid-round-2-plus' | 
  'grid-round-4' | 
  'grid-round-5' | 
  'grid3' | 
  'grill' | 
  'grill-fire' | 
  'grill-hot' | 
  'grimace' | 
  'grin' | 
  'grin-alt' | 
  'grin-beam' | 
  'grin-beam-sweat' | 
  'grin-hearts' | 
  'grin-squint' | 
  'grin-squint-tears' | 
  'grin-stars' | 
  'grin-tears' | 
  'grin-tongue' | 
  'grin-tongue-squint' | 
  'grin-tongue-wink' | 
  'grin-wink' | 
  'grip' | 
  'grip-dots' | 
  'grip-dots-vertical' | 
  'grip-horizontal' | 
  'grip-lines' | 
  'grip-lines-vertical' | 
  'grip-vertical' | 
  'gripfire' | 
  'group-arrows-rotate' | 
  'grunt' | 
  'guarani-sign' | 
  'guilded' | 
  'guitar' | 
  'guitar-electric' | 
  'guitars' | 
  'gulp' | 
  'gun' | 
  'gun-slash' | 
  'gun-squirt' | 
  'h' | 
  'h-square' | 
  'h1' | 
  'h2' | 
  'h3' | 
  'h4' | 
  'h5' | 
  'h6' | 
  'hacker-news' | 
  'hacker-news-square' | 
  'hackerrank' | 
  'hamburger' | 
  'hammer' | 
  'hammer-brush' | 
  'hammer-crash' | 
  'hammer-war' | 
  'hamsa' | 
  'hand' | 
  'hand-back-fist' | 
  'hand-back-point-down' | 
  'hand-back-point-left' | 
  'hand-back-point-ribbon' | 
  'hand-back-point-right' | 
  'hand-back-point-up' | 
  'hand-dots' | 
  'hand-fingers-crossed' | 
  'hand-fist' | 
  'hand-heart' | 
  'hand-holding' | 
  'hand-holding-box' | 
  'hand-holding-circle-dollar' | 
  'hand-holding-dollar' | 
  'hand-holding-droplet' | 
  'hand-holding-hand' | 
  'hand-holding-heart' | 
  'hand-holding-magic' | 
  'hand-holding-medical' | 
  'hand-holding-seedling' | 
  'hand-holding-skull' | 
  'hand-holding-usd' | 
  'hand-holding-water' | 
  'hand-horns' | 
  'hand-lizard' | 
  'hand-love' | 
  'hand-middle-finger' | 
  'hand-paper' | 
  'hand-peace' | 
  'hand-point-down' | 
  'hand-point-left' | 
  'hand-point-ribbon' | 
  'hand-point-right' | 
  'hand-point-up' | 
  'hand-pointer' | 
  'hand-receiving' | 
  'hand-rock' | 
  'hand-scissors' | 
  'hand-sparkles' | 
  'hand-spock' | 
  'hand-wave' | 
  'handcuffs' | 
  'hands' | 
  'hands-american-sign-language-interpreting' | 
  'hands-asl-interpreting' | 
  'hands-bound' | 
  'hands-bubbles' | 
  'hands-clapping' | 
  'hands-heart' | 
  'hands-helping' | 
  'hands-holding' | 
  'hands-holding-child' | 
  'hands-holding-circle' | 
  'hands-holding-diamond' | 
  'hands-holding-dollar' | 
  'hands-holding-heart' | 
  'hands-praying' | 
  'hands-usd' | 
  'hands-wash' | 
  'handshake' | 
  'handshake-alt' | 
  'handshake-alt-slash' | 
  'handshake-angle' | 
  'handshake-simple' | 
  'handshake-simple-slash' | 
  'handshake-slash' | 
  'hanukiah' | 
  'hard-drive' | 
  'hard-hat' | 
  'hard-of-hearing' | 
  'hashnode' | 
  'hashtag' | 
  'hashtag-lock' | 
  'hat-beach' | 
  'hat-chef' | 
  'hat-cowboy' | 
  'hat-cowboy-side' | 
  'hat-hard' | 
  'hat-santa' | 
  'hat-winter' | 
  'hat-witch' | 
  'hat-wizard' | 
  'haykal' | 
  'hdd' | 
  'head-side' | 
  'head-side-brain' | 
  'head-side-cough' | 
  'head-side-cough-slash' | 
  'head-side-gear' | 
  'head-side-goggles' | 
  'head-side-headphones' | 
  'head-side-heart' | 
  'head-side-mask' | 
  'head-side-medical' | 
  'head-side-virus' | 
  'head-vr' | 
  'header' | 
  'heading' | 
  'headphones' | 
  'headphones-alt' | 
  'headphones-simple' | 
  'headset' | 
  'heart' | 
  'heart-broken' | 
  'heart-circle' | 
  'heart-circle-bolt' | 
  'heart-circle-check' | 
  'heart-circle-exclamation' | 
  'heart-circle-minus' | 
  'heart-circle-plus' | 
  'heart-circle-xmark' | 
  'heart-crack' | 
  'heart-half' | 
  'heart-half-alt' | 
  'heart-half-stroke' | 
  'heart-music-camera-bolt' | 
  'heart-pulse' | 
  'heart-rate' | 
  'heart-square' | 
  'heartbeat' | 
  'heat' | 
  'helicopter' | 
  'helicopter-symbol' | 
  'helmet-battle' | 
  'helmet-safety' | 
  'helmet-un' | 
  'hexagon' | 
  'hexagon-check' | 
  'hexagon-divide' | 
  'hexagon-exclamation' | 
  'hexagon-image' | 
  'hexagon-minus' | 
  'hexagon-plus' | 
  'hexagon-vertical-nft' | 
  'hexagon-vertical-nft-slanted' | 
  'hexagon-xmark' | 
  'high-definition' | 
  'highlighter' | 
  'highlighter-line' | 
  'hiking' | 
  'hill-avalanche' | 
  'hill-rockslide' | 
  'hippo' | 
  'hips' | 
  'hire-a-helper' | 
  'history' | 
  'hive' | 
  'hockey-mask' | 
  'hockey-puck' | 
  'hockey-stick-puck' | 
  'hockey-sticks' | 
  'holly-berry' | 
  'home' | 
  'home-alt' | 
  'home-blank' | 
  'home-heart' | 
  'home-lg' | 
  'home-lg-alt' | 
  'home-user' | 
  'honey-pot' | 
  'hood-cloak' | 
  'hooli' | 
  'horizontal-rule' | 
  'hornbill' | 
  'horse' | 
  'horse-head' | 
  'horse-saddle' | 
  'hose' | 
  'hose-reel' | 
  'hospital' | 
  'hospital-alt' | 
  'hospital-symbol' | 
  'hospital-user' | 
  'hospital-wide' | 
  'hospitals' | 
  'hot-tub' | 
  'hot-tub-person' | 
  'hotdog' | 
  'hotel' | 
  'hotjar' | 
  'hourglass' | 
  'hourglass-clock' | 
  'hourglass-empty' | 
  'hourglass-end' | 
  'hourglass-half' | 
  'hourglass-start' | 
  'hourglass1' | 
  'hourglass2' | 
  'hourglass3' | 
  'house' | 
  'house-blank' | 
  'house-building' | 
  'house-chimney' | 
  'house-chimney-blank' | 
  'house-chimney-crack' | 
  'house-chimney-heart' | 
  'house-chimney-medical' | 
  'house-chimney-user' | 
  'house-chimney-window' | 
  'house-circle-check' | 
  'house-circle-exclamation' | 
  'house-circle-xmark' | 
  'house-crack' | 
  'house-damage' | 
  'house-day' | 
  'house-fire' | 
  'house-flag' | 
  'house-flood' | 
  'house-flood-water' | 
  'house-flood-water-circle-arrow-right' | 
  'house-heart' | 
  'house-laptop' | 
  'house-leave' | 
  'house-lock' | 
  'house-medical' | 
  'house-medical-circle-check' | 
  'house-medical-circle-exclamation' | 
  'house-medical-circle-xmark' | 
  'house-medical-flag' | 
  'house-night' | 
  'house-person-arrive' | 
  'house-person-depart' | 
  'house-person-leave' | 
  'house-person-return' | 
  'house-return' | 
  'house-signal' | 
  'house-tree' | 
  'house-tsunami' | 
  'house-turret' | 
  'house-user' | 
  'house-water' | 
  'house-window' | 
  'houzz' | 
  'hryvnia' | 
  'hryvnia-sign' | 
  'html5' | 
  'hubspot' | 
  'humidity' | 
  'hundred-points' | 
  'hurricane' | 
  'hydra' | 
  'hyphen' | 
  'i' | 
  'i-cursor' | 
  'ice-cream' | 
  'ice-skate' | 
  'icicles' | 
  'icons' | 
  'icons-alt' | 
  'id-badge' | 
  'id-card' | 
  'id-card-alt' | 
  'id-card-clip' | 
  'ideal' | 
  'igloo' | 
  'ils' | 
  'image' | 
  'image-landscape' | 
  'image-polaroid' | 
  'image-polaroid-user' | 
  'image-portrait' | 
  'image-slash' | 
  'image-user' | 
  'images' | 
  'images-user' | 
  'imdb' | 
  'inbox' | 
  'inbox-arrow-down' | 
  'inbox-arrow-up' | 
  'inbox-full' | 
  'inbox-in' | 
  'inbox-out' | 
  'inboxes' | 
  'indent' | 
  'indian-rupee' | 
  'indian-rupee-sign' | 
  'industry' | 
  'industry-alt' | 
  'industry-windows' | 
  'infinity' | 
  'info' | 
  'info-circle' | 
  'info-square' | 
  'inhaler' | 
  'innosoft' | 
  'input-numeric' | 
  'input-pipe' | 
  'input-text' | 
  'inr' | 
  'instagram' | 
  'instagram-square' | 
  'instalod' | 
  'institution' | 
  'integral' | 
  'intercom' | 
  'internet-explorer' | 
  'interrobang' | 
  'intersection' | 
  'inventory' | 
  'invision' | 
  'ioxhost' | 
  'island-tree-palm' | 
  'island-tropical' | 
  'italic' | 
  'itch-io' | 
  'itunes' | 
  'itunes-note' | 
  'j' | 
  'jack-o-lantern' | 
  'jar' | 
  'jar-wheat' | 
  'java' | 
  'jedi' | 
  'jedi-order' | 
  'jenkins' | 
  'jet-fighter' | 
  'jet-fighter-up' | 
  'jira' | 
  'joget' | 
  'joint' | 
  'joomla' | 
  'journal-whills' | 
  'joystick' | 
  'jpy' | 
  'js' | 
  'js-square' | 
  'jsfiddle' | 
  'jug' | 
  'jug-bottle' | 
  'jug-detergent' | 
  'jxl' | 
  'k' | 
  'kaaba' | 
  'kaggle' | 
  'kazoo' | 
  'kerning' | 
  'key' | 
  'key-skeleton' | 
  'key-skeleton-left-right' | 
  'keybase' | 
  'keyboard' | 
  'keyboard-brightness' | 
  'keyboard-brightness-low' | 
  'keyboard-down' | 
  'keyboard-left' | 
  'keycdn' | 
  'keynote' | 
  'khanda' | 
  'kickstarter' | 
  'kickstarter-k' | 
  'kidneys' | 
  'kip-sign' | 
  'kiss' | 
  'kiss-beam' | 
  'kiss-wink-heart' | 
  'kit-medical' | 
  'kitchen-set' | 
  'kite' | 
  'kiwi-bird' | 
  'kiwi-fruit' | 
  'knife' | 
  'knife-kitchen' | 
  'korvue' | 
  'krw' | 
  'l' | 
  'lacrosse-stick' | 
  'lacrosse-stick-ball' | 
  'ladder-water' | 
  'lambda' | 
  'lamp' | 
  'lamp-desk' | 
  'lamp-floor' | 
  'lamp-street' | 
  'land-mine-on' | 
  'landmark' | 
  'landmark-alt' | 
  'landmark-dome' | 
  'landmark-flag' | 
  'landmark-magnifying-glass' | 
  'landscape' | 
  'language' | 
  'laptop' | 
  'laptop-arrow-down' | 
  'laptop-binary' | 
  'laptop-code' | 
  'laptop-file' | 
  'laptop-house' | 
  'laptop-medical' | 
  'laptop-mobile' | 
  'laptop-slash' | 
  'laravel' | 
  'lari-sign' | 
  'lasso' | 
  'lasso-sparkles' | 
  'lastfm' | 
  'lastfm-square' | 
  'laugh' | 
  'laugh-beam' | 
  'laugh-squint' | 
  'laugh-wink' | 
  'layer-group' | 
  'layer-group-minus' | 
  'layer-group-plus' | 
  'layer-minus' | 
  'layer-plus' | 
  'leaf' | 
  'leaf-heart' | 
  'leaf-maple' | 
  'leaf-oak' | 
  'leafy-green' | 
  'leanpub' | 
  'left' | 
  'left-from-bracket' | 
  'left-from-line' | 
  'left-long' | 
  'left-long-to-line' | 
  'left-right' | 
  'left-to-bracket' | 
  'left-to-line' | 
  'legal' | 
  'lemon' | 
  'less' | 
  'less-than' | 
  'less-than-equal' | 
  'letterboxd' | 
  'level-down' | 
  'level-down-alt' | 
  'level-up' | 
  'level-up-alt' | 
  'life-ring' | 
  'light-ceiling' | 
  'light-emergency' | 
  'light-emergency-on' | 
  'light-switch' | 
  'light-switch-off' | 
  'light-switch-on' | 
  'lightbulb' | 
  'lightbulb-cfl' | 
  'lightbulb-cfl-on' | 
  'lightbulb-dollar' | 
  'lightbulb-exclamation' | 
  'lightbulb-exclamation-on' | 
  'lightbulb-gear' | 
  'lightbulb-message' | 
  'lightbulb-on' | 
  'lightbulb-slash' | 
  'lighthouse' | 
  'lights-holiday' | 
  'line' | 
  'line-chart' | 
  'line-columns' | 
  'line-height' | 
  'lines-leaning' | 
  'link' | 
  'link-horizontal' | 
  'link-horizontal-slash' | 
  'link-simple' | 
  'link-simple-slash' | 
  'link-slash' | 
  'linkedin' | 
  'linkedin-in' | 
  'linode' | 
  'linux' | 
  'lips' | 
  'lira-sign' | 
  'list' | 
  'list-alt' | 
  'list-check' | 
  'list-dots' | 
  'list-dropdown' | 
  'list-music' | 
  'list-numeric' | 
  'list-ol' | 
  'list-radio' | 
  'list-squares' | 
  'list-timeline' | 
  'list-tree' | 
  'list-ul' | 
  'list12' | 
  'litecoin-sign' | 
  'loader' | 
  'lobster' | 
  'location' | 
  'location-arrow' | 
  'location-arrow-up' | 
  'location-check' | 
  'location-circle' | 
  'location-crosshairs' | 
  'location-crosshairs-slash' | 
  'location-dot' | 
  'location-dot-slash' | 
  'location-exclamation' | 
  'location-minus' | 
  'location-pen' | 
  'location-pin' | 
  'location-pin-lock' | 
  'location-pin-slash' | 
  'location-plus' | 
  'location-question' | 
  'location-slash' | 
  'location-smile' | 
  'location-xmark' | 
  'lock' | 
  'lock-a' | 
  'lock-alt' | 
  'lock-hashtag' | 
  'lock-keyhole' | 
  'lock-keyhole-open' | 
  'lock-open' | 
  'lock-open-alt' | 
  'locust' | 
  'lollipop' | 
  'lollypop' | 
  'long-arrow-alt-down' | 
  'long-arrow-alt-left' | 
  'long-arrow-alt-right' | 
  'long-arrow-alt-up' | 
  'long-arrow-down' | 
  'long-arrow-left' | 
  'long-arrow-right' | 
  'long-arrow-up' | 
  'loveseat' | 
  'low-vision' | 
  'luchador' | 
  'luchador-mask' | 
  'luggage-cart' | 
  'lungs' | 
  'lungs-virus' | 
  'lyft' | 
  'm' | 
  'mace' | 
  'magento' | 
  'magic' | 
  'magic-wand-sparkles' | 
  'magnet' | 
  'magnifying-glass' | 
  'magnifying-glass-arrow-right' | 
  'magnifying-glass-arrows-rotate' | 
  'magnifying-glass-chart' | 
  'magnifying-glass-dollar' | 
  'magnifying-glass-location' | 
  'magnifying-glass-minus' | 
  'magnifying-glass-music' | 
  'magnifying-glass-play' | 
  'magnifying-glass-plus' | 
  'magnifying-glass-waveform' | 
  'mail-bulk' | 
  'mail-forward' | 
  'mail-reply' | 
  'mail-reply-all' | 
  'mailbox' | 
  'mailbox-flag-up' | 
  'mailchimp' | 
  'maki-roll' | 
  'makizushi' | 
  'male' | 
  'manat-sign' | 
  'mandalorian' | 
  'mandolin' | 
  'mango' | 
  'manhole' | 
  'map' | 
  'map-location' | 
  'map-location-dot' | 
  'map-marked' | 
  'map-marked-alt' | 
  'map-marker' | 
  'map-marker-alt' | 
  'map-marker-alt-slash' | 
  'map-marker-check' | 
  'map-marker-edit' | 
  'map-marker-exclamation' | 
  'map-marker-minus' | 
  'map-marker-plus' | 
  'map-marker-question' | 
  'map-marker-slash' | 
  'map-marker-smile' | 
  'map-marker-times' | 
  'map-marker-xmark' | 
  'map-pin' | 
  'map-signs' | 
  'markdown' | 
  'marker' | 
  'mars' | 
  'mars-and-venus' | 
  'mars-and-venus-burst' | 
  'mars-double' | 
  'mars-stroke' | 
  'mars-stroke-h' | 
  'mars-stroke-right' | 
  'mars-stroke-up' | 
  'mars-stroke-v' | 
  'martini-glass' | 
  'martini-glass-citrus' | 
  'martini-glass-empty' | 
  'mask' | 
  'mask-face' | 
  'mask-luchador' | 
  'mask-snorkel' | 
  'mask-ventilator' | 
  'masks-theater' | 
  'mastodon' | 
  'mattress-pillow' | 
  'maxcdn' | 
  'maximize' | 
  'mdb' | 
  'meat' | 
  'medal' | 
  'medapps' | 
  'medium' | 
  'medium-m' | 
  'medkit' | 
  'medrt' | 
  'meetup' | 
  'megaphone' | 
  'megaport' | 
  'meh' | 
  'meh-blank' | 
  'meh-rolling-eyes' | 
  'melon' | 
  'melon-slice' | 
  'memo' | 
  'memo-circle-check' | 
  'memo-circle-info' | 
  'memo-pad' | 
  'memory' | 
  'mendeley' | 
  'menorah' | 
  'mercury' | 
  'merge' | 
  'message' | 
  'message-arrow-down' | 
  'message-arrow-up' | 
  'message-arrow-up-right' | 
  'message-bot' | 
  'message-captions' | 
  'message-check' | 
  'message-code' | 
  'message-dollar' | 
  'message-dots' | 
  'message-edit' | 
  'message-exclamation' | 
  'message-heart' | 
  'message-image' | 
  'message-lines' | 
  'message-medical' | 
  'message-middle' | 
  'message-middle-top' | 
  'message-minus' | 
  'message-music' | 
  'message-pen' | 
  'message-plus' | 
  'message-question' | 
  'message-quote' | 
  'message-slash' | 
  'message-smile' | 
  'message-sms' | 
  'message-text' | 
  'message-times' | 
  'message-xmark' | 
  'messages' | 
  'messages-dollar' | 
  'messages-question' | 
  'messaging' | 
  'meta' | 
  'meteor' | 
  'meter' | 
  'meter-bolt' | 
  'meter-droplet' | 
  'meter-fire' | 
  'microblog' | 
  'microchip' | 
  'microchip-ai' | 
  'microphone' | 
  'microphone-alt' | 
  'microphone-alt-slash' | 
  'microphone-circle' | 
  'microphone-circle-alt' | 
  'microphone-lines' | 
  'microphone-lines-slash' | 
  'microphone-slash' | 
  'microphone-stand' | 
  'microscope' | 
  'microsoft' | 
  'microwave' | 
  'mill-sign' | 
  'mind-share' | 
  'minimize' | 
  'mintbit' | 
  'minus' | 
  'minus-circle' | 
  'minus-hexagon' | 
  'minus-large' | 
  'minus-octagon' | 
  'minus-square' | 
  'mistletoe' | 
  'mitten' | 
  'mix' | 
  'mixcloud' | 
  'mixer' | 
  'mizuni' | 
  'mobile' | 
  'mobile-alt' | 
  'mobile-android' | 
  'mobile-android-alt' | 
  'mobile-button' | 
  'mobile-iphone' | 
  'mobile-notch' | 
  'mobile-phone' | 
  'mobile-retro' | 
  'mobile-screen' | 
  'mobile-screen-button' | 
  'mobile-signal' | 
  'mobile-signal-out' | 
  'modx' | 
  'monero' | 
  'money-bill' | 
  'money-bill-1' | 
  'money-bill-1-wave' | 
  'money-bill-alt' | 
  'money-bill-simple' | 
  'money-bill-simple-wave' | 
  'money-bill-transfer' | 
  'money-bill-trend-up' | 
  'money-bill-wave' | 
  'money-bill-wave-alt' | 
  'money-bill-wheat' | 
  'money-bills' | 
  'money-bills-alt' | 
  'money-bills-simple' | 
  'money-check' | 
  'money-check-alt' | 
  'money-check-dollar' | 
  'money-check-dollar-pen' | 
  'money-check-edit' | 
  'money-check-edit-alt' | 
  'money-check-pen' | 
  'money-from-bracket' | 
  'money-simple-from-bracket' | 
  'monitor-heart-rate' | 
  'monitor-waveform' | 
  'monkey' | 
  'monument' | 
  'moon' | 
  'moon-cloud' | 
  'moon-over-sun' | 
  'moon-stars' | 
  'moped' | 
  'mortar-board' | 
  'mortar-pestle' | 
  'mosque' | 
  'mosquito' | 
  'mosquito-net' | 
  'motorcycle' | 
  'mound' | 
  'mountain' | 
  'mountain-city' | 
  'mountain-sun' | 
  'mountains' | 
  'mouse' | 
  'mouse-alt' | 
  'mouse-field' | 
  'mouse-pointer' | 
  'mp3-player' | 
  'mug' | 
  'mug-hot' | 
  'mug-marshmallows' | 
  'mug-saucer' | 
  'mug-tea' | 
  'mug-tea-saucer' | 
  'multiply' | 
  'museum' | 
  'mushroom' | 
  'music' | 
  'music-alt' | 
  'music-alt-slash' | 
  'music-magnifying-glass' | 
  'music-note' | 
  'music-note-slash' | 
  'music-slash' | 
  'mustache' | 
  'n' | 
  'naira-sign' | 
  'napster' | 
  'narwhal' | 
  'navicon' | 
  'neos' | 
  'nesting-dolls' | 
  'network-wired' | 
  'neuter' | 
  'newspaper' | 
  'nfc' | 
  'nfc-directional' | 
  'nfc-lock' | 
  'nfc-magnifying-glass' | 
  'nfc-pen' | 
  'nfc-signal' | 
  'nfc-slash' | 
  'nfc-symbol' | 
  'nfc-trash' | 
  'nigiri' | 
  'nimblr' | 
  'node' | 
  'node-js' | 
  'nose' | 
  'not-equal' | 
  'notdef' | 
  'note' | 
  'note-medical' | 
  'note-sticky' | 
  'notebook' | 
  'notes' | 
  'notes-medical' | 
  'npm' | 
  'ns8' | 
  'nutritionix' | 
  'o' | 
  'object-exclude' | 
  'object-group' | 
  'object-intersect' | 
  'object-subtract' | 
  'object-ungroup' | 
  'object-union' | 
  'objects-align-bottom' | 
  'objects-align-center-horizontal' | 
  'objects-align-center-vertical' | 
  'objects-align-left' | 
  'objects-align-right' | 
  'objects-align-top' | 
  'objects-column' | 
  'octagon' | 
  'octagon-check' | 
  'octagon-divide' | 
  'octagon-exclamation' | 
  'octagon-minus' | 
  'octagon-plus' | 
  'octagon-xmark' | 
  'octopus' | 
  'octopus-deploy' | 
  'odnoklassniki' | 
  'odnoklassniki-square' | 
  'odysee' | 
  'oil-can' | 
  'oil-can-drip' | 
  'oil-temp' | 
  'oil-temperature' | 
  'oil-well' | 
  'old-republic' | 
  'olive' | 
  'olive-branch' | 
  'om' | 
  'omega' | 
  'onion' | 
  'opencart' | 
  'openid' | 
  'opensuse' | 
  'opera' | 
  'optin-monster' | 
  'option' | 
  'orcid' | 
  'ornament' | 
  'osi' | 
  'otter' | 
  'outdent' | 
  'outlet' | 
  'oven' | 
  'overline' | 
  'p' | 
  'padlet' | 
  'page' | 
  'page-break' | 
  'page-caret-down' | 
  'page-caret-up' | 
  'page4' | 
  'pagelines' | 
  'pager' | 
  'paint-brush' | 
  'paint-brush-alt' | 
  'paint-brush-fine' | 
  'paint-roller' | 
  'paintbrush' | 
  'paintbrush-alt' | 
  'paintbrush-fine' | 
  'paintbrush-pencil' | 
  'palette' | 
  'palette-boxes' | 
  'palfed' | 
  'pallet' | 
  'pallet-alt' | 
  'pallet-box' | 
  'pallet-boxes' | 
  'pan-food' | 
  'pan-frying' | 
  'pancakes' | 
  'panel-ews' | 
  'panel-fire' | 
  'panorama' | 
  'paper-plane' | 
  'paper-plane-alt' | 
  'paper-plane-top' | 
  'paperclip' | 
  'paperclip-vertical' | 
  'parachute-box' | 
  'paragraph' | 
  'paragraph-left' | 
  'paragraph-rtl' | 
  'parentheses' | 
  'parenthesis' | 
  'parking' | 
  'parking-circle' | 
  'parking-circle-slash' | 
  'parking-slash' | 
  'party-back' | 
  'party-bell' | 
  'party-horn' | 
  'passport' | 
  'pastafarianism' | 
  'paste' | 
  'patreon' | 
  'pause' | 
  'pause-circle' | 
  'paw' | 
  'paw-alt' | 
  'paw-claws' | 
  'paw-simple' | 
  'paypal' | 
  'peace' | 
  'peach' | 
  'peanut' | 
  'peanuts' | 
  'peapod' | 
  'pear' | 
  'pedestal' | 
  'pegasus' | 
  'pen' | 
  'pen-alt' | 
  'pen-alt-slash' | 
  'pen-circle' | 
  'pen-clip' | 
  'pen-clip-slash' | 
  'pen-fancy' | 
  'pen-fancy-slash' | 
  'pen-field' | 
  'pen-line' | 
  'pen-nib' | 
  'pen-nib-slash' | 
  'pen-paintbrush' | 
  'pen-ruler' | 
  'pen-slash' | 
  'pen-square' | 
  'pen-swirl' | 
  'pen-to-square' | 
  'pencil' | 
  'pencil-alt' | 
  'pencil-mechanical' | 
  'pencil-paintbrush' | 
  'pencil-ruler' | 
  'pencil-slash' | 
  'pencil-square' | 
  'pennant' | 
  'people' | 
  'people-arrows' | 
  'people-arrows-left-right' | 
  'people-carry' | 
  'people-carry-box' | 
  'people-dress' | 
  'people-dress-simple' | 
  'people-group' | 
  'people-line' | 
  'people-pants' | 
  'people-pants-simple' | 
  'people-pulling' | 
  'people-robbery' | 
  'people-roof' | 
  'people-simple' | 
  'pepper' | 
  'pepper-hot' | 
  'perbyte' | 
  'percent' | 
  'percentage' | 
  'period' | 
  'periscope' | 
  'person' | 
  'person-arrow-down-to-line' | 
  'person-arrow-up-from-line' | 
  'person-biking' | 
  'person-biking-mountain' | 
  'person-booth' | 
  'person-breastfeeding' | 
  'person-burst' | 
  'person-cane' | 
  'person-carry' | 
  'person-carry-box' | 
  'person-chalkboard' | 
  'person-circle-check' | 
  'person-circle-exclamation' | 
  'person-circle-minus' | 
  'person-circle-plus' | 
  'person-circle-question' | 
  'person-circle-xmark' | 
  'person-digging' | 
  'person-dolly' | 
  'person-dolly-empty' | 
  'person-dots-from-line' | 
  'person-dress' | 
  'person-dress-burst' | 
  'person-dress-fairy' | 
  'person-dress-simple' | 
  'person-drowning' | 
  'person-fairy' | 
  'person-falling' | 
  'person-falling-burst' | 
  'person-from-portal' | 
  'person-half-dress' | 
  'person-harassing' | 
  'person-hiking' | 
  'person-military-pointing' | 
  'person-military-rifle' | 
  'person-military-to-person' | 
  'person-pinball' | 
  'person-praying' | 
  'person-pregnant' | 
  'person-rays' | 
  'person-rifle' | 
  'person-running' | 
  'person-running-fast' | 
  'person-seat' | 
  'person-seat-reclined' | 
  'person-shelter' | 
  'person-sign' | 
  'person-simple' | 
  'person-skating' | 
  'person-ski-jumping' | 
  'person-ski-lift' | 
  'person-skiing' | 
  'person-skiing-nordic' | 
  'person-sledding' | 
  'person-snowboarding' | 
  'person-snowmobiling' | 
  'person-swimming' | 
  'person-through-window' | 
  'person-to-door' | 
  'person-to-portal' | 
  'person-walking' | 
  'person-walking-arrow-loop-left' | 
  'person-walking-arrow-right' | 
  'person-walking-dashed-line-arrow-right' | 
  'person-walking-luggage' | 
  'person-walking-with-cane' | 
  'peseta-sign' | 
  'peso-sign' | 
  'phabricator' | 
  'phoenix-framework' | 
  'phoenix-squadron' | 
  'phone' | 
  'phone-alt' | 
  'phone-arrow-down' | 
  'phone-arrow-down-left' | 
  'phone-arrow-right' | 
  'phone-arrow-up' | 
  'phone-arrow-up-right' | 
  'phone-circle' | 
  'phone-circle-alt' | 
  'phone-circle-down' | 
  'phone-flip' | 
  'phone-hangup' | 
  'phone-incoming' | 
  'phone-intercom' | 
  'phone-laptop' | 
  'phone-missed' | 
  'phone-office' | 
  'phone-outgoing' | 
  'phone-plus' | 
  'phone-rotary' | 
  'phone-slash' | 
  'phone-square' | 
  'phone-square-alt' | 
  'phone-square-down' | 
  'phone-volume' | 
  'phone-xmark' | 
  'photo-film' | 
  'photo-film-music' | 
  'photo-video' | 
  'php' | 
  'pi' | 
  'piano' | 
  'piano-keyboard' | 
  'pickaxe' | 
  'pickleball' | 
  'pie' | 
  'pie-chart' | 
  'pied-piper' | 
  'pied-piper-alt' | 
  'pied-piper-hat' | 
  'pied-piper-pp' | 
  'pied-piper-square' | 
  'pig' | 
  'piggy-bank' | 
  'pills' | 
  'pinata' | 
  'pinball' | 
  'pineapple' | 
  'ping-pong-paddle-ball' | 
  'pinterest' | 
  'pinterest-p' | 
  'pinterest-square' | 
  'pipe' | 
  'pipe-circle-check' | 
  'pipe-collar' | 
  'pipe-section' | 
  'pipe-smoking' | 
  'pipe-valve' | 
  'pix' | 
  'pixiv' | 
  'pizza' | 
  'pizza-slice' | 
  'place-of-worship' | 
  'plane' | 
  'plane-alt' | 
  'plane-arrival' | 
  'plane-circle-check' | 
  'plane-circle-exclamation' | 
  'plane-circle-xmark' | 
  'plane-departure' | 
  'plane-engines' | 
  'plane-lock' | 
  'plane-prop' | 
  'plane-slash' | 
  'plane-tail' | 
  'plane-up' | 
  'plane-up-slash' | 
  'planet-moon' | 
  'planet-ringed' | 
  'plant-wilt' | 
  'plate-utensils' | 
  'plate-wheat' | 
  'play' | 
  'play-circle' | 
  'play-pause' | 
  'playstation' | 
  'plug' | 
  'plug-circle-bolt' | 
  'plug-circle-check' | 
  'plug-circle-exclamation' | 
  'plug-circle-minus' | 
  'plug-circle-plus' | 
  'plug-circle-xmark' | 
  'plus' | 
  'plus-circle' | 
  'plus-hexagon' | 
  'plus-large' | 
  'plus-minus' | 
  'plus-octagon' | 
  'plus-square' | 
  'podcast' | 
  'podium' | 
  'podium-star' | 
  'police-box' | 
  'poll' | 
  'poll-h' | 
  'poll-people' | 
  'pompebled' | 
  'poo' | 
  'poo-bolt' | 
  'poo-storm' | 
  'pool-8-ball' | 
  'poop' | 
  'popcorn' | 
  'popsicle' | 
  'portal-enter' | 
  'portal-exit' | 
  'portrait' | 
  'pot-food' | 
  'potato' | 
  'pound-sign' | 
  'power-off' | 
  'pray' | 
  'praying-hands' | 
  'prescription' | 
  'prescription-bottle' | 
  'prescription-bottle-alt' | 
  'prescription-bottle-medical' | 
  'prescription-bottle-pill' | 
  'presentation' | 
  'presentation-screen' | 
  'pretzel' | 
  'print' | 
  'print-magnifying-glass' | 
  'print-search' | 
  'print-slash' | 
  'pro' | 
  'procedures' | 
  'product-hunt' | 
  'project-diagram' | 
  'projector' | 
  'pump' | 
  'pump-medical' | 
  'pump-soap' | 
  'pumpkin' | 
  'pushed' | 
  'puzzle' | 
  'puzzle-piece' | 
  'puzzle-piece-alt' | 
  'puzzle-piece-simple' | 
  'python' | 
  'q' | 
  'qq' | 
  'qrcode' | 
  'question' | 
  'question-circle' | 
  'question-square' | 
  'quidditch' | 
  'quidditch-broom-ball' | 
  'quinscape' | 
  'quora' | 
  'quote-left' | 
  'quote-left-alt' | 
  'quote-right' | 
  'quote-right-alt' | 
  'quotes' | 
  'quran' | 
  'r' | 
  'r-project' | 
  'rabbit' | 
  'rabbit-fast' | 
  'rabbit-running' | 
  'raccoon' | 
  'racquet' | 
  'radar' | 
  'radiation' | 
  'radiation-alt' | 
  'radio' | 
  'radio-alt' | 
  'radio-tuner' | 
  'rainbow' | 
  'raindrops' | 
  'ram' | 
  'ramp-loading' | 
  'random' | 
  'ranking-star' | 
  'raspberry-pi' | 
  'ravelry' | 
  'raygun' | 
  'react' | 
  'reacteurope' | 
  'readme' | 
  'rebel' | 
  'receipt' | 
  'record-vinyl' | 
  'rectangle' | 
  'rectangle-ad' | 
  'rectangle-barcode' | 
  'rectangle-code' | 
  'rectangle-hd' | 
  'rectangle-history' | 
  'rectangle-history-circle-plus' | 
  'rectangle-history-circle-user' | 
  'rectangle-landscape' | 
  'rectangle-list' | 
  'rectangle-portrait' | 
  'rectangle-pro' | 
  'rectangle-sd' | 
  'rectangle-terminal' | 
  'rectangle-times' | 
  'rectangle-vertical' | 
  'rectangle-vertical-history' | 
  'rectangle-wide' | 
  'rectangle-xmark' | 
  'rectangles-mixed' | 
  'recycle' | 
  'red-river' | 
  'reddit' | 
  'reddit-alien' | 
  'reddit-square' | 
  'redhat' | 
  'redo' | 
  'redo-alt' | 
  'reel' | 
  'reflect-both' | 
  'reflect-horizontal' | 
  'reflect-vertical' | 
  'refresh' | 
  'refrigerator' | 
  'registered' | 
  'remove' | 
  'remove-format' | 
  'rendact' | 
  'renren' | 
  'reorder' | 
  'repeat' | 
  'repeat-1' | 
  'repeat-alt' | 
  'repeat1-alt' | 
  'reply' | 
  'reply-all' | 
  'reply-clock' | 
  'reply-time' | 
  'replyd' | 
  'republican' | 
  'researchgate' | 
  'resolving' | 
  'restroom' | 
  'restroom-simple' | 
  'retweet' | 
  'retweet-alt' | 
  'rev' | 
  'rhombus' | 
  'ribbon' | 
  'right' | 
  'right-from-bracket' | 
  'right-from-line' | 
  'right-left' | 
  'right-left-large' | 
  'right-long' | 
  'right-long-to-line' | 
  'right-to-bracket' | 
  'right-to-line' | 
  'ring' | 
  'ring-diamond' | 
  'rings-wedding' | 
  'rmb' | 
  'road' | 
  'road-barrier' | 
  'road-bridge' | 
  'road-circle-check' | 
  'road-circle-exclamation' | 
  'road-circle-xmark' | 
  'road-lock' | 
  'road-spikes' | 
  'robot' | 
  'robot-astromech' | 
  'rocket' | 
  'rocket-launch' | 
  'rocketchat' | 
  'rockrms' | 
  'rod-asclepius' | 
  'rod-snake' | 
  'roller-coaster' | 
  'rotate' | 
  'rotate-back' | 
  'rotate-backward' | 
  'rotate-exclamation' | 
  'rotate-forward' | 
  'rotate-left' | 
  'rotate-reverse' | 
  'rotate-right' | 
  'rouble' | 
  'route' | 
  'route-highway' | 
  'route-interstate' | 
  'router' | 
  'rows' | 
  'rss' | 
  'rss-square' | 
  'rub' | 
  'ruble' | 
  'ruble-sign' | 
  'rug' | 
  'rugby-ball' | 
  'ruler' | 
  'ruler-combined' | 
  'ruler-horizontal' | 
  'ruler-triangle' | 
  'ruler-vertical' | 
  'running' | 
  'rupee' | 
  'rupee-sign' | 
  'rupiah-sign' | 
  'rust' | 
  'rv' | 
  's' | 
  'sack' | 
  'sack-dollar' | 
  'sack-xmark' | 
  'sad-cry' | 
  'sad-tear' | 
  'safari' | 
  'sailboat' | 
  'salad' | 
  'salesforce' | 
  'salt-shaker' | 
  'sandwich' | 
  'sass' | 
  'satellite' | 
  'satellite-dish' | 
  'sausage' | 
  'save' | 
  'save-circle-arrow-right' | 
  'save-circle-xmark' | 
  'save-times' | 
  'sax-hot' | 
  'saxophone' | 
  'saxophone-fire' | 
  'scale-balanced' | 
  'scale-unbalanced' | 
  'scale-unbalanced-flip' | 
  'scalpel' | 
  'scalpel-line-dashed' | 
  'scalpel-path' | 
  'scanner' | 
  'scanner-gun' | 
  'scanner-image' | 
  'scanner-keyboard' | 
  'scanner-touchscreen' | 
  'scarecrow' | 
  'scarf' | 
  'schlix' | 
  'school' | 
  'school-circle-check' | 
  'school-circle-exclamation' | 
  'school-circle-xmark' | 
  'school-flag' | 
  'school-lock' | 
  'scissors' | 
  'screen-users' | 
  'screencast' | 
  'screenpal' | 
  'screenshot' | 
  'screwdriver' | 
  'screwdriver-wrench' | 
  'scribble' | 
  'scribd' | 
  'scroll' | 
  'scroll-old' | 
  'scroll-ribbon' | 
  'scroll-torah' | 
  'scrubber' | 
  'scythe' | 
  'sd-card' | 
  'sd-cards' | 
  'seal' | 
  'seal-exclamation' | 
  'seal-question' | 
  'search' | 
  'search-dollar' | 
  'search-location' | 
  'search-minus' | 
  'search-plus' | 
  'searchengin' | 
  'seat-airline' | 
  'section' | 
  'seedling' | 
  'sellcast' | 
  'sellsy' | 
  'semicolon' | 
  'send' | 
  'send-back' | 
  'send-backward' | 
  'sensor' | 
  'sensor-alert' | 
  'sensor-cloud' | 
  'sensor-fire' | 
  'sensor-on' | 
  'sensor-smoke' | 
  'sensor-triangle-exclamation' | 
  'server' | 
  'servicestack' | 
  'shapes' | 
  'share' | 
  'share-all' | 
  'share-alt' | 
  'share-alt-square' | 
  'share-from-square' | 
  'share-nodes' | 
  'share-square' | 
  'sheep' | 
  'sheet-plastic' | 
  'shekel' | 
  'shekel-sign' | 
  'shelves' | 
  'shelves-empty' | 
  'sheqel' | 
  'sheqel-sign' | 
  'shield' | 
  'shield-alt' | 
  'shield-blank' | 
  'shield-cat' | 
  'shield-check' | 
  'shield-cross' | 
  'shield-dog' | 
  'shield-exclamation' | 
  'shield-halved' | 
  'shield-heart' | 
  'shield-keyhole' | 
  'shield-minus' | 
  'shield-plus' | 
  'shield-quartered' | 
  'shield-slash' | 
  'shield-times' | 
  'shield-virus' | 
  'shield-xmark' | 
  'ship' | 
  'shipping-fast' | 
  'shipping-timed' | 
  'shirt' | 
  'shirt-long-sleeve' | 
  'shirt-running' | 
  'shirt-tank-top' | 
  'shirtsinbulk' | 
  'shish-kebab' | 
  'shoe-prints' | 
  'shoelace' | 
  'shop' | 
  'shop-lock' | 
  'shop-slash' | 
  'shopify' | 
  'shopping-bag' | 
  'shopping-basket' | 
  'shopping-basket-alt' | 
  'shopping-cart' | 
  'shopware' | 
  'shortcake' | 
  'shovel' | 
  'shovel-snow' | 
  'shower' | 
  'shower-alt' | 
  'shower-down' | 
  'shredder' | 
  'shrimp' | 
  'shuffle' | 
  'shutters' | 
  'shuttle-space' | 
  'shuttle-van' | 
  'shuttlecock' | 
  'sickle' | 
  'sidebar' | 
  'sidebar-flip' | 
  'sigma' | 
  'sign' | 
  'sign-hanging' | 
  'sign-in' | 
  'sign-in-alt' | 
  'sign-language' | 
  'sign-out' | 
  'sign-out-alt' | 
  'sign-post' | 
  'sign-posts' | 
  'sign-posts-wrench' | 
  'signal' | 
  'signal-alt' | 
  'signal-alt-slash' | 
  'signal-alt1' | 
  'signal-alt2' | 
  'signal-alt3' | 
  'signal-alt4' | 
  'signal-bars' | 
  'signal-bars-fair' | 
  'signal-bars-good' | 
  'signal-bars-slash' | 
  'signal-bars-strong' | 
  'signal-bars-weak' | 
  'signal-fair' | 
  'signal-good' | 
  'signal-messenger' | 
  'signal-perfect' | 
  'signal-slash' | 
  'signal-stream' | 
  'signal-stream-slash' | 
  'signal-strong' | 
  'signal-weak' | 
  'signal1' | 
  'signal2' | 
  'signal3' | 
  'signal4' | 
  'signal5' | 
  'signature' | 
  'signature-lock' | 
  'signature-slash' | 
  'signing' | 
  'signs-post' | 
  'sim-card' | 
  'sim-cards' | 
  'simplybuilt' | 
  'sink' | 
  'siren' | 
  'siren-on' | 
  'sistrix' | 
  'sitemap' | 
  'sith' | 
  'sitrox' | 
  'skating' | 
  'skeleton' | 
  'skeleton-ribs' | 
  'sketch' | 
  'ski-boot' | 
  'ski-boot-ski' | 
  'ski-jump' | 
  'ski-lift' | 
  'skiing' | 
  'skiing-nordic' | 
  'skull' | 
  'skull-cow' | 
  'skull-crossbones' | 
  'skyatlas' | 
  'skype' | 
  'slack' | 
  'slack-hash' | 
  'slash' | 
  'slash-back' | 
  'slash-forward' | 
  'sledding' | 
  'sleigh' | 
  'slider' | 
  'sliders' | 
  'sliders-h' | 
  'sliders-h-square' | 
  'sliders-simple' | 
  'sliders-up' | 
  'sliders-v' | 
  'sliders-v-square' | 
  'slideshare' | 
  'slot-machine' | 
  'smile' | 
  'smile-beam' | 
  'smile-plus' | 
  'smile-wink' | 
  'smog' | 
  'smoke' | 
  'smoking' | 
  'smoking-ban' | 
  'sms' | 
  'snake' | 
  'snapchat' | 
  'snapchat-ghost' | 
  'snapchat-square' | 
  'snooze' | 
  'snow-blowing' | 
  'snowboarding' | 
  'snowflake' | 
  'snowflake-droplets' | 
  'snowflakes' | 
  'snowman' | 
  'snowman-head' | 
  'snowmobile' | 
  'snowplow' | 
  'soap' | 
  'soccer-ball' | 
  'socks' | 
  'soft-serve' | 
  'solar-panel' | 
  'solar-system' | 
  'sort' | 
  'sort-alpha-asc' | 
  'sort-alpha-desc' | 
  'sort-alpha-down' | 
  'sort-alpha-down-alt' | 
  'sort-alpha-up' | 
  'sort-alpha-up-alt' | 
  'sort-alt' | 
  'sort-amount-asc' | 
  'sort-amount-desc' | 
  'sort-amount-down' | 
  'sort-amount-down-alt' | 
  'sort-amount-up' | 
  'sort-amount-up-alt' | 
  'sort-asc' | 
  'sort-circle' | 
  'sort-circle-down' | 
  'sort-circle-up' | 
  'sort-desc' | 
  'sort-down' | 
  'sort-numeric-asc' | 
  'sort-numeric-desc' | 
  'sort-numeric-down' | 
  'sort-numeric-down-alt' | 
  'sort-numeric-up' | 
  'sort-numeric-up-alt' | 
  'sort-shapes-down' | 
  'sort-shapes-down-alt' | 
  'sort-shapes-up' | 
  'sort-shapes-up-alt' | 
  'sort-size-down' | 
  'sort-size-down-alt' | 
  'sort-size-up' | 
  'sort-size-up-alt' | 
  'sort-up' | 
  'sort-up-down' | 
  'soundcloud' | 
  'soup' | 
  'sourcetree' | 
  'spa' | 
  'space-awesome' | 
  'space-shuttle' | 
  'space-station-moon' | 
  'space-station-moon-alt' | 
  'space-station-moon-construction' | 
  'spade' | 
  'spaghetti-monster-flying' | 
  'sparkle' | 
  'sparkles' | 
  'speakap' | 
  'speaker' | 
  'speaker-deck' | 
  'speakers' | 
  'spell-check' | 
  'spider' | 
  'spider-black-widow' | 
  'spider-web' | 
  'spinner' | 
  'spinner-scale' | 
  'spinner-third' | 
  'split' | 
  'splotch' | 
  'spoon' | 
  'sportsball' | 
  'spotify' | 
  'spray-can' | 
  'spray-can-sparkles' | 
  'sprinkler' | 
  'sprinkler-ceiling' | 
  'sprout' | 
  'square' | 
  'square-0' | 
  'square-1' | 
  'square-2' | 
  'square-3' | 
  'square-4' | 
  'square-5' | 
  'square-6' | 
  'square-7' | 
  'square-8' | 
  'square-9' | 
  'square-a' | 
  'square-a-lock' | 
  'square-ampersand' | 
  'square-arrow-down' | 
  'square-arrow-down-left' | 
  'square-arrow-down-right' | 
  'square-arrow-left' | 
  'square-arrow-right' | 
  'square-arrow-up' | 
  'square-arrow-up-left' | 
  'square-arrow-up-right' | 
  'square-b' | 
  'square-behance' | 
  'square-bolt' | 
  'square-c' | 
  'square-caret-down' | 
  'square-caret-left' | 
  'square-caret-right' | 
  'square-caret-up' | 
  'square-check' | 
  'square-chevron-down' | 
  'square-chevron-left' | 
  'square-chevron-right' | 
  'square-chevron-up' | 
  'square-code' | 
  'square-d' | 
  'square-dashed' | 
  'square-dashed-circle-plus' | 
  'square-divide' | 
  'square-dollar' | 
  'square-down' | 
  'square-down-left' | 
  'square-down-right' | 
  'square-dribbble' | 
  'square-e' | 
  'square-ellipsis' | 
  'square-ellipsis-vertical' | 
  'square-envelope' | 
  'square-exclamation' | 
  'square-f' | 
  'square-facebook' | 
  'square-font-awesome' | 
  'square-font-awesome-stroke' | 
  'square-fragile' | 
  'square-full' | 
  'square-g' | 
  'square-git' | 
  'square-github' | 
  'square-gitlab' | 
  'square-google-plus' | 
  'square-h' | 
  'square-hacker-news' | 
  'square-heart' | 
  'square-i' | 
  'square-info' | 
  'square-instagram' | 
  'square-j' | 
  'square-js' | 
  'square-k' | 
  'square-kanban' | 
  'square-kickstarter' | 
  'square-l' | 
  'square-lastfm' | 
  'square-left' | 
  'square-letterboxd' | 
  'square-list' | 
  'square-m' | 
  'square-minus' | 
  'square-n' | 
  'square-nfi' | 
  'square-o' | 
  'square-odnoklassniki' | 
  'square-p' | 
  'square-parking' | 
  'square-parking-slash' | 
  'square-pen' | 
  'square-person-confined' | 
  'square-phone' | 
  'square-phone-flip' | 
  'square-phone-hangup' | 
  'square-pied-piper' | 
  'square-pinterest' | 
  'square-plus' | 
  'square-poll-horizontal' | 
  'square-poll-vertical' | 
  'square-q' | 
  'square-quarters' | 
  'square-question' | 
  'square-quote' | 
  'square-r' | 
  'square-reddit' | 
  'square-right' | 
  'square-ring' | 
  'square-root' | 
  'square-root-alt' | 
  'square-root-variable' | 
  'square-rss' | 
  'square-s' | 
  'square-share-nodes' | 
  'square-sliders' | 
  'square-sliders-vertical' | 
  'square-small' | 
  'square-snapchat' | 
  'square-star' | 
  'square-steam' | 
  'square-t' | 
  'square-terminal' | 
  'square-this-way-up' | 
  'square-threads' | 
  'square-tumblr' | 
  'square-twitter' | 
  'square-u' | 
  'square-up' | 
  'square-up-left' | 
  'square-up-right' | 
  'square-upwork' | 
  'square-user' | 
  'square-v' | 
  'square-viadeo' | 
  'square-vimeo' | 
  'square-virus' | 
  'square-w' | 
  'square-web-awesome' | 
  'square-web-awesome-stroke' | 
  'square-whatsapp' | 
  'square-wine-glass-crack' | 
  'square-x' | 
  'square-x-twitter' | 
  'square-xing' | 
  'square-xmark' | 
  'square-y' | 
  'square-youtube' | 
  'square-z' | 
  'squarespace' | 
  'squid' | 
  'squirrel' | 
  'stack-exchange' | 
  'stack-overflow' | 
  'stackpath' | 
  'staff' | 
  'staff-aesculapius' | 
  'staff-snake' | 
  'stairs' | 
  'stamp' | 
  'standard-definition' | 
  'stapler' | 
  'star' | 
  'star-and-crescent' | 
  'star-christmas' | 
  'star-circle' | 
  'star-exclamation' | 
  'star-half' | 
  'star-half-alt' | 
  'star-half-stroke' | 
  'star-of-david' | 
  'star-of-life' | 
  'star-sharp' | 
  'star-sharp-half' | 
  'star-sharp-half-alt' | 
  'star-sharp-half-stroke' | 
  'star-shooting' | 
  'starfighter' | 
  'starfighter-alt' | 
  'starfighter-alt-advanced' | 
  'starfighter-twin-ion-engine' | 
  'starfighter-twin-ion-engine-advanced' | 
  'stars' | 
  'starship' | 
  'starship-freighter' | 
  'staylinked' | 
  'steak' | 
  'steam' | 
  'steam-square' | 
  'steam-symbol' | 
  'steering-wheel' | 
  'step-backward' | 
  'step-forward' | 
  'sterling-sign' | 
  'stethoscope' | 
  'sticker-mule' | 
  'sticky-note' | 
  'stocking' | 
  'stomach' | 
  'stop' | 
  'stop-circle' | 
  'stopwatch' | 
  'stopwatch-20' | 
  'store' | 
  'store-alt' | 
  'store-alt-slash' | 
  'store-lock' | 
  'store-slash' | 
  'strava' | 
  'strawberry' | 
  'stream' | 
  'street-view' | 
  'stretcher' | 
  'strikethrough' | 
  'stripe' | 
  'stripe-s' | 
  'stroopwafel' | 
  'stubber' | 
  'studiovinari' | 
  'stumbleupon' | 
  'stumbleupon-circle' | 
  'subscript' | 
  'subtitles' | 
  'subtitles-slash' | 
  'subtract' | 
  'subway' | 
  'subway-tunnel' | 
  'suitcase' | 
  'suitcase-medical' | 
  'suitcase-rolling' | 
  'sun' | 
  'sun-alt' | 
  'sun-bright' | 
  'sun-cloud' | 
  'sun-dust' | 
  'sun-haze' | 
  'sun-plant-wilt' | 
  'sunglasses' | 
  'sunrise' | 
  'sunset' | 
  'superpowers' | 
  'superscript' | 
  'supple' | 
  'surprise' | 
  'suse' | 
  'sushi' | 
  'sushi-roll' | 
  'swap' | 
  'swap-arrows' | 
  'swatchbook' | 
  'swift' | 
  'swimmer' | 
  'swimming-pool' | 
  'sword' | 
  'sword-laser' | 
  'sword-laser-alt' | 
  'swords' | 
  'swords-laser' | 
  'symbols' | 
  'symfony' | 
  'synagogue' | 
  'sync' | 
  'sync-alt' | 
  'syringe' | 
  't' | 
  't-rex' | 
  't-shirt' | 
  'table' | 
  'table-cells' | 
  'table-cells-column-lock' | 
  'table-cells-column-unlock' | 
  'table-cells-large' | 
  'table-cells-lock' | 
  'table-cells-row-lock' | 
  'table-cells-row-unlock' | 
  'table-cells-unlock' | 
  'table-columns' | 
  'table-layout' | 
  'table-list' | 
  'table-picnic' | 
  'table-pivot' | 
  'table-rows' | 
  'table-tennis' | 
  'table-tennis-paddle-ball' | 
  'table-tree' | 
  'tablet' | 
  'tablet-alt' | 
  'tablet-android' | 
  'tablet-android-alt' | 
  'tablet-button' | 
  'tablet-rugged' | 
  'tablet-screen' | 
  'tablet-screen-button' | 
  'tablets' | 
  'tachograph-digital' | 
  'tachometer' | 
  'tachometer-alt' | 
  'tachometer-alt-average' | 
  'tachometer-alt-fast' | 
  'tachometer-alt-fastest' | 
  'tachometer-alt-slow' | 
  'tachometer-alt-slowest' | 
  'tachometer-average' | 
  'tachometer-fast' | 
  'tachometer-fastest' | 
  'tachometer-slow' | 
  'tachometer-slowest' | 
  'taco' | 
  'tag' | 
  'tags' | 
  'tally' | 
  'tally-1' | 
  'tally-2' | 
  'tally-3' | 
  'tally-4' | 
  'tally5' | 
  'tamale' | 
  'tanakh' | 
  'tank-water' | 
  'tape' | 
  'tarp' | 
  'tarp-droplet' | 
  'tasks' | 
  'tasks-alt' | 
  'taxi' | 
  'taxi-bus' | 
  'teamspeak' | 
  'teddy-bear' | 
  'teeth' | 
  'teeth-open' | 
  'telegram' | 
  'telegram-plane' | 
  'telescope' | 
  'teletype' | 
  'teletype-answer' | 
  'television' | 
  'temperature-arrow-down' | 
  'temperature-arrow-up' | 
  'temperature-down' | 
  'temperature-empty' | 
  'temperature-frigid' | 
  'temperature-full' | 
  'temperature-half' | 
  'temperature-high' | 
  'temperature-hot' | 
  'temperature-list' | 
  'temperature-low' | 
  'temperature-quarter' | 
  'temperature-snow' | 
  'temperature-sun' | 
  'temperature-three-quarters' | 
  'temperature-up' | 
  'temperature0' | 
  'temperature1' | 
  'temperature2' | 
  'temperature3' | 
  'temperature4' | 
  'tencent-weibo' | 
  'tenge' | 
  'tenge-sign' | 
  'tennis-ball' | 
  'tent' | 
  'tent-arrow-down-to-line' | 
  'tent-arrow-left-right' | 
  'tent-arrow-turn-left' | 
  'tent-arrows-down' | 
  'tent-double-peak' | 
  'tents' | 
  'terminal' | 
  'text' | 
  'text-height' | 
  'text-size' | 
  'text-slash' | 
  'text-width' | 
  'th' | 
  'th-large' | 
  'th-list' | 
  'the-red-yeti' | 
  'theater-masks' | 
  'themeco' | 
  'themeisle' | 
  'thermometer' | 
  'thermometer-empty' | 
  'thermometer-full' | 
  'thermometer-half' | 
  'thermometer-quarter' | 
  'thermometer-three-quarters' | 
  'thermometer0' | 
  'thermometer1' | 
  'thermometer2' | 
  'thermometer3' | 
  'thermometer4' | 
  'theta' | 
  'think-peaks' | 
  'thought-bubble' | 
  'threads' | 
  'thumb-tack' | 
  'thumb-tack-slash' | 
  'thumbs-down' | 
  'thumbs-up' | 
  'thumbtack' | 
  'thumbtack-slash' | 
  'thunderstorm' | 
  'thunderstorm-moon' | 
  'thunderstorm-sun' | 
  'tick' | 
  'ticket' | 
  'ticket-airline' | 
  'ticket-alt' | 
  'ticket-perforated' | 
  'ticket-perforated-plane' | 
  'ticket-plane' | 
  'ticket-simple' | 
  'tickets' | 
  'tickets-airline' | 
  'tickets-perforated' | 
  'tickets-perforated-plane' | 
  'tickets-plane' | 
  'tickets-simple' | 
  'tiktok' | 
  'tilde' | 
  'timeline' | 
  'timeline-arrow' | 
  'timer' | 
  'times' | 
  'times-circle' | 
  'times-hexagon' | 
  'times-octagon' | 
  'times-rectangle' | 
  'times-square' | 
  'times-to-slot' | 
  'tint' | 
  'tint-slash' | 
  'tire' | 
  'tire-flat' | 
  'tire-pressure-warning' | 
  'tire-rugged' | 
  'tired' | 
  'toggle-large-off' | 
  'toggle-large-on' | 
  'toggle-off' | 
  'toggle-on' | 
  'toilet' | 
  'toilet-paper' | 
  'toilet-paper-alt' | 
  'toilet-paper-blank' | 
  'toilet-paper-blank-under' | 
  'toilet-paper-check' | 
  'toilet-paper-reverse' | 
  'toilet-paper-reverse-alt' | 
  'toilet-paper-reverse-slash' | 
  'toilet-paper-slash' | 
  'toilet-paper-under' | 
  'toilet-paper-under-slash' | 
  'toilet-paper-xmark' | 
  'toilet-portable' | 
  'toilets-portable' | 
  'tomato' | 
  'tombstone' | 
  'tombstone-alt' | 
  'tombstone-blank' | 
  'toolbox' | 
  'tools' | 
  'tooth' | 
  'toothbrush' | 
  'torah' | 
  'torii-gate' | 
  'tornado' | 
  'tower-broadcast' | 
  'tower-cell' | 
  'tower-control' | 
  'tower-observation' | 
  'tractor' | 
  'trade-federation' | 
  'trademark' | 
  'traffic-cone' | 
  'traffic-light' | 
  'traffic-light-go' | 
  'traffic-light-slow' | 
  'traffic-light-stop' | 
  'trailer' | 
  'train' | 
  'train-subway' | 
  'train-subway-tunnel' | 
  'train-track' | 
  'train-tram' | 
  'train-tunnel' | 
  'tram' | 
  'transformer-bolt' | 
  'transgender' | 
  'transgender-alt' | 
  'transporter' | 
  'transporter-1' | 
  'transporter-2' | 
  'transporter-3' | 
  'transporter-4' | 
  'transporter-5' | 
  'transporter-6' | 
  'transporter-7' | 
  'transporter-empty' | 
  'trash' | 
  'trash-alt' | 
  'trash-alt-slash' | 
  'trash-arrow-turn-left' | 
  'trash-arrow-up' | 
  'trash-can' | 
  'trash-can-arrow-turn-left' | 
  'trash-can-arrow-up' | 
  'trash-can-check' | 
  'trash-can-clock' | 
  'trash-can-list' | 
  'trash-can-plus' | 
  'trash-can-slash' | 
  'trash-can-undo' | 
  'trash-can-xmark' | 
  'trash-check' | 
  'trash-circle' | 
  'trash-clock' | 
  'trash-list' | 
  'trash-plus' | 
  'trash-restore' | 
  'trash-restore-alt' | 
  'trash-slash' | 
  'trash-undo' | 
  'trash-undo-alt' | 
  'trash-xmark' | 
  'treasure-chest' | 
  'tree' | 
  'tree-alt' | 
  'tree-christmas' | 
  'tree-city' | 
  'tree-deciduous' | 
  'tree-decorated' | 
  'tree-large' | 
  'tree-palm' | 
  'trees' | 
  'trello' | 
  'trian-balbot' | 
  'triangle' | 
  'triangle-circle-square' | 
  'triangle-exclamation' | 
  'triangle-instrument' | 
  'triangle-music' | 
  'triangle-person-digging' | 
  'tricycle' | 
  'tricycle-adult' | 
  'trillium' | 
  'trophy' | 
  'trophy-alt' | 
  'trophy-star' | 
  'trowel' | 
  'trowel-bricks' | 
  'truck' | 
  'truck-arrow-right' | 
  'truck-bolt' | 
  'truck-clock' | 
  'truck-container' | 
  'truck-container-empty' | 
  'truck-couch' | 
  'truck-droplet' | 
  'truck-fast' | 
  'truck-field' | 
  'truck-field-un' | 
  'truck-fire' | 
  'truck-flatbed' | 
  'truck-front' | 
  'truck-ladder' | 
  'truck-loading' | 
  'truck-medical' | 
  'truck-monster' | 
  'truck-moving' | 
  'truck-pickup' | 
  'truck-plane' | 
  'truck-plow' | 
  'truck-ramp' | 
  'truck-ramp-box' | 
  'truck-ramp-couch' | 
  'truck-tow' | 
  'truck-utensils' | 
  'trumpet' | 
  'try' | 
  'tshirt' | 
  'tty' | 
  'tty-answer' | 
  'tugrik-sign' | 
  'tumblr' | 
  'tumblr-square' | 
  'turkey' | 
  'turkish-lira' | 
  'turkish-lira-sign' | 
  'turn-down' | 
  'turn-down-left' | 
  'turn-down-right' | 
  'turn-left' | 
  'turn-left-down' | 
  'turn-left-up' | 
  'turn-right' | 
  'turn-up' | 
  'turntable' | 
  'turtle' | 
  'tv' | 
  'tv-alt' | 
  'tv-music' | 
  'tv-retro' | 
  'twitch' | 
  'twitter' | 
  'twitter-square' | 
  'typewriter' | 
  'typo3' | 
  'u' | 
  'uber' | 
  'ubuntu' | 
  'ufo' | 
  'ufo-beam' | 
  'uikit' | 
  'umbraco' | 
  'umbrella' | 
  'umbrella-alt' | 
  'umbrella-beach' | 
  'umbrella-simple' | 
  'uncharted' | 
  'underline' | 
  'undo' | 
  'undo-alt' | 
  'unicorn' | 
  'uniform-martial-arts' | 
  'union' | 
  'uniregistry' | 
  'unity' | 
  'universal-access' | 
  'university' | 
  'unlink' | 
  'unlock' | 
  'unlock-alt' | 
  'unlock-keyhole' | 
  'unsorted' | 
  'unsplash' | 
  'untappd' | 
  'up' | 
  'up-down' | 
  'up-down-left-right' | 
  'up-from-bracket' | 
  'up-from-dotted-line' | 
  'up-from-line' | 
  'up-left' | 
  'up-long' | 
  'up-right' | 
  'up-right-and-down-left-from-center' | 
  'up-right-from-square' | 
  'up-to-bracket' | 
  'up-to-dotted-line' | 
  'up-to-line' | 
  'upload' | 
  'ups' | 
  'upwork' | 
  'usb' | 
  'usb-drive' | 
  'usd' | 
  'usd-circle' | 
  'usd-square' | 
  'user' | 
  'user-alien' | 
  'user-alt' | 
  'user-alt-slash' | 
  'user-astronaut' | 
  'user-beard-bolt' | 
  'user-bounty-hunter' | 
  'user-chart' | 
  'user-check' | 
  'user-chef' | 
  'user-circle' | 
  'user-clock' | 
  'user-cog' | 
  'user-construction' | 
  'user-cowboy' | 
  'user-crown' | 
  'user-doctor' | 
  'user-doctor-hair' | 
  'user-doctor-hair-long' | 
  'user-doctor-message' | 
  'user-edit' | 
  'user-friends' | 
  'user-gear' | 
  'user-graduate' | 
  'user-group' | 
  'user-group-crown' | 
  'user-group-simple' | 
  'user-hair' | 
  'user-hair-buns' | 
  'user-hair-long' | 
  'user-hair-mullet' | 
  'user-hard-hat' | 
  'user-headset' | 
  'user-helmet-safety' | 
  'user-hoodie' | 
  'user-injured' | 
  'user-large' | 
  'user-large-slash' | 
  'user-lock' | 
  'user-magnifying-glass' | 
  'user-md' | 
  'user-md-chat' | 
  'user-minus' | 
  'user-music' | 
  'user-ninja' | 
  'user-nurse' | 
  'user-nurse-hair' | 
  'user-nurse-hair-long' | 
  'user-pen' | 
  'user-pilot' | 
  'user-pilot-tie' | 
  'user-plus' | 
  'user-police' | 
  'user-police-tie' | 
  'user-robot' | 
  'user-robot-xmarks' | 
  'user-secret' | 
  'user-shakespeare' | 
  'user-shield' | 
  'user-slash' | 
  'user-tag' | 
  'user-tie' | 
  'user-tie-hair' | 
  'user-tie-hair-long' | 
  'user-times' | 
  'user-unlock' | 
  'user-visor' | 
  'user-vneck' | 
  'user-vneck-hair' | 
  'user-vneck-hair-long' | 
  'user-xmark' | 
  'users' | 
  'users-between-lines' | 
  'users-class' | 
  'users-cog' | 
  'users-crown' | 
  'users-gear' | 
  'users-line' | 
  'users-medical' | 
  'users-rays' | 
  'users-rectangle' | 
  'users-slash' | 
  'users-viewfinder' | 
  'usps' | 
  'ussunnah' | 
  'utensil-fork' | 
  'utensil-knife' | 
  'utensil-spoon' | 
  'utensils' | 
  'utensils-alt' | 
  'utensils-slash' | 
  'utility-pole' | 
  'utility-pole-double' | 
  'v' | 
  'vaadin' | 
  'vacuum' | 
  'vacuum-robot' | 
  'value-absolute' | 
  'van-shuttle' | 
  'vault' | 
  'vcard' | 
  'vector-circle' | 
  'vector-polygon' | 
  'vector-square' | 
  'vent-damper' | 
  'venus' | 
  'venus-double' | 
  'venus-mars' | 
  'vest' | 
  'vest-patches' | 
  'vhs' | 
  'viacoin' | 
  'viadeo' | 
  'viadeo-square' | 
  'vial' | 
  'vial-circle-check' | 
  'vial-virus' | 
  'vials' | 
  'viber' | 
  'video' | 
  'video-arrow-down-left' | 
  'video-arrow-up-right' | 
  'video-camera' | 
  'video-circle' | 
  'video-handheld' | 
  'video-plus' | 
  'video-slash' | 
  'vihara' | 
  'vimeo' | 
  'vimeo-square' | 
  'vimeo-v' | 
  'vine' | 
  'violin' | 
  'virus' | 
  'virus-covid' | 
  'virus-covid-slash' | 
  'virus-slash' | 
  'viruses' | 
  'vk' | 
  'vnv' | 
  'voicemail' | 
  'volcano' | 
  'volleyball' | 
  'volleyball-ball' | 
  'volume' | 
  'volume-control-phone' | 
  'volume-down' | 
  'volume-high' | 
  'volume-low' | 
  'volume-medium' | 
  'volume-mute' | 
  'volume-off' | 
  'volume-slash' | 
  'volume-times' | 
  'volume-up' | 
  'volume-xmark' | 
  'vote-nay' | 
  'vote-yea' | 
  'vr-cardboard' | 
  'vuejs' | 
  'w' | 
  'waffle' | 
  'wagon-covered' | 
  'walker' | 
  'walkie-talkie' | 
  'walking' | 
  'wall-brick' | 
  'wallet' | 
  'wand' | 
  'wand-magic' | 
  'wand-magic-sparkles' | 
  'wand-sparkles' | 
  'warehouse' | 
  'warehouse-alt' | 
  'warehouse-full' | 
  'warning' | 
  'washer' | 
  'washing-machine' | 
  'watch' | 
  'watch-apple' | 
  'watch-calculator' | 
  'watch-fitness' | 
  'watch-smart' | 
  'watchman-monitoring' | 
  'water' | 
  'water-arrow-down' | 
  'water-arrow-up' | 
  'water-ladder' | 
  'water-lower' | 
  'water-rise' | 
  'watermelon-slice' | 
  'wave' | 
  'wave-pulse' | 
  'wave-sine' | 
  'wave-square' | 
  'wave-triangle' | 
  'waveform' | 
  'waveform-circle' | 
  'waveform-lines' | 
  'waveform-path' | 
  'waves-sine' | 
  'waze' | 
  'web-awesome' | 
  'webcam' | 
  'webcam-slash' | 
  'webflow' | 
  'webhook' | 
  'weebly' | 
  'weibo' | 
  'weight' | 
  'weight-hanging' | 
  'weight-scale' | 
  'weixin' | 
  'whale' | 
  'whatsapp' | 
  'whatsapp-square' | 
  'wheat' | 
  'wheat-alt' | 
  'wheat-awn' | 
  'wheat-awn-circle-exclamation' | 
  'wheat-awn-slash' | 
  'wheat-slash' | 
  'wheelchair' | 
  'wheelchair-alt' | 
  'wheelchair-move' | 
  'whiskey-glass' | 
  'whiskey-glass-ice' | 
  'whistle' | 
  'whmcs' | 
  'wifi' | 
  'wifi-exclamation' | 
  'wifi-fair' | 
  'wifi-slash' | 
  'wifi-strong' | 
  'wifi-weak' | 
  'wifi1' | 
  'wifi2' | 
  'wifi3' | 
  'wikipedia-w' | 
  'wind' | 
  'wind-circle-exclamation' | 
  'wind-turbine' | 
  'wind-warning' | 
  'window' | 
  'window-alt' | 
  'window-close' | 
  'window-flip' | 
  'window-frame' | 
  'window-frame-open' | 
  'window-maximize' | 
  'window-minimize' | 
  'window-restore' | 
  'windows' | 
  'windsock' | 
  'wine-bottle' | 
  'wine-glass' | 
  'wine-glass-alt' | 
  'wine-glass-crack' | 
  'wine-glass-empty' | 
  'wirsindhandwerk' | 
  'wix' | 
  'wizards-of-the-coast' | 
  'wodu' | 
  'wolf-pack-battalion' | 
  'won' | 
  'won-sign' | 
  'wordpress' | 
  'wordpress-simple' | 
  'worm' | 
  'wpbeginner' | 
  'wpexplorer' | 
  'wpforms' | 
  'wpressr' | 
  'wreath' | 
  'wreath-laurel' | 
  'wrench' | 
  'wrench-simple' | 
  'wsh' | 
  'x' | 
  'x-ray' | 
  'x-twitter' | 
  'xbox' | 
  'xing' | 
  'xing-square' | 
  'xmark' | 
  'xmark-circle' | 
  'xmark-hexagon' | 
  'xmark-large' | 
  'xmark-octagon' | 
  'xmark-square' | 
  'xmark-to-slot' | 
  'xmarks-lines' | 
  'y' | 
  'y-combinator' | 
  'yahoo' | 
  'yammer' | 
  'yandex' | 
  'yandex-international' | 
  'yarn' | 
  'yelp' | 
  'yen' | 
  'yen-sign' | 
  'yin-yang' | 
  'yoast' | 
  'youtube' | 
  'youtube-square' | 
  'z' | 
  'zap' | 
  'zhihu' | 
  'zzz';
