# Hugeicons React Pro

Welcome to the professional edition of Hugeicons for React — an extensive library of meticulously crafted icons designed to elevate the visual appeal of your web and mobile applications. With Hugeicons React Pro, you gain access to a vast selection of icons tailored to suit every need, allowing for highly customizable and dynamic user interfaces.

Discover more at our website: [hugeicons.com](https://hugeicons.com/)

## Features

### Autocomplete for Efficiency
Swiftly find the icon you need with our intuitive autocomplete feature, streamlining your design process.

### Customizable Size
Freedom to scale: adjust icon sizes effortlessly to match your design requirements.

### Multiple Variants
Seven distinct variants ensure that you can select the perfect style to match your project's aesthetics.

### Unlimited Colors
Customize icon colors with ease, giving you the ability to maintain consistency with your brand's color palette.

### Expansive Library
Access over 27,000 icons within the library, ensuring you'll find the exact icon for every context.

## How to Use

Using Hugeicons React Pro is straightforward. Here’s a quick example of how an icon component can be utilized:

```jsx
import {Home01Icon} from "@hugeicons/react-pro";

const App = () => {
  return (
    <div>
      <Home01Icon 
        size={48} 
        color="#FF0000" 
        variant="stroke"
      />
    </div>
  );
};
```

## Installation

To install Hugeicons React Pro, simply run the following command in your project directory:

```sh
npm install @hugeicons/react-pro
```

Or if you prefer using Yarn:

```sh
yarn add @hugeicons/react-pro
```

## Activate Your License
You have to activate your license key before using Hugeicons React Pro. To do so, you need to import the `hugeiconsLicense` function and call it with your license key as a parameter.

You can do this in your main application file, such as `App.js` or `index.js`:

```jsx
// App.js or index.js
import {hugeiconsLicense} from "@hugeicons/react-pro";

hugeiconsLicense('your-license-key-here');
```

Replace `your-license-key-here` with the license key that can be generated with our 

[License Generator](https://hugeicons.com/license-generate)

`Please note` if you did not activate your license, the icons will not be displayed correctly.

Enjoy the seamless integration of premium icons with Hugeicons React Pro and take your application to the next level!
