import * as react from 'react';
import { ForwardRefExoticComponent, ReactSVG, RefAttributes, SVGProps } from 'react';

type IconSvgElement = [elementName: keyof ReactSVG, attrs: Record<string, any>][];
type IconSvgObject = {
    [variantType: string]: IconSvgElement;
};
type SVGAttributes = Partial<SVGProps<SVGSVGElement>>;
type ComponentAttributes = RefAttributes<SVGSVGElement> & SVGAttributes;
interface HugeiconsProps extends ComponentAttributes {
    size?: string | number;
    variant?: string;
    type?: string;
}
type HugeiconsIcon = ForwardRefExoticComponent<HugeiconsProps>;
declare const createHugeiconComponent: (iconName: string, svgObject: IconSvgObject) => React.FC<React.PropsWithoutRef<HugeiconsProps> & React.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirstBracketIcon
 * @description Renders hugeicons FirstBracketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirstBracketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirstBracketCircleIcon
 * @description Renders hugeicons FirstBracketCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirstBracketCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirstBracketSquareIcon
 * @description Renders hugeicons FirstBracketSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirstBracketSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirstBrecketIcon
 * @description Renders hugeicons FirstBrecketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirstBrecketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirstBrecketCircleIcon
 * @description Renders hugeicons FirstBrecketCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirstBrecketCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirstBrecketSquareIcon
 * @description Renders hugeicons FirstBrecketSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirstBrecketSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecondBracketIcon
 * @description Renders hugeicons SecondBracketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecondBracketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecondBracketCircleIcon
 * @description Renders hugeicons SecondBracketCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecondBracketCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecondBracketSquareIcon
 * @description Renders hugeicons SecondBracketSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecondBracketSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecondBrecketIcon
 * @description Renders hugeicons SecondBrecketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecondBrecketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecondBrecketCircleIcon
 * @description Renders hugeicons SecondBrecketCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecondBrecketCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecondBrecketSquareIcon
 * @description Renders hugeicons SecondBrecketSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecondBrecketSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThreeDMoveIcon
 * @description Renders hugeicons ThreeDMoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThreeDMoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThreeDRotateIcon
 * @description Renders hugeicons ThreeDRotateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThreeDRotateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThreeDScaleIcon
 * @description Renders hugeicons ThreeDScaleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThreeDScaleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThreeDViewIcon
 * @description Renders hugeicons ThreeDViewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThreeDViewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThirdBracketIcon
 * @description Renders hugeicons ThirdBracketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThirdBracketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThirdBracketCircleIcon
 * @description Renders hugeicons ThirdBracketCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThirdBracketCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThirdBracketSquareIcon
 * @description Renders hugeicons ThirdBracketSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThirdBracketSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThirdBrecketIcon
 * @description Renders hugeicons ThirdBrecketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThirdBrecketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThirdBrecketCircleIcon
 * @description Renders hugeicons ThirdBrecketCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThirdBrecketCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ThirdBrecketSquareIcon
 * @description Renders hugeicons ThirdBrecketSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ThirdBrecketSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FourKIcon
 * @description Renders hugeicons FourKIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FourKIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AbacusIcon
 * @description Renders hugeicons AbacusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AbacusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AbsoluteIcon
 * @description Renders hugeicons AbsoluteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AbsoluteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AccelerationIcon
 * @description Renders hugeicons AccelerationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AccelerationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AccessIcon
 * @description Renders hugeicons AccessIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AccessIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AccidentIcon
 * @description Renders hugeicons AccidentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AccidentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AccountSetting01Icon
 * @description Renders hugeicons AccountSetting01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AccountSetting01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AccountSetting02Icon
 * @description Renders hugeicons AccountSetting02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AccountSetting02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AccountSetting03Icon
 * @description Renders hugeicons AccountSetting03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AccountSetting03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AcuteIcon
 * @description Renders hugeicons AcuteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AcuteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Add01Icon
 * @description Renders hugeicons Add01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Add01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Add02Icon
 * @description Renders hugeicons Add02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Add02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AddCircleIcon
 * @description Renders hugeicons AddCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AddCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AddCircleHalfDotIcon
 * @description Renders hugeicons AddCircleHalfDotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AddCircleHalfDotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AddSquareIcon
 * @description Renders hugeicons AddSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AddSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AddTeamIcon
 * @description Renders hugeicons AddTeamIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AddTeamIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AddressBookIcon
 * @description Renders hugeicons AddressBookIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AddressBookIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdobeAfterEffectIcon
 * @description Renders hugeicons AdobeAfterEffectIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdobeAfterEffectIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdobeIllustratorIcon
 * @description Renders hugeicons AdobeIllustratorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdobeIllustratorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdobeIndesignIcon
 * @description Renders hugeicons AdobeIndesignIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdobeIndesignIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdobePhotoshopIcon
 * @description Renders hugeicons AdobePhotoshopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdobePhotoshopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdobePremierIcon
 * @description Renders hugeicons AdobePremierIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdobePremierIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdobeXdIcon
 * @description Renders hugeicons AdobeXdIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdobeXdIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdventureIcon
 * @description Renders hugeicons AdventureIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdventureIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdvertisementIcon
 * @description Renders hugeicons AdvertisementIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdvertisementIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdvertisimentIcon
 * @description Renders hugeicons AdvertisimentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdvertisimentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AdzanIcon
 * @description Renders hugeicons AdzanIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AdzanIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AffiliateIcon
 * @description Renders hugeicons AffiliateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AffiliateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Agreement01Icon
 * @description Renders hugeicons Agreement01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Agreement01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Agreement02Icon
 * @description Renders hugeicons Agreement02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Agreement02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Agreement03Icon
 * @description Renders hugeicons Agreement03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Agreement03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiBookIcon
 * @description Renders hugeicons AiBookIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiBookIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiBrain01Icon
 * @description Renders hugeicons AiBrain01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiBrain01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiBrain02Icon
 * @description Renders hugeicons AiBrain02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiBrain02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiBrain03Icon
 * @description Renders hugeicons AiBrain03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiBrain03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiBrain04Icon
 * @description Renders hugeicons AiBrain04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiBrain04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiBrain05Icon
 * @description Renders hugeicons AiBrain05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiBrain05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiChat01Icon
 * @description Renders hugeicons AiChat01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiChat01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiChat02Icon
 * @description Renders hugeicons AiChat02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiChat02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiCloud01Icon
 * @description Renders hugeicons AiCloud01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiCloud01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiCloud02Icon
 * @description Renders hugeicons AiCloud02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiCloud02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiComputerIcon
 * @description Renders hugeicons AiComputerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiComputerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiDnaIcon
 * @description Renders hugeicons AiDnaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiDnaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiFolder01Icon
 * @description Renders hugeicons AiFolder01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiFolder01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiFolder02Icon
 * @description Renders hugeicons AiFolder02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiFolder02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiInnovation01Icon
 * @description Renders hugeicons AiInnovation01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiInnovation01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiInnovation02Icon
 * @description Renders hugeicons AiInnovation02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiInnovation02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiInnovation03Icon
 * @description Renders hugeicons AiInnovation03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiInnovation03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiLaptopIcon
 * @description Renders hugeicons AiLaptopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiLaptopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiLearningIcon
 * @description Renders hugeicons AiLearningIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiLearningIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiLockIcon
 * @description Renders hugeicons AiLockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiLockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiMailIcon
 * @description Renders hugeicons AiMailIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiMailIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiNetworkIcon
 * @description Renders hugeicons AiNetworkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiNetworkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiPhone01Icon
 * @description Renders hugeicons AiPhone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiPhone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiPhone02Icon
 * @description Renders hugeicons AiPhone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiPhone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiSearchIcon
 * @description Renders hugeicons AiSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiSecurity01Icon
 * @description Renders hugeicons AiSecurity01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiSecurity01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiSecurity02Icon
 * @description Renders hugeicons AiSecurity02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiSecurity02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiSmartwatchIcon
 * @description Renders hugeicons AiSmartwatchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiSmartwatchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AiViewIcon
 * @description Renders hugeicons AiViewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AiViewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AidsIcon
 * @description Renders hugeicons AidsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AidsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirbnbIcon
 * @description Renders hugeicons AirbnbIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirbnbIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AircraftGameIcon
 * @description Renders hugeicons AircraftGameIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AircraftGameIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirdropIcon
 * @description Renders hugeicons AirdropIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirdropIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Airplane01Icon
 * @description Renders hugeicons Airplane01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Airplane01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Airplane02Icon
 * @description Renders hugeicons Airplane02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Airplane02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirplaneLanding01Icon
 * @description Renders hugeicons AirplaneLanding01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirplaneLanding01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirplaneLanding02Icon
 * @description Renders hugeicons AirplaneLanding02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirplaneLanding02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirplaneModeIcon
 * @description Renders hugeicons AirplaneModeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirplaneModeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirplaneModeOffIcon
 * @description Renders hugeicons AirplaneModeOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirplaneModeOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirplaneTakeOff01Icon
 * @description Renders hugeicons AirplaneTakeOff01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirplaneTakeOff01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirplaneTakeOff02Icon
 * @description Renders hugeicons AirplaneTakeOff02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirplaneTakeOff02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AirplayLineIcon
 * @description Renders hugeicons AirplayLineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AirplayLineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Airpod01Icon
 * @description Renders hugeicons Airpod01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Airpod01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Airpod02Icon
 * @description Renders hugeicons Airpod02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Airpod02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Airpod03Icon
 * @description Renders hugeicons Airpod03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Airpod03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlAqsaMosqueIcon
 * @description Renders hugeicons AlAqsaMosqueIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlAqsaMosqueIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlarmClockIcon
 * @description Renders hugeicons AlarmClockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlarmClockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Album01Icon
 * @description Renders hugeicons Album01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Album01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Album02Icon
 * @description Renders hugeicons Album02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Album02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlbumNotFound01Icon
 * @description Renders hugeicons AlbumNotFound01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlbumNotFound01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlbumNotFound02Icon
 * @description Renders hugeicons AlbumNotFound02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlbumNotFound02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Alert01Icon
 * @description Renders hugeicons Alert01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Alert01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Alert02Icon
 * @description Renders hugeicons Alert02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Alert02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlertCircleIcon
 * @description Renders hugeicons AlertCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlertCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlertDiamondIcon
 * @description Renders hugeicons AlertDiamondIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlertDiamondIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlertSquareIcon
 * @description Renders hugeicons AlertSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlertSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlgorithmIcon
 * @description Renders hugeicons AlgorithmIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlgorithmIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Alien01Icon
 * @description Renders hugeicons Alien01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Alien01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Alien02Icon
 * @description Renders hugeicons Alien02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Alien02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBottomIcon
 * @description Renders hugeicons AlignBottomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBottomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxBottomCenterIcon
 * @description Renders hugeicons AlignBoxBottomCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxBottomCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxBottomLeftIcon
 * @description Renders hugeicons AlignBoxBottomLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxBottomLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxBottomRightIcon
 * @description Renders hugeicons AlignBoxBottomRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxBottomRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxMiddleCenterIcon
 * @description Renders hugeicons AlignBoxMiddleCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxMiddleCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxMiddleLeftIcon
 * @description Renders hugeicons AlignBoxMiddleLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxMiddleLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxMiddleRightIcon
 * @description Renders hugeicons AlignBoxMiddleRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxMiddleRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxTopCenterIcon
 * @description Renders hugeicons AlignBoxTopCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxTopCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxTopLeftIcon
 * @description Renders hugeicons AlignBoxTopLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxTopLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignBoxTopRightIcon
 * @description Renders hugeicons AlignBoxTopRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignBoxTopRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignHorizontalCenterIcon
 * @description Renders hugeicons AlignHorizontalCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignHorizontalCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignKeyObjectIcon
 * @description Renders hugeicons AlignKeyObjectIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignKeyObjectIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignLeftIcon
 * @description Renders hugeicons AlignLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignRightIcon
 * @description Renders hugeicons AlignRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignSelectionIcon
 * @description Renders hugeicons AlignSelectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignSelectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignTopIcon
 * @description Renders hugeicons AlignTopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignTopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlignVerticalCenterIcon
 * @description Renders hugeicons AlignVerticalCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlignVerticalCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AllBookmarkIcon
 * @description Renders hugeicons AllBookmarkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AllBookmarkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AllahIcon
 * @description Renders hugeicons AllahIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AllahIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlmsIcon
 * @description Renders hugeicons AlmsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlmsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphaIcon
 * @description Renders hugeicons AlphaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphaCircleIcon
 * @description Renders hugeicons AlphaCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphaCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphaSquareIcon
 * @description Renders hugeicons AlphaSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphaSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetArabicIcon
 * @description Renders hugeicons AlphabetArabicIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetArabicIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetBanglaIcon
 * @description Renders hugeicons AlphabetBanglaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetBanglaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetChineseIcon
 * @description Renders hugeicons AlphabetChineseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetChineseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetGreekIcon
 * @description Renders hugeicons AlphabetGreekIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetGreekIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetHebrewIcon
 * @description Renders hugeicons AlphabetHebrewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetHebrewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetHindiIcon
 * @description Renders hugeicons AlphabetHindiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetHindiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetJapaneseIcon
 * @description Renders hugeicons AlphabetJapaneseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetJapaneseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetKoreanIcon
 * @description Renders hugeicons AlphabetKoreanIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetKoreanIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AlphabetThaiIcon
 * @description Renders hugeicons AlphabetThaiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AlphabetThaiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AmbulanceIcon
 * @description Renders hugeicons AmbulanceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AmbulanceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AmericanFootballIcon
 * @description Renders hugeicons AmericanFootballIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AmericanFootballIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AmieIcon
 * @description Renders hugeicons AmieIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AmieIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AmpouleIcon
 * @description Renders hugeicons AmpouleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AmpouleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AnalysisTextLinkIcon
 * @description Renders hugeicons AnalysisTextLinkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AnalysisTextLinkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Analytics01Icon
 * @description Renders hugeicons Analytics01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Analytics01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Analytics02Icon
 * @description Renders hugeicons Analytics02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Analytics02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AnalyticsDownIcon
 * @description Renders hugeicons AnalyticsDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AnalyticsDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AnalyticsUpIcon
 * @description Renders hugeicons AnalyticsUpIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AnalyticsUpIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AnchorPointIcon
 * @description Renders hugeicons AnchorPointIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AnchorPointIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AndroidIcon
 * @description Renders hugeicons AndroidIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AndroidIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AngelIcon
 * @description Renders hugeicons AngelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AngelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Angle01Icon
 * @description Renders hugeicons Angle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Angle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AngleIcon
 * @description Renders hugeicons AngleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AngleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AngryBirdIcon
 * @description Renders hugeicons AngryBirdIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AngryBirdIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AngryIcon
 * @description Renders hugeicons AngryIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AngryIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AnonymousIcon
 * @description Renders hugeicons AnonymousIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AnonymousIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ApiIcon
 * @description Renders hugeicons ApiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ApiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AppStoreIcon
 * @description Renders hugeicons AppStoreIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AppStoreIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Apple01Icon
 * @description Renders hugeicons Apple01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Apple01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AppleIcon
 * @description Renders hugeicons AppleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AppleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AppleFinderIcon
 * @description Renders hugeicons AppleFinderIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AppleFinderIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AppleNewsIcon
 * @description Renders hugeicons AppleNewsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AppleNewsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ApplePieIcon
 * @description Renders hugeicons ApplePieIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ApplePieIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AppleReminderIcon
 * @description Renders hugeicons AppleReminderIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AppleReminderIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AppleStocksIcon
 * @description Renders hugeicons AppleStocksIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AppleStocksIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ApproximatelyEqualIcon
 * @description Renders hugeicons ApproximatelyEqualIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ApproximatelyEqualIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ApproximatelyEqualCircleIcon
 * @description Renders hugeicons ApproximatelyEqualCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ApproximatelyEqualCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ApproximatelyEqualSquareIcon
 * @description Renders hugeicons ApproximatelyEqualSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ApproximatelyEqualSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ApricotIcon
 * @description Renders hugeicons ApricotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ApricotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ApronIcon
 * @description Renders hugeicons ApronIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ApronIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArcBrowserIcon
 * @description Renders hugeicons ArcBrowserIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArcBrowserIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArcherIcon
 * @description Renders hugeicons ArcherIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArcherIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Archive01Icon
 * @description Renders hugeicons Archive01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Archive01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Archive02Icon
 * @description Renders hugeicons Archive02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Archive02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArchiveIcon
 * @description Renders hugeicons ArchiveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArchiveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArmoredBootIcon
 * @description Renders hugeicons ArmoredBootIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArmoredBootIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrangeIcon
 * @description Renders hugeicons ArrangeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrangeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrangeByLettersAZIcon
 * @description Renders hugeicons ArrangeByLettersAZIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrangeByLettersAZIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrangeByLettersZAIcon
 * @description Renders hugeicons ArrangeByLettersZAIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrangeByLettersZAIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrangeByNumbers19Icon
 * @description Renders hugeicons ArrangeByNumbers19Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrangeByNumbers19Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrangeByNumbers91Icon
 * @description Renders hugeicons ArrangeByNumbers91Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrangeByNumbers91Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowAllDirectionIcon
 * @description Renders hugeicons ArrowAllDirectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowAllDirectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDataTransferDiagonalIcon
 * @description Renders hugeicons ArrowDataTransferDiagonalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDataTransferDiagonalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDataTransferHorizontalIcon
 * @description Renders hugeicons ArrowDataTransferHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDataTransferHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDataTransferVerticalIcon
 * @description Renders hugeicons ArrowDataTransferVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDataTransferVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDiagonalIcon
 * @description Renders hugeicons ArrowDiagonalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDiagonalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDown01Icon
 * @description Renders hugeicons ArrowDown01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDown01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDown02Icon
 * @description Renders hugeicons ArrowDown02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDown02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDown03Icon
 * @description Renders hugeicons ArrowDown03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDown03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDown04Icon
 * @description Renders hugeicons ArrowDown04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDown04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDown05Icon
 * @description Renders hugeicons ArrowDown05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDown05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDownDoubleIcon
 * @description Renders hugeicons ArrowDownDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDownDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDownLeft01Icon
 * @description Renders hugeicons ArrowDownLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDownLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDownLeft02Icon
 * @description Renders hugeicons ArrowDownLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDownLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDownRight01Icon
 * @description Renders hugeicons ArrowDownRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDownRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowDownRight02Icon
 * @description Renders hugeicons ArrowDownRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowDownRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowExpand01Icon
 * @description Renders hugeicons ArrowExpand01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowExpand01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowExpand02Icon
 * @description Renders hugeicons ArrowExpand02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowExpand02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowExpandIcon
 * @description Renders hugeicons ArrowExpandIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowExpandIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowExpandDiagonal01Icon
 * @description Renders hugeicons ArrowExpandDiagonal01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowExpandDiagonal01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowExpandDiagonal02Icon
 * @description Renders hugeicons ArrowExpandDiagonal02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowExpandDiagonal02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowHorizontalIcon
 * @description Renders hugeicons ArrowHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowLeft01Icon
 * @description Renders hugeicons ArrowLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowLeft02Icon
 * @description Renders hugeicons ArrowLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowLeft03Icon
 * @description Renders hugeicons ArrowLeft03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowLeft03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowLeft04Icon
 * @description Renders hugeicons ArrowLeft04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowLeft04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowLeft05Icon
 * @description Renders hugeicons ArrowLeft05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowLeft05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowLeftDoubleIcon
 * @description Renders hugeicons ArrowLeftDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowLeftDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowLeftRightIcon
 * @description Renders hugeicons ArrowLeftRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowLeftRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowMoveDownLeftIcon
 * @description Renders hugeicons ArrowMoveDownLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowMoveDownLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowMoveDownRightIcon
 * @description Renders hugeicons ArrowMoveDownRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowMoveDownRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowMoveLeftDownIcon
 * @description Renders hugeicons ArrowMoveLeftDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowMoveLeftDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowMoveRightDownIcon
 * @description Renders hugeicons ArrowMoveRightDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowMoveRightDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowMoveUpLeftIcon
 * @description Renders hugeicons ArrowMoveUpLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowMoveUpLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowMoveUpRightIcon
 * @description Renders hugeicons ArrowMoveUpRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowMoveUpRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowReloadHorizontalIcon
 * @description Renders hugeicons ArrowReloadHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowReloadHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowReloadVerticalIcon
 * @description Renders hugeicons ArrowReloadVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowReloadVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowRight01Icon
 * @description Renders hugeicons ArrowRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowRight02Icon
 * @description Renders hugeicons ArrowRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowRight03Icon
 * @description Renders hugeicons ArrowRight03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowRight03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowRight04Icon
 * @description Renders hugeicons ArrowRight04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowRight04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowRight05Icon
 * @description Renders hugeicons ArrowRight05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowRight05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowRightDoubleIcon
 * @description Renders hugeicons ArrowRightDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowRightDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowShrink01Icon
 * @description Renders hugeicons ArrowShrink01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowShrink01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowShrink02Icon
 * @description Renders hugeicons ArrowShrink02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowShrink02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowShrinkIcon
 * @description Renders hugeicons ArrowShrinkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowShrinkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowTurnBackwardIcon
 * @description Renders hugeicons ArrowTurnBackwardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowTurnBackwardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowTurnDownIcon
 * @description Renders hugeicons ArrowTurnDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowTurnDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowTurnForwardIcon
 * @description Renders hugeicons ArrowTurnForwardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowTurnForwardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowTurnUpIcon
 * @description Renders hugeicons ArrowTurnUpIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowTurnUpIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUp01Icon
 * @description Renders hugeicons ArrowUp01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUp01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUp02Icon
 * @description Renders hugeicons ArrowUp02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUp02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUp03Icon
 * @description Renders hugeicons ArrowUp03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUp03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUp04Icon
 * @description Renders hugeicons ArrowUp04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUp04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUp05Icon
 * @description Renders hugeicons ArrowUp05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUp05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUpDoubleIcon
 * @description Renders hugeicons ArrowUpDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUpDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUpDownIcon
 * @description Renders hugeicons ArrowUpDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUpDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUpLeft01Icon
 * @description Renders hugeicons ArrowUpLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUpLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUpLeft02Icon
 * @description Renders hugeicons ArrowUpLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUpLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUpRight01Icon
 * @description Renders hugeicons ArrowUpRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUpRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowUpRight02Icon
 * @description Renders hugeicons ArrowUpRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowUpRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArrowVerticalIcon
 * @description Renders hugeicons ArrowVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArrowVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtboardIcon
 * @description Renders hugeicons ArtboardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtboardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtboardToolIcon
 * @description Renders hugeicons ArtboardToolIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtboardToolIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtificialIntelligence01Icon
 * @description Renders hugeicons ArtificialIntelligence01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtificialIntelligence01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtificialIntelligence02Icon
 * @description Renders hugeicons ArtificialIntelligence02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtificialIntelligence02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtificialIntelligence03Icon
 * @description Renders hugeicons ArtificialIntelligence03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtificialIntelligence03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtificialIntelligence04Icon
 * @description Renders hugeicons ArtificialIntelligence04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtificialIntelligence04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtificialIntelligence05Icon
 * @description Renders hugeicons ArtificialIntelligence05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtificialIntelligence05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtificialIntelligence06Icon
 * @description Renders hugeicons ArtificialIntelligence06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtificialIntelligence06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ArtificialIntelligence07Icon
 * @description Renders hugeicons ArtificialIntelligence07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ArtificialIntelligence07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AspectRatioIcon
 * @description Renders hugeicons AspectRatioIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AspectRatioIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Asteroid01Icon
 * @description Renders hugeicons Asteroid01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Asteroid01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Asteroid02Icon
 * @description Renders hugeicons Asteroid02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Asteroid02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Astronaut01Icon
 * @description Renders hugeicons Astronaut01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Astronaut01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Astronaut02Icon
 * @description Renders hugeicons Astronaut02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Astronaut02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AtIcon
 * @description Renders hugeicons AtIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AtIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Atm01Icon
 * @description Renders hugeicons Atm01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Atm01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Atm02Icon
 * @description Renders hugeicons Atm02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Atm02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Atom01Icon
 * @description Renders hugeicons Atom01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Atom01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Atom02Icon
 * @description Renders hugeicons Atom02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Atom02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AtomicPowerIcon
 * @description Renders hugeicons AtomicPowerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AtomicPowerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Attachment01Icon
 * @description Renders hugeicons Attachment01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Attachment01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Attachment02Icon
 * @description Renders hugeicons Attachment02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Attachment02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AttachmentIcon
 * @description Renders hugeicons AttachmentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AttachmentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AttachmentCircleIcon
 * @description Renders hugeicons AttachmentCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AttachmentCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AttachmentSquareIcon
 * @description Renders hugeicons AttachmentSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AttachmentSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AuctionIcon
 * @description Renders hugeicons AuctionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AuctionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AudioBook01Icon
 * @description Renders hugeicons AudioBook01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AudioBook01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AudioBook02Icon
 * @description Renders hugeicons AudioBook02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AudioBook02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AudioBook03Icon
 * @description Renders hugeicons AudioBook03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AudioBook03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AudioBook04Icon
 * @description Renders hugeicons AudioBook04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AudioBook04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Audit01Icon
 * @description Renders hugeicons Audit01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Audit01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Audit02Icon
 * @description Renders hugeicons Audit02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Audit02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AugmentedRealityArIcon
 * @description Renders hugeicons AugmentedRealityArIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AugmentedRealityArIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AuthorizedIcon
 * @description Renders hugeicons AuthorizedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AuthorizedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AutoConversationsIcon
 * @description Renders hugeicons AutoConversationsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AutoConversationsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AutomotiveBattery01Icon
 * @description Renders hugeicons AutomotiveBattery01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AutomotiveBattery01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AutomotiveBattery02Icon
 * @description Renders hugeicons AutomotiveBattery02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AutomotiveBattery02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AvalancheIcon
 * @description Renders hugeicons AvalancheIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AvalancheIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name AvocadoIcon
 * @description Renders hugeicons AvocadoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const AvocadoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Award01Icon
 * @description Renders hugeicons Award01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Award01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Award02Icon
 * @description Renders hugeicons Award02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Award02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Award03Icon
 * @description Renders hugeicons Award03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Award03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Award04Icon
 * @description Renders hugeicons Award04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Award04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Award05Icon
 * @description Renders hugeicons Award05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Award05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Baby01Icon
 * @description Renders hugeicons Baby01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Baby01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Baby02Icon
 * @description Renders hugeicons Baby02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Baby02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BabyBed01Icon
 * @description Renders hugeicons BabyBed01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BabyBed01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BabyBed02Icon
 * @description Renders hugeicons BabyBed02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BabyBed02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BabyBottleIcon
 * @description Renders hugeicons BabyBottleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BabyBottleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BabyBoyDressIcon
 * @description Renders hugeicons BabyBoyDressIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BabyBoyDressIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BabyGirlDressIcon
 * @description Renders hugeicons BabyGirlDressIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BabyGirlDressIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Backpack01Icon
 * @description Renders hugeicons Backpack01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Backpack01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Backpack02Icon
 * @description Renders hugeicons Backpack02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Backpack02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Backpack03Icon
 * @description Renders hugeicons Backpack03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Backpack03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Backward01Icon
 * @description Renders hugeicons Backward01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Backward01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Backward02Icon
 * @description Renders hugeicons Backward02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Backward02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BacteriaIcon
 * @description Renders hugeicons BacteriaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BacteriaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BadmintonIcon
 * @description Renders hugeicons BadmintonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BadmintonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BadmintonShuttleIcon
 * @description Renders hugeicons BadmintonShuttleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BadmintonShuttleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BananaIcon
 * @description Renders hugeicons BananaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BananaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BandageIcon
 * @description Renders hugeicons BandageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BandageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BankIcon
 * @description Renders hugeicons BankIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BankIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BarCode01Icon
 * @description Renders hugeicons BarCode01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BarCode01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BarCode02Icon
 * @description Renders hugeicons BarCode02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BarCode02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BarnsIcon
 * @description Renders hugeicons BarnsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BarnsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BaseballBatIcon
 * @description Renders hugeicons BaseballBatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BaseballBatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BaseballIcon
 * @description Renders hugeicons BaseballIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BaseballIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BaseballHelmetIcon
 * @description Renders hugeicons BaseballHelmetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BaseballHelmetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Basketball01Icon
 * @description Renders hugeicons Basketball01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Basketball01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Basketball02Icon
 * @description Renders hugeicons Basketball02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Basketball02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BasketballHoopIcon
 * @description Renders hugeicons BasketballHoopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BasketballHoopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bathtub01Icon
 * @description Renders hugeicons Bathtub01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bathtub01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bathtub02Icon
 * @description Renders hugeicons Bathtub02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bathtub02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteriesEnergyIcon
 * @description Renders hugeicons BatteriesEnergyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteriesEnergyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteryCharging01Icon
 * @description Renders hugeicons BatteryCharging01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteryCharging01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteryCharging02Icon
 * @description Renders hugeicons BatteryCharging02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteryCharging02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteryEcoChargingIcon
 * @description Renders hugeicons BatteryEcoChargingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteryEcoChargingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteryEmptyIcon
 * @description Renders hugeicons BatteryEmptyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteryEmptyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteryFullIcon
 * @description Renders hugeicons BatteryFullIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteryFullIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteryLowIcon
 * @description Renders hugeicons BatteryLowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteryLowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteryMedium01Icon
 * @description Renders hugeicons BatteryMedium01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteryMedium01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BatteryMedium02Icon
 * @description Renders hugeicons BatteryMedium02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BatteryMedium02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BbqGrillIcon
 * @description Renders hugeicons BbqGrillIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BbqGrillIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BeachIcon
 * @description Renders hugeicons BeachIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BeachIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BeaterIcon
 * @description Renders hugeicons BeaterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BeaterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BeboIcon
 * @description Renders hugeicons BeboIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BeboIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BedIcon
 * @description Renders hugeicons BedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BedBunkIcon
 * @description Renders hugeicons BedBunkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BedBunkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BedDoubleIcon
 * @description Renders hugeicons BedDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BedDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BedSingle01Icon
 * @description Renders hugeicons BedSingle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BedSingle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BedSingle02Icon
 * @description Renders hugeicons BedSingle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BedSingle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bedug01Icon
 * @description Renders hugeicons Bedug01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bedug01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bedug02Icon
 * @description Renders hugeicons Bedug02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bedug02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Behance01Icon
 * @description Renders hugeicons Behance01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Behance01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Behance02Icon
 * @description Renders hugeicons Behance02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Behance02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BeltIcon
 * @description Renders hugeicons BeltIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BeltIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BendToolIcon
 * @description Renders hugeicons BendToolIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BendToolIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BerlinIcon
 * @description Renders hugeicons BerlinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BerlinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BerlinTowerIcon
 * @description Renders hugeicons BerlinTowerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BerlinTowerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BetaIcon
 * @description Renders hugeicons BetaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BetaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bicycle01Icon
 * @description Renders hugeicons Bicycle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bicycle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BicycleIcon
 * @description Renders hugeicons BicycleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BicycleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Billiard01Icon
 * @description Renders hugeicons Billiard01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Billiard01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Billiard02Icon
 * @description Renders hugeicons Billiard02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Billiard02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BinaryCodeIcon
 * @description Renders hugeicons BinaryCodeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BinaryCodeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BingIcon
 * @description Renders hugeicons BingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BioEnergyIcon
 * @description Renders hugeicons BioEnergyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BioEnergyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BiomassEnergyIcon
 * @description Renders hugeicons BiomassEnergyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BiomassEnergyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BirthdayCakeIcon
 * @description Renders hugeicons BirthdayCakeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BirthdayCakeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BiscuitIcon
 * @description Renders hugeicons BiscuitIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BiscuitIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bitcoin01Icon
 * @description Renders hugeicons Bitcoin01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bitcoin01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bitcoin02Icon
 * @description Renders hugeicons Bitcoin02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bitcoin02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bitcoin03Icon
 * @description Renders hugeicons Bitcoin03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bitcoin03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bitcoin04Icon
 * @description Renders hugeicons Bitcoin04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bitcoin04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinBagIcon
 * @description Renders hugeicons BitcoinBagIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinBagIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinIcon
 * @description Renders hugeicons BitcoinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinCircleIcon
 * @description Renders hugeicons BitcoinCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinCloudIcon
 * @description Renders hugeicons BitcoinCloudIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinCloudIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinCpuIcon
 * @description Renders hugeicons BitcoinCpuIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinCpuIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinCreditCardIcon
 * @description Renders hugeicons BitcoinCreditCardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinCreditCardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinDatabaseIcon
 * @description Renders hugeicons BitcoinDatabaseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinDatabaseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinDown01Icon
 * @description Renders hugeicons BitcoinDown01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinDown01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinDown02Icon
 * @description Renders hugeicons BitcoinDown02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinDown02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinEllipseIcon
 * @description Renders hugeicons BitcoinEllipseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinEllipseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinEyeIcon
 * @description Renders hugeicons BitcoinEyeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinEyeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinFilterIcon
 * @description Renders hugeicons BitcoinFilterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinFilterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinFlashdiskIcon
 * @description Renders hugeicons BitcoinFlashdiskIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinFlashdiskIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinGraphIcon
 * @description Renders hugeicons BitcoinGraphIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinGraphIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinInvoiceIcon
 * @description Renders hugeicons BitcoinInvoiceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinInvoiceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinKeyIcon
 * @description Renders hugeicons BitcoinKeyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinKeyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinLocationIcon
 * @description Renders hugeicons BitcoinLocationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinLocationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinLockIcon
 * @description Renders hugeicons BitcoinLockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinLockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinMailIcon
 * @description Renders hugeicons BitcoinMailIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinMailIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinMindIcon
 * @description Renders hugeicons BitcoinMindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinMindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinMoney01Icon
 * @description Renders hugeicons BitcoinMoney01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinMoney01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinMoney02Icon
 * @description Renders hugeicons BitcoinMoney02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinMoney02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinPieChartIcon
 * @description Renders hugeicons BitcoinPieChartIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinPieChartIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinPiggyBankIcon
 * @description Renders hugeicons BitcoinPiggyBankIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinPiggyBankIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinPresentationIcon
 * @description Renders hugeicons BitcoinPresentationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinPresentationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinReceiptIcon
 * @description Renders hugeicons BitcoinReceiptIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinReceiptIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinReceiveIcon
 * @description Renders hugeicons BitcoinReceiveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinReceiveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinRectangleIcon
 * @description Renders hugeicons BitcoinRectangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinRectangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinSafeIcon
 * @description Renders hugeicons BitcoinSafeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinSafeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinSearchIcon
 * @description Renders hugeicons BitcoinSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinSendIcon
 * @description Renders hugeicons BitcoinSendIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinSendIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinSettingIcon
 * @description Renders hugeicons BitcoinSettingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinSettingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinShieldIcon
 * @description Renders hugeicons BitcoinShieldIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinShieldIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinShoppingIcon
 * @description Renders hugeicons BitcoinShoppingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinShoppingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinSmartphone01Icon
 * @description Renders hugeicons BitcoinSmartphone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinSmartphone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinSmartphone02Icon
 * @description Renders hugeicons BitcoinSmartphone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinSmartphone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinSquareIcon
 * @description Renders hugeicons BitcoinSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinStoreIcon
 * @description Renders hugeicons BitcoinStoreIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinStoreIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinTagIcon
 * @description Renders hugeicons BitcoinTagIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinTagIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinTargetIcon
 * @description Renders hugeicons BitcoinTargetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinTargetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinTransactionIcon
 * @description Renders hugeicons BitcoinTransactionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinTransactionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinUp01Icon
 * @description Renders hugeicons BitcoinUp01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinUp01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinUp02Icon
 * @description Renders hugeicons BitcoinUp02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinUp02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinWalletIcon
 * @description Renders hugeicons BitcoinWalletIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinWalletIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BitcoinWithdrawIcon
 * @description Renders hugeicons BitcoinWithdrawIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BitcoinWithdrawIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BlackHole01Icon
 * @description Renders hugeicons BlackHole01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BlackHole01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BlackHoleIcon
 * @description Renders hugeicons BlackHoleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BlackHoleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BlendIcon
 * @description Renders hugeicons BlendIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BlendIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BlenderIcon
 * @description Renders hugeicons BlenderIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BlenderIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BlockGameIcon
 * @description Renders hugeicons BlockGameIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BlockGameIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Blockchain01Icon
 * @description Renders hugeicons Blockchain01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Blockchain01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Blockchain02Icon
 * @description Renders hugeicons Blockchain02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Blockchain02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Blockchain03Icon
 * @description Renders hugeicons Blockchain03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Blockchain03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Blockchain04Icon
 * @description Renders hugeicons Blockchain04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Blockchain04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Blockchain05Icon
 * @description Renders hugeicons Blockchain05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Blockchain05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Blockchain06Icon
 * @description Renders hugeicons Blockchain06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Blockchain06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Blockchain07Icon
 * @description Renders hugeicons Blockchain07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Blockchain07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BloggerIcon
 * @description Renders hugeicons BloggerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BloggerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BloodBagIcon
 * @description Renders hugeicons BloodBagIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BloodBagIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BloodBottleIcon
 * @description Renders hugeicons BloodBottleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BloodBottleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BloodIcon
 * @description Renders hugeicons BloodIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BloodIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BloodPressureIcon
 * @description Renders hugeicons BloodPressureIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BloodPressureIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BloodTypeIcon
 * @description Renders hugeicons BloodTypeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BloodTypeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BluetoothIcon
 * @description Renders hugeicons BluetoothIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BluetoothIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BluetoothCircleIcon
 * @description Renders hugeicons BluetoothCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BluetoothCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BluetoothNotConnectedIcon
 * @description Renders hugeicons BluetoothNotConnectedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BluetoothNotConnectedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BluetoothSearchIcon
 * @description Renders hugeicons BluetoothSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BluetoothSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BluetoothSquareIcon
 * @description Renders hugeicons BluetoothSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BluetoothSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BlurIcon
 * @description Renders hugeicons BlurIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BlurIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BlushBrush01Icon
 * @description Renders hugeicons BlushBrush01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BlushBrush01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BlushBrush02Icon
 * @description Renders hugeicons BlushBrush02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BlushBrush02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BoardMathIcon
 * @description Renders hugeicons BoardMathIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BoardMathIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BoatIcon
 * @description Renders hugeicons BoatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BoatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BodyArmorIcon
 * @description Renders hugeicons BodyArmorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BodyArmorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BodyPartLegIcon
 * @description Renders hugeicons BodyPartLegIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BodyPartLegIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BodyPartMuscleIcon
 * @description Renders hugeicons BodyPartMuscleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BodyPartMuscleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BodyPartSixPackIcon
 * @description Renders hugeicons BodyPartSixPackIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BodyPartSixPackIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BodySoapIcon
 * @description Renders hugeicons BodySoapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BodySoapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BodyWeightIcon
 * @description Renders hugeicons BodyWeightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BodyWeightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BombIcon
 * @description Renders hugeicons BombIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BombIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bone01Icon
 * @description Renders hugeicons Bone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bone02Icon
 * @description Renders hugeicons Bone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Book01Icon
 * @description Renders hugeicons Book01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Book01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Book02Icon
 * @description Renders hugeicons Book02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Book02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Book03Icon
 * @description Renders hugeicons Book03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Book03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Book04Icon
 * @description Renders hugeicons Book04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Book04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookBookmark01Icon
 * @description Renders hugeicons BookBookmark01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookBookmark01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookBookmark02Icon
 * @description Renders hugeicons BookBookmark02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookBookmark02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookDownloadIcon
 * @description Renders hugeicons BookDownloadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookDownloadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookEditIcon
 * @description Renders hugeicons BookEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookOpen01Icon
 * @description Renders hugeicons BookOpen01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookOpen01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookOpen02Icon
 * @description Renders hugeicons BookOpen02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookOpen02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookUploadIcon
 * @description Renders hugeicons BookUploadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookUploadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bookmark01Icon
 * @description Renders hugeicons Bookmark01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bookmark01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bookmark02Icon
 * @description Renders hugeicons Bookmark02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bookmark02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bookmark03Icon
 * @description Renders hugeicons Bookmark03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bookmark03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkAdd01Icon
 * @description Renders hugeicons BookmarkAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkAdd02Icon
 * @description Renders hugeicons BookmarkAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkBlock01Icon
 * @description Renders hugeicons BookmarkBlock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkBlock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkBlock02Icon
 * @description Renders hugeicons BookmarkBlock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkBlock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkCheck01Icon
 * @description Renders hugeicons BookmarkCheck01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkCheck01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkCheck02Icon
 * @description Renders hugeicons BookmarkCheck02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkCheck02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkMinus01Icon
 * @description Renders hugeicons BookmarkMinus01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkMinus01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkMinus02Icon
 * @description Renders hugeicons BookmarkMinus02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkMinus02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkOff01Icon
 * @description Renders hugeicons BookmarkOff01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkOff01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkOff02Icon
 * @description Renders hugeicons BookmarkOff02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkOff02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkRemove01Icon
 * @description Renders hugeicons BookmarkRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BookmarkRemove02Icon
 * @description Renders hugeicons BookmarkRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BookmarkRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Books01Icon
 * @description Renders hugeicons Books01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Books01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Books02Icon
 * @description Renders hugeicons Books02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Books02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bookshelf01Icon
 * @description Renders hugeicons Bookshelf01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bookshelf01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bookshelf02Icon
 * @description Renders hugeicons Bookshelf02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bookshelf02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bookshelf03Icon
 * @description Renders hugeicons Bookshelf03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bookshelf03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BootstrapIcon
 * @description Renders hugeicons BootstrapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BootstrapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderAll01Icon
 * @description Renders hugeicons BorderAll01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderAll01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderAll02Icon
 * @description Renders hugeicons BorderAll02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderAll02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderBottom01Icon
 * @description Renders hugeicons BorderBottom01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderBottom01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderBottom02Icon
 * @description Renders hugeicons BorderBottom02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderBottom02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderFullIcon
 * @description Renders hugeicons BorderFullIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderFullIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderHorizontalIcon
 * @description Renders hugeicons BorderHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderInnerIcon
 * @description Renders hugeicons BorderInnerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderInnerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderLeft01Icon
 * @description Renders hugeicons BorderLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderLeft02Icon
 * @description Renders hugeicons BorderLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderNone01Icon
 * @description Renders hugeicons BorderNone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderNone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderNone02Icon
 * @description Renders hugeicons BorderNone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderNone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderRight01Icon
 * @description Renders hugeicons BorderRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderRight02Icon
 * @description Renders hugeicons BorderRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderTop01Icon
 * @description Renders hugeicons BorderTop01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderTop01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderTop02Icon
 * @description Renders hugeicons BorderTop02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderTop02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorderVerticalIcon
 * @description Renders hugeicons BorderVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorderVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BorobudurIcon
 * @description Renders hugeicons BorobudurIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BorobudurIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BotIcon
 * @description Renders hugeicons BotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BounceLeftIcon
 * @description Renders hugeicons BounceLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BounceLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BounceRightIcon
 * @description Renders hugeicons BounceRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BounceRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BoundingBoxIcon
 * @description Renders hugeicons BoundingBoxIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BoundingBoxIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BowTieIcon
 * @description Renders hugeicons BowTieIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BowTieIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BowlingIcon
 * @description Renders hugeicons BowlingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BowlingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BowlingPinsIcon
 * @description Renders hugeicons BowlingPinsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BowlingPinsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BoxerIcon
 * @description Renders hugeicons BoxerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BoxerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BoxingBagIcon
 * @description Renders hugeicons BoxingBagIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BoxingBagIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BoxingGlove01Icon
 * @description Renders hugeicons BoxingGlove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BoxingGlove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BoxingGloveIcon
 * @description Renders hugeicons BoxingGloveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BoxingGloveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Brain01Icon
 * @description Renders hugeicons Brain01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Brain01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Brain02Icon
 * @description Renders hugeicons Brain02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Brain02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BrainIcon
 * @description Renders hugeicons BrainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BrainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bread01Icon
 * @description Renders hugeicons Bread01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bread01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bread02Icon
 * @description Renders hugeicons Bread02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bread02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bread03Icon
 * @description Renders hugeicons Bread03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bread03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bread04Icon
 * @description Renders hugeicons Bread04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bread04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BreastPumpIcon
 * @description Renders hugeicons BreastPumpIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BreastPumpIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BridgeIcon
 * @description Renders hugeicons BridgeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BridgeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase01Icon
 * @description Renders hugeicons Briefcase01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase02Icon
 * @description Renders hugeicons Briefcase02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase03Icon
 * @description Renders hugeicons Briefcase03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase04Icon
 * @description Renders hugeicons Briefcase04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase05Icon
 * @description Renders hugeicons Briefcase05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase06Icon
 * @description Renders hugeicons Briefcase06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase07Icon
 * @description Renders hugeicons Briefcase07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase08Icon
 * @description Renders hugeicons Briefcase08Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase08Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Briefcase09Icon
 * @description Renders hugeicons Briefcase09Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Briefcase09Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BriefcaseDollarIcon
 * @description Renders hugeicons BriefcaseDollarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BriefcaseDollarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BroccoliIcon
 * @description Renders hugeicons BroccoliIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BroccoliIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BrochureIcon
 * @description Renders hugeicons BrochureIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BrochureIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BrokenBoneIcon
 * @description Renders hugeicons BrokenBoneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BrokenBoneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BrowserIcon
 * @description Renders hugeicons BrowserIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BrowserIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BrushIcon
 * @description Renders hugeicons BrushIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BrushIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatAddIcon
 * @description Renders hugeicons BubbleChatAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatBlockedIcon
 * @description Renders hugeicons BubbleChatBlockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatBlockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatIcon
 * @description Renders hugeicons BubbleChatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatCancelIcon
 * @description Renders hugeicons BubbleChatCancelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatCancelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatDelayIcon
 * @description Renders hugeicons BubbleChatDelayIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatDelayIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatDoneIcon
 * @description Renders hugeicons BubbleChatDoneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatDoneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatDownload01Icon
 * @description Renders hugeicons BubbleChatDownload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatDownload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatDownload02Icon
 * @description Renders hugeicons BubbleChatDownload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatDownload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatEditIcon
 * @description Renders hugeicons BubbleChatEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatFavouriteIcon
 * @description Renders hugeicons BubbleChatFavouriteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatFavouriteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatIncomeIcon
 * @description Renders hugeicons BubbleChatIncomeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatIncomeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatLockIcon
 * @description Renders hugeicons BubbleChatLockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatLockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatNotificationIcon
 * @description Renders hugeicons BubbleChatNotificationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatNotificationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatOutcomeIcon
 * @description Renders hugeicons BubbleChatOutcomeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatOutcomeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatPreviewIcon
 * @description Renders hugeicons BubbleChatPreviewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatPreviewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatQuestionIcon
 * @description Renders hugeicons BubbleChatQuestionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatQuestionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatSearchIcon
 * @description Renders hugeicons BubbleChatSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatSecureIcon
 * @description Renders hugeicons BubbleChatSecureIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatSecureIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatTranslateIcon
 * @description Renders hugeicons BubbleChatTranslateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatTranslateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatUnlockIcon
 * @description Renders hugeicons BubbleChatUnlockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatUnlockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatUploadIcon
 * @description Renders hugeicons BubbleChatUploadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatUploadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleChatUserIcon
 * @description Renders hugeicons BubbleChatUserIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleChatUserIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleTea01Icon
 * @description Renders hugeicons BubbleTea01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleTea01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BubbleTea02Icon
 * @description Renders hugeicons BubbleTea02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BubbleTea02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bug01Icon
 * @description Renders hugeicons Bug01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bug01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bug02Icon
 * @description Renders hugeicons Bug02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bug02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Building01Icon
 * @description Renders hugeicons Building01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Building01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Building02Icon
 * @description Renders hugeicons Building02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Building02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Building03Icon
 * @description Renders hugeicons Building03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Building03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Building04Icon
 * @description Renders hugeicons Building04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Building04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Building05Icon
 * @description Renders hugeicons Building05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Building05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Building06Icon
 * @description Renders hugeicons Building06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Building06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BulbIcon
 * @description Renders hugeicons BulbIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BulbIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BulbChargingIcon
 * @description Renders hugeicons BulbChargingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BulbChargingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BulletproofVestIcon
 * @description Renders hugeicons BulletproofVestIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BulletproofVestIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BurjAlArabIcon
 * @description Renders hugeicons BurjAlArabIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BurjAlArabIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name BurningCdIcon
 * @description Renders hugeicons BurningCdIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const BurningCdIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bus01Icon
 * @description Renders hugeicons Bus01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bus01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bus02Icon
 * @description Renders hugeicons Bus02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bus02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Bus03Icon
 * @description Renders hugeicons Bus03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Bus03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CIcon
 * @description Renders hugeicons CIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CProgrammingIcon
 * @description Renders hugeicons CProgrammingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CProgrammingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cabinet01Icon
 * @description Renders hugeicons Cabinet01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cabinet01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cabinet02Icon
 * @description Renders hugeicons Cabinet02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cabinet02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cabinet03Icon
 * @description Renders hugeicons Cabinet03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cabinet03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cabinet04Icon
 * @description Renders hugeicons Cabinet04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cabinet04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CableCarIcon
 * @description Renders hugeicons CableCarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CableCarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CactusIcon
 * @description Renders hugeicons CactusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CactusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CaduceusIcon
 * @description Renders hugeicons CaduceusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CaduceusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalculateIcon
 * @description Renders hugeicons CalculateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalculateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Calculator01Icon
 * @description Renders hugeicons Calculator01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Calculator01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalculatorIcon
 * @description Renders hugeicons CalculatorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalculatorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Calendar01Icon
 * @description Renders hugeicons Calendar01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Calendar01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Calendar02Icon
 * @description Renders hugeicons Calendar02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Calendar02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Calendar03Icon
 * @description Renders hugeicons Calendar03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Calendar03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Calendar04Icon
 * @description Renders hugeicons Calendar04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Calendar04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarAdd01Icon
 * @description Renders hugeicons CalendarAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarAdd02Icon
 * @description Renders hugeicons CalendarAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarBlock01Icon
 * @description Renders hugeicons CalendarBlock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarBlock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarBlock02Icon
 * @description Renders hugeicons CalendarBlock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarBlock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarCheckIn01Icon
 * @description Renders hugeicons CalendarCheckIn01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarCheckIn01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarCheckIn02Icon
 * @description Renders hugeicons CalendarCheckIn02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarCheckIn02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarCheckOut01Icon
 * @description Renders hugeicons CalendarCheckOut01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarCheckOut01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarCheckOut02Icon
 * @description Renders hugeicons CalendarCheckOut02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarCheckOut02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarDownload01Icon
 * @description Renders hugeicons CalendarDownload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarDownload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarDownload02Icon
 * @description Renders hugeicons CalendarDownload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarDownload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarFavorite01Icon
 * @description Renders hugeicons CalendarFavorite01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarFavorite01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarFavorite02Icon
 * @description Renders hugeicons CalendarFavorite02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarFavorite02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarLock01Icon
 * @description Renders hugeicons CalendarLock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarLock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarLock02Icon
 * @description Renders hugeicons CalendarLock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarLock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarLove01Icon
 * @description Renders hugeicons CalendarLove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarLove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarLove02Icon
 * @description Renders hugeicons CalendarLove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarLove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarMinus01Icon
 * @description Renders hugeicons CalendarMinus01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarMinus01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarMinus02Icon
 * @description Renders hugeicons CalendarMinus02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarMinus02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarRemove01Icon
 * @description Renders hugeicons CalendarRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarRemove02Icon
 * @description Renders hugeicons CalendarRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarSetting01Icon
 * @description Renders hugeicons CalendarSetting01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarSetting01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarSetting02Icon
 * @description Renders hugeicons CalendarSetting02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarSetting02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarUpload01Icon
 * @description Renders hugeicons CalendarUpload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarUpload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CalendarUpload02Icon
 * @description Renders hugeicons CalendarUpload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CalendarUpload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallAddIcon
 * @description Renders hugeicons CallAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallBlockedIcon
 * @description Renders hugeicons CallBlockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallBlockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallIcon
 * @description Renders hugeicons CallIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallDisabledIcon
 * @description Renders hugeicons CallDisabledIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallDisabledIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallDoneIcon
 * @description Renders hugeicons CallDoneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallDoneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallEnd01Icon
 * @description Renders hugeicons CallEnd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallEnd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallEnd02Icon
 * @description Renders hugeicons CallEnd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallEnd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallIncoming01Icon
 * @description Renders hugeicons CallIncoming01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallIncoming01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallIncoming02Icon
 * @description Renders hugeicons CallIncoming02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallIncoming02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallInternalIcon
 * @description Renders hugeicons CallInternalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallInternalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallLockedIcon
 * @description Renders hugeicons CallLockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallLockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallMinusIcon
 * @description Renders hugeicons CallMinusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallMinusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallMissed01Icon
 * @description Renders hugeicons CallMissed01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallMissed01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallMissed02Icon
 * @description Renders hugeicons CallMissed02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallMissed02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallOutgoing01Icon
 * @description Renders hugeicons CallOutgoing01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallOutgoing01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallOutgoing02Icon
 * @description Renders hugeicons CallOutgoing02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallOutgoing02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallPausedIcon
 * @description Renders hugeicons CallPausedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallPausedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallReceivedIcon
 * @description Renders hugeicons CallReceivedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallReceivedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallRinging01Icon
 * @description Renders hugeicons CallRinging01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallRinging01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallRinging02Icon
 * @description Renders hugeicons CallRinging02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallRinging02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallUnlockedIcon
 * @description Renders hugeicons CallUnlockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallUnlockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CallingIcon
 * @description Renders hugeicons CallingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CallingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CamelIcon
 * @description Renders hugeicons CamelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CamelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Camera01Icon
 * @description Renders hugeicons Camera01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Camera01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Camera02Icon
 * @description Renders hugeicons Camera02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Camera02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraAdd01Icon
 * @description Renders hugeicons CameraAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraAdd02Icon
 * @description Renders hugeicons CameraAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraAutomatically01Icon
 * @description Renders hugeicons CameraAutomatically01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraAutomatically01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraAutomatically02Icon
 * @description Renders hugeicons CameraAutomatically02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraAutomatically02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraLensIcon
 * @description Renders hugeicons CameraLensIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraLensIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraMicrophone01Icon
 * @description Renders hugeicons CameraMicrophone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraMicrophone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraMicrophone02Icon
 * @description Renders hugeicons CameraMicrophone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraMicrophone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraNightMode01Icon
 * @description Renders hugeicons CameraNightMode01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraNightMode01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraNightMode02Icon
 * @description Renders hugeicons CameraNightMode02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraNightMode02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraOff01Icon
 * @description Renders hugeicons CameraOff01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraOff01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraOff02Icon
 * @description Renders hugeicons CameraOff02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraOff02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraRotated01Icon
 * @description Renders hugeicons CameraRotated01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraRotated01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraRotated02Icon
 * @description Renders hugeicons CameraRotated02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraRotated02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraSmile01Icon
 * @description Renders hugeicons CameraSmile01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraSmile01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraSmile02Icon
 * @description Renders hugeicons CameraSmile02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraSmile02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraTripodIcon
 * @description Renders hugeicons CameraTripodIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraTripodIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CameraVideoIcon
 * @description Renders hugeicons CameraVideoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CameraVideoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CamperIcon
 * @description Renders hugeicons CamperIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CamperIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cancel01Icon
 * @description Renders hugeicons Cancel01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cancel01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cancel02Icon
 * @description Renders hugeicons Cancel02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cancel02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CancelCircleIcon
 * @description Renders hugeicons CancelCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CancelCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CancelCircleHalfDotIcon
 * @description Renders hugeicons CancelCircleHalfDotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CancelCircleHalfDotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CancelSquareIcon
 * @description Renders hugeicons CancelSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CancelSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Candelier01Icon
 * @description Renders hugeicons Candelier01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Candelier01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Candelier02Icon
 * @description Renders hugeicons Candelier02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Candelier02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CanvasIcon
 * @description Renders hugeicons CanvasIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CanvasIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CapIcon
 * @description Renders hugeicons CapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CapProjectingIcon
 * @description Renders hugeicons CapProjectingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CapProjectingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CapRoundIcon
 * @description Renders hugeicons CapRoundIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CapRoundIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CapStraightIcon
 * @description Renders hugeicons CapStraightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CapStraightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CapcutIcon
 * @description Renders hugeicons CapcutIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CapcutIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CapcutRectangleIcon
 * @description Renders hugeicons CapcutRectangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CapcutRectangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Car01Icon
 * @description Renders hugeicons Car01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Car01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Car02Icon
 * @description Renders hugeicons Car02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Car02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Car03Icon
 * @description Renders hugeicons Car03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Car03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Car04Icon
 * @description Renders hugeicons Car04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Car04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CarParking01Icon
 * @description Renders hugeicons CarParking01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CarParking01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CarParking02Icon
 * @description Renders hugeicons CarParking02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CarParking02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CaravanIcon
 * @description Renders hugeicons CaravanIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CaravanIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CardExchange01Icon
 * @description Renders hugeicons CardExchange01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CardExchange01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CardExchange02Icon
 * @description Renders hugeicons CardExchange02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CardExchange02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CardiganIcon
 * @description Renders hugeicons CardiganIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CardiganIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cardiogram01Icon
 * @description Renders hugeicons Cardiogram01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cardiogram01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cardiogram02Icon
 * @description Renders hugeicons Cardiogram02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cardiogram02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cards01Icon
 * @description Renders hugeicons Cards01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cards01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cards02Icon
 * @description Renders hugeicons Cards02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cards02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CargoShipIcon
 * @description Renders hugeicons CargoShipIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CargoShipIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CarouselHorizontalIcon
 * @description Renders hugeicons CarouselHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CarouselHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CarouselVerticalIcon
 * @description Renders hugeicons CarouselVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CarouselVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CarrotIcon
 * @description Renders hugeicons CarrotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CarrotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cash01Icon
 * @description Renders hugeicons Cash01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cash01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cash02Icon
 * @description Renders hugeicons Cash02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cash02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CashierIcon
 * @description Renders hugeicons CashierIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CashierIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Castle01Icon
 * @description Renders hugeicons Castle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Castle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Castle02Icon
 * @description Renders hugeicons Castle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Castle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CastleIcon
 * @description Renders hugeicons CastleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CastleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CatalogueIcon
 * @description Renders hugeicons CatalogueIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CatalogueIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CayanTowerIcon
 * @description Renders hugeicons CayanTowerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CayanTowerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CctvCameraIcon
 * @description Renders hugeicons CctvCameraIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CctvCameraIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CdIcon
 * @description Renders hugeicons CdIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CdIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CellsIcon
 * @description Renders hugeicons CellsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CellsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CellularNetworkIcon
 * @description Renders hugeicons CellularNetworkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CellularNetworkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CellularNetworkOfflineIcon
 * @description Renders hugeicons CellularNetworkOfflineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CellularNetworkOfflineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CelsiusIcon
 * @description Renders hugeicons CelsiusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CelsiusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CenterFocusIcon
 * @description Renders hugeicons CenterFocusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CenterFocusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CentralShaheedMinarIcon
 * @description Renders hugeicons CentralShaheedMinarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CentralShaheedMinarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CentralizedIcon
 * @description Renders hugeicons CentralizedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CentralizedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Certificate01Icon
 * @description Renders hugeicons Certificate01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Certificate01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Certificate02Icon
 * @description Renders hugeicons Certificate02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Certificate02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chair01Icon
 * @description Renders hugeicons Chair01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chair01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chair02Icon
 * @description Renders hugeicons Chair02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chair02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chair03Icon
 * @description Renders hugeicons Chair03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chair03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chair04Icon
 * @description Renders hugeicons Chair04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chair04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chair05Icon
 * @description Renders hugeicons Chair05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chair05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChairBarberIcon
 * @description Renders hugeicons ChairBarberIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChairBarberIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChampionIcon
 * @description Renders hugeicons ChampionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChampionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChangeScreenModeIcon
 * @description Renders hugeicons ChangeScreenModeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChangeScreenModeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CharacterPhoneticIcon
 * @description Renders hugeicons CharacterPhoneticIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CharacterPhoneticIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CharityIcon
 * @description Renders hugeicons CharityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CharityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartAverageIcon
 * @description Renders hugeicons ChartAverageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartAverageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartBarLineIcon
 * @description Renders hugeicons ChartBarLineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartBarLineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartBreakoutCircleIcon
 * @description Renders hugeicons ChartBreakoutCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartBreakoutCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartBreakoutSquareIcon
 * @description Renders hugeicons ChartBreakoutSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartBreakoutSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartBubble01Icon
 * @description Renders hugeicons ChartBubble01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartBubble01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartBubble02Icon
 * @description Renders hugeicons ChartBubble02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartBubble02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartIcon
 * @description Renders hugeicons ChartIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartColumnIcon
 * @description Renders hugeicons ChartColumnIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartColumnIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartDecreaseIcon
 * @description Renders hugeicons ChartDecreaseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartDecreaseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartEvaluationIcon
 * @description Renders hugeicons ChartEvaluationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartEvaluationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartHighLowIcon
 * @description Renders hugeicons ChartHighLowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartHighLowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartHistogramIcon
 * @description Renders hugeicons ChartHistogramIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartHistogramIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartIncreaseIcon
 * @description Renders hugeicons ChartIncreaseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartIncreaseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartLineData01Icon
 * @description Renders hugeicons ChartLineData01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartLineData01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartLineData02Icon
 * @description Renders hugeicons ChartLineData02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartLineData02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartLineData03Icon
 * @description Renders hugeicons ChartLineData03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartLineData03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartMaximumIcon
 * @description Renders hugeicons ChartMaximumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartMaximumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartMediumIcon
 * @description Renders hugeicons ChartMediumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartMediumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartMinimumIcon
 * @description Renders hugeicons ChartMinimumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartMinimumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartRadarIcon
 * @description Renders hugeicons ChartRadarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartRadarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartRelationshipIcon
 * @description Renders hugeicons ChartRelationshipIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartRelationshipIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartRingIcon
 * @description Renders hugeicons ChartRingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartRingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartRoseIcon
 * @description Renders hugeicons ChartRoseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartRoseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChartScatterIcon
 * @description Renders hugeicons ChartScatterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChartScatterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChatBotIcon
 * @description Renders hugeicons ChatBotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChatBotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chatting01Icon
 * @description Renders hugeicons Chatting01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chatting01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckListIcon
 * @description Renders hugeicons CheckListIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckListIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkBadge01Icon
 * @description Renders hugeicons CheckmarkBadge01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkBadge01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkBadge02Icon
 * @description Renders hugeicons CheckmarkBadge02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkBadge02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkBadge03Icon
 * @description Renders hugeicons CheckmarkBadge03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkBadge03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkBadge04Icon
 * @description Renders hugeicons CheckmarkBadge04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkBadge04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkCircle01Icon
 * @description Renders hugeicons CheckmarkCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkCircle02Icon
 * @description Renders hugeicons CheckmarkCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkCircle03Icon
 * @description Renders hugeicons CheckmarkCircle03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkCircle03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkCircle04Icon
 * @description Renders hugeicons CheckmarkCircle04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkCircle04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkSquare01Icon
 * @description Renders hugeicons CheckmarkSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkSquare02Icon
 * @description Renders hugeicons CheckmarkSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkSquare03Icon
 * @description Renders hugeicons CheckmarkSquare03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkSquare03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheckmarkSquare04Icon
 * @description Renders hugeicons CheckmarkSquare04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheckmarkSquare04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheeseIcon
 * @description Renders hugeicons CheeseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheeseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheeseCake01Icon
 * @description Renders hugeicons CheeseCake01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheeseCake01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CheeseCake02Icon
 * @description Renders hugeicons CheeseCake02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CheeseCake02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChefIcon
 * @description Renders hugeicons ChefIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChefIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChefHatIcon
 * @description Renders hugeicons ChefHatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChefHatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chemistry01Icon
 * @description Renders hugeicons Chemistry01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chemistry01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chemistry02Icon
 * @description Renders hugeicons Chemistry02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chemistry02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chemistry03Icon
 * @description Renders hugeicons Chemistry03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chemistry03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CherryIcon
 * @description Renders hugeicons CherryIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CherryIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chess01Icon
 * @description Renders hugeicons Chess01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chess01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chess02Icon
 * @description Renders hugeicons Chess02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chess02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChessPawnIcon
 * @description Renders hugeicons ChessPawnIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChessPawnIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChickenThighsIcon
 * @description Renders hugeicons ChickenThighsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChickenThighsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChimneyIcon
 * @description Renders hugeicons ChimneyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChimneyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChinaTempleIcon
 * @description Renders hugeicons ChinaTempleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChinaTempleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Chip02Icon
 * @description Renders hugeicons Chip02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Chip02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChipIcon
 * @description Renders hugeicons ChipIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChipIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChocolateIcon
 * @description Renders hugeicons ChocolateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChocolateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChromeIcon
 * @description Renders hugeicons ChromeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChromeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChryslerIcon
 * @description Renders hugeicons ChryslerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChryslerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ChurchIcon
 * @description Renders hugeicons ChurchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ChurchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CinnamonRollIcon
 * @description Renders hugeicons CinnamonRollIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CinnamonRollIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDataTransferDiagonalIcon
 * @description Renders hugeicons CircleArrowDataTransferDiagonalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDataTransferDiagonalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDataTransferHorizontalIcon
 * @description Renders hugeicons CircleArrowDataTransferHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDataTransferHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDataTransferVerticalIcon
 * @description Renders hugeicons CircleArrowDataTransferVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDataTransferVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDiagonal01Icon
 * @description Renders hugeicons CircleArrowDiagonal01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDiagonal01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDiagonal02Icon
 * @description Renders hugeicons CircleArrowDiagonal02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDiagonal02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDown01Icon
 * @description Renders hugeicons CircleArrowDown01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDown01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDown02Icon
 * @description Renders hugeicons CircleArrowDown02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDown02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDown03Icon
 * @description Renders hugeicons CircleArrowDown03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDown03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDownDoubleIcon
 * @description Renders hugeicons CircleArrowDownDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDownDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDownLeftIcon
 * @description Renders hugeicons CircleArrowDownLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDownLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowDownRightIcon
 * @description Renders hugeicons CircleArrowDownRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowDownRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowExpand01Icon
 * @description Renders hugeicons CircleArrowExpand01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowExpand01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowExpand02Icon
 * @description Renders hugeicons CircleArrowExpand02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowExpand02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowHorizontalIcon
 * @description Renders hugeicons CircleArrowHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowLeft01Icon
 * @description Renders hugeicons CircleArrowLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowLeft02Icon
 * @description Renders hugeicons CircleArrowLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowLeft03Icon
 * @description Renders hugeicons CircleArrowLeft03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowLeft03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowLeftDoubleIcon
 * @description Renders hugeicons CircleArrowLeftDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowLeftDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowLeftRightIcon
 * @description Renders hugeicons CircleArrowLeftRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowLeftRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowMoveDownLeftIcon
 * @description Renders hugeicons CircleArrowMoveDownLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowMoveDownLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowMoveDownRightIcon
 * @description Renders hugeicons CircleArrowMoveDownRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowMoveDownRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowMoveLeftDownIcon
 * @description Renders hugeicons CircleArrowMoveLeftDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowMoveLeftDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowMoveRightDownIcon
 * @description Renders hugeicons CircleArrowMoveRightDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowMoveRightDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowMoveUpLeftIcon
 * @description Renders hugeicons CircleArrowMoveUpLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowMoveUpLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowMoveUpRightIcon
 * @description Renders hugeicons CircleArrowMoveUpRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowMoveUpRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowReload01Icon
 * @description Renders hugeicons CircleArrowReload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowReload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowReload02Icon
 * @description Renders hugeicons CircleArrowReload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowReload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowRight01Icon
 * @description Renders hugeicons CircleArrowRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowRight02Icon
 * @description Renders hugeicons CircleArrowRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowRight03Icon
 * @description Renders hugeicons CircleArrowRight03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowRight03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowRightDoubleIcon
 * @description Renders hugeicons CircleArrowRightDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowRightDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowShrink01Icon
 * @description Renders hugeicons CircleArrowShrink01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowShrink01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowShrink02Icon
 * @description Renders hugeicons CircleArrowShrink02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowShrink02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowUp01Icon
 * @description Renders hugeicons CircleArrowUp01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowUp01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowUp02Icon
 * @description Renders hugeicons CircleArrowUp02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowUp02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowUp03Icon
 * @description Renders hugeicons CircleArrowUp03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowUp03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowUpDoubleIcon
 * @description Renders hugeicons CircleArrowUpDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowUpDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowUpDownIcon
 * @description Renders hugeicons CircleArrowUpDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowUpDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowUpLeftIcon
 * @description Renders hugeicons CircleArrowUpLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowUpLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowUpRightIcon
 * @description Renders hugeicons CircleArrowUpRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowUpRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleArrowVerticalIcon
 * @description Renders hugeicons CircleArrowVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleArrowVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleIcon
 * @description Renders hugeicons CircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLock01Icon
 * @description Renders hugeicons CircleLock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLock02Icon
 * @description Renders hugeicons CircleLock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLockAdd01Icon
 * @description Renders hugeicons CircleLockAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLockAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLockAdd02Icon
 * @description Renders hugeicons CircleLockAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLockAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLockCheck01Icon
 * @description Renders hugeicons CircleLockCheck01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLockCheck01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLockCheck02Icon
 * @description Renders hugeicons CircleLockCheck02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLockCheck02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLockMinus01Icon
 * @description Renders hugeicons CircleLockMinus01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLockMinus01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLockMinus02Icon
 * @description Renders hugeicons CircleLockMinus02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLockMinus02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLockRemove01Icon
 * @description Renders hugeicons CircleLockRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLockRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleLockRemove02Icon
 * @description Renders hugeicons CircleLockRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleLockRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CirclePasswordIcon
 * @description Renders hugeicons CirclePasswordIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CirclePasswordIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleUnlock01Icon
 * @description Renders hugeicons CircleUnlock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleUnlock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CircleUnlock02Icon
 * @description Renders hugeicons CircleUnlock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CircleUnlock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name City01Icon
 * @description Renders hugeicons City01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const City01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name City02Icon
 * @description Renders hugeicons City02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const City02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name City03Icon
 * @description Renders hugeicons City03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const City03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clapping01Icon
 * @description Renders hugeicons Clapping01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clapping01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clapping02Icon
 * @description Renders hugeicons Clapping02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clapping02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CleaningBucketIcon
 * @description Renders hugeicons CleaningBucketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CleaningBucketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ClinicIcon
 * @description Renders hugeicons ClinicIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ClinicIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ClipIcon
 * @description Renders hugeicons ClipIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ClipIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ClipboardIcon
 * @description Renders hugeicons ClipboardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ClipboardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clock01Icon
 * @description Renders hugeicons Clock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clock02Icon
 * @description Renders hugeicons Clock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clock03Icon
 * @description Renders hugeicons Clock03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clock03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clock04Icon
 * @description Renders hugeicons Clock04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clock04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clock05Icon
 * @description Renders hugeicons Clock05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clock05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ClosedCaptionAltIcon
 * @description Renders hugeicons ClosedCaptionAltIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ClosedCaptionAltIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ClosedCaptionIcon
 * @description Renders hugeicons ClosedCaptionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ClosedCaptionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ClothesIcon
 * @description Renders hugeicons ClothesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ClothesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudAngledRainIcon
 * @description Renders hugeicons CloudAngledRainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudAngledRainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudAngledRainZapIcon
 * @description Renders hugeicons CloudAngledRainZapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudAngledRainZapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudAngledZapIcon
 * @description Renders hugeicons CloudAngledZapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudAngledZapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudBigRainIcon
 * @description Renders hugeicons CloudBigRainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudBigRainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudIcon
 * @description Renders hugeicons CloudIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudDownloadIcon
 * @description Renders hugeicons CloudDownloadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudDownloadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudFastWindIcon
 * @description Renders hugeicons CloudFastWindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudFastWindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudHailstoneIcon
 * @description Renders hugeicons CloudHailstoneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudHailstoneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudLittleRainIcon
 * @description Renders hugeicons CloudLittleRainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudLittleRainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudLittleSnowIcon
 * @description Renders hugeicons CloudLittleSnowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudLittleSnowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudLoadingIcon
 * @description Renders hugeicons CloudLoadingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudLoadingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudMidRainIcon
 * @description Renders hugeicons CloudMidRainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudMidRainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudMidSnowIcon
 * @description Renders hugeicons CloudMidSnowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudMidSnowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudSavingDone01Icon
 * @description Renders hugeicons CloudSavingDone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudSavingDone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudSavingDone02Icon
 * @description Renders hugeicons CloudSavingDone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudSavingDone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudServerIcon
 * @description Renders hugeicons CloudServerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudServerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudSlowWindIcon
 * @description Renders hugeicons CloudSlowWindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudSlowWindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudSnowIcon
 * @description Renders hugeicons CloudSnowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudSnowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CloudUploadIcon
 * @description Renders hugeicons CloudUploadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CloudUploadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clubs01Icon
 * @description Renders hugeicons Clubs01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clubs01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Clubs02Icon
 * @description Renders hugeicons Clubs02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Clubs02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CoPresentIcon
 * @description Renders hugeicons CoPresentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CoPresentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CodeIcon
 * @description Renders hugeicons CodeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CodeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CodeCircleIcon
 * @description Renders hugeicons CodeCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CodeCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CodeFolderIcon
 * @description Renders hugeicons CodeFolderIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CodeFolderIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CodeSquareIcon
 * @description Renders hugeicons CodeSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CodeSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CodesandboxIcon
 * @description Renders hugeicons CodesandboxIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CodesandboxIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coffee01Icon
 * @description Renders hugeicons Coffee01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coffee01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coffee02Icon
 * @description Renders hugeicons Coffee02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coffee02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CoffeeBeansIcon
 * @description Renders hugeicons CoffeeBeansIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CoffeeBeansIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coins01Icon
 * @description Renders hugeicons Coins01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coins01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coins02Icon
 * @description Renders hugeicons Coins02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coins02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CoinsBitcoinIcon
 * @description Renders hugeicons CoinsBitcoinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CoinsBitcoinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CoinsDollarIcon
 * @description Renders hugeicons CoinsDollarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CoinsDollarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CoinsEuroIcon
 * @description Renders hugeicons CoinsEuroIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CoinsEuroIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CoinsPoundIcon
 * @description Renders hugeicons CoinsPoundIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CoinsPoundIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CoinsSwapIcon
 * @description Renders hugeicons CoinsSwapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CoinsSwapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CoinsYenIcon
 * @description Renders hugeicons CoinsYenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CoinsYenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CollectionsBookmarkIcon
 * @description Renders hugeicons CollectionsBookmarkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CollectionsBookmarkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ColorPickerIcon
 * @description Renders hugeicons ColorPickerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ColorPickerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ColorsIcon
 * @description Renders hugeicons ColorsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ColorsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ColosseumIcon
 * @description Renders hugeicons ColosseumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ColosseumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ColumnDeleteIcon
 * @description Renders hugeicons ColumnDeleteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ColumnDeleteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ColumnInsertIcon
 * @description Renders hugeicons ColumnInsertIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ColumnInsertIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Comet01Icon
 * @description Renders hugeicons Comet01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Comet01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Comet02Icon
 * @description Renders hugeicons Comet02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Comet02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComingSoon01Icon
 * @description Renders hugeicons ComingSoon01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComingSoon01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComingSoon02Icon
 * @description Renders hugeicons ComingSoon02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComingSoon02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CommandIcon
 * @description Renders hugeicons CommandIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CommandIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CommandLineIcon
 * @description Renders hugeicons CommandLineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CommandLineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Comment01Icon
 * @description Renders hugeicons Comment01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Comment01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Comment02Icon
 * @description Renders hugeicons Comment02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Comment02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CommentAdd01Icon
 * @description Renders hugeicons CommentAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CommentAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CommentAdd02Icon
 * @description Renders hugeicons CommentAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CommentAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CommentBlock01Icon
 * @description Renders hugeicons CommentBlock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CommentBlock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CommentBlock02Icon
 * @description Renders hugeicons CommentBlock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CommentBlock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CommentRemove01Icon
 * @description Renders hugeicons CommentRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CommentRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CommentRemove02Icon
 * @description Renders hugeicons CommentRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CommentRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Compass01Icon
 * @description Renders hugeicons Compass01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Compass01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CompassIcon
 * @description Renders hugeicons CompassIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CompassIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComplaintIcon
 * @description Renders hugeicons ComplaintIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComplaintIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerAddIcon
 * @description Renders hugeicons ComputerAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerIcon
 * @description Renders hugeicons ComputerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerCheckIcon
 * @description Renders hugeicons ComputerCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerCloudIcon
 * @description Renders hugeicons ComputerCloudIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerCloudIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerDesk01Icon
 * @description Renders hugeicons ComputerDesk01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerDesk01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerDesk02Icon
 * @description Renders hugeicons ComputerDesk02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerDesk02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerDesk03Icon
 * @description Renders hugeicons ComputerDesk03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerDesk03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerDollarIcon
 * @description Renders hugeicons ComputerDollarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerDollarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerPhoneSyncIcon
 * @description Renders hugeicons ComputerPhoneSyncIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerPhoneSyncIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerProgramming01Icon
 * @description Renders hugeicons ComputerProgramming01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerProgramming01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerProgramming02Icon
 * @description Renders hugeicons ComputerProgramming02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerProgramming02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerProtectionIcon
 * @description Renders hugeicons ComputerProtectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerProtectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerRemoveIcon
 * @description Renders hugeicons ComputerRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerSettingsIcon
 * @description Renders hugeicons ComputerSettingsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerSettingsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerVideoIcon
 * @description Renders hugeicons ComputerVideoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerVideoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ComputerVideoCallIcon
 * @description Renders hugeicons ComputerVideoCallIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ComputerVideoCallIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cone01Icon
 * @description Renders hugeicons Cone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cone02Icon
 * @description Renders hugeicons Cone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ConferenceIcon
 * @description Renders hugeicons ConferenceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ConferenceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Configuration01Icon
 * @description Renders hugeicons Configuration01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Configuration01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Configuration02Icon
 * @description Renders hugeicons Configuration02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Configuration02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ConfusedIcon
 * @description Renders hugeicons ConfusedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ConfusedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CongruentToIcon
 * @description Renders hugeicons CongruentToIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CongruentToIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CongruentToCircleIcon
 * @description Renders hugeicons CongruentToCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CongruentToCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CongruentToSquareIcon
 * @description Renders hugeicons CongruentToSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CongruentToSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ConnectIcon
 * @description Renders hugeicons ConnectIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ConnectIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ConsoleIcon
 * @description Renders hugeicons ConsoleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ConsoleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ConstellationIcon
 * @description Renders hugeicons ConstellationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ConstellationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Contact01Icon
 * @description Renders hugeicons Contact01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Contact01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Contact02Icon
 * @description Renders hugeicons Contact02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Contact02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ContactBookIcon
 * @description Renders hugeicons ContactBookIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ContactBookIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ContactIcon
 * @description Renders hugeicons ContactIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ContactIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ContainerTruck01Icon
 * @description Renders hugeicons ContainerTruck01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ContainerTruck01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ContainerTruck02Icon
 * @description Renders hugeicons ContainerTruck02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ContainerTruck02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ContainerTruckIcon
 * @description Renders hugeicons ContainerTruckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ContainerTruckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ConversationIcon
 * @description Renders hugeicons ConversationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ConversationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CookBookIcon
 * @description Renders hugeicons CookBookIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CookBookIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CookieIcon
 * @description Renders hugeicons CookieIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CookieIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coordinate01Icon
 * @description Renders hugeicons Coordinate01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coordinate01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coordinate02Icon
 * @description Renders hugeicons Coordinate02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coordinate02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Copy01Icon
 * @description Renders hugeicons Copy01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Copy01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Copy02Icon
 * @description Renders hugeicons Copy02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Copy02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CopyLinkIcon
 * @description Renders hugeicons CopyLinkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CopyLinkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CopyrightIcon
 * @description Renders hugeicons CopyrightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CopyrightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CornIcon
 * @description Renders hugeicons CornIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CornIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CorporateIcon
 * @description Renders hugeicons CorporateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CorporateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CosIcon
 * @description Renders hugeicons CosIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CosIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cosine01Icon
 * @description Renders hugeicons Cosine01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cosine01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cosine02Icon
 * @description Renders hugeicons Cosine02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cosine02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CottageIcon
 * @description Renders hugeicons CottageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CottageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CottonCandyIcon
 * @description Renders hugeicons CottonCandyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CottonCandyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coupon01Icon
 * @description Renders hugeicons Coupon01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coupon01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coupon02Icon
 * @description Renders hugeicons Coupon02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coupon02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Coupon03Icon
 * @description Renders hugeicons Coupon03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Coupon03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CouponPercentIcon
 * @description Renders hugeicons CouponPercentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CouponPercentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CourseIcon
 * @description Renders hugeicons CourseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CourseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CourtHouseIcon
 * @description Renders hugeicons CourtHouseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CourtHouseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CourtLawIcon
 * @description Renders hugeicons CourtLawIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CourtLawIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CovariateIcon
 * @description Renders hugeicons CovariateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CovariateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CovidInfoIcon
 * @description Renders hugeicons CovidInfoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CovidInfoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CowboyHatIcon
 * @description Renders hugeicons CowboyHatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CowboyHatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CpuIcon
 * @description Renders hugeicons CpuIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CpuIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CpuChargeIcon
 * @description Renders hugeicons CpuChargeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CpuChargeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CpuSettingsIcon
 * @description Renders hugeicons CpuSettingsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CpuSettingsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CrabIcon
 * @description Renders hugeicons CrabIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CrabIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CraneIcon
 * @description Renders hugeicons CraneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CraneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CrazyIcon
 * @description Renders hugeicons CrazyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CrazyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreativeMarketIcon
 * @description Renders hugeicons CreativeMarketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreativeMarketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardAcceptIcon
 * @description Renders hugeicons CreditCardAcceptIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardAcceptIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardAddIcon
 * @description Renders hugeicons CreditCardAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardIcon
 * @description Renders hugeicons CreditCardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardChangeIcon
 * @description Renders hugeicons CreditCardChangeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardChangeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardDefrostIcon
 * @description Renders hugeicons CreditCardDefrostIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardDefrostIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardFreezeIcon
 * @description Renders hugeicons CreditCardFreezeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardFreezeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardNotAcceptIcon
 * @description Renders hugeicons CreditCardNotAcceptIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardNotAcceptIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardNotFoundIcon
 * @description Renders hugeicons CreditCardNotFoundIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardNotFoundIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardPosIcon
 * @description Renders hugeicons CreditCardPosIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardPosIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CreditCardValidationIcon
 * @description Renders hugeicons CreditCardValidationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CreditCardValidationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CricketBatIcon
 * @description Renders hugeicons CricketBatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CricketBatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CricketHelmetIcon
 * @description Renders hugeicons CricketHelmetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CricketHelmetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CroissantIcon
 * @description Renders hugeicons CroissantIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CroissantIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CropIcon
 * @description Renders hugeicons CropIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CropIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CrowdfundingIcon
 * @description Renders hugeicons CrowdfundingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CrowdfundingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CrownIcon
 * @description Renders hugeicons CrownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CrownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CryingIcon
 * @description Renders hugeicons CryingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CryingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Csv01Icon
 * @description Renders hugeicons Csv01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Csv01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Csv02Icon
 * @description Renders hugeicons Csv02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Csv02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CubeIcon
 * @description Renders hugeicons CubeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CubeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cupcake01Icon
 * @description Renders hugeicons Cupcake01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cupcake01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cupcake02Icon
 * @description Renders hugeicons Cupcake02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cupcake02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cupcake03Icon
 * @description Renders hugeicons Cupcake03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cupcake03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CurlingIcon
 * @description Renders hugeicons CurlingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CurlingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cursor01Icon
 * @description Renders hugeicons Cursor01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cursor01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cursor02Icon
 * @description Renders hugeicons Cursor02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cursor02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorAddSelection01Icon
 * @description Renders hugeicons CursorAddSelection01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorAddSelection01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorAddSelection02Icon
 * @description Renders hugeicons CursorAddSelection02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorAddSelection02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorCircleSelection01Icon
 * @description Renders hugeicons CursorCircleSelection01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorCircleSelection01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorCircleSelection02Icon
 * @description Renders hugeicons CursorCircleSelection02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorCircleSelection02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorDisabled01Icon
 * @description Renders hugeicons CursorDisabled01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorDisabled01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorDisabled02Icon
 * @description Renders hugeicons CursorDisabled02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorDisabled02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorEdit01Icon
 * @description Renders hugeicons CursorEdit01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorEdit01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorEdit02Icon
 * @description Renders hugeicons CursorEdit02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorEdit02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorHold01Icon
 * @description Renders hugeicons CursorHold01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorHold01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorHold02Icon
 * @description Renders hugeicons CursorHold02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorHold02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorInWindowIcon
 * @description Renders hugeicons CursorInWindowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorInWindowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorInfo01Icon
 * @description Renders hugeicons CursorInfo01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorInfo01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorInfo02Icon
 * @description Renders hugeicons CursorInfo02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorInfo02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorLoading01Icon
 * @description Renders hugeicons CursorLoading01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorLoading01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorLoading02Icon
 * @description Renders hugeicons CursorLoading02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorLoading02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorMagicSelection01Icon
 * @description Renders hugeicons CursorMagicSelection01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorMagicSelection01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorMagicSelection02Icon
 * @description Renders hugeicons CursorMagicSelection02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorMagicSelection02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorMove01Icon
 * @description Renders hugeicons CursorMove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorMove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorMove02Icon
 * @description Renders hugeicons CursorMove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorMove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorPointer01Icon
 * @description Renders hugeicons CursorPointer01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorPointer01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorPointer02Icon
 * @description Renders hugeicons CursorPointer02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorPointer02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorProgress01Icon
 * @description Renders hugeicons CursorProgress01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorProgress01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorProgress02Icon
 * @description Renders hugeicons CursorProgress02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorProgress02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorProgress03Icon
 * @description Renders hugeicons CursorProgress03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorProgress03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorProgress04Icon
 * @description Renders hugeicons CursorProgress04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorProgress04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorRectangleSelection01Icon
 * @description Renders hugeicons CursorRectangleSelection01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorRectangleSelection01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorRectangleSelection02Icon
 * @description Renders hugeicons CursorRectangleSelection02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorRectangleSelection02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorRemoveSelection01Icon
 * @description Renders hugeicons CursorRemoveSelection01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorRemoveSelection01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorRemoveSelection02Icon
 * @description Renders hugeicons CursorRemoveSelection02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorRemoveSelection02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CursorTextIcon
 * @description Renders hugeicons CursorTextIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CursorTextIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CurtainsIcon
 * @description Renders hugeicons CurtainsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CurtainsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CurvyLeftDirectionIcon
 * @description Renders hugeicons CurvyLeftDirectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CurvyLeftDirectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CurvyLeftRightDirectionIcon
 * @description Renders hugeicons CurvyLeftRightDirectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CurvyLeftRightDirectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CurvyRightDirectionIcon
 * @description Renders hugeicons CurvyRightDirectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CurvyRightDirectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CurvyUpDownDirectionIcon
 * @description Renders hugeicons CurvyUpDownDirectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CurvyUpDownDirectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CustomerService01Icon
 * @description Renders hugeicons CustomerService01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CustomerService01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CustomerService02Icon
 * @description Renders hugeicons CustomerService02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CustomerService02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CustomerServiceIcon
 * @description Renders hugeicons CustomerServiceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CustomerServiceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CustomerSupportIcon
 * @description Renders hugeicons CustomerSupportIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CustomerSupportIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name CustomizeIcon
 * @description Renders hugeicons CustomizeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const CustomizeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cylinder01Icon
 * @description Renders hugeicons Cylinder01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cylinder01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cylinder02Icon
 * @description Renders hugeicons Cylinder02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cylinder02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cylinder03Icon
 * @description Renders hugeicons Cylinder03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cylinder03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Cylinder04Icon
 * @description Renders hugeicons Cylinder04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Cylinder04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DangerIcon
 * @description Renders hugeicons DangerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DangerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DartIcon
 * @description Renders hugeicons DartIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DartIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardBrowsingIcon
 * @description Renders hugeicons DashboardBrowsingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardBrowsingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardCircleAddIcon
 * @description Renders hugeicons DashboardCircleAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardCircleAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardCircleIcon
 * @description Renders hugeicons DashboardCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardCircleEditIcon
 * @description Renders hugeicons DashboardCircleEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardCircleEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardCircleRemoveIcon
 * @description Renders hugeicons DashboardCircleRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardCircleRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardCircleSettingsIcon
 * @description Renders hugeicons DashboardCircleSettingsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardCircleSettingsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSpeed01Icon
 * @description Renders hugeicons DashboardSpeed01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSpeed01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSpeed02Icon
 * @description Renders hugeicons DashboardSpeed02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSpeed02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSquare01Icon
 * @description Renders hugeicons DashboardSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSquare02Icon
 * @description Renders hugeicons DashboardSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSquare03Icon
 * @description Renders hugeicons DashboardSquare03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSquare03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSquareAddIcon
 * @description Renders hugeicons DashboardSquareAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSquareAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSquareEditIcon
 * @description Renders hugeicons DashboardSquareEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSquareEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSquareRemoveIcon
 * @description Renders hugeicons DashboardSquareRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSquareRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashboardSquareSettingIcon
 * @description Renders hugeicons DashboardSquareSettingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashboardSquareSettingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashedLine01Icon
 * @description Renders hugeicons DashedLine01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashedLine01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DashedLine02Icon
 * @description Renders hugeicons DashedLine02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DashedLine02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DataRecoveryIcon
 * @description Renders hugeicons DataRecoveryIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DataRecoveryIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Database01Icon
 * @description Renders hugeicons Database01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Database01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Database02Icon
 * @description Renders hugeicons Database02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Database02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseAddIcon
 * @description Renders hugeicons DatabaseAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseIcon
 * @description Renders hugeicons DatabaseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseExportIcon
 * @description Renders hugeicons DatabaseExportIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseExportIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseImportIcon
 * @description Renders hugeicons DatabaseImportIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseImportIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseLockedIcon
 * @description Renders hugeicons DatabaseLockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseLockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseRestoreIcon
 * @description Renders hugeicons DatabaseRestoreIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseRestoreIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseSettingIcon
 * @description Renders hugeicons DatabaseSettingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseSettingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseSync01Icon
 * @description Renders hugeicons DatabaseSync01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseSync01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatabaseSyncIcon
 * @description Renders hugeicons DatabaseSyncIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatabaseSyncIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DatesIcon
 * @description Renders hugeicons DatesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DatesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeadIcon
 * @description Renders hugeicons DeadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Delete01Icon
 * @description Renders hugeicons Delete01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Delete01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Delete02Icon
 * @description Renders hugeicons Delete02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Delete02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Delete03Icon
 * @description Renders hugeicons Delete03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Delete03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Delete04Icon
 * @description Renders hugeicons Delete04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Delete04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeletePutBackIcon
 * @description Renders hugeicons DeletePutBackIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeletePutBackIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeleteThrowIcon
 * @description Renders hugeicons DeleteThrowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeleteThrowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveredSentIcon
 * @description Renders hugeicons DeliveredSentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveredSentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryBox01Icon
 * @description Renders hugeicons DeliveryBox01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryBox01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryBox02Icon
 * @description Renders hugeicons DeliveryBox02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryBox02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryDelay01Icon
 * @description Renders hugeicons DeliveryDelay01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryDelay01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryDelay02Icon
 * @description Renders hugeicons DeliveryDelay02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryDelay02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryReturn01Icon
 * @description Renders hugeicons DeliveryReturn01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryReturn01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryReturn02Icon
 * @description Renders hugeicons DeliveryReturn02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryReturn02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliverySecure01Icon
 * @description Renders hugeicons DeliverySecure01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliverySecure01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliverySecure02Icon
 * @description Renders hugeicons DeliverySecure02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliverySecure02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliverySent01Icon
 * @description Renders hugeicons DeliverySent01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliverySent01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliverySent02Icon
 * @description Renders hugeicons DeliverySent02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliverySent02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryTracking01Icon
 * @description Renders hugeicons DeliveryTracking01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryTracking01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryTracking02Icon
 * @description Renders hugeicons DeliveryTracking02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryTracking02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryTruck01Icon
 * @description Renders hugeicons DeliveryTruck01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryTruck01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryTruck02Icon
 * @description Renders hugeicons DeliveryTruck02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryTruck02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryView01Icon
 * @description Renders hugeicons DeliveryView01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryView01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeliveryView02Icon
 * @description Renders hugeicons DeliveryView02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeliveryView02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DentalBracesIcon
 * @description Renders hugeicons DentalBracesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DentalBracesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DentalBrokenToothIcon
 * @description Renders hugeicons DentalBrokenToothIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DentalBrokenToothIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DentalCareIcon
 * @description Renders hugeicons DentalCareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DentalCareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DentalToothIcon
 * @description Renders hugeicons DentalToothIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DentalToothIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DepartementIcon
 * @description Renders hugeicons DepartementIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DepartementIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DesertIcon
 * @description Renders hugeicons DesertIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DesertIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Desk01Icon
 * @description Renders hugeicons Desk01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Desk01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Desk02Icon
 * @description Renders hugeicons Desk02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Desk02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeskIcon
 * @description Renders hugeicons DeskIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeskIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeveloperIcon
 * @description Renders hugeicons DeveloperIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeveloperIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DeviantartIcon
 * @description Renders hugeicons DeviantartIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DeviantartIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiagonalScrollPoint01Icon
 * @description Renders hugeicons DiagonalScrollPoint01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiagonalScrollPoint01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiagonalScrollPoint02Icon
 * @description Renders hugeicons DiagonalScrollPoint02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiagonalScrollPoint02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DialpadCircle01Icon
 * @description Renders hugeicons DialpadCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DialpadCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DialpadCircle02Icon
 * @description Renders hugeicons DialpadCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DialpadCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DialpadSquare01Icon
 * @description Renders hugeicons DialpadSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DialpadSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DialpadSquare02Icon
 * @description Renders hugeicons DialpadSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DialpadSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiameterIcon
 * @description Renders hugeicons DiameterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiameterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Diamond01Icon
 * @description Renders hugeicons Diamond01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Diamond01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Diamond02Icon
 * @description Renders hugeicons Diamond02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Diamond02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiamondIcon
 * @description Renders hugeicons DiamondIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiamondIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiaperIcon
 * @description Renders hugeicons DiaperIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiaperIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiceIcon
 * @description Renders hugeicons DiceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DigestionIcon
 * @description Renders hugeicons DigestionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DigestionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiggIcon
 * @description Renders hugeicons DiggIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiggIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DigitalClockIcon
 * @description Renders hugeicons DigitalClockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DigitalClockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DimSum01Icon
 * @description Renders hugeicons DimSum01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DimSum01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DimSum02Icon
 * @description Renders hugeicons DimSum02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DimSum02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiningTableIcon
 * @description Renders hugeicons DiningTableIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiningTableIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiplomaIcon
 * @description Renders hugeicons DiplomaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiplomaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DirectionLeft01Icon
 * @description Renders hugeicons DirectionLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DirectionLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DirectionLeft02Icon
 * @description Renders hugeicons DirectionLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DirectionLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DirectionRight01Icon
 * @description Renders hugeicons DirectionRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DirectionRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DirectionRight02Icon
 * @description Renders hugeicons DirectionRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DirectionRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Directions01Icon
 * @description Renders hugeicons Directions01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Directions01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Directions02Icon
 * @description Renders hugeicons Directions02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Directions02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Disability01Icon
 * @description Renders hugeicons Disability01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Disability01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Disability02Icon
 * @description Renders hugeicons Disability02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Disability02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiscordIcon
 * @description Renders hugeicons DiscordIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiscordIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Discount01Icon
 * @description Renders hugeicons Discount01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Discount01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiscountIcon
 * @description Renders hugeicons DiscountIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiscountIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiscountTag01Icon
 * @description Renders hugeicons DiscountTag01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiscountTag01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiscountTag02Icon
 * @description Renders hugeicons DiscountTag02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiscountTag02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiscoverCircleIcon
 * @description Renders hugeicons DiscoverCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiscoverCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DiscoverSquareIcon
 * @description Renders hugeicons DiscoverSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DiscoverSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dish01Icon
 * @description Renders hugeicons Dish01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dish01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dish02Icon
 * @description Renders hugeicons Dish02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dish02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DishWasherIcon
 * @description Renders hugeicons DishWasherIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DishWasherIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DispleasedIcon
 * @description Renders hugeicons DispleasedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DispleasedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DistributeHorizontalCenterIcon
 * @description Renders hugeicons DistributeHorizontalCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DistributeHorizontalCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DistributeHorizontalLeftIcon
 * @description Renders hugeicons DistributeHorizontalLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DistributeHorizontalLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DistributeHorizontalRightIcon
 * @description Renders hugeicons DistributeHorizontalRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DistributeHorizontalRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DistributeVerticalBottomIcon
 * @description Renders hugeicons DistributeVerticalBottomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DistributeVerticalBottomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DistributeVerticalCenterIcon
 * @description Renders hugeicons DistributeVerticalCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DistributeVerticalCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DistributeVerticalTopIcon
 * @description Renders hugeicons DistributeVerticalTopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DistributeVerticalTopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DistributionIcon
 * @description Renders hugeicons DistributionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DistributionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DivideSignIcon
 * @description Renders hugeicons DivideSignIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DivideSignIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DivideSignCircleIcon
 * @description Renders hugeicons DivideSignCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DivideSignCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DivideSignSquareIcon
 * @description Renders hugeicons DivideSignSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DivideSignSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dna01Icon
 * @description Renders hugeicons Dna01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dna01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DnaIcon
 * @description Renders hugeicons DnaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DnaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DoNotTouch01Icon
 * @description Renders hugeicons DoNotTouch01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DoNotTouch01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DoNotTouch02Icon
 * @description Renders hugeicons DoNotTouch02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DoNotTouch02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Doc01Icon
 * @description Renders hugeicons Doc01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Doc01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Doc02Icon
 * @description Renders hugeicons Doc02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Doc02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Doctor01Icon
 * @description Renders hugeicons Doctor01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Doctor01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Doctor02Icon
 * @description Renders hugeicons Doctor02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Doctor02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Doctor03Icon
 * @description Renders hugeicons Doctor03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Doctor03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DocumentAttachmentIcon
 * @description Renders hugeicons DocumentAttachmentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DocumentAttachmentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DocumentCodeIcon
 * @description Renders hugeicons DocumentCodeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DocumentCodeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DocumentValidationIcon
 * @description Renders hugeicons DocumentValidationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DocumentValidationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dollar01Icon
 * @description Renders hugeicons Dollar01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dollar01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dollar02Icon
 * @description Renders hugeicons Dollar02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dollar02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DollarCircleIcon
 * @description Renders hugeicons DollarCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DollarCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DollarReceive01Icon
 * @description Renders hugeicons DollarReceive01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DollarReceive01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DollarReceive02Icon
 * @description Renders hugeicons DollarReceive02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DollarReceive02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DollarSend01Icon
 * @description Renders hugeicons DollarSend01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DollarSend01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DollarSend02Icon
 * @description Renders hugeicons DollarSend02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DollarSend02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DollarSquareIcon
 * @description Renders hugeicons DollarSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DollarSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DomeIcon
 * @description Renders hugeicons DomeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DomeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DominoIcon
 * @description Renders hugeicons DominoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DominoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Door01Icon
 * @description Renders hugeicons Door01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Door01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Door02Icon
 * @description Renders hugeicons Door02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Door02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DoorIcon
 * @description Renders hugeicons DoorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DoorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DoorLockIcon
 * @description Renders hugeicons DoorLockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DoorLockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DoughnutIcon
 * @description Renders hugeicons DoughnutIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DoughnutIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Download01Icon
 * @description Renders hugeicons Download01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Download01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Download02Icon
 * @description Renders hugeicons Download02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Download02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Download03Icon
 * @description Renders hugeicons Download03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Download03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Download04Icon
 * @description Renders hugeicons Download04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Download04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Download05Icon
 * @description Renders hugeicons Download05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Download05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DownloadCircle01Icon
 * @description Renders hugeicons DownloadCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DownloadCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DownloadCircle02Icon
 * @description Renders hugeicons DownloadCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DownloadCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DownloadSquare01Icon
 * @description Renders hugeicons DownloadSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DownloadSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DownloadSquare02Icon
 * @description Renders hugeicons DownloadSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DownloadSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Drag01Icon
 * @description Renders hugeicons Drag01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Drag01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Drag02Icon
 * @description Renders hugeicons Drag02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Drag02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Drag03Icon
 * @description Renders hugeicons Drag03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Drag03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Drag04Icon
 * @description Renders hugeicons Drag04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Drag04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragDropIcon
 * @description Renders hugeicons DragDropIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragDropIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragDropHorizontalIcon
 * @description Renders hugeicons DragDropHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragDropHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragDropVerticalIcon
 * @description Renders hugeicons DragDropVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragDropVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragLeft01Icon
 * @description Renders hugeicons DragLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragLeft02Icon
 * @description Renders hugeicons DragLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragLeft03Icon
 * @description Renders hugeicons DragLeft03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragLeft03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragLeft04Icon
 * @description Renders hugeicons DragLeft04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragLeft04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragRight01Icon
 * @description Renders hugeicons DragRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragRight02Icon
 * @description Renders hugeicons DragRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragRight03Icon
 * @description Renders hugeicons DragRight03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragRight03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DragRight04Icon
 * @description Renders hugeicons DragRight04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DragRight04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DrawingCompassIcon
 * @description Renders hugeicons DrawingCompassIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DrawingCompassIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DrawingModeIcon
 * @description Renders hugeicons DrawingModeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DrawingModeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dress01Icon
 * @description Renders hugeicons Dress01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dress01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dress02Icon
 * @description Renders hugeicons Dress02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dress02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dress03Icon
 * @description Renders hugeicons Dress03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dress03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dress04Icon
 * @description Renders hugeicons Dress04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dress04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dress05Icon
 * @description Renders hugeicons Dress05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dress05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dress06Icon
 * @description Renders hugeicons Dress06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dress06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dress07Icon
 * @description Renders hugeicons Dress07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dress07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DressingTable01Icon
 * @description Renders hugeicons DressingTable01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DressingTable01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DressingTable02Icon
 * @description Renders hugeicons DressingTable02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DressingTable02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DressingTable03Icon
 * @description Renders hugeicons DressingTable03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DressingTable03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DribbbleIcon
 * @description Renders hugeicons DribbbleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DribbbleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DrinkIcon
 * @description Renders hugeicons DrinkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DrinkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DroneIcon
 * @description Renders hugeicons DroneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DroneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DroolingIcon
 * @description Renders hugeicons DroolingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DroolingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DropboxIcon
 * @description Renders hugeicons DropboxIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DropboxIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DropletIcon
 * @description Renders hugeicons DropletIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DropletIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DropperIcon
 * @description Renders hugeicons DropperIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DropperIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Ds3ToolIcon
 * @description Renders hugeicons Ds3ToolIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Ds3ToolIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name DuaIcon
 * @description Renders hugeicons DuaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const DuaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dumbbell01Icon
 * @description Renders hugeicons Dumbbell01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dumbbell01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dumbbell02Icon
 * @description Renders hugeicons Dumbbell02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dumbbell02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Dumbbell03Icon
 * @description Renders hugeicons Dumbbell03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Dumbbell03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EarIcon
 * @description Renders hugeicons EarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EarRings01Icon
 * @description Renders hugeicons EarRings01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EarRings01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EarRings02Icon
 * @description Renders hugeicons EarRings02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EarRings02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EarRings03Icon
 * @description Renders hugeicons EarRings03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EarRings03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EarthIcon
 * @description Renders hugeicons EarthIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EarthIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EaseCurveControlPointsIcon
 * @description Renders hugeicons EaseCurveControlPointsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EaseCurveControlPointsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EaseInIcon
 * @description Renders hugeicons EaseInIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EaseInIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EaseInControlPointIcon
 * @description Renders hugeicons EaseInControlPointIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EaseInControlPointIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EaseInOutIcon
 * @description Renders hugeicons EaseInOutIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EaseInOutIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EaseOutIcon
 * @description Renders hugeicons EaseOutIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EaseOutIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EaseOutControlPointIcon
 * @description Renders hugeicons EaseOutControlPointIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EaseOutControlPointIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EcoEnergyIcon
 * @description Renders hugeicons EcoEnergyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EcoEnergyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EcoPowerIcon
 * @description Renders hugeicons EcoPowerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EcoPowerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EdgeStyleIcon
 * @description Renders hugeicons EdgeStyleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EdgeStyleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Edit01Icon
 * @description Renders hugeicons Edit01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Edit01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Edit02Icon
 * @description Renders hugeicons Edit02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Edit02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EditOffIcon
 * @description Renders hugeicons EditOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EditOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EditRoadIcon
 * @description Renders hugeicons EditRoadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EditRoadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EditUser02Icon
 * @description Renders hugeicons EditUser02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EditUser02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EggsIcon
 * @description Renders hugeicons EggsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EggsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EidMubarakIcon
 * @description Renders hugeicons EidMubarakIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EidMubarakIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EiffelTowerIcon
 * @description Renders hugeicons EiffelTowerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EiffelTowerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ElearningExchangeIcon
 * @description Renders hugeicons ElearningExchangeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ElearningExchangeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ElectricHome01Icon
 * @description Renders hugeicons ElectricHome01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ElectricHome01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ElectricHome02Icon
 * @description Renders hugeicons ElectricHome02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ElectricHome02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ElectricPlugsIcon
 * @description Renders hugeicons ElectricPlugsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ElectricPlugsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ElectricTower01Icon
 * @description Renders hugeicons ElectricTower01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ElectricTower01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ElectricTower02Icon
 * @description Renders hugeicons ElectricTower02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ElectricTower02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ElectricWireIcon
 * @description Renders hugeicons ElectricWireIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ElectricWireIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EllipseSelectionIcon
 * @description Renders hugeicons EllipseSelectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EllipseSelectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EnergyIcon
 * @description Renders hugeicons EnergyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EnergyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EnergyEllipseIcon
 * @description Renders hugeicons EnergyEllipseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EnergyEllipseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EnergyRectangleIcon
 * @description Renders hugeicons EnergyRectangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EnergyRectangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EnteringGeoFenceIcon
 * @description Renders hugeicons EnteringGeoFenceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EnteringGeoFenceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EnvatoIcon
 * @description Renders hugeicons EnvatoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EnvatoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EqualSignIcon
 * @description Renders hugeicons EqualSignIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EqualSignIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EqualSignCircleIcon
 * @description Renders hugeicons EqualSignCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EqualSignCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EqualSignSquareIcon
 * @description Renders hugeicons EqualSignSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EqualSignSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EquipmentBenchPressIcon
 * @description Renders hugeicons EquipmentBenchPressIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EquipmentBenchPressIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EquipmentChestPressIcon
 * @description Renders hugeicons EquipmentChestPressIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EquipmentChestPressIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EquipmentGym01Icon
 * @description Renders hugeicons EquipmentGym01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EquipmentGym01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EquipmentGym02Icon
 * @description Renders hugeicons EquipmentGym02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EquipmentGym02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EquipmentGym03Icon
 * @description Renders hugeicons EquipmentGym03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EquipmentGym03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EquipmentWeightliftingIcon
 * @description Renders hugeicons EquipmentWeightliftingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EquipmentWeightliftingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Eraser01Icon
 * @description Renders hugeicons Eraser01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Eraser01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EraserAddIcon
 * @description Renders hugeicons EraserAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EraserAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EraserAutoIcon
 * @description Renders hugeicons EraserAutoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EraserAutoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EraserIcon
 * @description Renders hugeicons EraserIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EraserIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Estimate01Icon
 * @description Renders hugeicons Estimate01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Estimate01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Estimate02Icon
 * @description Renders hugeicons Estimate02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Estimate02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EthereumIcon
 * @description Renders hugeicons EthereumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EthereumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EthereumEllipseIcon
 * @description Renders hugeicons EthereumEllipseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EthereumEllipseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EthereumRectangleIcon
 * @description Renders hugeicons EthereumRectangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EthereumRectangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EuroIcon
 * @description Renders hugeicons EuroIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EuroIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EuroCircleIcon
 * @description Renders hugeicons EuroCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EuroCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EuroReceiveIcon
 * @description Renders hugeicons EuroReceiveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EuroReceiveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EuroSendIcon
 * @description Renders hugeicons EuroSendIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EuroSendIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EuroSquareIcon
 * @description Renders hugeicons EuroSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EuroSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EvChargingIcon
 * @description Renders hugeicons EvChargingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EvChargingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EvilIcon
 * @description Renders hugeicons EvilIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EvilIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Exchange01Icon
 * @description Renders hugeicons Exchange01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Exchange01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Exchange02Icon
 * @description Renders hugeicons Exchange02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Exchange02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Exchange03Icon
 * @description Renders hugeicons Exchange03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Exchange03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ExpanderIcon
 * @description Renders hugeicons ExpanderIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ExpanderIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ExternalDriveIcon
 * @description Renders hugeicons ExternalDriveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ExternalDriveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name EyeIcon
 * @description Renders hugeicons EyeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const EyeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Facebook01Icon
 * @description Renders hugeicons Facebook01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Facebook01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Facebook02Icon
 * @description Renders hugeicons Facebook02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Facebook02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Factory01Icon
 * @description Renders hugeicons Factory01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Factory01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Factory02Icon
 * @description Renders hugeicons Factory02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Factory02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FactoryIcon
 * @description Renders hugeicons FactoryIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FactoryIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FahrenheitIcon
 * @description Renders hugeicons FahrenheitIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FahrenheitIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FallingStarIcon
 * @description Renders hugeicons FallingStarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FallingStarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FastWindIcon
 * @description Renders hugeicons FastWindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FastWindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FavouriteIcon
 * @description Renders hugeicons FavouriteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FavouriteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FavouriteCircleIcon
 * @description Renders hugeicons FavouriteCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FavouriteCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FavouriteSquareIcon
 * @description Renders hugeicons FavouriteSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FavouriteSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FencingIcon
 * @description Renders hugeicons FencingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FencingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FencingMaskIcon
 * @description Renders hugeicons FencingMaskIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FencingMaskIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FerrisWheelIcon
 * @description Renders hugeicons FerrisWheelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FerrisWheelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FerryBoatIcon
 * @description Renders hugeicons FerryBoatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FerryBoatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FigmaIcon
 * @description Renders hugeicons FigmaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FigmaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name File01Icon
 * @description Renders hugeicons File01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const File01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name File02Icon
 * @description Renders hugeicons File02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const File02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileAddIcon
 * @description Renders hugeicons FileAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileAttachmentIcon
 * @description Renders hugeicons FileAttachmentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileAttachmentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileAudioIcon
 * @description Renders hugeicons FileAudioIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileAudioIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileBitcoinIcon
 * @description Renders hugeicons FileBitcoinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileBitcoinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileBlockIcon
 * @description Renders hugeicons FileBlockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileBlockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileBookmarkIcon
 * @description Renders hugeicons FileBookmarkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileBookmarkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileCloudIcon
 * @description Renders hugeicons FileCloudIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileCloudIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileCorruptIcon
 * @description Renders hugeicons FileCorruptIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileCorruptIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileDollarIcon
 * @description Renders hugeicons FileDollarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileDollarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileDownloadIcon
 * @description Renders hugeicons FileDownloadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileDownloadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileEditIcon
 * @description Renders hugeicons FileEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileEuroIcon
 * @description Renders hugeicons FileEuroIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileEuroIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileExportIcon
 * @description Renders hugeicons FileExportIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileExportIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileFavouriteIcon
 * @description Renders hugeicons FileFavouriteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileFavouriteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileImportIcon
 * @description Renders hugeicons FileImportIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileImportIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileLinkIcon
 * @description Renders hugeicons FileLinkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileLinkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileLockedIcon
 * @description Renders hugeicons FileLockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileLockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileManagementIcon
 * @description Renders hugeicons FileManagementIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileManagementIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileMinusIcon
 * @description Renders hugeicons FileMinusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileMinusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileMusicIcon
 * @description Renders hugeicons FileMusicIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileMusicIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileNotFoundIcon
 * @description Renders hugeicons FileNotFoundIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileNotFoundIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilePasteIcon
 * @description Renders hugeicons FilePasteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilePasteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilePinIcon
 * @description Renders hugeicons FilePinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilePinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilePoundIcon
 * @description Renders hugeicons FilePoundIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilePoundIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileRemoveIcon
 * @description Renders hugeicons FileRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileScriptIcon
 * @description Renders hugeicons FileScriptIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileScriptIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileSearchIcon
 * @description Renders hugeicons FileSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileSecurityIcon
 * @description Renders hugeicons FileSecurityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileSecurityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileShredderIcon
 * @description Renders hugeicons FileShredderIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileShredderIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileStarIcon
 * @description Renders hugeicons FileStarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileStarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileSyncIcon
 * @description Renders hugeicons FileSyncIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileSyncIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileUnknownIcon
 * @description Renders hugeicons FileUnknownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileUnknownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileUnlockedIcon
 * @description Renders hugeicons FileUnlockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileUnlockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileUploadIcon
 * @description Renders hugeicons FileUploadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileUploadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileValidationIcon
 * @description Renders hugeicons FileValidationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileValidationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileVerifiedIcon
 * @description Renders hugeicons FileVerifiedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileVerifiedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileVideoIcon
 * @description Renders hugeicons FileVideoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileVideoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileViewIcon
 * @description Renders hugeicons FileViewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileViewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileYenIcon
 * @description Renders hugeicons FileYenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileYenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FileZipIcon
 * @description Renders hugeicons FileZipIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FileZipIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Film01Icon
 * @description Renders hugeicons Film01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Film01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Film02Icon
 * @description Renders hugeicons Film02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Film02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilmRoll01Icon
 * @description Renders hugeicons FilmRoll01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilmRoll01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilmRoll02Icon
 * @description Renders hugeicons FilmRoll02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilmRoll02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterAddIcon
 * @description Renders hugeicons FilterAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterIcon
 * @description Renders hugeicons FilterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterEditIcon
 * @description Renders hugeicons FilterEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterHorizontalIcon
 * @description Renders hugeicons FilterHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterMailCircleIcon
 * @description Renders hugeicons FilterMailCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterMailCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterMailSquareIcon
 * @description Renders hugeicons FilterMailSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterMailSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterRemoveIcon
 * @description Renders hugeicons FilterRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterResetIcon
 * @description Renders hugeicons FilterResetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterResetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FilterVerticalIcon
 * @description Renders hugeicons FilterVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FilterVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FingerPrintAddIcon
 * @description Renders hugeicons FingerPrintAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FingerPrintAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FingerPrintIcon
 * @description Renders hugeicons FingerPrintIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FingerPrintIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FingerPrintCheckIcon
 * @description Renders hugeicons FingerPrintCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FingerPrintCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FingerPrintMinusIcon
 * @description Renders hugeicons FingerPrintMinusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FingerPrintMinusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FingerPrintRemoveIcon
 * @description Renders hugeicons FingerPrintRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FingerPrintRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FingerPrintScanIcon
 * @description Renders hugeicons FingerPrintScanIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FingerPrintScanIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FinsIcon
 * @description Renders hugeicons FinsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FinsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FireIcon
 * @description Renders hugeicons FireIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FireIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirePitIcon
 * @description Renders hugeicons FirePitIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirePitIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FireSecurityIcon
 * @description Renders hugeicons FireSecurityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FireSecurityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirewallIcon
 * @description Renders hugeicons FirewallIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirewallIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FirstAidKitIcon
 * @description Renders hugeicons FirstAidKitIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FirstAidKitIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FishFoodIcon
 * @description Renders hugeicons FishFoodIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FishFoodIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FiverrIcon
 * @description Renders hugeicons FiverrIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FiverrIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Flag01Icon
 * @description Renders hugeicons Flag01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Flag01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Flag02Icon
 * @description Renders hugeicons Flag02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Flag02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Flag03Icon
 * @description Renders hugeicons Flag03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Flag03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlashIcon
 * @description Renders hugeicons FlashIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlashIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlashOffIcon
 * @description Renders hugeicons FlashOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlashOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlaticonIcon
 * @description Renders hugeicons FlaticonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlaticonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlickrIcon
 * @description Renders hugeicons FlickrIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlickrIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlimSlateIcon
 * @description Renders hugeicons FlimSlateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlimSlateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlipBottomIcon
 * @description Renders hugeicons FlipBottomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlipBottomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlipHorizontalIcon
 * @description Renders hugeicons FlipHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlipHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlipLeftIcon
 * @description Renders hugeicons FlipLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlipLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlipPhoneIcon
 * @description Renders hugeicons FlipPhoneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlipPhoneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlipRightIcon
 * @description Renders hugeicons FlipRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlipRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlipTopIcon
 * @description Renders hugeicons FlipTopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlipTopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlipVerticalIcon
 * @description Renders hugeicons FlipVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlipVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FloorPlanIcon
 * @description Renders hugeicons FloorPlanIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FloorPlanIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FloppyDiskIcon
 * @description Renders hugeicons FloppyDiskIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FloppyDiskIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlowIcon
 * @description Renders hugeicons FlowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlowCircleIcon
 * @description Renders hugeicons FlowCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlowCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlowConnectionIcon
 * @description Renders hugeicons FlowConnectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlowConnectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlowSquareIcon
 * @description Renders hugeicons FlowSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlowSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Flowchart01Icon
 * @description Renders hugeicons Flowchart01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Flowchart01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Flowchart02Icon
 * @description Renders hugeicons Flowchart02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Flowchart02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlowerPotIcon
 * @description Renders hugeicons FlowerPotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlowerPotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FlushedIcon
 * @description Renders hugeicons FlushedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FlushedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FocusPointIcon
 * @description Renders hugeicons FocusPointIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FocusPointIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Folder01Icon
 * @description Renders hugeicons Folder01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Folder01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Folder02Icon
 * @description Renders hugeicons Folder02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Folder02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Folder03Icon
 * @description Renders hugeicons Folder03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Folder03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderAddIcon
 * @description Renders hugeicons FolderAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderAttachmentIcon
 * @description Renders hugeicons FolderAttachmentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderAttachmentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderAudioIcon
 * @description Renders hugeicons FolderAudioIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderAudioIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderBlockIcon
 * @description Renders hugeicons FolderBlockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderBlockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderCheckIcon
 * @description Renders hugeicons FolderCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderCloudIcon
 * @description Renders hugeicons FolderCloudIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderCloudIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderDetailsIcon
 * @description Renders hugeicons FolderDetailsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderDetailsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderDetailsReferenceIcon
 * @description Renders hugeicons FolderDetailsReferenceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderDetailsReferenceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderDownloadIcon
 * @description Renders hugeicons FolderDownloadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderDownloadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderEditIcon
 * @description Renders hugeicons FolderEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderFavouriteIcon
 * @description Renders hugeicons FolderFavouriteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderFavouriteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderFileStorageIcon
 * @description Renders hugeicons FolderFileStorageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderFileStorageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderLibraryIcon
 * @description Renders hugeicons FolderLibraryIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderLibraryIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderLinksIcon
 * @description Renders hugeicons FolderLinksIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderLinksIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderLockedIcon
 * @description Renders hugeicons FolderLockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderLockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderManagementIcon
 * @description Renders hugeicons FolderManagementIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderManagementIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderMinusIcon
 * @description Renders hugeicons FolderMinusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderMinusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderMoveInIcon
 * @description Renders hugeicons FolderMoveInIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderMoveInIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderMoveToIcon
 * @description Renders hugeicons FolderMoveToIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderMoveToIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderMusicIcon
 * @description Renders hugeicons FolderMusicIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderMusicIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderOffIcon
 * @description Renders hugeicons FolderOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderOpenIcon
 * @description Renders hugeicons FolderOpenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderOpenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderPinIcon
 * @description Renders hugeicons FolderPinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderPinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderRemoveIcon
 * @description Renders hugeicons FolderRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderSearchIcon
 * @description Renders hugeicons FolderSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderSecurityIcon
 * @description Renders hugeicons FolderSecurityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderSecurityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderShared01Icon
 * @description Renders hugeicons FolderShared01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderShared01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderShared02Icon
 * @description Renders hugeicons FolderShared02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderShared02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderShared03Icon
 * @description Renders hugeicons FolderShared03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderShared03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderSyncIcon
 * @description Renders hugeicons FolderSyncIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderSyncIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderTransferIcon
 * @description Renders hugeicons FolderTransferIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderTransferIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderUnknownIcon
 * @description Renders hugeicons FolderUnknownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderUnknownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderUnlockedIcon
 * @description Renders hugeicons FolderUnlockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderUnlockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderUploadIcon
 * @description Renders hugeicons FolderUploadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderUploadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderVideoIcon
 * @description Renders hugeicons FolderVideoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderVideoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderViewIcon
 * @description Renders hugeicons FolderViewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderViewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FolderZipIcon
 * @description Renders hugeicons FolderZipIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FolderZipIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FoldersIcon
 * @description Renders hugeicons FoldersIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FoldersIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FootballIcon
 * @description Renders hugeicons FootballIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FootballIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FootballPitchIcon
 * @description Renders hugeicons FootballPitchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FootballPitchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ForkIcon
 * @description Renders hugeicons ForkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ForkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ForrstIcon
 * @description Renders hugeicons ForrstIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ForrstIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FortressIcon
 * @description Renders hugeicons FortressIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FortressIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Forward01Icon
 * @description Renders hugeicons Forward01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Forward01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Forward02Icon
 * @description Renders hugeicons Forward02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Forward02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FourFinger02Icon
 * @description Renders hugeicons FourFinger02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FourFinger02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FourFinger03Icon
 * @description Renders hugeicons FourFinger03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FourFinger03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FoursquareIcon
 * @description Renders hugeicons FoursquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FoursquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FramerIcon
 * @description Renders hugeicons FramerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FramerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FrenchFries01Icon
 * @description Renders hugeicons FrenchFries01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FrenchFries01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FrenchFries02Icon
 * @description Renders hugeicons FrenchFries02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FrenchFries02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FridgeIcon
 * @description Renders hugeicons FridgeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FridgeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FryIcon
 * @description Renders hugeicons FryIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FryIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Fuel02Icon
 * @description Renders hugeicons Fuel02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Fuel02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FuelIcon
 * @description Renders hugeicons FuelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FuelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FuelStationIcon
 * @description Renders hugeicons FuelStationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FuelStationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FunctionIcon
 * @description Renders hugeicons FunctionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FunctionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FunctionCircleIcon
 * @description Renders hugeicons FunctionCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FunctionCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FunctionOfXIcon
 * @description Renders hugeicons FunctionOfXIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FunctionOfXIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name FunctionSquareIcon
 * @description Renders hugeicons FunctionSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const FunctionSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GalaxyIcon
 * @description Renders hugeicons GalaxyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GalaxyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GameIcon
 * @description Renders hugeicons GameIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GameIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GameController01Icon
 * @description Renders hugeicons GameController01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GameController01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GameController02Icon
 * @description Renders hugeicons GameController02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GameController02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GameController03Icon
 * @description Renders hugeicons GameController03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GameController03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GameboyIcon
 * @description Renders hugeicons GameboyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GameboyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GarageIcon
 * @description Renders hugeicons GarageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GarageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GarbageTruckIcon
 * @description Renders hugeicons GarbageTruckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GarbageTruckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GasPipeIcon
 * @description Renders hugeicons GasPipeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GasPipeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GasStoveIcon
 * @description Renders hugeicons GasStoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GasStoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GemIcon
 * @description Renders hugeicons GemIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GemIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GeologyCrustIcon
 * @description Renders hugeicons GeologyCrustIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GeologyCrustIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GeometricShapes01Icon
 * @description Renders hugeicons GeometricShapes01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GeometricShapes01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GeometricShapes02Icon
 * @description Renders hugeicons GeometricShapes02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GeometricShapes02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GibbousMoonIcon
 * @description Renders hugeicons GibbousMoonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GibbousMoonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Gif01Icon
 * @description Renders hugeicons Gif01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Gif01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Gif02Icon
 * @description Renders hugeicons Gif02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Gif02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GiftIcon
 * @description Renders hugeicons GiftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GiftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GiftCardIcon
 * @description Renders hugeicons GiftCardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GiftCardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitBranchIcon
 * @description Renders hugeicons GitBranchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitBranchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitCommitIcon
 * @description Renders hugeicons GitCommitIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitCommitIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitCompareIcon
 * @description Renders hugeicons GitCompareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitCompareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitForkIcon
 * @description Renders hugeicons GitForkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitForkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitMergeIcon
 * @description Renders hugeicons GitMergeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitMergeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitPullRequestIcon
 * @description Renders hugeicons GitPullRequestIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitPullRequestIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitPullRequestClosedIcon
 * @description Renders hugeicons GitPullRequestClosedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitPullRequestClosedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitPullRequestDraftIcon
 * @description Renders hugeicons GitPullRequestDraftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitPullRequestDraftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Github01Icon
 * @description Renders hugeicons Github01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Github01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GithubIcon
 * @description Renders hugeicons GithubIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GithubIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GitlabIcon
 * @description Renders hugeicons GitlabIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GitlabIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GiveBloodIcon
 * @description Renders hugeicons GiveBloodIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GiveBloodIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GivePillIcon
 * @description Renders hugeicons GivePillIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GivePillIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GlassesIcon
 * @description Renders hugeicons GlassesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GlassesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GlobalIcon
 * @description Renders hugeicons GlobalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GlobalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GlobalEditingIcon
 * @description Renders hugeicons GlobalEditingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GlobalEditingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GlobalEducationIcon
 * @description Renders hugeicons GlobalEducationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GlobalEducationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GlobalRefreshIcon
 * @description Renders hugeicons GlobalRefreshIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GlobalRefreshIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GlobalSearchIcon
 * @description Renders hugeicons GlobalSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GlobalSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Globe02Icon
 * @description Renders hugeicons Globe02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Globe02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GlobeIcon
 * @description Renders hugeicons GlobeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GlobeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GloveIcon
 * @description Renders hugeicons GloveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GloveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoBackward10SecIcon
 * @description Renders hugeicons GoBackward10SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoBackward10SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoBackward15SecIcon
 * @description Renders hugeicons GoBackward15SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoBackward15SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoBackward30SecIcon
 * @description Renders hugeicons GoBackward30SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoBackward30SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoBackward5SecIcon
 * @description Renders hugeicons GoBackward5SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoBackward5SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoBackward60SecIcon
 * @description Renders hugeicons GoBackward60SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoBackward60SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoForward10SecIcon
 * @description Renders hugeicons GoForward10SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoForward10SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoForward15SecIcon
 * @description Renders hugeicons GoForward15SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoForward15SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoForward30SecIcon
 * @description Renders hugeicons GoForward30SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoForward30SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoForward5SecIcon
 * @description Renders hugeicons GoForward5SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoForward5SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoForward60SecIcon
 * @description Renders hugeicons GoForward60SecIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoForward60SecIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoldIcon
 * @description Renders hugeicons GoldIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoldIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoldIngotsIcon
 * @description Renders hugeicons GoldIngotsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoldIngotsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GolfBallIcon
 * @description Renders hugeicons GolfBallIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GolfBallIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GolfBatIcon
 * @description Renders hugeicons GolfBatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GolfBatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GolfCartIcon
 * @description Renders hugeicons GolfCartIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GolfCartIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GolfHoleIcon
 * @description Renders hugeicons GolfHoleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GolfHoleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoogleIcon
 * @description Renders hugeicons GoogleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoogleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoogleDocIcon
 * @description Renders hugeicons GoogleDocIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoogleDocIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoogleDriveIcon
 * @description Renders hugeicons GoogleDriveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoogleDriveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoogleHomeIcon
 * @description Renders hugeicons GoogleHomeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoogleHomeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoogleMapsIcon
 * @description Renders hugeicons GoogleMapsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoogleMapsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GoogleSheetIcon
 * @description Renders hugeicons GoogleSheetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GoogleSheetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Gps01Icon
 * @description Renders hugeicons Gps01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Gps01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Gps02Icon
 * @description Renders hugeicons Gps02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Gps02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GpsDisconnectedIcon
 * @description Renders hugeicons GpsDisconnectedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GpsDisconnectedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GpsOff01Icon
 * @description Renders hugeicons GpsOff01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GpsOff01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GpsOff02Icon
 * @description Renders hugeicons GpsOff02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GpsOff02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GpsSignal01Icon
 * @description Renders hugeicons GpsSignal01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GpsSignal01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GpsSignal02Icon
 * @description Renders hugeicons GpsSignal02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GpsSignal02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GraduateFemaleIcon
 * @description Renders hugeicons GraduateFemaleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GraduateFemaleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GraduateMaleIcon
 * @description Renders hugeicons GraduateMaleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GraduateMaleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GraduationScrollIcon
 * @description Renders hugeicons GraduationScrollIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GraduationScrollIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GrapesIcon
 * @description Renders hugeicons GrapesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GrapesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GravityIcon
 * @description Renders hugeicons GravityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GravityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GreaterThanIcon
 * @description Renders hugeicons GreaterThanIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GreaterThanIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GreaterThanCircleIcon
 * @description Renders hugeicons GreaterThanCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GreaterThanCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GreaterThanSquareIcon
 * @description Renders hugeicons GreaterThanSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GreaterThanSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GreekHelmetIcon
 * @description Renders hugeicons GreekHelmetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GreekHelmetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GreenHouseIcon
 * @description Renders hugeicons GreenHouseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GreenHouseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GridIcon
 * @description Renders hugeicons GridIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GridIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GridOffIcon
 * @description Renders hugeicons GridOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GridOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GridTableIcon
 * @description Renders hugeicons GridTableIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GridTableIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GridViewIcon
 * @description Renders hugeicons GridViewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GridViewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GrimacingIcon
 * @description Renders hugeicons GrimacingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GrimacingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GrinningIcon
 * @description Renders hugeicons GrinningIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GrinningIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GrokIcon
 * @description Renders hugeicons GrokIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GrokIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GroupItemsIcon
 * @description Renders hugeicons GroupItemsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GroupItemsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GroupLayersIcon
 * @description Renders hugeicons GroupLayersIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GroupLayersIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GuestHouseIcon
 * @description Renders hugeicons GuestHouseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GuestHouseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GunIcon
 * @description Renders hugeicons GunIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GunIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GymnasticIcon
 * @description Renders hugeicons GymnasticIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GymnasticIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name GymnasticRingsIcon
 * @description Renders hugeicons GymnasticRingsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const GymnasticRingsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HairClipsIcon
 * @description Renders hugeicons HairClipsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HairClipsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HairDryerIcon
 * @description Renders hugeicons HairDryerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HairDryerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HajiIcon
 * @description Renders hugeicons HajiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HajiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HalalIcon
 * @description Renders hugeicons HalalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HalalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hamburger01Icon
 * @description Renders hugeicons Hamburger01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hamburger01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hamburger02Icon
 * @description Renders hugeicons Hamburger02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hamburger02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandBag01Icon
 * @description Renders hugeicons HandBag01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandBag01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandBag02Icon
 * @description Renders hugeicons HandBag02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandBag02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandBeaterIcon
 * @description Renders hugeicons HandBeaterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandBeaterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandGripIcon
 * @description Renders hugeicons HandGripIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandGripIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingDown01Icon
 * @description Renders hugeicons HandPointingDown01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingDown01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingDown02Icon
 * @description Renders hugeicons HandPointingDown02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingDown02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingDown03Icon
 * @description Renders hugeicons HandPointingDown03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingDown03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingDown04Icon
 * @description Renders hugeicons HandPointingDown04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingDown04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingLeft01Icon
 * @description Renders hugeicons HandPointingLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingLeft02Icon
 * @description Renders hugeicons HandPointingLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingLeft03Icon
 * @description Renders hugeicons HandPointingLeft03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingLeft03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingLeft04Icon
 * @description Renders hugeicons HandPointingLeft04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingLeft04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingRight01Icon
 * @description Renders hugeicons HandPointingRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingRight02Icon
 * @description Renders hugeicons HandPointingRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingRight03Icon
 * @description Renders hugeicons HandPointingRight03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingRight03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPointingRight04Icon
 * @description Renders hugeicons HandPointingRight04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPointingRight04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandPrayerIcon
 * @description Renders hugeicons HandPrayerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandPrayerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandSanitizerIcon
 * @description Renders hugeicons HandSanitizerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandSanitizerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HandcuffsIcon
 * @description Renders hugeicons HandcuffsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HandcuffsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HangerIcon
 * @description Renders hugeicons HangerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HangerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HangingClockIcon
 * @description Renders hugeicons HangingClockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HangingClockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HangoutIcon
 * @description Renders hugeicons HangoutIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HangoutIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HappyIcon
 * @description Renders hugeicons HappyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HappyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HardDriveIcon
 * @description Renders hugeicons HardDriveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HardDriveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HddIcon
 * @description Renders hugeicons HddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hdr01Icon
 * @description Renders hugeicons Hdr01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hdr01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hdr02Icon
 * @description Renders hugeicons Hdr02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hdr02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Heading01Icon
 * @description Renders hugeicons Heading01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Heading01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Heading02Icon
 * @description Renders hugeicons Heading02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Heading02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Heading03Icon
 * @description Renders hugeicons Heading03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Heading03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Heading04Icon
 * @description Renders hugeicons Heading04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Heading04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Heading05Icon
 * @description Renders hugeicons Heading05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Heading05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Heading06Icon
 * @description Renders hugeicons Heading06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Heading06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeadingIcon
 * @description Renders hugeicons HeadingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeadingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeadphoneMuteIcon
 * @description Renders hugeicons HeadphoneMuteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeadphoneMuteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeadphonesIcon
 * @description Renders hugeicons HeadphonesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeadphonesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeadsetIcon
 * @description Renders hugeicons HeadsetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeadsetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeadsetConnectedIcon
 * @description Renders hugeicons HeadsetConnectedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeadsetConnectedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeadsetOffIcon
 * @description Renders hugeicons HeadsetOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeadsetOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HealtcareIcon
 * @description Renders hugeicons HealtcareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HealtcareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HealthIcon
 * @description Renders hugeicons HealthIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HealthIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeartAddIcon
 * @description Renders hugeicons HeartAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeartAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeartCheckIcon
 * @description Renders hugeicons HeartCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeartCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeartRemoveIcon
 * @description Renders hugeicons HeartRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeartRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HeartbreakIcon
 * @description Renders hugeicons HeartbreakIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HeartbreakIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HelicopterIcon
 * @description Renders hugeicons HelicopterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HelicopterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HelpCircleIcon
 * @description Renders hugeicons HelpCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HelpCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HelpSquareIcon
 * @description Renders hugeicons HelpSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HelpSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hexagon01Icon
 * @description Renders hugeicons Hexagon01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hexagon01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HexagonIcon
 * @description Renders hugeicons HexagonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HexagonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchyIcon
 * @description Renders hugeicons HierarchyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchyCircle01Icon
 * @description Renders hugeicons HierarchyCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchyCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchyCircle02Icon
 * @description Renders hugeicons HierarchyCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchyCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchyCircle03Icon
 * @description Renders hugeicons HierarchyCircle03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchyCircle03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchyFilesIcon
 * @description Renders hugeicons HierarchyFilesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchyFilesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare01Icon
 * @description Renders hugeicons HierarchySquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare02Icon
 * @description Renders hugeicons HierarchySquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare03Icon
 * @description Renders hugeicons HierarchySquare03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare04Icon
 * @description Renders hugeicons HierarchySquare04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare05Icon
 * @description Renders hugeicons HierarchySquare05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare06Icon
 * @description Renders hugeicons HierarchySquare06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare07Icon
 * @description Renders hugeicons HierarchySquare07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare08Icon
 * @description Renders hugeicons HierarchySquare08Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare08Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HierarchySquare10Icon
 * @description Renders hugeicons HierarchySquare10Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HierarchySquare10Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HighHeels01Icon
 * @description Renders hugeicons HighHeels01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HighHeels01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HighHeels02Icon
 * @description Renders hugeicons HighHeels02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HighHeels02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HijabIcon
 * @description Renders hugeicons HijabIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HijabIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HockeyIcon
 * @description Renders hugeicons HockeyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HockeyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hold01Icon
 * @description Renders hugeicons Hold01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hold01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hold02Icon
 * @description Renders hugeicons Hold02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hold02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hold03Icon
 * @description Renders hugeicons Hold03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hold03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hold04Icon
 * @description Renders hugeicons Hold04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hold04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hold05Icon
 * @description Renders hugeicons Hold05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hold05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HoldLocked01Icon
 * @description Renders hugeicons HoldLocked01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HoldLocked01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HoldLocked02Icon
 * @description Renders hugeicons HoldLocked02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HoldLocked02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HoldPhoneIcon
 * @description Renders hugeicons HoldPhoneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HoldPhoneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HologramIcon
 * @description Renders hugeicons HologramIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HologramIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Home01Icon
 * @description Renders hugeicons Home01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Home01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Home02Icon
 * @description Renders hugeicons Home02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Home02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Home03Icon
 * @description Renders hugeicons Home03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Home03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Home04Icon
 * @description Renders hugeicons Home04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Home04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Home05Icon
 * @description Renders hugeicons Home05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Home05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Home06Icon
 * @description Renders hugeicons Home06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Home06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HomeWifiIcon
 * @description Renders hugeicons HomeWifiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HomeWifiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Honey01Icon
 * @description Renders hugeicons Honey01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Honey01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Honey02Icon
 * @description Renders hugeicons Honey02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Honey02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HonorIcon
 * @description Renders hugeicons HonorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HonorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HonourStarIcon
 * @description Renders hugeicons HonourStarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HonourStarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HoodieIcon
 * @description Renders hugeicons HoodieIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HoodieIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HorizonalScrollPointIcon
 * @description Renders hugeicons HorizonalScrollPointIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HorizonalScrollPointIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HorizontalResizeIcon
 * @description Renders hugeicons HorizontalResizeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HorizontalResizeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hospital01Icon
 * @description Renders hugeicons Hospital01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hospital01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hospital02Icon
 * @description Renders hugeicons Hospital02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hospital02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HospitalBed01Icon
 * @description Renders hugeicons HospitalBed01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HospitalBed01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HospitalBed02Icon
 * @description Renders hugeicons HospitalBed02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HospitalBed02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HospitalLocationIcon
 * @description Renders hugeicons HospitalLocationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HospitalLocationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HotAirBalloonIcon
 * @description Renders hugeicons HotAirBalloonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HotAirBalloonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HotPriceIcon
 * @description Renders hugeicons HotPriceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HotPriceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HotTubeIcon
 * @description Renders hugeicons HotTubeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HotTubeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HotdogIcon
 * @description Renders hugeicons HotdogIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HotdogIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hotel01Icon
 * @description Renders hugeicons Hotel01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hotel01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Hotel02Icon
 * @description Renders hugeicons Hotel02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Hotel02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HotspotIcon
 * @description Renders hugeicons HotspotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HotspotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HotspotOfflineIcon
 * @description Renders hugeicons HotspotOfflineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HotspotOfflineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HourglassIcon
 * @description Renders hugeicons HourglassIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HourglassIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HourglassOffIcon
 * @description Renders hugeicons HourglassOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HourglassOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name House01Icon
 * @description Renders hugeicons House01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const House01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name House02Icon
 * @description Renders hugeicons House02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const House02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name House03Icon
 * @description Renders hugeicons House03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const House03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name House04Icon
 * @description Renders hugeicons House04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const House04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name House05Icon
 * @description Renders hugeicons House05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const House05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HouseSolarPanelIcon
 * @description Renders hugeicons HouseSolarPanelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HouseSolarPanelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Html5Icon
 * @description Renders hugeicons Html5Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Html5Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HumidityIcon
 * @description Renders hugeicons HumidityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HumidityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HutIcon
 * @description Renders hugeicons HutIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HutIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HydroPowerIcon
 * @description Renders hugeicons HydroPowerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HydroPowerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name HyperboleIcon
 * @description Renders hugeicons HyperboleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const HyperboleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IceCream01Icon
 * @description Renders hugeicons IceCream01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IceCream01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IceCream02Icon
 * @description Renders hugeicons IceCream02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IceCream02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IceCream03Icon
 * @description Renders hugeicons IceCream03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IceCream03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IceCream04Icon
 * @description Renders hugeicons IceCream04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IceCream04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IceHockeyIcon
 * @description Renders hugeicons IceHockeyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IceHockeyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IceSkatingIcon
 * @description Renders hugeicons IceSkatingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IceSkatingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IcoIcon
 * @description Renders hugeicons IcoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IcoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IconjarIcon
 * @description Renders hugeicons IconjarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IconjarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IdIcon
 * @description Renders hugeicons IdIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IdIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IdNotVerifiedIcon
 * @description Renders hugeicons IdNotVerifiedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IdNotVerifiedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IdVerifiedIcon
 * @description Renders hugeicons IdVerifiedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IdVerifiedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Idea01Icon
 * @description Renders hugeicons Idea01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Idea01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IdeaIcon
 * @description Renders hugeicons IdeaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IdeaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IdentificationIcon
 * @description Renders hugeicons IdentificationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IdentificationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Image01Icon
 * @description Renders hugeicons Image01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Image01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Image02Icon
 * @description Renders hugeicons Image02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Image02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageAdd01Icon
 * @description Renders hugeicons ImageAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageAdd02Icon
 * @description Renders hugeicons ImageAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageCompositionIcon
 * @description Renders hugeicons ImageCompositionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageCompositionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageCompositionOvalIcon
 * @description Renders hugeicons ImageCompositionOvalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageCompositionOvalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageCropIcon
 * @description Renders hugeicons ImageCropIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageCropIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageDelete01Icon
 * @description Renders hugeicons ImageDelete01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageDelete01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageDelete02Icon
 * @description Renders hugeicons ImageDelete02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageDelete02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageDone01Icon
 * @description Renders hugeicons ImageDone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageDone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageDone02Icon
 * @description Renders hugeicons ImageDone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageDone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageDownload02Icon
 * @description Renders hugeicons ImageDownload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageDownload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageDownloadIcon
 * @description Renders hugeicons ImageDownloadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageDownloadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageNotFound01Icon
 * @description Renders hugeicons ImageNotFound01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageNotFound01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageNotFound02Icon
 * @description Renders hugeicons ImageNotFound02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageNotFound02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageRemove01Icon
 * @description Renders hugeicons ImageRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageRemove02Icon
 * @description Renders hugeicons ImageRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageUpload01Icon
 * @description Renders hugeicons ImageUpload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageUpload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImageUploadIcon
 * @description Renders hugeicons ImageUploadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImageUploadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImoIcon
 * @description Renders hugeicons ImoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ImportantBookIcon
 * @description Renders hugeicons ImportantBookIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ImportantBookIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InLoveIcon
 * @description Renders hugeicons InLoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InLoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InboxIcon
 * @description Renders hugeicons InboxIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InboxIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InboxCheckIcon
 * @description Renders hugeicons InboxCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InboxCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InboxDownloadIcon
 * @description Renders hugeicons InboxDownloadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InboxDownloadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InboxUnreadIcon
 * @description Renders hugeicons InboxUnreadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InboxUnreadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InboxUploadIcon
 * @description Renders hugeicons InboxUploadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InboxUploadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IncognitoIcon
 * @description Renders hugeicons IncognitoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IncognitoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IndiaGateIcon
 * @description Renders hugeicons IndiaGateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IndiaGateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Inequality01Icon
 * @description Renders hugeicons Inequality01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Inequality01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Inequality02Icon
 * @description Renders hugeicons Inequality02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Inequality02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InequalityCircle01Icon
 * @description Renders hugeicons InequalityCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InequalityCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InequalityCircle02Icon
 * @description Renders hugeicons InequalityCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InequalityCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InequalitySquare01Icon
 * @description Renders hugeicons InequalitySquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InequalitySquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InequalitySquare02Icon
 * @description Renders hugeicons InequalitySquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InequalitySquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Infinity01Icon
 * @description Renders hugeicons Infinity01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Infinity01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Infinity02Icon
 * @description Renders hugeicons Infinity02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Infinity02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InfinityCircleIcon
 * @description Renders hugeicons InfinityCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InfinityCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InfinitySquareIcon
 * @description Renders hugeicons InfinitySquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InfinitySquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InformationCircleIcon
 * @description Renders hugeicons InformationCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InformationCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InformationDiamondIcon
 * @description Renders hugeicons InformationDiamondIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InformationDiamondIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InformationSquareIcon
 * @description Renders hugeicons InformationSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InformationSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InjectionIcon
 * @description Renders hugeicons InjectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InjectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InsertBottomImageIcon
 * @description Renders hugeicons InsertBottomImageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InsertBottomImageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InsertCenterImageIcon
 * @description Renders hugeicons InsertCenterImageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InsertCenterImageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InsertPiIcon
 * @description Renders hugeicons InsertPiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InsertPiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InsertTopImageIcon
 * @description Renders hugeicons InsertTopImageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InsertTopImageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InspectCodeIcon
 * @description Renders hugeicons InspectCodeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InspectCodeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InstagramIcon
 * @description Renders hugeicons InstagramIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InstagramIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InstallingUpdates01Icon
 * @description Renders hugeicons InstallingUpdates01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InstallingUpdates01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InstallingUpdates02Icon
 * @description Renders hugeicons InstallingUpdates02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InstallingUpdates02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InternetAntenna01Icon
 * @description Renders hugeicons InternetAntenna01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InternetAntenna01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InternetAntenna02Icon
 * @description Renders hugeicons InternetAntenna02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InternetAntenna02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InternetAntenna03Icon
 * @description Renders hugeicons InternetAntenna03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InternetAntenna03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InternetAntenna04Icon
 * @description Renders hugeicons InternetAntenna04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InternetAntenna04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InternetIcon
 * @description Renders hugeicons InternetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InternetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InvestigationIcon
 * @description Renders hugeicons InvestigationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InvestigationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Invoice01Icon
 * @description Renders hugeicons Invoice01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Invoice01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Invoice02Icon
 * @description Renders hugeicons Invoice02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Invoice02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Invoice03Icon
 * @description Renders hugeicons Invoice03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Invoice03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Invoice04Icon
 * @description Renders hugeicons Invoice04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Invoice04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name InvoiceIcon
 * @description Renders hugeicons InvoiceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const InvoiceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IpodIcon
 * @description Renders hugeicons IpodIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IpodIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IrisScanIcon
 * @description Renders hugeicons IrisScanIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IrisScanIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name IslandIcon
 * @description Renders hugeicons IslandIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const IslandIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JarIcon
 * @description Renders hugeicons JarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JavaIcon
 * @description Renders hugeicons JavaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JavaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JavaScriptIcon
 * @description Renders hugeicons JavaScriptIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JavaScriptIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JobLinkIcon
 * @description Renders hugeicons JobLinkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JobLinkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JobSearchIcon
 * @description Renders hugeicons JobSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JobSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JobShareIcon
 * @description Renders hugeicons JobShareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JobShareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JoggerPantsIcon
 * @description Renders hugeicons JoggerPantsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JoggerPantsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JoinBevelIcon
 * @description Renders hugeicons JoinBevelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JoinBevelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JoinRoundIcon
 * @description Renders hugeicons JoinRoundIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JoinRoundIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JoinStraightIcon
 * @description Renders hugeicons JoinStraightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JoinStraightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JokerIcon
 * @description Renders hugeicons JokerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JokerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Joystick01Icon
 * @description Renders hugeicons Joystick01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Joystick01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Joystick02Icon
 * @description Renders hugeicons Joystick02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Joystick02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Joystick03Icon
 * @description Renders hugeicons Joystick03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Joystick03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Joystick04Icon
 * @description Renders hugeicons Joystick04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Joystick04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Joystick05Icon
 * @description Renders hugeicons Joystick05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Joystick05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Jpg01Icon
 * @description Renders hugeicons Jpg01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Jpg01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Jpg02Icon
 * @description Renders hugeicons Jpg02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Jpg02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Jsx01Icon
 * @description Renders hugeicons Jsx01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Jsx01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Jsx02Icon
 * @description Renders hugeicons Jsx02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Jsx02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Jsx03Icon
 * @description Renders hugeicons Jsx03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Jsx03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JudgeIcon
 * @description Renders hugeicons JudgeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JudgeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JupiterIcon
 * @description Renders hugeicons JupiterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JupiterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JusticeScale01Icon
 * @description Renders hugeicons JusticeScale01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JusticeScale01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name JusticeScale02Icon
 * @description Renders hugeicons JusticeScale02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const JusticeScale02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Kaaba01Icon
 * @description Renders hugeicons Kaaba01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Kaaba01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Kaaba02Icon
 * @description Renders hugeicons Kaaba02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Kaaba02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KayakIcon
 * @description Renders hugeicons KayakIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KayakIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeffiyehIcon
 * @description Renders hugeicons KeffiyehIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeffiyehIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Kettle01Icon
 * @description Renders hugeicons Kettle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Kettle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KettleIcon
 * @description Renders hugeicons KettleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KettleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KettlebellIcon
 * @description Renders hugeicons KettlebellIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KettlebellIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KetupatIcon
 * @description Renders hugeicons KetupatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KetupatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyboardIcon
 * @description Renders hugeicons KeyboardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyboardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeAddIcon
 * @description Renders hugeicons KeyframeAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeAlignCenterIcon
 * @description Renders hugeicons KeyframeAlignCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeAlignCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeAlignHorizontalIcon
 * @description Renders hugeicons KeyframeAlignHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeAlignHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeAlignVerticalIcon
 * @description Renders hugeicons KeyframeAlignVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeAlignVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeBottomIcon
 * @description Renders hugeicons KeyframeBottomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeBottomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeIcon
 * @description Renders hugeicons KeyframeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeLeftIcon
 * @description Renders hugeicons KeyframeLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeRemoveIcon
 * @description Renders hugeicons KeyframeRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeRightIcon
 * @description Renders hugeicons KeyframeRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframeTopIcon
 * @description Renders hugeicons KeyframeTopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframeTopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframesDoubleAddIcon
 * @description Renders hugeicons KeyframesDoubleAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframesDoubleAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframesDoubleIcon
 * @description Renders hugeicons KeyframesDoubleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframesDoubleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframesDoubleRemoveIcon
 * @description Renders hugeicons KeyframesDoubleRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframesDoubleRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframesMultipleAddIcon
 * @description Renders hugeicons KeyframesMultipleAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframesMultipleAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframesMultipleIcon
 * @description Renders hugeicons KeyframesMultipleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframesMultipleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KeyframesMultipleRemoveIcon
 * @description Renders hugeicons KeyframesMultipleRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KeyframesMultipleRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Kickstarter01Icon
 * @description Renders hugeicons Kickstarter01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Kickstarter01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Kickstarter02Icon
 * @description Renders hugeicons Kickstarter02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Kickstarter02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KidIcon
 * @description Renders hugeicons KidIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KidIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KidneysIcon
 * @description Renders hugeicons KidneysIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KidneysIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KissingIcon
 * @description Renders hugeicons KissingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KissingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KitchenUtensilsIcon
 * @description Renders hugeicons KitchenUtensilsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KitchenUtensilsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KiteIcon
 * @description Renders hugeicons KiteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KiteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Knife01Icon
 * @description Renders hugeicons Knife01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Knife01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Knife02Icon
 * @description Renders hugeicons Knife02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Knife02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KnifeBreadIcon
 * @description Renders hugeicons KnifeBreadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KnifeBreadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KnightShieldIcon
 * @description Renders hugeicons KnightShieldIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KnightShieldIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KnivesIcon
 * @description Renders hugeicons KnivesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KnivesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Knowledge01Icon
 * @description Renders hugeicons Knowledge01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Knowledge01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Knowledge02Icon
 * @description Renders hugeicons Knowledge02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Knowledge02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Kurta01Icon
 * @description Renders hugeicons Kurta01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Kurta01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name KurtaIcon
 * @description Renders hugeicons KurtaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const KurtaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LabelIcon
 * @description Renders hugeicons LabelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LabelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LabelImportantIcon
 * @description Renders hugeicons LabelImportantIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LabelImportantIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaborIcon
 * @description Renders hugeicons LaborIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaborIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LabsIcon
 * @description Renders hugeicons LabsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LabsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LakeIcon
 * @description Renders hugeicons LakeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LakeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Lamp01Icon
 * @description Renders hugeicons Lamp01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Lamp01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Lamp02Icon
 * @description Renders hugeicons Lamp02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Lamp02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Lamp03Icon
 * @description Renders hugeicons Lamp03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Lamp03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Lamp04Icon
 * @description Renders hugeicons Lamp04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Lamp04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Lamp05Icon
 * @description Renders hugeicons Lamp05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Lamp05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LampIcon
 * @description Renders hugeicons LampIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LampIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LanguageCircleIcon
 * @description Renders hugeicons LanguageCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LanguageCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LanguageSkillIcon
 * @description Renders hugeicons LanguageSkillIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LanguageSkillIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LanguageSquareIcon
 * @description Renders hugeicons LanguageSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LanguageSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LanternIcon
 * @description Renders hugeicons LanternIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LanternIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopAddIcon
 * @description Renders hugeicons LaptopAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopIcon
 * @description Renders hugeicons LaptopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopChargingIcon
 * @description Renders hugeicons LaptopChargingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopChargingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopCheckIcon
 * @description Renders hugeicons LaptopCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopCloudIcon
 * @description Renders hugeicons LaptopCloudIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopCloudIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopIssueIcon
 * @description Renders hugeicons LaptopIssueIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopIssueIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopPerformanceIcon
 * @description Renders hugeicons LaptopPerformanceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopPerformanceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopPhoneSyncIcon
 * @description Renders hugeicons LaptopPhoneSyncIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopPhoneSyncIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopProgrammingIcon
 * @description Renders hugeicons LaptopProgrammingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopProgrammingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopRemoveIcon
 * @description Renders hugeicons LaptopRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopSettingsIcon
 * @description Renders hugeicons LaptopSettingsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopSettingsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaptopVideoIcon
 * @description Renders hugeicons LaptopVideoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaptopVideoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LassoTool01Icon
 * @description Renders hugeicons LassoTool01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LassoTool01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LassoTool02Icon
 * @description Renders hugeicons LassoTool02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LassoTool02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LastFmIcon
 * @description Renders hugeicons LastFmIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LastFmIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LatitudeIcon
 * @description Renders hugeicons LatitudeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LatitudeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LaughingIcon
 * @description Renders hugeicons LaughingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LaughingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayerAddIcon
 * @description Renders hugeicons LayerAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayerAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayerMask01Icon
 * @description Renders hugeicons LayerMask01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayerMask01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayerMask02Icon
 * @description Renders hugeicons LayerMask02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayerMask02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layers01Icon
 * @description Renders hugeicons Layers01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layers01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layers02Icon
 * @description Renders hugeicons Layers02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layers02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayersLogoIcon
 * @description Renders hugeicons LayersLogoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayersLogoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout01Icon
 * @description Renders hugeicons Layout01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout02Icon
 * @description Renders hugeicons Layout02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout03Icon
 * @description Renders hugeicons Layout03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout04Icon
 * @description Renders hugeicons Layout04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout05Icon
 * @description Renders hugeicons Layout05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout06Icon
 * @description Renders hugeicons Layout06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout07Icon
 * @description Renders hugeicons Layout07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout2ColumnIcon
 * @description Renders hugeicons Layout2ColumnIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout2ColumnIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout2RowIcon
 * @description Renders hugeicons Layout2RowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout2RowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout3ColumnIcon
 * @description Renders hugeicons Layout3ColumnIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout3ColumnIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Layout3RowIcon
 * @description Renders hugeicons Layout3RowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Layout3RowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayoutBottomIcon
 * @description Renders hugeicons LayoutBottomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayoutBottomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayoutGridIcon
 * @description Renders hugeicons LayoutGridIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayoutGridIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayoutLeftIcon
 * @description Renders hugeicons LayoutLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayoutLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayoutRightIcon
 * @description Renders hugeicons LayoutRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayoutRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayoutTable01Icon
 * @description Renders hugeicons LayoutTable01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayoutTable01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayoutTable02Icon
 * @description Renders hugeicons LayoutTable02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayoutTable02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LayoutTopIcon
 * @description Renders hugeicons LayoutTopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LayoutTopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeavingGeoFenceIcon
 * @description Renders hugeicons LeavingGeoFenceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeavingGeoFenceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftAngleIcon
 * @description Renders hugeicons LeftAngleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftAngleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftToRightBlockQuoteIcon
 * @description Renders hugeicons LeftToRightBlockQuoteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftToRightBlockQuoteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftToRightListBulletIcon
 * @description Renders hugeicons LeftToRightListBulletIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftToRightListBulletIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftToRightListDashIcon
 * @description Renders hugeicons LeftToRightListDashIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftToRightListDashIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftToRightListNumberIcon
 * @description Renders hugeicons LeftToRightListNumberIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftToRightListNumberIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftToRightListStar01Icon
 * @description Renders hugeicons LeftToRightListStar01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftToRightListStar01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftToRightListStarIcon
 * @description Renders hugeicons LeftToRightListStarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftToRightListStarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftToRightListTriangleIcon
 * @description Renders hugeicons LeftToRightListTriangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftToRightListTriangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LeftTriangleIcon
 * @description Renders hugeicons LeftTriangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LeftTriangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Legal01Icon
 * @description Renders hugeicons Legal01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Legal01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Legal02Icon
 * @description Renders hugeicons Legal02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Legal02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LegalDocument01Icon
 * @description Renders hugeicons LegalDocument01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LegalDocument01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LegalDocument02Icon
 * @description Renders hugeicons LegalDocument02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LegalDocument02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LegalHammerIcon
 * @description Renders hugeicons LegalHammerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LegalHammerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LessThanIcon
 * @description Renders hugeicons LessThanIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LessThanIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LessThanCircleIcon
 * @description Renders hugeicons LessThanCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LessThanCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LessThanSquareIcon
 * @description Renders hugeicons LessThanSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LessThanSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LetterSpacingIcon
 * @description Renders hugeicons LetterSpacingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LetterSpacingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LibraryIcon
 * @description Renders hugeicons LibraryIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LibraryIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LicenseIcon
 * @description Renders hugeicons LicenseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LicenseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LicenseDraftIcon
 * @description Renders hugeicons LicenseDraftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LicenseDraftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LicenseMaintenanceIcon
 * @description Renders hugeicons LicenseMaintenanceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LicenseMaintenanceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LicenseNoIcon
 * @description Renders hugeicons LicenseNoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LicenseNoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LicensePinIcon
 * @description Renders hugeicons LicensePinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LicensePinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LicenseThirdPartyIcon
 * @description Renders hugeicons LicenseThirdPartyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LicenseThirdPartyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LiftTruckIcon
 * @description Renders hugeicons LiftTruckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LiftTruckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LighthouseIcon
 * @description Renders hugeicons LighthouseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LighthouseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LimitationIcon
 * @description Renders hugeicons LimitationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LimitationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LineIcon
 * @description Renders hugeicons LineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LinerIcon
 * @description Renders hugeicons LinerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LinerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Link01Icon
 * @description Renders hugeicons Link01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Link01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Link02Icon
 * @description Renders hugeicons Link02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Link02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Link03Icon
 * @description Renders hugeicons Link03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Link03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Link04Icon
 * @description Renders hugeicons Link04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Link04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Link05Icon
 * @description Renders hugeicons Link05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Link05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Link06Icon
 * @description Renders hugeicons Link06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Link06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LinkBackwardIcon
 * @description Renders hugeicons LinkBackwardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LinkBackwardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LinkCircle02Icon
 * @description Renders hugeicons LinkCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LinkCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LinkCircleIcon
 * @description Renders hugeicons LinkCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LinkCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LinkForwardIcon
 * @description Renders hugeicons LinkForwardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LinkForwardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LinkSquare01Icon
 * @description Renders hugeicons LinkSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LinkSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LinkSquare02Icon
 * @description Renders hugeicons LinkSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LinkSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Linkedin01Icon
 * @description Renders hugeicons Linkedin01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Linkedin01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Linkedin02Icon
 * @description Renders hugeicons Linkedin02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Linkedin02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ListSettingIcon
 * @description Renders hugeicons ListSettingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ListSettingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ListViewIcon
 * @description Renders hugeicons ListViewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ListViewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LitecoinIcon
 * @description Renders hugeicons LitecoinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LitecoinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LiverIcon
 * @description Renders hugeicons LiverIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LiverIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Loading01Icon
 * @description Renders hugeicons Loading01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Loading01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Loading02Icon
 * @description Renders hugeicons Loading02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Loading02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Loading03Icon
 * @description Renders hugeicons Loading03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Loading03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Loading04Icon
 * @description Renders hugeicons Loading04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Loading04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location01Icon
 * @description Renders hugeicons Location01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location02Icon
 * @description Renders hugeicons Location02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location03Icon
 * @description Renders hugeicons Location03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location04Icon
 * @description Renders hugeicons Location04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location05Icon
 * @description Renders hugeicons Location05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location06Icon
 * @description Renders hugeicons Location06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location07Icon
 * @description Renders hugeicons Location07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location08Icon
 * @description Renders hugeicons Location08Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location08Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location09Icon
 * @description Renders hugeicons Location09Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location09Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Location10Icon
 * @description Renders hugeicons Location10Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Location10Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationAdd01Icon
 * @description Renders hugeicons LocationAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationAdd02Icon
 * @description Renders hugeicons LocationAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationCheck01Icon
 * @description Renders hugeicons LocationCheck01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationCheck01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationCheck02Icon
 * @description Renders hugeicons LocationCheck02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationCheck02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationFavourite01Icon
 * @description Renders hugeicons LocationFavourite01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationFavourite01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationFavourite02Icon
 * @description Renders hugeicons LocationFavourite02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationFavourite02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationOffline01Icon
 * @description Renders hugeicons LocationOffline01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationOffline01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationOffline02Icon
 * @description Renders hugeicons LocationOffline02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationOffline02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationOffline03Icon
 * @description Renders hugeicons LocationOffline03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationOffline03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationOffline04Icon
 * @description Renders hugeicons LocationOffline04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationOffline04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationRemove01Icon
 * @description Renders hugeicons LocationRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationRemove02Icon
 * @description Renders hugeicons LocationRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationShare01Icon
 * @description Renders hugeicons LocationShare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationShare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationShare02Icon
 * @description Renders hugeicons LocationShare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationShare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationStar01Icon
 * @description Renders hugeicons LocationStar01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationStar01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationStar02Icon
 * @description Renders hugeicons LocationStar02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationStar02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationUpdate01Icon
 * @description Renders hugeicons LocationUpdate01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationUpdate01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationUpdate02Icon
 * @description Renders hugeicons LocationUpdate02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationUpdate02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationUser01Icon
 * @description Renders hugeicons LocationUser01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationUser01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationUser02Icon
 * @description Renders hugeicons LocationUser02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationUser02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationUser03Icon
 * @description Renders hugeicons LocationUser03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationUser03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LocationUser04Icon
 * @description Renders hugeicons LocationUser04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LocationUser04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LockIcon
 * @description Renders hugeicons LockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LockComputerIcon
 * @description Renders hugeicons LockComputerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LockComputerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LockKeyIcon
 * @description Renders hugeicons LockKeyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LockKeyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LockSync01Icon
 * @description Renders hugeicons LockSync01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LockSync01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LockSync02Icon
 * @description Renders hugeicons LockSync02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LockSync02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LockedIcon
 * @description Renders hugeicons LockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Locker01Icon
 * @description Renders hugeicons Locker01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Locker01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LockerIcon
 * @description Renders hugeicons LockerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LockerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Login01Icon
 * @description Renders hugeicons Login01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Login01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Login02Icon
 * @description Renders hugeicons Login02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Login02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Login03Icon
 * @description Renders hugeicons Login03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Login03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LoginCircle01Icon
 * @description Renders hugeicons LoginCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LoginCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LoginCircle02Icon
 * @description Renders hugeicons LoginCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LoginCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LoginSquare01Icon
 * @description Renders hugeicons LoginSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LoginSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LoginSquare02Icon
 * @description Renders hugeicons LoginSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LoginSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Logout01Icon
 * @description Renders hugeicons Logout01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Logout01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Logout02Icon
 * @description Renders hugeicons Logout02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Logout02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Logout03Icon
 * @description Renders hugeicons Logout03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Logout03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Logout04Icon
 * @description Renders hugeicons Logout04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Logout04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Logout05Icon
 * @description Renders hugeicons Logout05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Logout05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LogoutCircle01Icon
 * @description Renders hugeicons LogoutCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LogoutCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LogoutCircle02Icon
 * @description Renders hugeicons LogoutCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LogoutCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LogoutSquare01Icon
 * @description Renders hugeicons LogoutSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LogoutSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LogoutSquare02Icon
 * @description Renders hugeicons LogoutSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LogoutSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LollipopIcon
 * @description Renders hugeicons LollipopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LollipopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LongSleeveShirtIcon
 * @description Renders hugeicons LongSleeveShirtIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LongSleeveShirtIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LongitudeIcon
 * @description Renders hugeicons LongitudeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LongitudeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LookBottomIcon
 * @description Renders hugeicons LookBottomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LookBottomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LookLeftIcon
 * @description Renders hugeicons LookLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LookLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LookRightIcon
 * @description Renders hugeicons LookRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LookRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LookTopIcon
 * @description Renders hugeicons LookTopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LookTopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LoomIcon
 * @description Renders hugeicons LoomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LoomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LottiefilesIcon
 * @description Renders hugeicons LottiefilesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LottiefilesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LoveKoreanFingerIcon
 * @description Renders hugeicons LoveKoreanFingerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LoveKoreanFingerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LoyaltyCardIcon
 * @description Renders hugeicons LoyaltyCardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LoyaltyCardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name LungsIcon
 * @description Renders hugeicons LungsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const LungsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MachineRobotIcon
 * @description Renders hugeicons MachineRobotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MachineRobotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MagicWand01Icon
 * @description Renders hugeicons MagicWand01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MagicWand01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MagicWand02Icon
 * @description Renders hugeicons MagicWand02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MagicWand02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MagicWand03Icon
 * @description Renders hugeicons MagicWand03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MagicWand03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Magnet01Icon
 * @description Renders hugeicons Magnet01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Magnet01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Magnet02Icon
 * @description Renders hugeicons Magnet02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Magnet02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MagnetIcon
 * @description Renders hugeicons MagnetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MagnetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mail01Icon
 * @description Renders hugeicons Mail01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mail01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mail02Icon
 * @description Renders hugeicons Mail02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mail02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailAccount01Icon
 * @description Renders hugeicons MailAccount01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailAccount01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailAccount02Icon
 * @description Renders hugeicons MailAccount02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailAccount02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailAdd01Icon
 * @description Renders hugeicons MailAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailAdd02Icon
 * @description Renders hugeicons MailAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailAtSign01Icon
 * @description Renders hugeicons MailAtSign01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailAtSign01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailAtSign02Icon
 * @description Renders hugeicons MailAtSign02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailAtSign02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailBlock01Icon
 * @description Renders hugeicons MailBlock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailBlock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailBlock02Icon
 * @description Renders hugeicons MailBlock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailBlock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailDownload01Icon
 * @description Renders hugeicons MailDownload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailDownload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailDownload02Icon
 * @description Renders hugeicons MailDownload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailDownload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailEdit01Icon
 * @description Renders hugeicons MailEdit01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailEdit01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailEdit02Icon
 * @description Renders hugeicons MailEdit02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailEdit02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailLock01Icon
 * @description Renders hugeicons MailLock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailLock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailLock02Icon
 * @description Renders hugeicons MailLock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailLock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailLove01Icon
 * @description Renders hugeicons MailLove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailLove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailLove02Icon
 * @description Renders hugeicons MailLove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailLove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailMinus01Icon
 * @description Renders hugeicons MailMinus01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailMinus01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailMinus02Icon
 * @description Renders hugeicons MailMinus02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailMinus02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailOpen01Icon
 * @description Renders hugeicons MailOpen01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailOpen01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailOpen02Icon
 * @description Renders hugeicons MailOpen02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailOpen02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailOpenIcon
 * @description Renders hugeicons MailOpenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailOpenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailOpenLoveIcon
 * @description Renders hugeicons MailOpenLoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailOpenLoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailReceive01Icon
 * @description Renders hugeicons MailReceive01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailReceive01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailReceive02Icon
 * @description Renders hugeicons MailReceive02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailReceive02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailRemove01Icon
 * @description Renders hugeicons MailRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailRemove02Icon
 * @description Renders hugeicons MailRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailReply01Icon
 * @description Renders hugeicons MailReply01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailReply01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailReply02Icon
 * @description Renders hugeicons MailReply02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailReply02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailReplyAll01Icon
 * @description Renders hugeicons MailReplyAll01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailReplyAll01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailReplyAll02Icon
 * @description Renders hugeicons MailReplyAll02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailReplyAll02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailSearch01Icon
 * @description Renders hugeicons MailSearch01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailSearch01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailSearch02Icon
 * @description Renders hugeicons MailSearch02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailSearch02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailSecure01Icon
 * @description Renders hugeicons MailSecure01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailSecure01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailSecure02Icon
 * @description Renders hugeicons MailSecure02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailSecure02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailSend01Icon
 * @description Renders hugeicons MailSend01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailSend01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailSend02Icon
 * @description Renders hugeicons MailSend02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailSend02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailSetting01Icon
 * @description Renders hugeicons MailSetting01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailSetting01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailSetting02Icon
 * @description Renders hugeicons MailSetting02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailSetting02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailUnlock01Icon
 * @description Renders hugeicons MailUnlock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailUnlock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailUnlock02Icon
 * @description Renders hugeicons MailUnlock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailUnlock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailUpload01Icon
 * @description Renders hugeicons MailUpload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailUpload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailUpload02Icon
 * @description Renders hugeicons MailUpload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailUpload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailValidation01Icon
 * @description Renders hugeicons MailValidation01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailValidation01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailValidation02Icon
 * @description Renders hugeicons MailValidation02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailValidation02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailVoice01Icon
 * @description Renders hugeicons MailVoice01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailVoice01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailVoice02Icon
 * @description Renders hugeicons MailVoice02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailVoice02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mailbox01Icon
 * @description Renders hugeicons Mailbox01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mailbox01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MailboxIcon
 * @description Renders hugeicons MailboxIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MailboxIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ManagerIcon
 * @description Renders hugeicons ManagerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ManagerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapPinIcon
 * @description Renders hugeicons MapPinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapPinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapPinpoint01Icon
 * @description Renders hugeicons MapPinpoint01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapPinpoint01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapPinpoint02Icon
 * @description Renders hugeicons MapPinpoint02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapPinpoint02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapingIcon
 * @description Renders hugeicons MapingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsIcon
 * @description Renders hugeicons MapsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsCircle01Icon
 * @description Renders hugeicons MapsCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsCircle02Icon
 * @description Renders hugeicons MapsCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsEditingIcon
 * @description Renders hugeicons MapsEditingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsEditingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsGlobal01Icon
 * @description Renders hugeicons MapsGlobal01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsGlobal01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsGlobal02Icon
 * @description Renders hugeicons MapsGlobal02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsGlobal02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsLocation01Icon
 * @description Renders hugeicons MapsLocation01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsLocation01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsLocation02Icon
 * @description Renders hugeicons MapsLocation02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsLocation02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsOffIcon
 * @description Renders hugeicons MapsOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsRefreshIcon
 * @description Renders hugeicons MapsRefreshIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsRefreshIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsSearchIcon
 * @description Renders hugeicons MapsSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsSquare01Icon
 * @description Renders hugeicons MapsSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MapsSquare02Icon
 * @description Renders hugeicons MapsSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MapsSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MarketAnalysisIcon
 * @description Renders hugeicons MarketAnalysisIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MarketAnalysisIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MarketingIcon
 * @description Renders hugeicons MarketingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MarketingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MaskIcon
 * @description Renders hugeicons MaskIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MaskIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MaskLoveIcon
 * @description Renders hugeicons MaskLoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MaskLoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MasterCardIcon
 * @description Renders hugeicons MasterCardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MasterCardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MatchesIcon
 * @description Renders hugeicons MatchesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MatchesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MathIcon
 * @description Renders hugeicons MathIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MathIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MatrixIcon
 * @description Renders hugeicons MatrixIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MatrixIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Maximize01Icon
 * @description Renders hugeicons Maximize01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Maximize01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Maximize02Icon
 * @description Renders hugeicons Maximize02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Maximize02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Maximize03Icon
 * @description Renders hugeicons Maximize03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Maximize03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Maximize04Icon
 * @description Renders hugeicons Maximize04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Maximize04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MaximizeScreenIcon
 * @description Renders hugeicons MaximizeScreenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MaximizeScreenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MayanPyramidIcon
 * @description Renders hugeicons MayanPyramidIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MayanPyramidIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MazeIcon
 * @description Renders hugeicons MazeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MazeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medal01Icon
 * @description Renders hugeicons Medal01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medal01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medal02Icon
 * @description Renders hugeicons Medal02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medal02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medal03Icon
 * @description Renders hugeicons Medal03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medal03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medal04Icon
 * @description Renders hugeicons Medal04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medal04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medal05Icon
 * @description Renders hugeicons Medal05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medal05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medal06Icon
 * @description Renders hugeicons Medal06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medal06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medal07Icon
 * @description Renders hugeicons Medal07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medal07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MedalFirstPlaceIcon
 * @description Renders hugeicons MedalFirstPlaceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MedalFirstPlaceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MedalSecondPlaceIcon
 * @description Renders hugeicons MedalSecondPlaceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MedalSecondPlaceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MedalThirdPlaceIcon
 * @description Renders hugeicons MedalThirdPlaceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MedalThirdPlaceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MedicalFileIcon
 * @description Renders hugeicons MedicalFileIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MedicalFileIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MedicalMaskIcon
 * @description Renders hugeicons MedicalMaskIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MedicalMaskIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medicine01Icon
 * @description Renders hugeicons Medicine01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medicine01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Medicine02Icon
 * @description Renders hugeicons Medicine02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Medicine02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MedicineBottle01Icon
 * @description Renders hugeicons MedicineBottle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MedicineBottle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MedicineBottle02Icon
 * @description Renders hugeicons MedicineBottle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MedicineBottle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MedicineSyrupIcon
 * @description Renders hugeicons MedicineSyrupIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MedicineSyrupIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MediumIcon
 * @description Renders hugeicons MediumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MediumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MediumSquareIcon
 * @description Renders hugeicons MediumSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MediumSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MeetingRoomIcon
 * @description Renders hugeicons MeetingRoomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MeetingRoomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Megaphone01Icon
 * @description Renders hugeicons Megaphone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Megaphone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Megaphone02Icon
 * @description Renders hugeicons Megaphone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Megaphone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MehIcon
 * @description Renders hugeicons MehIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MehIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MentorIcon
 * @description Renders hugeicons MentorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MentorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MentoringIcon
 * @description Renders hugeicons MentoringIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MentoringIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu01Icon
 * @description Renders hugeicons Menu01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu02Icon
 * @description Renders hugeicons Menu02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu03Icon
 * @description Renders hugeicons Menu03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu04Icon
 * @description Renders hugeicons Menu04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu05Icon
 * @description Renders hugeicons Menu05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu06Icon
 * @description Renders hugeicons Menu06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu07Icon
 * @description Renders hugeicons Menu07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu08Icon
 * @description Renders hugeicons Menu08Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu08Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu09Icon
 * @description Renders hugeicons Menu09Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu09Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu10Icon
 * @description Renders hugeicons Menu10Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu10Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Menu11Icon
 * @description Renders hugeicons Menu11Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Menu11Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MenuCircleIcon
 * @description Renders hugeicons MenuCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MenuCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MenuSquareIcon
 * @description Renders hugeicons MenuSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MenuSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Message01Icon
 * @description Renders hugeicons Message01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Message01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Message02Icon
 * @description Renders hugeicons Message02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Message02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageAdd01Icon
 * @description Renders hugeicons MessageAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageAdd02Icon
 * @description Renders hugeicons MessageAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageBlockedIcon
 * @description Renders hugeicons MessageBlockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageBlockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageCancel01Icon
 * @description Renders hugeicons MessageCancel01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageCancel01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageCancel02Icon
 * @description Renders hugeicons MessageCancel02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageCancel02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageDelay01Icon
 * @description Renders hugeicons MessageDelay01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageDelay01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageDelay02Icon
 * @description Renders hugeicons MessageDelay02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageDelay02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageDone01Icon
 * @description Renders hugeicons MessageDone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageDone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageDone02Icon
 * @description Renders hugeicons MessageDone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageDone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageDownload01Icon
 * @description Renders hugeicons MessageDownload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageDownload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageDownload02Icon
 * @description Renders hugeicons MessageDownload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageDownload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageEdit01Icon
 * @description Renders hugeicons MessageEdit01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageEdit01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageEdit02Icon
 * @description Renders hugeicons MessageEdit02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageEdit02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageFavourite01Icon
 * @description Renders hugeicons MessageFavourite01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageFavourite01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageFavourite02Icon
 * @description Renders hugeicons MessageFavourite02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageFavourite02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageIncoming01Icon
 * @description Renders hugeicons MessageIncoming01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageIncoming01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageIncoming02Icon
 * @description Renders hugeicons MessageIncoming02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageIncoming02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageLock01Icon
 * @description Renders hugeicons MessageLock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageLock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageLock02Icon
 * @description Renders hugeicons MessageLock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageLock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageMultiple01Icon
 * @description Renders hugeicons MessageMultiple01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageMultiple01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageMultiple02Icon
 * @description Renders hugeicons MessageMultiple02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageMultiple02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageNotification01Icon
 * @description Renders hugeicons MessageNotification01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageNotification01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageNotification02Icon
 * @description Renders hugeicons MessageNotification02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageNotification02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageOutgoing01Icon
 * @description Renders hugeicons MessageOutgoing01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageOutgoing01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageOutgoing02Icon
 * @description Renders hugeicons MessageOutgoing02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageOutgoing02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessagePreview01Icon
 * @description Renders hugeicons MessagePreview01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessagePreview01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessagePreview02Icon
 * @description Renders hugeicons MessagePreview02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessagePreview02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageProgrammingIcon
 * @description Renders hugeicons MessageProgrammingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageProgrammingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageQuestionIcon
 * @description Renders hugeicons MessageQuestionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageQuestionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageSearch01Icon
 * @description Renders hugeicons MessageSearch01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageSearch01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageSearch02Icon
 * @description Renders hugeicons MessageSearch02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageSearch02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageSecure01Icon
 * @description Renders hugeicons MessageSecure01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageSecure01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageSecure02Icon
 * @description Renders hugeicons MessageSecure02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageSecure02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageTranslateIcon
 * @description Renders hugeicons MessageTranslateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageTranslateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageUnlock01Icon
 * @description Renders hugeicons MessageUnlock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageUnlock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageUnlock02Icon
 * @description Renders hugeicons MessageUnlock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageUnlock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageUpload01Icon
 * @description Renders hugeicons MessageUpload01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageUpload01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageUpload02Icon
 * @description Renders hugeicons MessageUpload02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageUpload02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageUser01Icon
 * @description Renders hugeicons MessageUser01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageUser01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessageUser02Icon
 * @description Renders hugeicons MessageUser02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessageUser02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MessengerIcon
 * @description Renders hugeicons MessengerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MessengerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MetaIcon
 * @description Renders hugeicons MetaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MetaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MetroIcon
 * @description Renders hugeicons MetroIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MetroIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mic01Icon
 * @description Renders hugeicons Mic01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mic01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mic02Icon
 * @description Renders hugeicons Mic02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mic02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MicOff01Icon
 * @description Renders hugeicons MicOff01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MicOff01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MicOff02Icon
 * @description Renders hugeicons MicOff02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MicOff02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MicrosoftAdminIcon
 * @description Renders hugeicons MicrosoftAdminIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MicrosoftAdminIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MicrosoftIcon
 * @description Renders hugeicons MicrosoftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MicrosoftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MicrowaveIcon
 * @description Renders hugeicons MicrowaveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MicrowaveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MilkBottleIcon
 * @description Renders hugeicons MilkBottleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MilkBottleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MilkCartonIcon
 * @description Renders hugeicons MilkCartonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MilkCartonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MilkCoconutIcon
 * @description Renders hugeicons MilkCoconutIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MilkCoconutIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MilkOatIcon
 * @description Renders hugeicons MilkOatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MilkOatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Minimize01Icon
 * @description Renders hugeicons Minimize01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Minimize01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Minimize02Icon
 * @description Renders hugeicons Minimize02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Minimize02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Minimize03Icon
 * @description Renders hugeicons Minimize03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Minimize03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Minimize04Icon
 * @description Renders hugeicons Minimize04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Minimize04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinimizeScreenIcon
 * @description Renders hugeicons MinimizeScreenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinimizeScreenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mining01Icon
 * @description Renders hugeicons Mining01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mining01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mining02Icon
 * @description Renders hugeicons Mining02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mining02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mining03Icon
 * @description Renders hugeicons Mining03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mining03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusPlus01Icon
 * @description Renders hugeicons MinusPlus01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusPlus01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusPlus02Icon
 * @description Renders hugeicons MinusPlus02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusPlus02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusPlusCircle01Icon
 * @description Renders hugeicons MinusPlusCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusPlusCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusPlusCircle02Icon
 * @description Renders hugeicons MinusPlusCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusPlusCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusPlusSquare01Icon
 * @description Renders hugeicons MinusPlusSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusPlusSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusPlusSquare02Icon
 * @description Renders hugeicons MinusPlusSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusPlusSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusSignIcon
 * @description Renders hugeicons MinusSignIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusSignIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusSignCircleIcon
 * @description Renders hugeicons MinusSignCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusSignCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MinusSignSquareIcon
 * @description Renders hugeicons MinusSignSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MinusSignSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MirrorIcon
 * @description Renders hugeicons MirrorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MirrorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MirroringScreenIcon
 * @description Renders hugeicons MirroringScreenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MirroringScreenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MixerIcon
 * @description Renders hugeicons MixerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MixerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MobileNavigator01Icon
 * @description Renders hugeicons MobileNavigator01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MobileNavigator01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MobileNavigator02Icon
 * @description Renders hugeicons MobileNavigator02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MobileNavigator02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MobileProgramming01Icon
 * @description Renders hugeicons MobileProgramming01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MobileProgramming01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MobileProgramming02Icon
 * @description Renders hugeicons MobileProgramming02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MobileProgramming02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MobileProtectionIcon
 * @description Renders hugeicons MobileProtectionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MobileProtectionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MobileSecurityIcon
 * @description Renders hugeicons MobileSecurityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MobileSecurityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MochiIcon
 * @description Renders hugeicons MochiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MochiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ModernTvFourKIcon
 * @description Renders hugeicons ModernTvFourKIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ModernTvFourKIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ModernTvIcon
 * @description Renders hugeicons ModernTvIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ModernTvIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ModernTvIssueIcon
 * @description Renders hugeicons ModernTvIssueIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ModernTvIssueIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoleculesIcon
 * @description Renders hugeicons MoleculesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoleculesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MonasIcon
 * @description Renders hugeicons MonasIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MonasIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Money01Icon
 * @description Renders hugeicons Money01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Money01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Money02Icon
 * @description Renders hugeicons Money02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Money02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Money03Icon
 * @description Renders hugeicons Money03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Money03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Money04Icon
 * @description Renders hugeicons Money04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Money04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyAdd01Icon
 * @description Renders hugeicons MoneyAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyAdd02Icon
 * @description Renders hugeicons MoneyAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyBag01Icon
 * @description Renders hugeicons MoneyBag01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyBag01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyBag02Icon
 * @description Renders hugeicons MoneyBag02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyBag02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyExchange01Icon
 * @description Renders hugeicons MoneyExchange01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyExchange01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyExchange02Icon
 * @description Renders hugeicons MoneyExchange02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyExchange02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyExchange03Icon
 * @description Renders hugeicons MoneyExchange03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyExchange03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyNotFound01Icon
 * @description Renders hugeicons MoneyNotFound01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyNotFound01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyNotFound02Icon
 * @description Renders hugeicons MoneyNotFound02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyNotFound02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyNotFound03Icon
 * @description Renders hugeicons MoneyNotFound03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyNotFound03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyNotFound04Icon
 * @description Renders hugeicons MoneyNotFound04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyNotFound04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyReceive01Icon
 * @description Renders hugeicons MoneyReceive01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyReceive01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyReceive02Icon
 * @description Renders hugeicons MoneyReceive02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyReceive02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyReceiveCircleIcon
 * @description Renders hugeicons MoneyReceiveCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyReceiveCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyReceiveFlow01Icon
 * @description Renders hugeicons MoneyReceiveFlow01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyReceiveFlow01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyReceiveFlow02Icon
 * @description Renders hugeicons MoneyReceiveFlow02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyReceiveFlow02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyReceiveSquareIcon
 * @description Renders hugeicons MoneyReceiveSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyReceiveSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyRemove01Icon
 * @description Renders hugeicons MoneyRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneyRemove02Icon
 * @description Renders hugeicons MoneyRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneyRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneySafeIcon
 * @description Renders hugeicons MoneySafeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneySafeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneySecurityIcon
 * @description Renders hugeicons MoneySecurityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneySecurityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneySend01Icon
 * @description Renders hugeicons MoneySend01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneySend01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneySend02Icon
 * @description Renders hugeicons MoneySend02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneySend02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneySendCircleIcon
 * @description Renders hugeicons MoneySendCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneySendCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneySendFlow01Icon
 * @description Renders hugeicons MoneySendFlow01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneySendFlow01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneySendFlow02Icon
 * @description Renders hugeicons MoneySendFlow02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneySendFlow02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoneySendSquareIcon
 * @description Renders hugeicons MoneySendSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoneySendSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Monocle01Icon
 * @description Renders hugeicons Monocle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Monocle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MonocleIcon
 * @description Renders hugeicons MonocleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MonocleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MonsterIcon
 * @description Renders hugeicons MonsterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MonsterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Moon01Icon
 * @description Renders hugeicons Moon01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Moon01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Moon02Icon
 * @description Renders hugeicons Moon02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Moon02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonAngledRainZapIcon
 * @description Renders hugeicons MoonAngledRainZapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonAngledRainZapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonIcon
 * @description Renders hugeicons MoonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudAngledRainIcon
 * @description Renders hugeicons MoonCloudAngledRainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudAngledRainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudAngledZapIcon
 * @description Renders hugeicons MoonCloudAngledZapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudAngledZapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudBigRainIcon
 * @description Renders hugeicons MoonCloudBigRainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudBigRainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudIcon
 * @description Renders hugeicons MoonCloudIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudFastWindIcon
 * @description Renders hugeicons MoonCloudFastWindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudFastWindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudHailstoneIcon
 * @description Renders hugeicons MoonCloudHailstoneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudHailstoneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudLittleRainIcon
 * @description Renders hugeicons MoonCloudLittleRainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudLittleRainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudLittleSnowIcon
 * @description Renders hugeicons MoonCloudLittleSnowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudLittleSnowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudMidRainIcon
 * @description Renders hugeicons MoonCloudMidRainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudMidRainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudMidSnowIcon
 * @description Renders hugeicons MoonCloudMidSnowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudMidSnowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudSlowWindIcon
 * @description Renders hugeicons MoonCloudSlowWindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudSlowWindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonCloudSnowIcon
 * @description Renders hugeicons MoonCloudSnowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonCloudSnowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonEclipseIcon
 * @description Renders hugeicons MoonEclipseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonEclipseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonFastWindIcon
 * @description Renders hugeicons MoonFastWindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonFastWindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonLandingIcon
 * @description Renders hugeicons MoonLandingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonLandingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonSlowWindIcon
 * @description Renders hugeicons MoonSlowWindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonSlowWindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoonsetIcon
 * @description Renders hugeicons MoonsetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoonsetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name More01Icon
 * @description Renders hugeicons More01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const More01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name More02Icon
 * @description Renders hugeicons More02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const More02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name More03Icon
 * @description Renders hugeicons More03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const More03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreIcon
 * @description Renders hugeicons MoreIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreHorizontalIcon
 * @description Renders hugeicons MoreHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreHorizontalCircle01Icon
 * @description Renders hugeicons MoreHorizontalCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreHorizontalCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreHorizontalCircle02Icon
 * @description Renders hugeicons MoreHorizontalCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreHorizontalCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreHorizontalSquare01Icon
 * @description Renders hugeicons MoreHorizontalSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreHorizontalSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreHorizontalSquare02Icon
 * @description Renders hugeicons MoreHorizontalSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreHorizontalSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreOrLessIcon
 * @description Renders hugeicons MoreOrLessIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreOrLessIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreOrLessCircleIcon
 * @description Renders hugeicons MoreOrLessCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreOrLessCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreOrLessSquareIcon
 * @description Renders hugeicons MoreOrLessSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreOrLessSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreVerticalIcon
 * @description Renders hugeicons MoreVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreVerticalCircle01Icon
 * @description Renders hugeicons MoreVerticalCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreVerticalCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreVerticalCircle02Icon
 * @description Renders hugeicons MoreVerticalCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreVerticalCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreVerticalSquare01Icon
 * @description Renders hugeicons MoreVerticalSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreVerticalSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoreVerticalSquare02Icon
 * @description Renders hugeicons MoreVerticalSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoreVerticalSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MortarIcon
 * @description Renders hugeicons MortarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MortarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mortarboard01Icon
 * @description Renders hugeicons Mortarboard01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mortarboard01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mortarboard02Icon
 * @description Renders hugeicons Mortarboard02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mortarboard02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mosque01Icon
 * @description Renders hugeicons Mosque01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mosque01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mosque02Icon
 * @description Renders hugeicons Mosque02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mosque02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mosque03Icon
 * @description Renders hugeicons Mosque03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mosque03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mosque04Icon
 * @description Renders hugeicons Mosque04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mosque04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mosque05Icon
 * @description Renders hugeicons Mosque05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mosque05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MosqueLocationIcon
 * @description Renders hugeicons MosqueLocationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MosqueLocationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Motion01Icon
 * @description Renders hugeicons Motion01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Motion01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Motion02Icon
 * @description Renders hugeicons Motion02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Motion02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Motorbike01Icon
 * @description Renders hugeicons Motorbike01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Motorbike01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Motorbike02Icon
 * @description Renders hugeicons Motorbike02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Motorbike02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse01Icon
 * @description Renders hugeicons Mouse01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse02Icon
 * @description Renders hugeicons Mouse02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse03Icon
 * @description Renders hugeicons Mouse03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse04Icon
 * @description Renders hugeicons Mouse04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse05Icon
 * @description Renders hugeicons Mouse05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse06Icon
 * @description Renders hugeicons Mouse06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse07Icon
 * @description Renders hugeicons Mouse07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse08Icon
 * @description Renders hugeicons Mouse08Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse08Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse09Icon
 * @description Renders hugeicons Mouse09Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse09Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse10Icon
 * @description Renders hugeicons Mouse10Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse10Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse11Icon
 * @description Renders hugeicons Mouse11Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse11Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse12Icon
 * @description Renders hugeicons Mouse12Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse12Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse13Icon
 * @description Renders hugeicons Mouse13Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse13Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse14Icon
 * @description Renders hugeicons Mouse14Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse14Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse15Icon
 * @description Renders hugeicons Mouse15Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse15Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse16Icon
 * @description Renders hugeicons Mouse16Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse16Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse17Icon
 * @description Renders hugeicons Mouse17Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse17Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse18Icon
 * @description Renders hugeicons Mouse18Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse18Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse19Icon
 * @description Renders hugeicons Mouse19Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse19Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse20Icon
 * @description Renders hugeicons Mouse20Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse20Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse21Icon
 * @description Renders hugeicons Mouse21Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse21Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse22Icon
 * @description Renders hugeicons Mouse22Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse22Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mouse23Icon
 * @description Renders hugeicons Mouse23Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mouse23Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseLeftClick01Icon
 * @description Renders hugeicons MouseLeftClick01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseLeftClick01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseLeftClick02Icon
 * @description Renders hugeicons MouseLeftClick02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseLeftClick02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseLeftClick03Icon
 * @description Renders hugeicons MouseLeftClick03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseLeftClick03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseLeftClick04Icon
 * @description Renders hugeicons MouseLeftClick04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseLeftClick04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseLeftClick05Icon
 * @description Renders hugeicons MouseLeftClick05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseLeftClick05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseLeftClick06Icon
 * @description Renders hugeicons MouseLeftClick06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseLeftClick06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseRightClick01Icon
 * @description Renders hugeicons MouseRightClick01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseRightClick01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseRightClick02Icon
 * @description Renders hugeicons MouseRightClick02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseRightClick02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseRightClick03Icon
 * @description Renders hugeicons MouseRightClick03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseRightClick03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseRightClick04Icon
 * @description Renders hugeicons MouseRightClick04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseRightClick04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseRightClick05Icon
 * @description Renders hugeicons MouseRightClick05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseRightClick05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseRightClick06Icon
 * @description Renders hugeicons MouseRightClick06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseRightClick06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseScroll01Icon
 * @description Renders hugeicons MouseScroll01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseScroll01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MouseScroll02Icon
 * @description Renders hugeicons MouseScroll02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MouseScroll02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Move01Icon
 * @description Renders hugeicons Move01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Move01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Move02Icon
 * @description Renders hugeicons Move02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Move02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoveBottomIcon
 * @description Renders hugeicons MoveBottomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoveBottomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoveIcon
 * @description Renders hugeicons MoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoveLeftIcon
 * @description Renders hugeicons MoveLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoveLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoveRightIcon
 * @description Renders hugeicons MoveRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoveRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoveToIcon
 * @description Renders hugeicons MoveToIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoveToIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MoveTopIcon
 * @description Renders hugeicons MoveTopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MoveTopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mp301Icon
 * @description Renders hugeicons Mp301Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mp301Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mp302Icon
 * @description Renders hugeicons Mp302Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mp302Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mp401Icon
 * @description Renders hugeicons Mp401Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mp401Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mp402Icon
 * @description Renders hugeicons Mp402Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mp402Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MuhammadIcon
 * @description Renders hugeicons MuhammadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MuhammadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MultiplicationSignIcon
 * @description Renders hugeicons MultiplicationSignIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MultiplicationSignIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MultiplicationSignCircleIcon
 * @description Renders hugeicons MultiplicationSignCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MultiplicationSignCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MultiplicationSignSquareIcon
 * @description Renders hugeicons MultiplicationSignSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MultiplicationSignSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Mushroom01Icon
 * @description Renders hugeicons Mushroom01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Mushroom01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MushroomIcon
 * @description Renders hugeicons MushroomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MushroomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MusicNote01Icon
 * @description Renders hugeicons MusicNote01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MusicNote01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MusicNote02Icon
 * @description Renders hugeicons MusicNote02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MusicNote02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MusicNote03Icon
 * @description Renders hugeicons MusicNote03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MusicNote03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MusicNote04Icon
 * @description Renders hugeicons MusicNote04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MusicNote04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MusicNoteSquare01Icon
 * @description Renders hugeicons MusicNoteSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MusicNoteSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MusicNoteSquare02Icon
 * @description Renders hugeicons MusicNoteSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MusicNoteSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MuslimIcon
 * @description Renders hugeicons MuslimIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MuslimIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MuteIcon
 * @description Renders hugeicons MuteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MuteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name MymindIcon
 * @description Renders hugeicons MymindIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const MymindIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NThRootIcon
 * @description Renders hugeicons NThRootIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NThRootIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NThRootCircleIcon
 * @description Renders hugeicons NThRootCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NThRootCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NThRootSquareIcon
 * @description Renders hugeicons NThRootSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NThRootSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NanoTechnologyIcon
 * @description Renders hugeicons NanoTechnologyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NanoTechnologyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NaturalFoodIcon
 * @description Renders hugeicons NaturalFoodIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NaturalFoodIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Navigation01Icon
 * @description Renders hugeicons Navigation01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Navigation01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Navigation02Icon
 * @description Renders hugeicons Navigation02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Navigation02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Navigation03Icon
 * @description Renders hugeicons Navigation03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Navigation03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Navigation04Icon
 * @description Renders hugeicons Navigation04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Navigation04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Navigator01Icon
 * @description Renders hugeicons Navigator01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Navigator01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Navigator02Icon
 * @description Renders hugeicons Navigator02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Navigator02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NecklaceIcon
 * @description Renders hugeicons NecklaceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NecklaceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NerdIcon
 * @description Renders hugeicons NerdIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NerdIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NeutralIcon
 * @description Renders hugeicons NeutralIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NeutralIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NewJobIcon
 * @description Renders hugeicons NewJobIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NewJobIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NewOfficeIcon
 * @description Renders hugeicons NewOfficeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NewOfficeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NewReleasesIcon
 * @description Renders hugeicons NewReleasesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NewReleasesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NewTwitterIcon
 * @description Renders hugeicons NewTwitterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NewTwitterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NewTwitterEllipseIcon
 * @description Renders hugeicons NewTwitterEllipseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NewTwitterEllipseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NewTwitterRectangleIcon
 * @description Renders hugeicons NewTwitterRectangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NewTwitterRectangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name News01Icon
 * @description Renders hugeicons News01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const News01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NewsIcon
 * @description Renders hugeicons NewsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NewsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NextIcon
 * @description Renders hugeicons NextIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NextIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NikeIcon
 * @description Renders hugeicons NikeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NikeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NintendoIcon
 * @description Renders hugeicons NintendoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NintendoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NintendoSwitchIcon
 * @description Renders hugeicons NintendoSwitchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NintendoSwitchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NiqabIcon
 * @description Renders hugeicons NiqabIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NiqabIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoInternetIcon
 * @description Renders hugeicons NoInternetIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoInternetIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoMeetingRoomIcon
 * @description Renders hugeicons NoMeetingRoomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoMeetingRoomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NodeAddIcon
 * @description Renders hugeicons NodeAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NodeAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NodeEditIcon
 * @description Renders hugeicons NodeEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NodeEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NodeMoveDownIcon
 * @description Renders hugeicons NodeMoveDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NodeMoveDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NodeMoveUpIcon
 * @description Renders hugeicons NodeMoveUpIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NodeMoveUpIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NodeRemoveIcon
 * @description Renders hugeicons NodeRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NodeRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoodlesIcon
 * @description Renders hugeicons NoodlesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoodlesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoseIcon
 * @description Renders hugeicons NoseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotEqualSignIcon
 * @description Renders hugeicons NotEqualSignIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotEqualSignIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotEqualSignCircleIcon
 * @description Renders hugeicons NotEqualSignCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotEqualSignCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotEqualSignSquareIcon
 * @description Renders hugeicons NotEqualSignSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotEqualSignSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Note01Icon
 * @description Renders hugeicons Note01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Note01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Note02Icon
 * @description Renders hugeicons Note02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Note02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Note03Icon
 * @description Renders hugeicons Note03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Note03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Note04Icon
 * @description Renders hugeicons Note04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Note04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Note05Icon
 * @description Renders hugeicons Note05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Note05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoteAddIcon
 * @description Renders hugeicons NoteAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoteAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoteIcon
 * @description Renders hugeicons NoteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoteDoneIcon
 * @description Renders hugeicons NoteDoneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoteDoneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoteEditIcon
 * @description Renders hugeicons NoteEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoteEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NoteRemoveIcon
 * @description Renders hugeicons NoteRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NoteRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Notebook01Icon
 * @description Renders hugeicons Notebook01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Notebook01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Notebook02Icon
 * @description Renders hugeicons Notebook02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Notebook02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotebookIcon
 * @description Renders hugeicons NotebookIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotebookIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Notification01Icon
 * @description Renders hugeicons Notification01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Notification01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Notification02Icon
 * @description Renders hugeicons Notification02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Notification02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Notification03Icon
 * @description Renders hugeicons Notification03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Notification03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationBlock01Icon
 * @description Renders hugeicons NotificationBlock01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationBlock01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationBlock02Icon
 * @description Renders hugeicons NotificationBlock02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationBlock02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationBlock03Icon
 * @description Renders hugeicons NotificationBlock03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationBlock03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationBubbleIcon
 * @description Renders hugeicons NotificationBubbleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationBubbleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationCircleIcon
 * @description Renders hugeicons NotificationCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationOff01Icon
 * @description Renders hugeicons NotificationOff01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationOff01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationOff02Icon
 * @description Renders hugeicons NotificationOff02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationOff02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationOff03Icon
 * @description Renders hugeicons NotificationOff03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationOff03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationSnooze01Icon
 * @description Renders hugeicons NotificationSnooze01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationSnooze01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationSnooze02Icon
 * @description Renders hugeicons NotificationSnooze02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationSnooze02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationSnooze03Icon
 * @description Renders hugeicons NotificationSnooze03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationSnooze03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NotificationSquareIcon
 * @description Renders hugeicons NotificationSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NotificationSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Notion01Icon
 * @description Renders hugeicons Notion01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Notion01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Notion02Icon
 * @description Renders hugeicons Notion02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Notion02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NpmIcon
 * @description Renders hugeicons NpmIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NpmIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NuclearPowerIcon
 * @description Renders hugeicons NuclearPowerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NuclearPowerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name NutIcon
 * @description Renders hugeicons NutIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const NutIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ObtuseIcon
 * @description Renders hugeicons ObtuseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ObtuseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OctagonIcon
 * @description Renders hugeicons OctagonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OctagonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OctopusIcon
 * @description Renders hugeicons OctopusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OctopusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Office365Icon
 * @description Renders hugeicons Office365Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Office365Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OfficeIcon
 * @description Renders hugeicons OfficeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OfficeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OfficeChairIcon
 * @description Renders hugeicons OfficeChairIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OfficeChairIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OilBarrelIcon
 * @description Renders hugeicons OilBarrelIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OilBarrelIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OkFingerIcon
 * @description Renders hugeicons OkFingerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OkFingerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OlympicTorchIcon
 * @description Renders hugeicons OlympicTorchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OlympicTorchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OnlineLearning01Icon
 * @description Renders hugeicons OnlineLearning01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OnlineLearning01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OnlineLearning02Icon
 * @description Renders hugeicons OnlineLearning02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OnlineLearning02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OnlineLearning03Icon
 * @description Renders hugeicons OnlineLearning03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OnlineLearning03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OnlineLearning04Icon
 * @description Renders hugeicons OnlineLearning04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OnlineLearning04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OpenCaptionIcon
 * @description Renders hugeicons OpenCaptionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OpenCaptionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OptionIcon
 * @description Renders hugeicons OptionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OptionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OrangeIcon
 * @description Renders hugeicons OrangeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OrangeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Orbit01Icon
 * @description Renders hugeicons Orbit01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Orbit01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Orbit02Icon
 * @description Renders hugeicons Orbit02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Orbit02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OrganicFoodIcon
 * @description Renders hugeicons OrganicFoodIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OrganicFoodIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OrthogonalEdgeIcon
 * @description Renders hugeicons OrthogonalEdgeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OrthogonalEdgeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OvalIcon
 * @description Renders hugeicons OvalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OvalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name OvenIcon
 * @description Renders hugeicons OvenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const OvenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageAddIcon
 * @description Renders hugeicons PackageAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageIcon
 * @description Renders hugeicons PackageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageDeliveredIcon
 * @description Renders hugeicons PackageDeliveredIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageDeliveredIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageMovingIcon
 * @description Renders hugeicons PackageMovingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageMovingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageOpenIcon
 * @description Renders hugeicons PackageOpenIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageOpenIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageOutOfStockIcon
 * @description Renders hugeicons PackageOutOfStockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageOutOfStockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageProcessIcon
 * @description Renders hugeicons PackageProcessIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageProcessIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageReceiveIcon
 * @description Renders hugeicons PackageReceiveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageReceiveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageRemoveIcon
 * @description Renders hugeicons PackageRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageSearchIcon
 * @description Renders hugeicons PackageSearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageSearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PackageSentIcon
 * @description Renders hugeicons PackageSentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PackageSentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pacman01Icon
 * @description Renders hugeicons Pacman01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pacman01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pacman02Icon
 * @description Renders hugeicons Pacman02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pacman02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaintBoardIcon
 * @description Renders hugeicons PaintBoardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaintBoardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaintBrush01Icon
 * @description Renders hugeicons PaintBrush01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaintBrush01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaintBrush02Icon
 * @description Renders hugeicons PaintBrush02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaintBrush02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaintBrush03Icon
 * @description Renders hugeicons PaintBrush03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaintBrush03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaintBrush04Icon
 * @description Renders hugeicons PaintBrush04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaintBrush04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaintBucketIcon
 * @description Renders hugeicons PaintBucketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaintBucketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pan01Icon
 * @description Renders hugeicons Pan01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pan01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pan02Icon
 * @description Renders hugeicons Pan02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pan02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pan03Icon
 * @description Renders hugeicons Pan03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pan03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Parabola01Icon
 * @description Renders hugeicons Parabola01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Parabola01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Parabola02Icon
 * @description Renders hugeicons Parabola02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Parabola02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Parabola03Icon
 * @description Renders hugeicons Parabola03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Parabola03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ParaglidingIcon
 * @description Renders hugeicons ParaglidingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ParaglidingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ParagraphIcon
 * @description Renders hugeicons ParagraphIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ParagraphIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ParagraphBulletsPoint01Icon
 * @description Renders hugeicons ParagraphBulletsPoint01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ParagraphBulletsPoint01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ParagraphBulletsPoint02Icon
 * @description Renders hugeicons ParagraphBulletsPoint02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ParagraphBulletsPoint02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ParagraphSpacingIcon
 * @description Renders hugeicons ParagraphSpacingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ParagraphSpacingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ParallelogramIcon
 * @description Renders hugeicons ParallelogramIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ParallelogramIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ParkingAreaCircleIcon
 * @description Renders hugeicons ParkingAreaCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ParkingAreaCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ParkingAreaSquareIcon
 * @description Renders hugeicons ParkingAreaSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ParkingAreaSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Passport01Icon
 * @description Renders hugeicons Passport01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Passport01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PassportIcon
 * @description Renders hugeicons PassportIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PassportIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PassportExpiredIcon
 * @description Renders hugeicons PassportExpiredIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PassportExpiredIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PassportValidIcon
 * @description Renders hugeicons PassportValidIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PassportValidIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PasswordValidationIcon
 * @description Renders hugeicons PasswordValidationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PasswordValidationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathIcon
 * @description Renders hugeicons PathIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderCropIcon
 * @description Renders hugeicons PathfinderCropIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderCropIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderDivideIcon
 * @description Renders hugeicons PathfinderDivideIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderDivideIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderExcludeIcon
 * @description Renders hugeicons PathfinderExcludeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderExcludeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderIntersectIcon
 * @description Renders hugeicons PathfinderIntersectIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderIntersectIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderMergeIcon
 * @description Renders hugeicons PathfinderMergeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderMergeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderMinusBackIcon
 * @description Renders hugeicons PathfinderMinusBackIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderMinusBackIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderMinusFrontIcon
 * @description Renders hugeicons PathfinderMinusFrontIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderMinusFrontIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderOutlineIcon
 * @description Renders hugeicons PathfinderOutlineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderOutlineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderTrimIcon
 * @description Renders hugeicons PathfinderTrimIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderTrimIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PathfinderUniteIcon
 * @description Renders hugeicons PathfinderUniteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PathfinderUniteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PatioIcon
 * @description Renders hugeicons PatioIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PatioIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PauseIcon
 * @description Renders hugeicons PauseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PauseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PavilonIcon
 * @description Renders hugeicons PavilonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PavilonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PayByCheckIcon
 * @description Renders hugeicons PayByCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PayByCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaymentSuccess01Icon
 * @description Renders hugeicons PaymentSuccess01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaymentSuccess01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaymentSuccess02Icon
 * @description Renders hugeicons PaymentSuccess02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaymentSuccess02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PayoneerIcon
 * @description Renders hugeicons PayoneerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PayoneerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PaypalIcon
 * @description Renders hugeicons PaypalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PaypalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pdf01Icon
 * @description Renders hugeicons Pdf01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pdf01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pdf02Icon
 * @description Renders hugeicons Pdf02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pdf02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PeerToPeer01Icon
 * @description Renders hugeicons PeerToPeer01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PeerToPeer01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PeerToPeer02Icon
 * @description Renders hugeicons PeerToPeer02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PeerToPeer02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PeerToPeer03Icon
 * @description Renders hugeicons PeerToPeer03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PeerToPeer03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PenConnectBluetoothIcon
 * @description Renders hugeicons PenConnectBluetoothIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PenConnectBluetoothIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PenConnectUsbIcon
 * @description Renders hugeicons PenConnectUsbIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PenConnectUsbIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PenConnectWifiIcon
 * @description Renders hugeicons PenConnectWifiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PenConnectWifiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PenTool01Icon
 * @description Renders hugeicons PenTool01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PenTool01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PenTool02Icon
 * @description Renders hugeicons PenTool02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PenTool02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PenTool03Icon
 * @description Renders hugeicons PenTool03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PenTool03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PenToolAddIcon
 * @description Renders hugeicons PenToolAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PenToolAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PenToolMinusIcon
 * @description Renders hugeicons PenToolMinusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PenToolMinusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PencilIcon
 * @description Renders hugeicons PencilIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PencilIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PencilEdit01Icon
 * @description Renders hugeicons PencilEdit01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PencilEdit01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PencilEdit02Icon
 * @description Renders hugeicons PencilEdit02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PencilEdit02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PendulumIcon
 * @description Renders hugeicons PendulumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PendulumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PensiveIcon
 * @description Renders hugeicons PensiveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PensiveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pentagon01Icon
 * @description Renders hugeicons Pentagon01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pentagon01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PentagonIcon
 * @description Renders hugeicons PentagonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PentagonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PercentIcon
 * @description Renders hugeicons PercentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PercentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PercentCircleIcon
 * @description Renders hugeicons PercentCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PercentCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PercentSquareIcon
 * @description Renders hugeicons PercentSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PercentSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PerfumeIcon
 * @description Renders hugeicons PerfumeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PerfumeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PeriscopeIcon
 * @description Renders hugeicons PeriscopeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PeriscopeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PermanentJobIcon
 * @description Renders hugeicons PermanentJobIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PermanentJobIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PerspectiveIcon
 * @description Renders hugeicons PerspectiveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PerspectiveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PhoneOff01Icon
 * @description Renders hugeicons PhoneOff01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PhoneOff01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PhoneOff02Icon
 * @description Renders hugeicons PhoneOff02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PhoneOff02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PhpIcon
 * @description Renders hugeicons PhpIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PhpIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PhysicsIcon
 * @description Renders hugeicons PhysicsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PhysicsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PiIcon
 * @description Renders hugeicons PiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PiCircleIcon
 * @description Renders hugeicons PiCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PiCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PiSquareIcon
 * @description Renders hugeicons PiSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PiSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PicasaIcon
 * @description Renders hugeicons PicasaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PicasaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pickup01Icon
 * @description Renders hugeicons Pickup01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pickup01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pickup02Icon
 * @description Renders hugeicons Pickup02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pickup02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PictureInPictureExitIcon
 * @description Renders hugeicons PictureInPictureExitIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PictureInPictureExitIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PictureInPictureOnIcon
 * @description Renders hugeicons PictureInPictureOnIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PictureInPictureOnIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PieIcon
 * @description Renders hugeicons PieIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PieIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PieChartIcon
 * @description Renders hugeicons PieChartIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PieChartIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PieChartSquareIcon
 * @description Renders hugeicons PieChartSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PieChartSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PiggyBankIcon
 * @description Renders hugeicons PiggyBankIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PiggyBankIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PinIcon
 * @description Renders hugeicons PinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PinCodeIcon
 * @description Renders hugeicons PinCodeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PinCodeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PinLocation01Icon
 * @description Renders hugeicons PinLocation01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PinLocation01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PinLocation02Icon
 * @description Renders hugeicons PinLocation02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PinLocation02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PinLocation03Icon
 * @description Renders hugeicons PinLocation03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PinLocation03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PinOffIcon
 * @description Renders hugeicons PinOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PinOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PinterestIcon
 * @description Renders hugeicons PinterestIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PinterestIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PipelineIcon
 * @description Renders hugeicons PipelineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PipelineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PisaTowerIcon
 * @description Renders hugeicons PisaTowerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PisaTowerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pizza01Icon
 * @description Renders hugeicons Pizza01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pizza01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pizza02Icon
 * @description Renders hugeicons Pizza02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pizza02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PizzaCutterIcon
 * @description Renders hugeicons PizzaCutterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PizzaCutterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlaneIcon
 * @description Renders hugeicons PlaneIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlaneIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlateIcon
 * @description Renders hugeicons PlateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlaxoIcon
 * @description Renders hugeicons PlaxoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlaxoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayIcon
 * @description Renders hugeicons PlayIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayCircleIcon
 * @description Renders hugeicons PlayCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayListAddIcon
 * @description Renders hugeicons PlayListAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayListAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayListIcon
 * @description Renders hugeicons PlayListIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayListIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayListFavourite01Icon
 * @description Renders hugeicons PlayListFavourite01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayListFavourite01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayListFavourite02Icon
 * @description Renders hugeicons PlayListFavourite02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayListFavourite02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayListMinusIcon
 * @description Renders hugeicons PlayListMinusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayListMinusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayListRemoveIcon
 * @description Renders hugeicons PlayListRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayListRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlaySquareIcon
 * @description Renders hugeicons PlaySquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlaySquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlayStoreIcon
 * @description Renders hugeicons PlayStoreIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlayStoreIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Playlist01Icon
 * @description Renders hugeicons Playlist01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Playlist01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Playlist02Icon
 * @description Renders hugeicons Playlist02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Playlist02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Playlist03Icon
 * @description Renders hugeicons Playlist03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Playlist03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlazaIcon
 * @description Renders hugeicons PlazaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlazaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Plug01Icon
 * @description Renders hugeicons Plug01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Plug01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Plug02Icon
 * @description Renders hugeicons Plug02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Plug02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlugSocketIcon
 * @description Renders hugeicons PlugSocketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlugSocketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusMinus01Icon
 * @description Renders hugeicons PlusMinus01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusMinus01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusMinus02Icon
 * @description Renders hugeicons PlusMinus02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusMinus02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusMinusCircle01Icon
 * @description Renders hugeicons PlusMinusCircle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusMinusCircle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusMinusCircle02Icon
 * @description Renders hugeicons PlusMinusCircle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusMinusCircle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusMinusSquare01Icon
 * @description Renders hugeicons PlusMinusSquare01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusMinusSquare01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusMinusSquare02Icon
 * @description Renders hugeicons PlusMinusSquare02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusMinusSquare02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusSignIcon
 * @description Renders hugeicons PlusSignIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusSignIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusSignCircleIcon
 * @description Renders hugeicons PlusSignCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusSignCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PlusSignSquareIcon
 * @description Renders hugeicons PlusSignSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PlusSignSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Png01Icon
 * @description Renders hugeicons Png01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Png01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Png02Icon
 * @description Renders hugeicons Png02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Png02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PodiumIcon
 * @description Renders hugeicons PodiumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PodiumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingLeft01Icon
 * @description Renders hugeicons PointingLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingLeft02Icon
 * @description Renders hugeicons PointingLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingLeft03Icon
 * @description Renders hugeicons PointingLeft03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingLeft03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingLeft04Icon
 * @description Renders hugeicons PointingLeft04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingLeft04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingLeft05Icon
 * @description Renders hugeicons PointingLeft05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingLeft05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingLeft06Icon
 * @description Renders hugeicons PointingLeft06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingLeft06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingLeft07Icon
 * @description Renders hugeicons PointingLeft07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingLeft07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingLeft08Icon
 * @description Renders hugeicons PointingLeft08Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingLeft08Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingRight01Icon
 * @description Renders hugeicons PointingRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingRight02Icon
 * @description Renders hugeicons PointingRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingRight03Icon
 * @description Renders hugeicons PointingRight03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingRight03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingRight04Icon
 * @description Renders hugeicons PointingRight04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingRight04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingRight05Icon
 * @description Renders hugeicons PointingRight05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingRight05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingRight06Icon
 * @description Renders hugeicons PointingRight06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingRight06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingRight07Icon
 * @description Renders hugeicons PointingRight07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingRight07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PointingRight08Icon
 * @description Renders hugeicons PointingRight08Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PointingRight08Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PokeballIcon
 * @description Renders hugeicons PokeballIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PokeballIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PokemonIcon
 * @description Renders hugeicons PokemonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PokemonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoliceBadgeIcon
 * @description Renders hugeicons PoliceBadgeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoliceBadgeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoliceCapIcon
 * @description Renders hugeicons PoliceCapIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoliceCapIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoliceCarIcon
 * @description Renders hugeicons PoliceCarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoliceCarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoliceStationIcon
 * @description Renders hugeicons PoliceStationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoliceStationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PolicyIcon
 * @description Renders hugeicons PolicyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PolicyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PolygonIcon
 * @description Renders hugeicons PolygonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PolygonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoolIcon
 * @description Renders hugeicons PoolIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoolIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoolTableIcon
 * @description Renders hugeicons PoolTableIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoolTableIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoopIcon
 * @description Renders hugeicons PoopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PopcornIcon
 * @description Renders hugeicons PopcornIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PopcornIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pot01Icon
 * @description Renders hugeicons Pot01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pot01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Pot02Icon
 * @description Renders hugeicons Pot02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Pot02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PotionIcon
 * @description Renders hugeicons PotionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PotionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoundIcon
 * @description Renders hugeicons PoundIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoundIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoundCircleIcon
 * @description Renders hugeicons PoundCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoundCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoundReceiveIcon
 * @description Renders hugeicons PoundReceiveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoundReceiveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoundSendIcon
 * @description Renders hugeicons PoundSendIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoundSendIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PoundSquareIcon
 * @description Renders hugeicons PoundSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PoundSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PowerServiceIcon
 * @description Renders hugeicons PowerServiceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PowerServiceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PowerSocket01Icon
 * @description Renders hugeicons PowerSocket01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PowerSocket01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PowerSocket02Icon
 * @description Renders hugeicons PowerSocket02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PowerSocket02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Ppt01Icon
 * @description Renders hugeicons Ppt01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Ppt01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Ppt02Icon
 * @description Renders hugeicons Ppt02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Ppt02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrawnIcon
 * @description Renders hugeicons PrawnIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrawnIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrayerRug01Icon
 * @description Renders hugeicons PrayerRug01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrayerRug01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrayerRug02Icon
 * @description Renders hugeicons PrayerRug02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrayerRug02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PreferenceHorizontalIcon
 * @description Renders hugeicons PreferenceHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PreferenceHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PreferenceVerticalIcon
 * @description Renders hugeicons PreferenceVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PreferenceVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrescriptionIcon
 * @description Renders hugeicons PrescriptionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrescriptionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Presentation01Icon
 * @description Renders hugeicons Presentation01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Presentation01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Presentation02Icon
 * @description Renders hugeicons Presentation02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Presentation02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Presentation03Icon
 * @description Renders hugeicons Presentation03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Presentation03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Presentation04Icon
 * @description Renders hugeicons Presentation04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Presentation04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Presentation05Icon
 * @description Renders hugeicons Presentation05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Presentation05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Presentation06Icon
 * @description Renders hugeicons Presentation06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Presentation06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Presentation07Icon
 * @description Renders hugeicons Presentation07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Presentation07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PresentationBarChart01Icon
 * @description Renders hugeicons PresentationBarChart01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PresentationBarChart01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PresentationBarChart02Icon
 * @description Renders hugeicons PresentationBarChart02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PresentationBarChart02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PresentationLineChart01Icon
 * @description Renders hugeicons PresentationLineChart01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PresentationLineChart01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PresentationLineChart02Icon
 * @description Renders hugeicons PresentationLineChart02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PresentationLineChart02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PresentationOnlineIcon
 * @description Renders hugeicons PresentationOnlineIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PresentationOnlineIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PresentationPodiumIcon
 * @description Renders hugeicons PresentationPodiumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PresentationPodiumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PreviousIcon
 * @description Renders hugeicons PreviousIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PreviousIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrinterIcon
 * @description Renders hugeicons PrinterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrinterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrinterOffIcon
 * @description Renders hugeicons PrinterOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrinterOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Prism01Icon
 * @description Renders hugeicons Prism01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Prism01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrismIcon
 * @description Renders hugeicons PrismIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrismIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrisonIcon
 * @description Renders hugeicons PrisonIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrisonIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrisonGuardIcon
 * @description Renders hugeicons PrisonGuardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrisonGuardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PrisonerIcon
 * @description Renders hugeicons PrisonerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PrisonerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ProductLoadingIcon
 * @description Renders hugeicons ProductLoadingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ProductLoadingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Profile02Icon
 * @description Renders hugeicons Profile02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Profile02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ProfileIcon
 * @description Renders hugeicons ProfileIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ProfileIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ProfitIcon
 * @description Renders hugeicons ProfitIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ProfitIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ProgrammingFlagIcon
 * @description Renders hugeicons ProgrammingFlagIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ProgrammingFlagIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Projector01Icon
 * @description Renders hugeicons Projector01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Projector01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ProjectorIcon
 * @description Renders hugeicons ProjectorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ProjectorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PromotionIcon
 * @description Renders hugeicons PromotionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PromotionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PropertyAddIcon
 * @description Renders hugeicons PropertyAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PropertyAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PropertyDeleteIcon
 * @description Renders hugeicons PropertyDeleteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PropertyDeleteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PropertyEditIcon
 * @description Renders hugeicons PropertyEditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PropertyEditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PropertyNewIcon
 * @description Renders hugeicons PropertyNewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PropertyNewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PropertySearchIcon
 * @description Renders hugeicons PropertySearchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PropertySearchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PropertyViewIcon
 * @description Renders hugeicons PropertyViewIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PropertyViewIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ProtectionMaskIcon
 * @description Renders hugeicons ProtectionMaskIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ProtectionMaskIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PulleyIcon
 * @description Renders hugeicons PulleyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PulleyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PumpkinIcon
 * @description Renders hugeicons PumpkinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PumpkinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PunchIcon
 * @description Renders hugeicons PunchIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PunchIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PunchingBall01Icon
 * @description Renders hugeicons PunchingBall01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PunchingBall01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PunchingBall02Icon
 * @description Renders hugeicons PunchingBall02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PunchingBall02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Purse01Icon
 * @description Renders hugeicons Purse01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Purse01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PurseIcon
 * @description Renders hugeicons PurseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PurseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PushUpBarIcon
 * @description Renders hugeicons PushUpBarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PushUpBarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PuzzleIcon
 * @description Renders hugeicons PuzzleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PuzzleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PyramidIcon
 * @description Renders hugeicons PyramidIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PyramidIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PyramidMaslowoIcon
 * @description Renders hugeicons PyramidMaslowoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PyramidMaslowoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PyramidStructure01Icon
 * @description Renders hugeicons PyramidStructure01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PyramidStructure01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name PyramidStructure02Icon
 * @description Renders hugeicons PyramidStructure02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const PyramidStructure02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QqPlotIcon
 * @description Renders hugeicons QqPlotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QqPlotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QrCode01Icon
 * @description Renders hugeicons QrCode01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QrCode01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QrCodeIcon
 * @description Renders hugeicons QrCodeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QrCodeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuestionIcon
 * @description Renders hugeicons QuestionIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuestionIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Queue01Icon
 * @description Renders hugeicons Queue01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Queue01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Queue02Icon
 * @description Renders hugeicons Queue02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Queue02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuillWrite01Icon
 * @description Renders hugeicons QuillWrite01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuillWrite01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuillWrite02Icon
 * @description Renders hugeicons QuillWrite02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuillWrite02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuoraIcon
 * @description Renders hugeicons QuoraIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuoraIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuoteDownIcon
 * @description Renders hugeicons QuoteDownIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuoteDownIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuoteDownCircleIcon
 * @description Renders hugeicons QuoteDownCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuoteDownCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuoteDownSquareIcon
 * @description Renders hugeicons QuoteDownSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuoteDownSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuoteUpIcon
 * @description Renders hugeicons QuoteUpIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuoteUpIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuoteUpCircleIcon
 * @description Renders hugeicons QuoteUpCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuoteUpCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name QuoteUpSquareIcon
 * @description Renders hugeicons QuoteUpSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const QuoteUpSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Quran01Icon
 * @description Renders hugeicons Quran01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Quran01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Quran02Icon
 * @description Renders hugeicons Quran02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Quran02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Quran03Icon
 * @description Renders hugeicons Quran03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Quran03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RacingFlagIcon
 * @description Renders hugeicons RacingFlagIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RacingFlagIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Radar01Icon
 * @description Renders hugeicons Radar01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Radar01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Radar02Icon
 * @description Renders hugeicons Radar02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Radar02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RadialIcon
 * @description Renders hugeicons RadialIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RadialIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Radio01Icon
 * @description Renders hugeicons Radio01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Radio01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Radio02Icon
 * @description Renders hugeicons Radio02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Radio02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RadioIcon
 * @description Renders hugeicons RadioIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RadioIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RadioactiveAlertIcon
 * @description Renders hugeicons RadioactiveAlertIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RadioactiveAlertIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RadiusIcon
 * @description Renders hugeicons RadiusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RadiusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RainIcon
 * @description Renders hugeicons RainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RainDoubleDropIcon
 * @description Renders hugeicons RainDoubleDropIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RainDoubleDropIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RainDropIcon
 * @description Renders hugeicons RainDropIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RainDropIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RainbowIcon
 * @description Renders hugeicons RainbowIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RainbowIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Ramadhan01Icon
 * @description Renders hugeicons Ramadhan01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Ramadhan01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Ramadhan02Icon
 * @description Renders hugeicons Ramadhan02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Ramadhan02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RamadhanMonthIcon
 * @description Renders hugeicons RamadhanMonthIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RamadhanMonthIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RankingIcon
 * @description Renders hugeicons RankingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RankingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Raw01Icon
 * @description Renders hugeicons Raw01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Raw01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Raw02Icon
 * @description Renders hugeicons Raw02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Raw02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ReIcon
 * @description Renders hugeicons ReIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ReIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ReactIcon
 * @description Renders hugeicons ReactIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ReactIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RealEstate01Icon
 * @description Renders hugeicons RealEstate01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RealEstate01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RealEstate02Icon
 * @description Renders hugeicons RealEstate02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RealEstate02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RecordIcon
 * @description Renders hugeicons RecordIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RecordIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Rectangular01Icon
 * @description Renders hugeicons Rectangular01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Rectangular01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RectangularIcon
 * @description Renders hugeicons RectangularIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RectangularIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Recycle01Icon
 * @description Renders hugeicons Recycle01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Recycle01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Recycle02Icon
 * @description Renders hugeicons Recycle02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Recycle02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Recycle03Icon
 * @description Renders hugeicons Recycle03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Recycle03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RedditIcon
 * @description Renders hugeicons RedditIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RedditIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ReflexIcon
 * @description Renders hugeicons ReflexIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ReflexIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RefreshIcon
 * @description Renders hugeicons RefreshIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RefreshIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RefrigeratorIcon
 * @description Renders hugeicons RefrigeratorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RefrigeratorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RegisterIcon
 * @description Renders hugeicons RegisterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RegisterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RegisteredIcon
 * @description Renders hugeicons RegisteredIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RegisteredIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Relieved01Icon
 * @description Renders hugeicons Relieved01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Relieved01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Relieved02Icon
 * @description Renders hugeicons Relieved02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Relieved02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ReloadIcon
 * @description Renders hugeicons ReloadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ReloadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ReminderIcon
 * @description Renders hugeicons ReminderIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ReminderIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RemoteControlIcon
 * @description Renders hugeicons RemoteControlIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RemoteControlIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Remove01Icon
 * @description Renders hugeicons Remove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Remove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Remove02Icon
 * @description Renders hugeicons Remove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Remove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RemoveCircleIcon
 * @description Renders hugeicons RemoveCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RemoveCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RemoveCircleHalfDotIcon
 * @description Renders hugeicons RemoveCircleHalfDotIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RemoveCircleHalfDotIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RemovePiIcon
 * @description Renders hugeicons RemovePiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RemovePiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RemoveSquareIcon
 * @description Renders hugeicons RemoveSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RemoveSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RenewableEnergy01Icon
 * @description Renders hugeicons RenewableEnergy01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RenewableEnergy01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RenewableEnergyIcon
 * @description Renders hugeicons RenewableEnergyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RenewableEnergyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RepeatIcon
 * @description Renders hugeicons RepeatIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RepeatIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RepeatOffIcon
 * @description Renders hugeicons RepeatOffIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RepeatOffIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RepeatOne01Icon
 * @description Renders hugeicons RepeatOne01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RepeatOne01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RepeatOne02Icon
 * @description Renders hugeicons RepeatOne02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RepeatOne02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RepositoryIcon
 * @description Renders hugeicons RepositoryIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RepositoryIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Resize01Icon
 * @description Renders hugeicons Resize01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Resize01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Resize02Icon
 * @description Renders hugeicons Resize02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Resize02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ResourcesAddIcon
 * @description Renders hugeicons ResourcesAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ResourcesAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ResourcesRemoveIcon
 * @description Renders hugeicons ResourcesRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ResourcesRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RestoreBinIcon
 * @description Renders hugeicons RestoreBinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RestoreBinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Rhombus01Icon
 * @description Renders hugeicons Rhombus01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Rhombus01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RhombusIcon
 * @description Renders hugeicons RhombusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RhombusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RiceBowl01Icon
 * @description Renders hugeicons RiceBowl01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RiceBowl01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RiceBowl02Icon
 * @description Renders hugeicons RiceBowl02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RiceBowl02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RightAngleIcon
 * @description Renders hugeicons RightAngleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RightAngleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RightToLeftBlockQuoteIcon
 * @description Renders hugeicons RightToLeftBlockQuoteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RightToLeftBlockQuoteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RightToLeftListBulletIcon
 * @description Renders hugeicons RightToLeftListBulletIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RightToLeftListBulletIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RightToLeftListDashIcon
 * @description Renders hugeicons RightToLeftListDashIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RightToLeftListDashIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RightToLeftListNumberIcon
 * @description Renders hugeicons RightToLeftListNumberIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RightToLeftListNumberIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RightToLeftListTriangleIcon
 * @description Renders hugeicons RightToLeftListTriangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RightToLeftListTriangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RightTriangleIcon
 * @description Renders hugeicons RightTriangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RightTriangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RippleIcon
 * @description Renders hugeicons RippleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RippleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Road01Icon
 * @description Renders hugeicons Road01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Road01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Road02Icon
 * @description Renders hugeicons Road02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Road02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RoadIcon
 * @description Renders hugeicons RoadIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RoadIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RoadLocation01Icon
 * @description Renders hugeicons RoadLocation01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RoadLocation01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RoadLocation02Icon
 * @description Renders hugeicons RoadLocation02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RoadLocation02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RoadWaysideIcon
 * @description Renders hugeicons RoadWaysideIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RoadWaysideIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RoboticIcon
 * @description Renders hugeicons RoboticIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RoboticIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Rocket01Icon
 * @description Renders hugeicons Rocket01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Rocket01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Rocket02Icon
 * @description Renders hugeicons Rocket02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Rocket02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RocketIcon
 * @description Renders hugeicons RocketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RocketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RockingChairIcon
 * @description Renders hugeicons RockingChairIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RockingChairIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RollerSkateIcon
 * @description Renders hugeicons RollerSkateIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RollerSkateIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RollingPinIcon
 * @description Renders hugeicons RollingPinIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RollingPinIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Root01Icon
 * @description Renders hugeicons Root01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Root01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Root02Icon
 * @description Renders hugeicons Root02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Root02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RootFirstBracketIcon
 * @description Renders hugeicons RootFirstBracketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RootFirstBracketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RootFirstBrecketIcon
 * @description Renders hugeicons RootFirstBrecketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RootFirstBrecketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RootSecondBracketIcon
 * @description Renders hugeicons RootSecondBracketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RootSecondBracketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RootSecondBrecketIcon
 * @description Renders hugeicons RootSecondBrecketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RootSecondBrecketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RootThirdBracketIcon
 * @description Renders hugeicons RootThirdBracketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RootThirdBracketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RootThirdBrecketIcon
 * @description Renders hugeicons RootThirdBrecketIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RootThirdBrecketIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RootCircleIcon
 * @description Renders hugeicons RootCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RootCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Rotate01Icon
 * @description Renders hugeicons Rotate01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Rotate01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Rotate02Icon
 * @description Renders hugeicons Rotate02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Rotate02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Rotate360Icon
 * @description Renders hugeicons Rotate360Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Rotate360Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateBottomLeftIcon
 * @description Renders hugeicons RotateBottomLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateBottomLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateBottomRightIcon
 * @description Renders hugeicons RotateBottomRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateBottomRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateClockwiseIcon
 * @description Renders hugeicons RotateClockwiseIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateClockwiseIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateCropIcon
 * @description Renders hugeicons RotateCropIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateCropIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateLeft01Icon
 * @description Renders hugeicons RotateLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateLeft02Icon
 * @description Renders hugeicons RotateLeft02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateLeft02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateLeft03Icon
 * @description Renders hugeicons RotateLeft03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateLeft03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateLeft04Icon
 * @description Renders hugeicons RotateLeft04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateLeft04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateLeft05Icon
 * @description Renders hugeicons RotateLeft05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateLeft05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateLeft06Icon
 * @description Renders hugeicons RotateLeft06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateLeft06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateRight01Icon
 * @description Renders hugeicons RotateRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateRight02Icon
 * @description Renders hugeicons RotateRight02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateRight02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateRight03Icon
 * @description Renders hugeicons RotateRight03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateRight03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateRight04Icon
 * @description Renders hugeicons RotateRight04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateRight04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateRight05Icon
 * @description Renders hugeicons RotateRight05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateRight05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateRight06Icon
 * @description Renders hugeicons RotateRight06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateRight06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateSquareIcon
 * @description Renders hugeicons RotateSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateTopLeftIcon
 * @description Renders hugeicons RotateTopLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateTopLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RotateTopRightIcon
 * @description Renders hugeicons RotateTopRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RotateTopRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Route01Icon
 * @description Renders hugeicons Route01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Route01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Route02Icon
 * @description Renders hugeicons Route02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Route02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Route03Icon
 * @description Renders hugeicons Route03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Route03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RouteBlockIcon
 * @description Renders hugeicons RouteBlockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RouteBlockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Router01Icon
 * @description Renders hugeicons Router01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Router01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Router02Icon
 * @description Renders hugeicons Router02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Router02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RouterIcon
 * @description Renders hugeicons RouterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RouterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RowDeleteIcon
 * @description Renders hugeicons RowDeleteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RowDeleteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RowInsertIcon
 * @description Renders hugeicons RowInsertIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RowInsertIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RssIcon
 * @description Renders hugeicons RssIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RssIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RssConnected01Icon
 * @description Renders hugeicons RssConnected01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RssConnected01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RssConnected02Icon
 * @description Renders hugeicons RssConnected02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RssConnected02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RssErrorIcon
 * @description Renders hugeicons RssErrorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RssErrorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RssLockedIcon
 * @description Renders hugeicons RssLockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RssLockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RssUnlockedIcon
 * @description Renders hugeicons RssUnlockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RssUnlockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RubElHizbIcon
 * @description Renders hugeicons RubElHizbIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RubElHizbIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RukuIcon
 * @description Renders hugeicons RukuIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RukuIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RulerIcon
 * @description Renders hugeicons RulerIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RulerIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name RunningShoesIcon
 * @description Renders hugeicons RunningShoesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const RunningShoesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Sad01Icon
 * @description Renders hugeicons Sad01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Sad01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Sad02Icon
 * @description Renders hugeicons Sad02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Sad02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SadDizzyIcon
 * @description Renders hugeicons SadDizzyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SadDizzyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SafariIcon
 * @description Renders hugeicons SafariIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SafariIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SafeIcon
 * @description Renders hugeicons SafeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SafeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SafeDelivery01Icon
 * @description Renders hugeicons SafeDelivery01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SafeDelivery01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SafeDelivery02Icon
 * @description Renders hugeicons SafeDelivery02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SafeDelivery02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SafetyPin01Icon
 * @description Renders hugeicons SafetyPin01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SafetyPin01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SafetyPin02Icon
 * @description Renders hugeicons SafetyPin02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SafetyPin02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SailboatCoastalIcon
 * @description Renders hugeicons SailboatCoastalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SailboatCoastalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SailboatOffshoreIcon
 * @description Renders hugeicons SailboatOffshoreIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SailboatOffshoreIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SalahIcon
 * @description Renders hugeicons SalahIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SalahIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SalahTimeIcon
 * @description Renders hugeicons SalahTimeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SalahTimeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SaleTag01Icon
 * @description Renders hugeicons SaleTag01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SaleTag01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SaleTag02Icon
 * @description Renders hugeicons SaleTag02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SaleTag02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SandalsIcon
 * @description Renders hugeicons SandalsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SandalsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Satellite01Icon
 * @description Renders hugeicons Satellite01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Satellite01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Satellite02Icon
 * @description Renders hugeicons Satellite02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Satellite02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Satellite03Icon
 * @description Renders hugeicons Satellite03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Satellite03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SatelliteIcon
 * @description Renders hugeicons SatelliteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SatelliteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Saturn01Icon
 * @description Renders hugeicons Saturn01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Saturn01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Saturn02Icon
 * @description Renders hugeicons Saturn02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Saturn02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SaturnIcon
 * @description Renders hugeicons SaturnIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SaturnIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SausageIcon
 * @description Renders hugeicons SausageIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SausageIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SaveEnergy01Icon
 * @description Renders hugeicons SaveEnergy01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SaveEnergy01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SaveEnergy02Icon
 * @description Renders hugeicons SaveEnergy02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SaveEnergy02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SchemeIcon
 * @description Renders hugeicons SchemeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SchemeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name School01Icon
 * @description Renders hugeicons School01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const School01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SchoolBell01Icon
 * @description Renders hugeicons SchoolBell01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SchoolBell01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SchoolBell02Icon
 * @description Renders hugeicons SchoolBell02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SchoolBell02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SchoolIcon
 * @description Renders hugeicons SchoolIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SchoolIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SchoolBusIcon
 * @description Renders hugeicons SchoolBusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SchoolBusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SchoolReportCardIcon
 * @description Renders hugeicons SchoolReportCardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SchoolReportCardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SchoolTieIcon
 * @description Renders hugeicons SchoolTieIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SchoolTieIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Scissor01Icon
 * @description Renders hugeicons Scissor01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Scissor01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScissorIcon
 * @description Renders hugeicons ScissorIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScissorIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScissorRectangleIcon
 * @description Renders hugeicons ScissorRectangleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScissorRectangleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Scooter01Icon
 * @description Renders hugeicons Scooter01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Scooter01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Scooter02Icon
 * @description Renders hugeicons Scooter02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Scooter02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Scooter03Icon
 * @description Renders hugeicons Scooter03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Scooter03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Scooter04Icon
 * @description Renders hugeicons Scooter04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Scooter04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScooterElectricIcon
 * @description Renders hugeicons ScooterElectricIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScooterElectricIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScreenAddToHomeIcon
 * @description Renders hugeicons ScreenAddToHomeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScreenAddToHomeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScreenLockRotationIcon
 * @description Renders hugeicons ScreenLockRotationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScreenLockRotationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScreenRotationIcon
 * @description Renders hugeicons ScreenRotationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScreenRotationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScribdIcon
 * @description Renders hugeicons ScribdIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScribdIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScrollIcon
 * @description Renders hugeicons ScrollIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScrollIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScrollHorizontalIcon
 * @description Renders hugeicons ScrollHorizontalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScrollHorizontalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ScrollVerticalIcon
 * @description Renders hugeicons ScrollVerticalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ScrollVerticalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SdCardIcon
 * @description Renders hugeicons SdCardIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SdCardIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SealIcon
 * @description Renders hugeicons SealIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SealIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Search01Icon
 * @description Renders hugeicons Search01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Search01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Search02Icon
 * @description Renders hugeicons Search02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Search02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchAddIcon
 * @description Renders hugeicons SearchAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchAreaIcon
 * @description Renders hugeicons SearchAreaIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchAreaIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchCircleIcon
 * @description Renders hugeicons SearchCircleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchCircleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchDollarIcon
 * @description Renders hugeicons SearchDollarIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchDollarIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchFocusIcon
 * @description Renders hugeicons SearchFocusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchFocusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchList01Icon
 * @description Renders hugeicons SearchList01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchList01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchList02Icon
 * @description Renders hugeicons SearchList02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchList02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchMinusIcon
 * @description Renders hugeicons SearchMinusIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchMinusIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchRemoveIcon
 * @description Renders hugeicons SearchRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchReplaceIcon
 * @description Renders hugeicons SearchReplaceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchReplaceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchSquareIcon
 * @description Renders hugeicons SearchSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchVisualIcon
 * @description Renders hugeicons SearchVisualIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchVisualIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SearchingIcon
 * @description Renders hugeicons SearchingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SearchingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecuredNetworkIcon
 * @description Renders hugeicons SecuredNetworkIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecuredNetworkIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecurityBlockIcon
 * @description Renders hugeicons SecurityBlockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecurityBlockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecurityIcon
 * @description Renders hugeicons SecurityIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecurityIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecurityCheckIcon
 * @description Renders hugeicons SecurityCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecurityCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecurityLockIcon
 * @description Renders hugeicons SecurityLockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecurityLockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecurityPasswordIcon
 * @description Renders hugeicons SecurityPasswordIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecurityPasswordIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecurityValidationIcon
 * @description Renders hugeicons SecurityValidationIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecurityValidationIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SecurityWifiIcon
 * @description Renders hugeicons SecurityWifiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SecurityWifiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SegmentIcon
 * @description Renders hugeicons SegmentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SegmentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Select01Icon
 * @description Renders hugeicons Select01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Select01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Select02Icon
 * @description Renders hugeicons Select02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Select02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SendToMobileIcon
 * @description Renders hugeicons SendToMobileIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SendToMobileIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SenselessIcon
 * @description Renders hugeicons SenselessIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SenselessIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SentIcon
 * @description Renders hugeicons SentIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SentIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SeoIcon
 * @description Renders hugeicons SeoIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SeoIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ServiceIcon
 * @description Renders hugeicons ServiceIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ServiceIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Setting06Icon
 * @description Renders hugeicons Setting06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Setting06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Setting07Icon
 * @description Renders hugeicons Setting07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Setting07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SettingDone01Icon
 * @description Renders hugeicons SettingDone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SettingDone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SettingDone02Icon
 * @description Renders hugeicons SettingDone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SettingDone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SettingDone03Icon
 * @description Renders hugeicons SettingDone03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SettingDone03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SettingDone04Icon
 * @description Renders hugeicons SettingDone04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SettingDone04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SettingError03Icon
 * @description Renders hugeicons SettingError03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SettingError03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SettingError04Icon
 * @description Renders hugeicons SettingError04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SettingError04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Settings01Icon
 * @description Renders hugeicons Settings01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Settings01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Settings02Icon
 * @description Renders hugeicons Settings02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Settings02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Settings03Icon
 * @description Renders hugeicons Settings03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Settings03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Settings04Icon
 * @description Renders hugeicons Settings04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Settings04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Settings05Icon
 * @description Renders hugeicons Settings05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Settings05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SettingsError01Icon
 * @description Renders hugeicons SettingsError01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SettingsError01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SettingsError02Icon
 * @description Renders hugeicons SettingsError02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SettingsError02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Setup01Icon
 * @description Renders hugeicons Setup01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Setup01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Setup02Icon
 * @description Renders hugeicons Setup02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Setup02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Shaka01Icon
 * @description Renders hugeicons Shaka01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Shaka01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Shaka02Icon
 * @description Renders hugeicons Shaka02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Shaka02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Shaka03Icon
 * @description Renders hugeicons Shaka03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Shaka03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Shaka04Icon
 * @description Renders hugeicons Shaka04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Shaka04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShampooIcon
 * @description Renders hugeicons ShampooIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShampooIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShapesIcon
 * @description Renders hugeicons ShapesIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShapesIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Share01Icon
 * @description Renders hugeicons Share01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Share01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Share02Icon
 * @description Renders hugeicons Share02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Share02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Share03Icon
 * @description Renders hugeicons Share03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Share03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Share04Icon
 * @description Renders hugeicons Share04Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Share04Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Share05Icon
 * @description Renders hugeicons Share05Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Share05Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Share06Icon
 * @description Renders hugeicons Share06Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Share06Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Share07Icon
 * @description Renders hugeicons Share07Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Share07Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Share08Icon
 * @description Renders hugeicons Share08Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Share08Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShareKnowledgeIcon
 * @description Renders hugeicons ShareKnowledgeIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShareKnowledgeIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShareLocation01Icon
 * @description Renders hugeicons ShareLocation01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShareLocation01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShareLocation02Icon
 * @description Renders hugeicons ShareLocation02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShareLocation02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SharedWifiIcon
 * @description Renders hugeicons SharedWifiIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SharedWifiIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SharingIcon
 * @description Renders hugeicons SharingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SharingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShellfishIcon
 * @description Renders hugeicons ShellfishIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShellfishIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Sheriff01Icon
 * @description Renders hugeicons Sheriff01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Sheriff01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Sheriff02Icon
 * @description Renders hugeicons Sheriff02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Sheriff02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShieldBlockchainIcon
 * @description Renders hugeicons ShieldBlockchainIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShieldBlockchainIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShieldEnergyIcon
 * @description Renders hugeicons ShieldEnergyIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShieldEnergyIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShipmentTrackingIcon
 * @description Renders hugeicons ShipmentTrackingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShipmentTrackingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShippingCenterIcon
 * @description Renders hugeicons ShippingCenterIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShippingCenterIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShippingLoadingIcon
 * @description Renders hugeicons ShippingLoadingIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShippingLoadingIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShippingTruck01Icon
 * @description Renders hugeicons ShippingTruck01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShippingTruck01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShippingTruck02Icon
 * @description Renders hugeicons ShippingTruck02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShippingTruck02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name Shirt01Icon
 * @description Renders hugeicons Shirt01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const Shirt01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShockedIcon
 * @description Renders hugeicons ShockedIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShockedIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShopSignIcon
 * @description Renders hugeicons ShopSignIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShopSignIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBag01Icon
 * @description Renders hugeicons ShoppingBag01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBag01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBag02Icon
 * @description Renders hugeicons ShoppingBag02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBag02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBag03Icon
 * @description Renders hugeicons ShoppingBag03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBag03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBagAddIcon
 * @description Renders hugeicons ShoppingBagAddIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBagAddIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBagCheckIcon
 * @description Renders hugeicons ShoppingBagCheckIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBagCheckIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBagFavoriteIcon
 * @description Renders hugeicons ShoppingBagFavoriteIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBagFavoriteIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBagRemoveIcon
 * @description Renders hugeicons ShoppingBagRemoveIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBagRemoveIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasket01Icon
 * @description Renders hugeicons ShoppingBasket01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasket01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasket02Icon
 * @description Renders hugeicons ShoppingBasket02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasket02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasket03Icon
 * @description Renders hugeicons ShoppingBasket03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasket03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketAdd01Icon
 * @description Renders hugeicons ShoppingBasketAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketAdd02Icon
 * @description Renders hugeicons ShoppingBasketAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketAdd03Icon
 * @description Renders hugeicons ShoppingBasketAdd03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketAdd03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketCheckIn01Icon
 * @description Renders hugeicons ShoppingBasketCheckIn01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketCheckIn01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketCheckIn02Icon
 * @description Renders hugeicons ShoppingBasketCheckIn02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketCheckIn02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketCheckIn03Icon
 * @description Renders hugeicons ShoppingBasketCheckIn03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketCheckIn03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketCheckOut01Icon
 * @description Renders hugeicons ShoppingBasketCheckOut01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketCheckOut01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketCheckOut02Icon
 * @description Renders hugeicons ShoppingBasketCheckOut02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketCheckOut02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketCheckOut03Icon
 * @description Renders hugeicons ShoppingBasketCheckOut03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketCheckOut03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketDone01Icon
 * @description Renders hugeicons ShoppingBasketDone01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketDone01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketDone02Icon
 * @description Renders hugeicons ShoppingBasketDone02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketDone02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketDone03Icon
 * @description Renders hugeicons ShoppingBasketDone03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketDone03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketFavorite01Icon
 * @description Renders hugeicons ShoppingBasketFavorite01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketFavorite01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketFavorite02Icon
 * @description Renders hugeicons ShoppingBasketFavorite02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketFavorite02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketFavorite03Icon
 * @description Renders hugeicons ShoppingBasketFavorite03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketFavorite03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketRemove01Icon
 * @description Renders hugeicons ShoppingBasketRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketRemove02Icon
 * @description Renders hugeicons ShoppingBasketRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketRemove03Icon
 * @description Renders hugeicons ShoppingBasketRemove03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketRemove03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketSecure01Icon
 * @description Renders hugeicons ShoppingBasketSecure01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketSecure01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketSecure02Icon
 * @description Renders hugeicons ShoppingBasketSecure02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketSecure02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingBasketSecure03Icon
 * @description Renders hugeicons ShoppingBasketSecure03Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingBasketSecure03Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCart01Icon
 * @description Renders hugeicons ShoppingCart01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCart01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCart02Icon
 * @description Renders hugeicons ShoppingCart02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCart02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartAdd01Icon
 * @description Renders hugeicons ShoppingCartAdd01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartAdd01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartAdd02Icon
 * @description Renders hugeicons ShoppingCartAdd02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartAdd02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartCheck01Icon
 * @description Renders hugeicons ShoppingCartCheck01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartCheck01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartCheck02Icon
 * @description Renders hugeicons ShoppingCartCheck02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartCheck02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartCheckIn01Icon
 * @description Renders hugeicons ShoppingCartCheckIn01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartCheckIn01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartCheckIn02Icon
 * @description Renders hugeicons ShoppingCartCheckIn02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartCheckIn02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartCheckOut01Icon
 * @description Renders hugeicons ShoppingCartCheckOut01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartCheckOut01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartCheckOut02Icon
 * @description Renders hugeicons ShoppingCartCheckOut02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartCheckOut02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartFavorite01Icon
 * @description Renders hugeicons ShoppingCartFavorite01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartFavorite01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartFavorite02Icon
 * @description Renders hugeicons ShoppingCartFavorite02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartFavorite02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartRemove01Icon
 * @description Renders hugeicons ShoppingCartRemove01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartRemove01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShoppingCartRemove02Icon
 * @description Renders hugeicons ShoppingCartRemove02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShoppingCartRemove02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShortsPantsIcon
 * @description Renders hugeicons ShortsPantsIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShortsPantsIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShuffleIcon
 * @description Renders hugeicons ShuffleIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShuffleIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShuffleSquareIcon
 * @description Renders hugeicons ShuffleSquareIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShuffleSquareIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name ShutterstockIcon
 * @description Renders hugeicons ShutterstockIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const ShutterstockIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SidebarBottomIcon
 * @description Renders hugeicons SidebarBottomIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SidebarBottomIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SidebarLeft01Icon
 * @description Renders hugeicons SidebarLeft01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SidebarLeft01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SidebarLeftIcon
 * @description Renders hugeicons SidebarLeftIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SidebarLeftIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SidebarRight01Icon
 * @description Renders hugeicons SidebarRight01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SidebarRight01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SidebarRightIcon
 * @description Renders hugeicons SidebarRightIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SidebarRightIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SidebarTopIcon
 * @description Renders hugeicons SidebarTopIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SidebarTopIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignLanguageCIcon
 * @description Renders hugeicons SignLanguageCIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SignLanguageCIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignalIcon
 * @description Renders hugeicons SignalIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SignalIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignalFull01Icon
 * @description Renders hugeicons SignalFull01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SignalFull01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignalFull02Icon
 * @description Renders hugeicons SignalFull02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SignalFull02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignalLow01Icon
 * @description Renders hugeicons SignalLow01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SignalLow01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignalLow02Icon
 * @description Renders hugeicons SignalLow02Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SignalLow02Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignalLowMediumIcon
 * @description Renders hugeicons SignalLowMediumIcon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SignalLowMediumIcon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignalMedium01Icon
 * @description Renders hugeicons SignalMedium01Icon svg element
 *
 * @param {Object} props - Hugeicons props and any valid SVG attribute
 * @returns {JSX.Element} JSX Element
 */
declare const SignalMedium01Icon: react.FC<Omit<HugeiconsProps, "ref"> & react.RefAttributes<SVGSVGElement>>;

/**
 * @component @name SignalMedium02Icon
 * @description Rende