import React from 'react';
import { useInView } from 'react-intersection-observer';
import ProfileCard from './AboutUs';
import { textColor } from '../constant';

const cardClass = 'border border-zinc-300 bg-card p-6 text-center rounded-lg shadow-lg';
const textPrimaryClass = `text-primary ${textColor} text-3xl font-bold`;
const textMutedClass = 'text-muted-foreground text-gray-500';

const AboutMe = () => {
    const { ref, inView } = useInView({
        triggerOnce: true,
        threshold: 0.1,
    });

    return (
        <div
            id='about'
            ref={ref}
            className={`about ${inView ? 'animate__animated animate__backInLeft' : ''} w-[90%] md:w-[85%] lg:w-[80%] mx-auto`}
        >
            <ProfileCard />
            <div className="w-full grid grid-cols-1 md:grid-cols-2 p-6 lg:grid-cols-4 gap-6 mb-8">
                <Card value="13+" description="Happy Clients" />
                <Card value="07+" description="Projects Done" />
                <Card value="353+" description="Cups of Coffee" />
                <Card value="587+" description="Working Hours" />
            </div>
        </div>
    );
};

const Card = ({ value, description }) => {
    return (
        <div className={cardClass}>
            <p className={textPrimaryClass}>{value}</p>
            <p className={textMutedClass}>{description}</p>
        </div>
    );
};

export default AboutMe;



/*

const InfoRow = ({ title, value, isPrimary }) => {
    return (
        <div>
            <p className="font-semibold text-[#00d9ff]">{title}:</p>
            <p className={isPrimary ? 'text-primary text-gray-500' : 'text-gray-500'}>{value}</p>
        </div>
    );
};

const handleDownloadCV = () => {
        const downloadUrl = `https://example-portfolio-frontend.vercel.app/Cv.pdf`;
        const link = document.createElement('a');
        link.href = downloadUrl;
        link.download = 'cv.pdf';
        link.target = '_blank';

        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    };

 <div className="border border-zinc-300 bg-card p-8 rounded-lg shadow-lg">
                    <h2 className="text-secondary text-lg font-semibold mb-2">ABOUT ME</h2>
                    <h1 className="lg:text-3xl font-bold mb-4 text-[#00d9ff] sm:text-2xl">A MERN Stack & React Native Developer Based in Pakistan</h1>
                    <p className="text-muted-foreground mb-6 text-gray-500">I craft captivating digital experiences through thoughtful design and skilled development, aiming to inspire and engage users worldwide. By blending creativity with cutting-edge technology, I bring innovative visions to life and create lasting impacts.</p>
                    <div className="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <InfoRow title="Name" value="Luqman Ahmad" />
                        <InfoRow title="Zip code" value="5400" />
                        <InfoRow title="Date of birth" value="January 01, 1999" />
                        <InfoRow title="Email" value="Ayubluqman713@gmail.com" isPrimary />
                        <InfoRow title="Address" value="Lahore Punjab, Pakistan" />
                        <InfoRow title="Phone" value="+92303-4423713" isPrimary />
                    </div>
                    <button className="bg-primary bg-[#00d9ff] text-white text-primary-foreground px-6 py-3 rounded-lg hover:bg-gray-600" onClick={handleDownloadCV}>
                        DOWNLOAD CV
                    </button>
                </div>

 */