import React, { useEffect, useState } from 'react';
import axios from 'axios';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faSearch } from '@fortawesome/free-solid-svg-icons';
import { onlyColor } from '../constant';

const ChatBot = ({ propmt }) => {
  const [inputValue, setInputValue] = useState('');
  const [messages, setMessages] = useState([]);

  const messageStyles = {
    user: {
      backgroundColor: '#f0f0f0',
      color: onlyColor,
    },
    bot: {
      backgroundColor: onlyColor,
      color: '#f0f0f0',
    },
  };

  const handleInputChange = (e) => {
    setInputValue(e.target.value);
  };

  const handleKeyDown = (e) => {
    if (e.key === 'Enter') {
      handleAsk();
    }
  };

  const handleAsk = async () => {
    if (inputValue.trim() === '') return;
    try {
      const response = await axios.post('https://example-portfolio-tau.vercel.app/api/gemini/call-gemini', { prompt: inputValue });
      const botResponse = response.data.message;
      setMessages((prevMessages) => [
        { text: botResponse, type: 'bot' },
        { text: inputValue, type: 'user' },
        ...prevMessages
      ]);
      setInputValue('');
    } catch (error) {
      console.error('Error fetching response:', error);
    }
  };

  useEffect(() => {
    if (propmt !== null) {
      setInputValue(propmt);
    }
  }, [propmt]);

  return (
    <div className="chat-container">
      <div className="relative flex items-center p-2">
        <input
          type="text"
          className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-1 text-zinc-500 focus:ring-zinc-500"
          placeholder="Search..."
          value={inputValue}
          onChange={handleInputChange}
          onKeyDown={handleKeyDown}
        />
        <FontAwesomeIcon
          icon={faSearch}
          className="absolute right-4 text-gray-500 cursor-pointer z-10"
          onClick={handleAsk}
        />
      </div>
      <div className="chat-area">
        {messages.map((message, index) => (
          <div key={index} className={`message-container ${message.type}`}>
            <span className="emoji">{message.type === 'user' ? '👤' : '🤖'}</span>
            <div
              className={`message ${message.type}`}
              style={messageStyles[message.type]}
            >
              {message.text}
            </div>
          </div>
        ))}
      </div>
    </div>
  );
};

export default ChatBot;
