import React,{useRef, useEffect} from 'react';
import ChatBot from './ChatBot';
import Typed from 'typed.js';
import { bgColor, Color, textColor, hoverTextColor, borderColor} from '../constant';

const buttonClass = `border ${borderColor} ${bgColor} text-white px-4 py-2 rounded-lg hover:bg-white ${hoverTextColor} transition`;

const TalkWithMe = () => {
    const typedElement = useRef(null);
  useEffect(() => {
    const typed = new Typed(typedElement.current, {
      strings: ['AI BOT'],
      typeSpeed: 100,
      backSpeed: 100,
      loop: true,
    });

    return () => {
      typed.destroy();
    };
  }, []);
    return (
        <div style={{width:"100%", margin:"auto"}} className="flex flex-col items-center justify-center border rounded-lg shadow-lg border-zinc-300 bg-white dark:bg-zinc-900 p-4">
            <h1 className="text-2xl md:text-4xl font-bold text-center mb-8">
                <span className={textColor}>TALK WITH ME</span> THROUGH MY <span className={textColor} ref={typedElement}></span>
            </h1>
            <div className="flex flex-wrap justify-center gap-4 mb-8">
                <button className={buttonClass}>
                    List down my skills
                </button>
                <button className={buttonClass}>
                    What is my qualification?
                </button>
                <button className={buttonClass}>
                    Tell me more about me
                </button>
            </div>
            <div className='flex items-center justify-center w-full gap-4 p-2'>
                <ChatBot/>
            </div>
        </div>
    );
};

export default TalkWithMe;
