import React, { useRef, useEffect, useState, } from 'react';
import Typed from 'typed.js';
import person from "../assets/7.png"
import { textColor, borderColor, hoverBgColor, bgColor, } from '../constant';
import ChatBot from './ChatBot';


const buttonClass = `h-16 border ${borderColor} bg-white ${textColor} px-4 py-2 rounded-lg ${hoverBgColor} hover:text-white transition`;
const cardClasses = 'p-4 bg-card w-full rounded-lg shadow-lg'


function ChatWithMe() {
    const typedElement = useRef(null);
    const [prompt, setPrompt] = useState(null);

    const handleClick = (text) => {
        setPrompt(text);
    }

    useEffect(() => {
        const typed = new Typed(typedElement.current, {
            strings: ['AI BOT'],
            typeSpeed: 100,
            backSpeed: 100,
            loop: true,
        });
        return () => {
            typed.destroy();
        };
    }, []);

    return (
        <div id='ai-bot' className='flex flex-col w-[100%] md:w-[90%] lg:w-[80%] m-auto items-center justify-center gap-2 mt-4'>
            <h1 className="text-4xl md:text-3xl lg:text-3xl md:text-4xl font-bold text-center mb-8">
                <span className={textColor}>TALK WITH ME</span> THROUGH MY <span className={textColor} ref={typedElement}></span>
            </h1>
            <div className='flex flex-col md:flex-row w-[100%] m-auto'>
                <div className='flex flex-col w-full md:w-[60%]'>
                    <div style={{ width: "100%", margin: "auto" }} className="flex flex-col items-center justify-center bg-white dark:bg-zinc-900 p-4">
                        <div className="flex flex-wrap justify-center gap-4 mb-8">
                            <button onClick={() => { handleClick('List down your skills') }} className={buttonClass}>
                                List down your skills
                            </button>
                            <button onClick={() => { handleClick(' What is your qualification?') }} className={buttonClass}>
                                What is your qualification?
                            </button>
                            <button onClick={() => { handleClick('Tell more about you') }} className={buttonClass}>
                                Tell more about you
                            </button>
                        </div>
                        <div className='flex items-center justify-center w-full gap-4 p-2'>
                            <div className={cardClasses}>
                                <ChatBot propmt={prompt} />
                            </div>
                        </div>
                    </div>
                </div>
                <div className="mb-6 w-[100%] mb:w-[40%] lg:w-[40%]">
                    <div className='relative w-full'>
                        <div className={`absolute inset-0 ${bgColor} bg-card shadow-lg h-[100%] w-[280px] rounded-t-full ml-[30%] md:ml-[30%] lg:ml-[25%] xl:ml-[30%] 2xl:ml-[32%]`}></div>
                        <img src={person} alt="Profile" className="relative z-10 w-[300px] mx-auto" />
                    </div>
                </div>
            </div>
        </div>
    );
}

export default ChatWithMe;
