import React, { useState } from 'react';
import axios from 'axios';
import { Email_API, bgColor, textColor } from '../constant';
import 'react-toastify/dist/ReactToastify.css';
import { toast } from 'react-toastify';

const accentColor = 'text-accent';
const zincColor = 'text-zinc-700';
const primaryColor = 'focus:ring-primary focus:border-primary';

const Address = "Penang- Bertam Kepala Batas, 13200";
const Mobile = "+60125626466";
const Email = "hippotechfast@gmail.com";

const ContactUs = () => {
    return (
        <div id='contact' className="flex items-center justify-center flex-col gap-4 w-[95%] md:w-[90%] lg:w-[80%] mx-auto my-12">
            <h2 className="text-4xl md:text-6xl lg:text-6xl font-extrabold"><span id='name-span'>Contact</span></h2>
            <div className="p-6 w-full flex flex-col md:flex-row justify-between">
                <ContactInfo />
                <SendMessageForm />
            </div>
        </div>
    );
};

const ContactInfo = () => {
    return (
        <div className="text-black space-y-6 md:w-1/2">
            <h2 className="text-4xl font-bold">Have a Project in mind? <span><h2 className={`text-4xl font-bold ${textColor}`}>Lets us Discuss it.</h2></span></h2>

            <div className="space-y-4">
                <ContactDetail svg={<svg className='mr-4' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width={36} height={36} color={"#000"} fill={"none"}>
                    <path d="M4.5 10C4.5 6.22876 4.5 4.34315 5.67157 3.17157C6.84315 2 8.72876 2 12.5 2H14C17.7712 2 19.6569 2 20.8284 3.17157C22 4.34315 22 6.22876 22 10V14C22 17.7712 22 19.6569 20.8284 20.8284C19.6569 22 17.7712 22 14 22H12.5C8.72876 22 6.84315 22 5.67157 20.8284C4.5 19.6569 4.5 17.7712 4.5 14V10Z" stroke="currentColor" strokeWidth="1.5" />
                    <path d="M15.25 10.0002V12.5002C15.25 13.3286 15.9216 14.0002 16.75 14.0002C17.5784 14.0002 18.25 13.3286 18.25 12.5002V12C18.25 9.23858 16.0114 7 13.25 7C10.4886 7 8.25 9.23858 8.25 12C8.25 14.7614 10.4886 17 13.25 17C14.3758 17 15.4147 16.6279 16.2505 16M15.25 12.0002C15.25 13.1048 14.3546 14.0002 13.25 14.0002C12.1454 14.0002 11.25 13.1048 11.25 12.0002C11.25 10.8956 12.1454 10.0002 13.25 10.0002C14.3546 10.0002 15.25 10.8956 15.25 12.0002Z" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" />
                    <path d="M4.5 6L2 6M4.5 12L2 12M4.5 18H2" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
                </svg>} title="Address" content={Address} />
                <ContactDetail svg={<svg className='mr-4' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width={36} height={36} color={"#000"} fill={"none"}>
                    <path d="M5 9C5 5.70017 5 4.05025 6.02513 3.02513C7.05025 2 8.70017 2 12 2C15.2998 2 16.9497 2 17.9749 3.02513C19 4.05025 19 5.70017 19 9V15C19 18.2998 19 19.9497 17.9749 20.9749C16.9497 22 15.2998 22 12 22C8.70017 22 7.05025 22 6.02513 20.9749C5 19.9497 5 18.2998 5 15V9Z" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" />
                    <path d="M11 19H13" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
                    <path d="M9 2L9.089 2.53402C9.28188 3.69129 9.37832 4.26993 9.77519 4.62204C10.1892 4.98934 10.7761 5 12 5C13.2239 5 13.8108 4.98934 14.2248 4.62204C14.6217 4.26993 14.7181 3.69129 14.911 2.53402L15 2" stroke="currentColor" strokeWidth="1.5" strokeLinejoin="round" />
                </svg>} title="Phone" content={Mobile} />
                <ContactDetail svg={<svg className='mr-4' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width={36} height={36} color={"#000"} fill={"none"}>
                    <path d="M2 6L8.91302 9.91697C11.4616 11.361 12.5384 11.361 15.087 9.91697L22 6" stroke="currentColor" strokeWidth="1.5" strokeLinejoin="round" />
                    <path d="M2.01577 13.4756C2.08114 16.5412 2.11383 18.0739 3.24496 19.2094C4.37608 20.3448 5.95033 20.3843 9.09883 20.4634C11.0393 20.5122 12.9607 20.5122 14.9012 20.4634C18.0497 20.3843 19.6239 20.3448 20.7551 19.2094C21.8862 18.0739 21.9189 16.5412 21.9842 13.4756C22.0053 12.4899 22.0053 11.5101 21.9842 10.5244C21.9189 7.45886 21.8862 5.92609 20.7551 4.79066C19.6239 3.65523 18.0497 3.61568 14.9012 3.53657C12.9607 3.48781 11.0393 3.48781 9.09882 3.53656C5.95033 3.61566 4.37608 3.65521 3.24495 4.79065C2.11382 5.92608 2.08114 7.45885 2.01576 10.5244C1.99474 11.5101 1.99475 12.4899 2.01577 13.4756Z" stroke="currentColor" strokeWidth="1.5" strokeLinejoin="round" />
                </svg>} title="Email" content={Email} />
            </div>
        </div>
    );
};

const ContactDetail = ({ svg, title, content }) => {
    return (
        <div className="flex items-center">
            {svg}
            <div>
                <h3 className={`text-lg font-semibold ${accentColor}`}>{title}</h3>
                <p className="text-sm text-zinc-500">{content}</p>
            </div>
        </div>
    );
};

const SendMessageForm = () => {
    const [name, setName] = useState('');
    const [email, setEmail] = useState('');
    const [message, setMessage] = useState('');
    const [isLoading, setIsLoading] = useState(false);

    const handleFormSubmit = (event) => {
        event.preventDefault();
        if (!name || !email || !message) {
            toast.warn('Please fill in all fields.')
            return;
        }
        const formData = {
            name: name,
            email: email,
            message: message
        };
        setIsLoading(true);
        axios.post(Email_API, formData)
            .then(response => {
                setIsLoading(false);
                toast.success('Message sent successfully!');
                setName('');
                setEmail('');
                setMessage('');
            })
            .catch(error => {
                setIsLoading(false);
                toast.error('Error sending message. Please try again later.');
                console.error('Error:', error);
            });
    };
    return (
        <div className="bg-zinc-100 p-8 rounded-lg shadow-lg border mt-8 md:mt-0 md:ml-8 w-full md:w-1/2">
            <h3 className="text-xl font-semibold mb-6">Send Message</h3>
            <form onSubmit={handleFormSubmit} className="space-y-4">
                <FormField
                    label="Full Name"
                    type="text"
                    id="name"
                    placeholder="Full Name"
                    value={name}
                    onChange={(e) => setName(e.target.value)}
                />
                <FormField
                    label="Email"
                    type="email"
                    id="email"
                    placeholder="Email"
                    value={email}
                    onChange={(e) => setEmail(e.target.value)}
                />
                <FormField
                    label="Message"
                    type="textarea"
                    id="message"
                    placeholder="Type your Message..."
                    rows={4}
                    value={message}
                    onChange={(e) => setMessage(e.target.value)}
                />
                <div>
                    <button
                        type="submit"
                        className={`w-full ${bgColor} text-white py-2 px-4 rounded-md shadow-sm hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-gray-400`}
                        disabled={isLoading}
                    >
                        {isLoading ? 'Sending...' : 'Send'}
                    </button>
                </div>
            </form>
        </div>
    );
};

const FormField = ({ label, type, id, placeholder, rows, value, onChange }) => {
    if (type === 'textarea') {
        return (
            <div>
                <label htmlFor={id} className="block text-sm font-medium text-gray-700">{label}</label>
                <textarea
                    id={id}
                    rows={rows}
                    className="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-gray-400 sm:text-sm"
                    placeholder={placeholder}
                    value={value}
                    onChange={onChange}
                />
            </div>
        );
    } else {
        return (
            <div>
                <label htmlFor={id} className="block text-sm font-medium text-gray-700">{label}</label>
                <input
                    type={type}
                    id={id}
                    className="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-gray-400 sm:text-sm"
                    placeholder={placeholder}
                    value={value}
                    onChange={onChange}
                />
            </div>
        );
    }
};
export default ContactUs;
