import React from 'react';
import ImageGallery from 'react-image-gallery';
import 'react-image-gallery/styles/css/image-gallery.css';
import g1 from "../assets/g1.jpg";
import g3 from "../assets/g3.jpg";
import g4 from "../assets/g4.jpg";
import g5 from "../assets/g5.jpg";
import g6 from "../assets/g6.jpg";
import g7 from "../assets/g7.jpg";
import g8 from "../assets/g8.jpg";

const images = [
    {
        original: g1,
        thumbnail: g1,
    },
    {
        original: g3,
        thumbnail: g3,
    },
    {
        original: g4,
        thumbnail: g4,
    },
    {
        original: g5,
        thumbnail: g5,
    },
    {
        original: g6,
        thumbnail: g6,
    },
    {
        original: g7,
        thumbnail: g7,
    },
    {
        original: g8,
        thumbnail: g8,
    },
];

const MyGallery = () => {
    return (
        <div className='flex flex-col w-full mb-12'>
            <div className='flex flex-col items-center justify-center w-[90%] md:w-[85%] lg:w-[80%] mx-auto my-6 gap-4'>
                <h2 className="text-4xl md:text-6xl lg:text-6xl font-extrabold mb-4"><span id='name-span'>My Gallery</span></h2>
                <div className='w-[350px] md:w-[600px] lg:w-[800px] h-[350px] md:h-[450px] lg:h-[500px] mx-auto'>
                    <ImageGallery
                        items={images}
                        showThumbnails={true}
                        showFullscreenButton={true}
                        showPlayButton={true}
                        autoPlay={true}
                        slideInterval={3000}
                        renderItem={(item) => (
                            <div className='h-[280px] md:h-[350px] lg:h-[400px] flex items-center justify-center'>
                                <img src={item.original} className='h-[280px] md:h-[350px] lg:h-[400px] w-auto' alt="gallery" />
                            </div>
                        )}
                        renderThumbInner={(item) => (
                            <div style={{ height: '60px', width: '80px', overflow: 'hidden' }}>
                                <img src={item.thumbnail} alt="" style={{ maxHeight: '100%', maxWidth: '80px' }} />
                            </div>
                        )}
                    />
                </div>
            </div>
        </div>
    );
};

export default MyGallery;
