import React, { useState, useEffect } from 'react';
import { textColor , Color, hoverTextColor, borderColor} from '../constant';

const NAV_LINKS = [
  { text: 'Home', href: '/' },
  { text: 'About', href: '#about' },
  { text: 'AI Bot', href: '#ai-bot' },
  { text: 'Skills', href: '#skill' },
  { text: 'Services', href: '#service' },
  { text: 'Projects', href: '#projects' },
  { text: 'Contact', href: '#contact' },  
];

const HEADER_CLASSES = 'flex items-center justify-between p-4';
const LINK_CLASSES = hoverTextColor;
const BUTTON_CLASSES = `bg${Color} text-white px-4 py-2 rounded-full hover:bg-gray-600`;
const activeNav = `border-b-2 ${borderColor} ${textColor} font-semibold`

const Header = () => {
  const [isMobileMenuOpen, setMobileMenuOpen] = useState(false);
  const [activeLink, setActiveLink] = useState('Home');

  const toggleMobileMenu = () => {
    setMobileMenuOpen(!isMobileMenuOpen);
  };

  const handleScroll = () => {
    const sections = NAV_LINKS.map(link => {
      if (link.href === '/') {
        return document.querySelector('body');
      }
      return document.querySelector(link.href);
    });
    let active = 'Home';

    sections.forEach((section, index) => {
      if (section) {
        const rect = section.getBoundingClientRect();
        if (rect.top <= window.innerHeight / 2 && rect.bottom >= window.innerHeight / 2) {
          active = NAV_LINKS[index].text;
        }
      }
    });

    setActiveLink(active);
  };

  const handleClick = (text) => {
    setActiveLink(text);
  };

  useEffect(() => {
    window.addEventListener('scroll', handleScroll);
    return () => {
      window.removeEventListener('scroll', handleScroll);
    };
  }, []);

  return (
    <div className="relative bg-opacity-80 text-black navbar">
      <nav className={HEADER_CLASSES}>
        <div className="flex items-center">
          <svg className="h-8 w-8 mr-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width={24} height={24} color={"#000"} fill={"none"}>
            <path d="M10 13.3333C10 13.0233 10 12.8683 10.0341 12.7412C10.1265 12.3961 10.3961 12.1265 10.7412 12.0341C10.8683 12 11.0233 12 11.3333 12H12.6667C12.9767 12 13.1317 12 13.2588 12.0341C13.6039 12.1265 13.8735 12.3961 13.9659 12.7412C14 12.8683 14 13.0233 14 13.3333V14C14 15.1046 13.1046 16 12 16C10.8954 16 10 15.1046 10 14V13.3333Z" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M13.9 13.5H15.0826C16.3668 13.5 17.0089 13.5 17.5556 13.3842C19.138 13.049 20.429 12.0207 20.9939 10.6455C21.1891 10.1704 21.2687 9.59552 21.428 8.4457C21.4878 8.01405 21.5177 7.79823 21.489 7.62169C21.4052 7.10754 20.9932 6.68638 20.4381 6.54764C20.2475 6.5 20.0065 6.5 19.5244 6.5H4.47562C3.99351 6.5 3.75245 6.5 3.56187 6.54764C3.00682 6.68638 2.59477 7.10754 2.51104 7.62169C2.48229 7.79823 2.51219 8.01405 2.57198 8.4457C2.73128 9.59552 2.81092 10.1704 3.00609 10.6455C3.571 12.0207 4.86198 13.049 6.44436 13.3842C6.99105 13.5 7.63318 13.5 8.91743 13.5H10.1" stroke="currentColor" strokeWidth="1.5" />
            <path d="M3.5 11.5V13.5C3.5 17.2712 3.5 19.1569 4.60649 20.3284C5.71297 21.5 7.49383 21.5 11.0556 21.5H12.9444C16.5062 21.5 18.287 21.5 19.3935 20.3284C20.5 19.1569 20.5 17.2712 20.5 13.5V11.5" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M15.5 6.5L15.4227 6.14679C15.0377 4.38673 14.8452 3.50671 14.3869 3.00335C13.9286 2.5 13.3199 2.5 12.1023 2.5H11.8977C10.6801 2.5 10.0714 2.5 9.61309 3.00335C9.15478 3.50671 8.96228 4.38673 8.57727 6.14679L8.5 6.5" stroke="currentColor" strokeWidth="1.5" />
          </svg>
          <span className="font-bold text-lg">Portfolio</span>
        </div>
        <div className="hidden md:flex space-x-6">
          {NAV_LINKS.map((link, index) => (
            <a
              key={index}
              href={link.href}
              className={`${LINK_CLASSES} ${activeLink === link.text ? activeNav : ''}`}
              onClick={() => handleClick(link.text)}
            >
              {link.text}
            </a>
          ))}
        </div>
        <div className="hidden md:flex items-center space-x-4">
          <a href='#contact'><button className={BUTTON_CLASSES}>Hire me</button></a>
        </div>
        <button id="menu-button" className="md:hidden focus:outline-none" onClick={toggleMobileMenu}>
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width={28} height={28} color={"#000"} fill={"none"}>
            <path d="M4 5L16 5" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M4 12L20 12" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M4 19L12 19" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
          </svg>
        </button>
      </nav>
      <div className={`${isMobileMenuOpen ? 'block' : 'hidden'} md:hidden absolute top-16 left-0 right-0 bg-gray-900 text-white p-4`}>
        <button id="close-menu-button" className="focus:outline-none flex justify-end" onClick={toggleMobileMenu}>
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width={28} height={28} color={"#ffffff"} fill={"none"}>
            <path d="M6 18L18 6M6 6L18 18" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
          </svg>
        </button>
        <div className="flex flex-col space-y-4 mt-8">
          {NAV_LINKS.map((link, index) => (
            <a
              key={index}
              href={link.href}
              className={`${LINK_CLASSES} ${activeLink === link.text ? `border-b-2 border${Color}` : ''}`}
              onClick={() => handleClick(link.text)}
            >
              {link.text}
            </a>
          ))}
          <a href='#contact'><button className={BUTTON_CLASSES}>Hire me</button></a>
        </div>
      </div>
    </div>
  );
};

const MainSection = () => {
  return (
    <div className="flex flex-col items-center justify-center h-screen bg-cover bg-center" style={{ backgroundImage: "url('https://placehold.co/1024x512')" }}>
      <div className="text-center text-white">
        <h1 className="text-4xl font-bold mb-4">Grow Big With Musicol Business</h1>
        <p className="mb-8">Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus.</p>
        <div className="flex justify-center space-x-4">
          <button className={BUTTON_CLASSES}>Our Services</button>
          <button className="bg-transparent border border-white text-white px-4 py-2 rounded hover:bg-white hover:text-black">See How It Work</button>
        </div>
      </div>
    </div>
  );
};

export { Header, MainSection }
