import React, { useState } from 'react';
import { Swiper, SwiperSlide } from 'swiper/react';
import 'swiper/css';
import 'swiper/css/effect-coverflow';
import 'swiper/css/pagination';
import 'swiper/css/navigation';
import { EffectCoverflow, Pagination, Navigation } from 'swiper/modules';

import Carousel from "react-multi-carousel";
import "react-multi-carousel/lib/styles.css";
import web from "../assets/web.jpeg";
import ux from "../assets/ux.jpeg";
import graphic from "../assets/graphic.jpeg";
import app from "../assets/app.jpeg";
import { textColor } from '../constant';
import { CustomLeftArrow, CustomRightArrow } from './CustomArrows';


const carouselItems = [
    {
        id: 1,
        imageUrl: web,
        title: 'Web Development',
        description: 'Crafting responsive and dynamic websites tailored to your needs, ensuring a seamless user experience across all devices.',
        bgColor: 'bg-secondary',
        textColor: 'text-primary-foreground'
    },
    {
        id: 2,
        imageUrl: ux,
        title: 'UI/UX Design',
        description: 'Designing intuitive and visually appealing user interfaces that enhance user interaction and satisfaction.',
        bgColor: 'bg-primary',
        textColor: 'text-primary-foreground'
    },
    {
        id: 3,
        imageUrl: graphic,
        title: 'Graphic Design',
        description: "Creating stunning graphics and visual content to effectively communicate your brand's message and engage your audience.",
        bgColor: 'bg-secondary',
        textColor: 'text-primary-foreground'
    },
    {
        id: 4,
        imageUrl: app,
        title: 'App Development',
        description: 'Developing robust and user-friendly mobile applications that bring your ideas to life and reach a wider audience.',
        bgColor: 'bg-primary',
        textColor: 'text-primary-foreground'
    }
];

const carouselClasses = {
    container: 'flex overflow-hidden space-x-4',
    item: 'border flex-none my-8 w-[95%] mx-auto text-justify h-80 rounded-lg p-4 flex flex-col items-center justify-center cursor-pointer transform transition-transform duration-300 shadow-lg',

};

const MultiCarousel = () => {
    return (
        <div className="container w-[90%] md:w-[85%] lg:w-[85%]">
            <Swiper
                effect={'coverflow'}
                grabCursor={true}
                centeredSlides={true}
                loop={true}
                slidesPerView={'auto'}
                coverflowEffect={{
                    rotate: 0,
                    stretch: 0,
                    depth: 100,
                    modifier: 2.5,
                }}
                pagination={{ el: '.swiper-pagination', clickable: true }}
                navigation={{
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                    clickable: true,
                }}
                modules={[EffectCoverflow, Pagination, Navigation]}
                className="h-[400px] md:h-[450px] lg:h-[470px]"
            >
                {carouselItems.map((item, index) => (
                    <SwiperSlide key={index}>
                        <div
                            key={item.id}
                            className={`bg-white p-4 h-[300px] md:h-[320px] lg:h-[350px] w-[70%] md:w-[90%] lg:w-[90%] xl:w-[95%] mx-auto ${carouselClasses.item} ${item.bgColor} ${item.textColor}`}
                        >
                            <img aria-hidden="true" alt="design-icon" src={item.imageUrl} className="w-[100px] rounded-lg" />
                            <h2 className={`text-xl ${textColor} font-bold mt-4`}>{item.title}</h2>
                            <p className="text-center mt-2">{item.description}</p>
                        </div>
                    </SwiperSlide>
                ))}
                <div className="slider-controler">
                    <div className="swiper-button-prev slider-arrow">
                        <ion-icon name="arrow-back-outline"></ion-icon>
                    </div>
                    <div className="swiper-button-next slider-arrow">
                        <ion-icon name="arrow-forward-outline"></ion-icon>
                    </div>
                    <div className="swiper-pagination"></div>
                </div>
            </Swiper>
        </div>
    );
}

export default MultiCarousel;

/**
function MultiCarousel() {
    const responsive = {
        superLargeDesktop: {
            breakpoint: { max: 4000, min: 3000 },
            items: 5
        },
        desktop: {
            breakpoint: { max: 3000, min: 1024 },
            items: 3
        },
        tablet: {
            breakpoint: { max: 1024, min: 540 },
            items: 2
        },
        mobile: {
            breakpoint: { max: 540, min: 0 },
            items: 1
        }
    };

    return (
        <div style={{ width: "100%", margin: "auto" }} className='p-4'>
            <Carousel
                responsive={responsive}
                showDots={true}
                infinite={true}
                customLeftArrow={<CustomLeftArrow />}
                customRightArrow={<CustomRightArrow />}
                containerClass="carousel-container"
                dotListClass="custom-dot-list-style"
                itemClass="carousel-item-padding-40-px"
            >
                {carouselItems.map((item, index) => (
                    <div
                        key={item.id}
                        className={`${carouselClasses.item} ${item.bgColor} ${item.textColor}`}
                    >
                        <img aria-hidden="true" alt="design-icon" src={item.imageUrl} className="w-[100px] rounded-lg" />
                        <h2 className={`text-xl ${textColor} font-bold mt-4`}>{item.title}</h2>
                        <p className="text-center mt-2">{item.description}</p>
                    </div>
                ))}
            </Carousel>
        </div>
    );
}

 */