import React from 'react';

const cardClasses = "bg-card text-card-foreground p-6 rounded-lg shadow-md";
const textClasses = "text-xl text-[#00d9ff] font-semibold text-center mb-2";
const imgClasses = "mx-auto mb-4";

const ServiceCard = ({ imageUrl, altText, title, description }) => {
    return (
        <div className={cardClasses}>
            <img src={imageUrl} alt={altText} className={imgClasses} />
            <h3 className={textClasses}>{title}</h3>
            <p className="text-center text-gray-500 text-muted-foreground">{description}</p>
        </div>
    );
};

const Services = () => {
    return (
        <div id="services" className="container mx-auto p-4 services">
            <h2 className="text-4xl md:text-6xl lg:text-6xl font-extrabold text-white"><span id='name-span'>Services</span></h2>
            <h1 className="text-secondary text-[#00d9ff] text-sm font-semibold tracking-widest mb-8">My Services</h1>
            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                <ServiceCard
                    imageUrl="https://placehold.co/64x64?text=UI/UX"
                    altText="UI/UX Design"
                    title="UI/UX Design"
                    description="Craft intuitive and seamless user experiences through thoughtful design and user-centric interfaces that enhance engagement and satisfaction."
                />
                <ServiceCard
                    imageUrl="https://placehold.co/64x64?text=Web"
                    altText="Web Development"
                    title="Web Development"
                    description="Transform your ideas into functional and responsive websites with cutting-edge technologies and user-friendly interfaces"
                />
                <ServiceCard
                    imageUrl="https://placehold.co/64x64?text=Graphic"
                    altText="Graphic Design"
                    title="Graphic Design"
                    description="Elevate your brand with visually compelling designs that communicate your message effectively and creatively."
                />
            </div>
        </div>
    );
};

export default Services;
