import React, { useState, useEffect, useRef } from 'react';

const skillBarClasses = 'w-full bg-muted rounded-full h-2.5';
const skillBarFillClasses = 'bg-accent h-2.5 rounded-full';

const SkillBar = ({ skill, percentage, animate }) => {
    const [fillWidth, setFillWidth] = useState(0);
    const targetWidth = percentage;
    const fillRef = useRef(null);

    useEffect(() => {
        if (animate) {
            let currentWidth = 0;
            const animationFrame = () => {
                if (currentWidth < targetWidth) {
                    currentWidth += 1;
                    setFillWidth(currentWidth);
                    requestAnimationFrame(animationFrame);
                }
            };
            requestAnimationFrame(animationFrame);
        }
    }, [animate, targetWidth]);

    useEffect(() => {
        if (!animate) {
            setFillWidth(0);
        }
    }, [animate]);

    return (
        <div>
            <div className="flex justify-between mb-1">
                <span>{skill}</span>
                <span>{animate ? `${fillWidth}%` : `${percentage}%`}</span>
            </div>
            <div className={skillBarClasses}>
                <div
                    ref={fillRef}
                    className={skillBarFillClasses}
                    style={{
                        width: `${fillWidth}%`,
                        transition: 'width 2s ease-in-out',
                        backgroundColor: animate ? '#00d9ff' : 'initial',
                    }}
                ></div>
            </div>
        </div>
    );
};

const Skills = () => {
    const [animateSkills, setAnimateSkills] = useState(false);

    useEffect(() => {
        const handleScroll = () => {
            const skillsSection = document.getElementById('skills');
            if (!skillsSection) return;

            const { top } = skillsSection.getBoundingClientRect();
            const screenHeight = window.innerHeight;

            if (top <= screenHeight && !animateSkills) {
                setAnimateSkills(true);
            }
        };

        window.addEventListener('scroll', handleScroll);
        return () => {
            window.removeEventListener('scroll', handleScroll);
        };
    }, [animateSkills]);

    return (
        <div style={{ width: '90%', margin: 'auto', marginTop: '40px' }} id="skills" className="border bg-background text-foreground p-8 skills rounded-lg shadow-lg">
            <div className="text-center mb-8">
                <h2 className="text-4xl md:text-6xl lg:text-6xl font-extrabold text-white"><span id='name-span'>Skills</span></h2>
                <h1 className="text-secondary text-[#00d9ff] text-sm font-semibold tracking-widest">My Skills</h1>
            </div>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <SkillBar skill="Face Recognition & Security System" percentage={95} animate={animateSkills} />
                <SkillBar skill="Chatbot" percentage={90} animate={animateSkills} />
                <SkillBar skill="IOT System" percentage={90} animate={animateSkills} />
                <SkillBar skill="AI Development" percentage={85} animate={animateSkills} />
                <SkillBar skill="App Development" percentage={90} animate={animateSkills} />
                <SkillBar skill="Robotic" percentage={90} animate={animateSkills} />
                <SkillBar skill="Drone Devlopment" percentage={90} animate={animateSkills} />
                <SkillBar skill="Flutter" percentage={95} animate={animateSkills} />
                <SkillBar skill="Python" percentage={95} animate={animateSkills} />
            </div>
        </div>
    );
};

export default Skills;
