import React from 'react';
import { Swiper, SwiperSlide } from 'swiper/react';
import 'swiper/css';
import 'swiper/css/effect-coverflow';
import 'swiper/css/pagination';
import 'swiper/css/navigation';
import { EffectCoverflow, Pagination, Navigation } from 'swiper/modules';

import img1 from '../assets/face.jpg';
import img2 from '../assets/food.jpg';
import img3 from '../assets/gym.jpg';
import img4 from '../assets/coffee.jpg';
import img5 from '../assets/fashion.jpg';
import { textColor } from '../constant';


const Swipe = () => {
    return (
        <div className="container w-[90%] md:w-[85%] lg:w-[80%]">
            <Swiper
                effect={'coverflow'}
                grabCursor={true}
                centeredSlides={true}
                loop={true}
                slidesPerView={'auto'}
                coverflowEffect={{
                    rotate: 0,
                    stretch: 0,
                    depth: 100,
                    modifier: 2.5,
                }}
                pagination={{ el: '.swiper-pagination', clickable: true }}
                navigation={{
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                    clickable: true,
                }}
                modules={[EffectCoverflow, Pagination, Navigation]}
                className="h-[350px] md:h-[430px] lg:h-[470px]"
            >
                {cardData.map((card, index) => (
                    <SwiperSlide key={index}>
                        <Card
                            key={index}
                            category={card.category}
                            title={card.title}
                            description={card.description}
                            views={card.views}
                            comments={card.comments}
                            projectLink={card.projectLink}
                            backgroundImage={card.backgroundImage}
                        />
                    </SwiperSlide>
                ))}
                <div className="slider-controler">
                    <div className="swiper-button-prev slider-arrow">
                        <ion-icon name="arrow-back-outline"></ion-icon>
                    </div>
                    <div className="swiper-button-next slider-arrow">
                        <ion-icon name="arrow-forward-outline"></ion-icon>
                    </div>
                    <div className="swiper-pagination"></div>
                </div>
            </Swiper>
        </div>
    );
}

export default Swipe;

//-------------------------------------------------------------------------------------


const Card = ({ category, title, description, projectLink, backgroundImage }) => (
    <div className="p-4 h-[300px] md:h-[350px] lg:h-[400px] w-[100%] mx-auto">
      <a href={projectLink} target="_blank" rel="noopener noreferrer" className="block h-full relative group">
        <div
          className="h-full bg-cover bg-center bg-gray-200 bg-opacity-75 px-8 pt-16 pb-24 rounded-lg overflow-hidden text-center relative transition-all duration-300 ease-in-out transform group-hover:scale-105"
          style={{ backgroundImage: `url(${backgroundImage})` }}
        >
          <div className="absolute inset-0 bg-gray-900 opacity-20 group-hover:opacity-20 transition-opacity duration-300 ease-in-out"></div>
          <div className="absolute inset-0 mt-12 flex flex-col items-center justify-center opacity-0 group-hover:opacity-100 px-4">
            <div className="relative bg-black bg-opacity-40 p-4 rounded-lg backdrop-blur-md">
              <h1 className={`title-font sm:text-2xl text-xl font-semibold ${textColor} mb-3`}>{title}</h1>
              <p className="leading-relaxed mb-3 text-zinc-200">{description}</p>
            </div>
          </div>
        </div>
      </a>
    </div>
  );
  
  


const cardData = [
    {
        category: 'Attendance System',
        title: 'Face Recognition Attendance System',
        description: 'A robust face recognition system for marking attendance in real-time using AI technology.',
        projectLink: 'https://www.google.com',
        backgroundImage: img1,
    },
    {
        category: 'Food Ordering',
        title: 'Online Food Ordering Website',
        description: 'A convenient and fast online platform for ordering your favorite meals from local restaurants.',
        projectLink: 'https://www.google.com',
        backgroundImage: img2,
    },
    {
        category: 'Health & Fitness',
        title: 'Gym Management System',
        description: 'An efficient system to manage gym memberships, schedules, and personal training sessions.',
        projectLink: 'https://www.google.com',
        backgroundImage: img3,
    },
    {
        category: 'Cafe',
        title: 'Coffee Shop Website',
        description: 'A beautifully designed website for showcasing the menu, ambiance, and services of a coffee shop.',
        projectLink: 'https://www.google.com',
        backgroundImage: img4,
    },
    {
        category: 'E-commerce',
        title: 'Online Fashion Store',
        description: 'A modern and user-friendly e-commerce platform for buying the latest fashion trends online.',
        projectLink: 'https://www.google.com',
        backgroundImage: img5,
    },
];
