import React from 'react';
import ChatBot from './ChatBot';

const testimonialData = [
  {
    name: 'David Thompson',
    role: 'Chief Technology Officer',
    description: 'Impressed by the MERN stack app you developed.',
    image: 'https://w7.pngwing.com/pngs/663/908/png-transparent-thumb-signal-man-smile-happiness-shows-miscellaneous-microphone-hand.png'
  },
  {
    name: 'Michael Robinson',
    role: 'Product Manager',
    description: 'Your React Native app is user-friendly and responsive.',
    image: 'https://toppng.com/uploads/preview/free-png-happy-black-person-png-images-transparent-black-man-thumbs-up-11563648491mkncpzrjrf.png'
  },
  {
    name: 'James Miller',
    role: 'Web Administrator',
    description: 'Your WordPress skills transformed our online presence.',
    image: 'https://thumbs.dreamstime.com/b/young-happy-positive-teenager-man-gesturing-ok-isolated-white-background-40784002.jpg'
  }
];

const testimonialCardClasses = 'bg-card p-6 rounded-lg shadow-lg text-center';
const imageClasses = 'w-16 h-16 rounded-full mx-auto mb-4';
const titleClasses = 'text-xl text-[#00d9ff] font-semibold text-foreground';
const roleClasses = 'text-secondary-foreground mb-4';
const descriptionClasses = 'text-muted-foreground text-gray-500';

const Testimonial = () => {
  return (
    <div style={{width:"90%", margin:"auto"}} className="bg-background py-12">
      <div className="text-center mb-8">
      <h2 className="text-4xl md:text-6xl lg:text-6xl font-extrabold text-white"><span id='name-span'>Testimonial</span></h2>
      <h1 className="text-secondary text-[#00d9ff] text-sm font-semibold tracking-widest">Happy Guests</h1>
      </div>
      <div className="container mx-auto px-4">
        <div className="flex flex-wrap justify-center">
          {testimonialData.map((testimonial, index) => (
            <div key={index} className="w-full md:w-1/3 p-4">
              <div className={testimonialCardClasses}>
                <img className={imageClasses} src={testimonial.image} alt={`Guest photo ${index + 1}`} />
                <h3 className={titleClasses}>{testimonial.name}</h3>
                <p className={roleClasses}>{testimonial.role}</p>
                <p className={descriptionClasses}>{testimonial.description}</p>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default Testimonial;
